<?php

$showposts = get_theme_mod('my_plugin_show_posts', 'no') === 'no';

if ($showposts == "no") {
wp_redirect(home_url());
exit;
}
else
{

get_header(); ?>

<main id="primary" class="site-main">SNGLE

    <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

            <!-- Title + Date -->
            <header class="post-header">
                <h1 class="post-title"><?php the_title(); ?></h1>
                <p class="post-date"><?php echo get_the_date(); ?></p>
                <hr class="post-divider">
            </header>

            <!-- Full-width featured image -->
            <?php if ( has_post_thumbnail() ) : ?>
                <div class="post-hero-full">
                    <?php the_post_thumbnail( 'full' ); ?>
                </div>
            <?php endif; ?>

            <!-- Content -->
            <div class="entry-content">
                <?php the_content(); ?>
            </div>
			
			<!-- Post Navigation -->
	    <nav class="post-navigation">
  	      <div class="nav-previous"><?php previous_post_link('&laquo; %link'); ?></div>
  	      <div class="nav-next"><?php next_post_link('%link &raquo;'); ?></div>
	    </nav>

        </article>

    <?php endwhile; endif; ?>

</main>

<?php get_footer(); 

}