<?php
/* ---------------------------------------------------------
 * Firefly “thing” list – single style file
 * --------------------------------------------------------- */

/* ========== 1. Collect all theme-mod settings ========== */
$layout          = get_theme_mod( "firefly_thing_layout_$slug", 'list' );
$thumb_width     = get_theme_mod( "firefly_thing_thumb_width_$slug",  300 );
$thumb_height    = get_theme_mod( "firefly_thing_thumb_height_$slug", 300 );
$image_padding   = get_theme_mod( "firefly_thing_image_padding_$slug", '0px' );
$panel_border    = get_theme_mod( "firefly_thing_border_$slug",       '1px' );
$panel_colour_key= get_theme_mod( "firefly_thing_panel_colour_$slug", 'white' );
$text_colour_key = get_theme_mod( "firefly_thing_text_colour_$slug",  'black' );
$heading_colour_key = get_theme_mod( "firefly_thing_heading_colour_$slug", 'black' );
$background_colour_key = get_theme_mod( "firefly_thing_background_colour_$slug", 'white' );
$line_colour_key = get_theme_mod( "firefly_thing_line_colour_$slug",  'black' );
$gallery_mode    = get_theme_mod( "firefly_thing_image_display_mode_$slug", 'single' );
$has_links       = get_theme_mod( "firefly_thing_link_to_page_$slug", 1 );

$heading_colour = match ($heading_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#000000',
};

$text_colour = match ($text_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#000000',
};

$background_colour = match ($background_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#ffffff',
};

$line_colour = match ($line_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#000000',
};

$panel_colour = match ($panel_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#ffffff',
};

/* ========== 2. Container ========== */
echo "<div class='thing-container-$slug'>";

/* ——— guard ——— */
if ( ! isset( $query ) || ! $query->have_posts() ) {
    echo '<p>No items to display.</p></div>';
    return;
}

/* ========== 3. Loop through posts ========== */
while ( $query->have_posts() ) {
    $query->the_post();

    $post_id   = get_the_ID();
    $post_slug = sanitize_title( get_the_title() );
    $url       = esc_url( site_url( "/$post_id/$slug/$post_slug" ) );




    $is_draft    = get_post_status() === 'draft';
$draft_class = $is_draft ? ' firefly-draft' : '';

echo '<div class="thing-panel-' . esc_attr( $slug ) . $draft_class . '">';

 //   echo "<h1>-$draft_class-</h1<>";

    echo '<div class="firefly-gallery-layout">';

    /* ========== 3a. IMAGE COLUMN ========== */
    if ( $has_links ) echo "<a href='$url'>";
    echo '<div class="firefly-gallery-wrapper" style="width:' . esc_attr( $thumb_width ) . 'px;height:' . esc_attr( $thumb_height ) . 'px;">';

    if ( $gallery_mode === 'single' ) {
        /* single image */
        $thumb_id = get_post_thumbnail_id();
        $gallery  = get_post_meta( $post_id, 'thing_gallery', true );
        $img_id   = $thumb_id ?: ( is_array( $gallery ) ? reset( $gallery ) : 0 );

          $alt = get_post_meta( $img_id, '_wp_attachment_image_alt', true );

        if ( $img_id ) {
            echo '<div class="firefly-gallery-image">';
            echo wp_get_attachment_image( $img_id, 'medium', false, [
                'style'   => 'width:100%;height:100%;object-fit:cover;',
                'loading' => 'lazy',
                 'alt'     => $alt !== '' ? $alt : get_the_title(),   // fallback = post title
    'title'   => $title !== '' ? $alt : get_the_title(),
            ] );





            echo '</div>';
        }
    } else {
        /* rotating gallery */
        $thumb_id = get_post_thumbnail_id();
        $gallery  = (array) get_post_meta( $post_id, 'thing_gallery', true );
        $img_ids  = $thumb_id ? array_merge( [ $thumb_id ], array_diff( $gallery, [ $thumb_id ] ) ) : $gallery;

        foreach ( $img_ids as $n => $img_id ) {
            $opacity = $n ? 0 : 1;
            echo '<div class="firefly-gallery-image" style="opacity:' . $opacity . ';">';
            echo wp_get_attachment_image( $img_id, 'medium', false, [
                'style'   => 'width:100%;height:100%;object-fit:cover;',
                'loading' => 'lazy',
            ] );
            echo '</div>';
        }
    }

    echo '</div>'; // .firefly-gallery-wrapper
    if ( $has_links ) echo '</a>';

    /* ========== 3b. TEXT COLUMN ========== */
    echo '<div class="firefly-gallery-content">';
    echo '<div class="thing-info-' . esc_attr( $slug ) . '">';

    /* admin inline tools */
    if ( current_user_can( 'manage_options' ) ) {
        $admin_tpl = get_stylesheet_directory() . '/firefly-admin-thing.php';
        if ( file_exists( $admin_tpl ) ) require $admin_tpl;
    }

    /* title */
    echo '<div class="thing-name">';
    if ( $has_links ) echo "<a href='$url'>";
    echo esc_html( get_the_title() );
    if ( $has_links ) echo '</a>';
    echo '</div>';

    /* description excerpt */
    $excerpt_len = (int) get_theme_mod( "firefly_thing_excerpt_length_$slug", 0 );
    if ( $excerpt_len ) {
        $raw  = get_the_excerpt() ?: strip_tags( get_the_content() );
        $words= preg_split( '/\s+/', trim( $raw ) );
        $trim = implode( ' ', array_slice( $words, 0, $excerpt_len ) );
        if ( count( $words ) > $excerpt_len ) $trim .= '…';
        echo '<div class="thing-description">' . esc_html( $trim ) . '</div>';
    }

    /* custom fields (list view) */
    $list_fields_raw = get_theme_mod( "firefly_thing_fields_list_$slug", '' );
    $list_fields     = array_filter( array_map( 'trim', explode( "\n", $list_fields_raw ) ) );

    $price_html = '';
    foreach ( $list_fields as $field_raw ) {
        $is_checkbox = str_starts_with( $field_raw, '*' );
        $field       = ltrim( $field_raw, '*' );
       // $key         = sanitize_title( $field );

        $key = thing_meta_key( $field );

        $val         = get_post_meta( $post_id, $key, true );

        if ( $val === '' ) continue;

        $out = $is_checkbox ? ( $val ? '✅' : '❌' ) : esc_html( $val );

        if ( strtolower( $field ) === 'price' ) {
            $price_html = '<div class="thing-price">' .
                          ( $has_links ? "<a href='$url' style='color:white;'>" : '' ) .
                          '$' . ltrim( $out, '$' ) .
                          ( $has_links ? '</a>' : '' ) .
                          '</div>';
        } else {
            echo '<div class="thing-field">' . esc_html( $field ) . ': ' . $out . '</div>';
        }
    }
    echo $price_html;

    echo '</div></div>';             // .thing-info  +  .firefly-gallery-content
    echo '</div></div>';             // .firefly-gallery-layout  +  .thing-panel
}

/* ========== 4. Done ========= */
wp_reset_postdata();
echo '</div>'; // .thing-container

/* ---------------------------------------------------------
 * 5. Inline styles (unchanged except stray layout fix)
 * --------------------------------------------------------- */


 // Get styling options
$firefly_thing_panel_width = get_theme_mod("firefly_thing_panel_width_$slug", '300px');
$text_align = get_theme_mod("firefly_thing_text_align_$slug", 'left');

$thing_heading_font_size = get_theme_mod("firefly_thing_heading_size_$slug", '36px');
$thing_description_font_size = get_theme_mod("firefly_thing_description_font_size_$slug", '18px');

$thing_heading_font_family = get_theme_mod("firefly_thing_heading_font_$slug", '18px');
$thing_description_font_family = get_theme_mod("firefly_thing_description_font_$slug", '18px');

$thing_custom_fields_font_size = get_theme_mod("firefly_thing_custom_fields_font_size_$slug", '18px');
$thing_headng_padding_top = get_theme_mod("firefly_panel_heading_padding_top_$slug", '18px');
$thing_headng_padding_bottom = get_theme_mod("firefly_panel_heading_padding_bottom_$slug", '18px');
$thing_description_padding_bottom = get_theme_mod("firefly_panel_description_padding_bottom_$slug", '18px');
$firefly_panel_padding_leftright = get_theme_mod("firefly_panel_padding_leftright_$slug", '0px');

$thing_heading_weight = get_theme_mod("firefly_thing_heading_weight_$slug", '10px');

$firefly_container_padding_top = get_theme_mod("firefly_container_padding_top_$slug", '10px');
$firefly_container_padding_bottom = get_theme_mod("firefly_container_padding_bottom_$slug", '10px');

$firefly_show_thing_borders = get_theme_mod("firefly_show_thing_borders_$slug", '');

$panel_border  = get_theme_mod("firefly_thing_border_$slug", '1px');
$align_price_bottom = get_theme_mod("firefly_align_price_bottom_$slug") ? true : false;


// === Output CSS
echo "
<style>


.thing-container-$slug {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 30px;

    background: {$background_colour};
    margin-top:{$panel_margin_top};
    margin-bottom:{$panel_margin_bottom};
    padding-top:{$firefly_container_padding_top};
    padding-bottom:{$firefly_container_padding_bottom};
}

.thing-panel-$slug {
    background: {$panel_colour};
    border: {$panel_border} solid {$line_colour};
    
    border-radius: 10px;
    overflow: hidden;
    width: 100%;
    max-width: {$firefly_thing_panel_width}px; 
    text-align: {$text_align};
    display: flex;
    flex-direction: row;
    padding-left:{$firefly_panel_padding_leftright};
    padding-right:{$firefly_panel_padding_leftright};
    padding-top:{$panel_padding_top} !important; 
    padding-bottom:{$panel_padding_bottom} !important;
    xxx:xxx;
}

.thing-panel-$slug:hover {
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.12);
}

/* Updated Gallery Styles */
.firefly-gallery-wrapper {
    position: relative;
    width: {$thumb_width}px !important;
    height: {$thumb_height}px !important;
    flex-shrink: 0;
    overflow: hidden;
    margin: 0 !important; /* Remove all margins */
    padding: 0 !important; /* Remove all padding */
    line-height: 0; /* Fixes phantom space under images */
}
.firefly-gallery-image {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
}

.firefly-gallery-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center;
    display: block;
}

.firefly-gallery-layout {
    display: flex;
    gap: 20px;
    margin-top:0px;
    margin-bottom:0px;
    align-items: flex-start;
}

.firefly-gallery-content {
    flex: 1;
}

.thing-name {
    font-family:{$thing_heading_font_family};
    font-size: {$thing_heading_font_size};
    font-weight: 600;
    color: {$heading_colour};
    line-height: 1.4;
    margin-top: {$thing_headng_padding_top};
    margin-bottom: {$thing_headng_padding_bottom};
    font-weight:{$thing_heading_weight};
}


.thing-name a {
  color: {$heading_colour} !important;
}
  
.thing-info {
    font-family:{$thing_description_font_family};
    display: flex;
    flex-direction: column;
    gap: 6px;
    font-family: 'Segoe UI', sans-serif;
}

.thing-field {
    font-family:{$thing_description_font_family};
    font-size: {$thing_custom_fields_font_size};
    color: {$text_colour};
    line-height: 1.3;
}

.thing-description {
    font-family:{$thing_description_font_family};
    font-size: {$thing_description_font_size};
    color: {$text_colour};
    line-height: 1.3;
    margin-bottom: {$thing_description_padding_bottom};
}

.thing-price {
    font-size: 1.3rem;
    font-weight: 600;
    color: white;
    background: #0079c1;
    padding: 10px 18px;
    display: inline-block;
    margin-top: 10px;
    border-radius: 4px;
    width: fit-content;
}

@media (max-width: 768px) {
    .thing-panel-$slug {
        flex-direction: column;
    }
    
    .firefly-gallery-wrapper {
        width: 100%;
        aspect-ratio: {$thumb_width}/{$thumb_height};
    }
}


@media (max-width: 768px) {
    .thing-panel-$slug {
        flex-direction: column;
        margin-left: 15px;
        margin-right: 15px;
    
    }

    .firefly-gallery-layout {
        flex-direction: column;
        align-items: center;
    }

    .firefly-gallery-wrapper {
        width: 100%;
        aspect-ratio: {$thumb_width}/{$thumb_height};
        margin-bottom: 15px;
}

.firefly-gallery-content {
        margin-left: 15px !important;
        margin-right: 15px !important;
        display:block;
    }
}
        .firefly-draft          { filter: grayscale(1);  }
.firefly-draft img      { filter: grayscale(1);  }

.firefly-draft .thing-name,
.firefly-draft .thing-field,
.firefly-draft .thing-description {
    color:#777 !important;
    text-decoration:line-through;
}
    

    ";




  if ( $firefly_show_thing_borders) {
    echo "
    
    .thing-container-$slug {
        border:10px red solid;
    }
    .thing-panel-$slug {
        border:5px green solid;
    }

    .firefly-gallery-wrapper{
        border:5px blue solid;
    }


    .firefly-gallery-layout {
        border:2px oranmge solid;
     
    }

    .firefly-gallery-wrapper{
        border:2px black solid;
    }


    .firefly-gallery-content{
        border:2px pink solid;
    }


    .thing-name{
        border:2px green solid;
    }
    ";
  }


  

if ($align_price_bottom) {
    echo "

.thing-panel-$slug {
    display: flex;
    flex-direction: column;
    align-items: stretch;
    height: 100%; /* Ensure panel takes full height */
}



.thing-info-$slug {
    flex-grow: 1;
    display: flex;
    flex-direction: column;    flex: 1 1 300px;
    /* min-height: 100%; Remove this as it's not needed */
    bobo:0px;
}

.thing-price {
    margin-top: auto; /* This pushes price to bottom */
}




";
}


    echo "
</style>
";
?>

<script>
/* simple fade gallery */
document.addEventListener("DOMContentLoaded",()=>{
  document.querySelectorAll(".firefly-gallery-wrapper").forEach(w=>{
    const imgs=w.querySelectorAll(".firefly-gallery-image");
    if(imgs.length<2)return;
    let i=0;
    const rot=()=>{imgs[i].style.opacity=0; i=(i+1)%imgs.length; imgs[i].style.opacity=1; w.tm=setTimeout(rot,3000)};
    imgs.forEach(img=>img.style.transition="opacity .5s");
    w.tm=setTimeout(rot,3000);
    w.addEventListener("mouseenter",()=>clearTimeout(w.tm));
    w.addEventListener("mouseleave",()=>w.tm=setTimeout(rot,3000));
  });
});
</script>
