<?php
if (!function_exists('firefly_customizer_menu')) {
    function firefly_customizer_menu($wp_customize) {
        $wp_customize->add_panel('firefly_menu_panel', array(
            'title'       => __('Firefly Menu', 'my-plugin'),
            'priority'    => 32,
            'description' => __('Customize top, dropdown, and mobile menus.', 'my-plugin'),
        ));

        $menu_sections = [
            'top'      => __('Top Level Menu', 'my-plugin'),
            'dropdown' => __('Drop Down Menu', 'my-plugin'),
            'mobile'   => __('Mobile Menu', 'my-plugin'),
        ];

        $colour_choices = array(
            'colour1' => array('color' => get_theme_mod('firefly_colour_1', '#dd3333'), 'label' => 'Colour 1'),
            'colour2' => array('color' => get_theme_mod('firefly_colour_2', '#1e73be'), 'label' => 'Colour 2'),
            'colour3' => array('color' => get_theme_mod('firefly_colour_3', '#8224e3'), 'label' => 'Colour 3'),
            'colour4' => array('color' => get_theme_mod('firefly_colour_4', '#ededc4'), 'label' => 'Colour 4'),
            'black'   => array('color' => '#000000', 'label' => 'Black'),
            'white'   => array('color' => '#ffffff', 'label' => 'White'),
        );

        $font_weights = [
            'normal' => __('Plain', 'my-plugin'),
            'bold'   => __('Bold', 'my-plugin'),
        ];

        $font_size_choices = [
            '12px' => '12 px',  '13px' => '13 px', '14px' => '14 px',  '15px' => '15 px', '16px' => '16 px',
             '17px' => '17 px', 
            '18px' => '18 px',  '19px' => '19 px', '20px' => '20 px',  '21px' => '21 px', 
            '22px' => '22 px', 
            '23px' => '23 px', 
            '24px' => '24 px',
            '28px' => '28 px', '32px' => '32 px', '36px' => '36 px',
        ];

        $padding_choices = [];
        for ($i = 0; $i <= 200; $i++) {
            $padding_choices["{$i}px"] = "{$i}px";
        }

        $margin_choices = $padding_choices;
        $google_fonts = firefly_get_google_fonts();

        foreach ($menu_sections as $id => $label) {
            $section_id = "firefly_menu_section_{$id}";

            $wp_customize->add_section($section_id, array(
                'title'    => $label,
                'panel'    => 'firefly_menu_panel',
                'priority' => 10,
            ));

            $fields = [
                'background_colour'       => __('Background Colour', 'my-plugin'),
                'text_colour'             => __('Text Colour', 'my-plugin'),
                'highlight_background'    => __('Highlighted Background Colour', 'my-plugin'),
                'highlight_text_colour'   => __('Highlighted Text Colour', 'my-plugin'),
                'padding'                 => __('Menu height (padding above and below menu items)', 'my-plugin'),
                'margin_lr'                 => __('Space between menu items', 'my-plugin'),
                'font_size'               => __('Font Size', 'my-plugin'),
                'font'                    => __('Font', 'my-plugin'),
                'font_weight'             => __('Font Weight', 'my-plugin'),
                'highlight_font_weight'   => __('Highlighted Font Weight', 'my-plugin'),
            ];

            foreach ($fields as $key => $field_label) {


             


                $setting_id = "firefly_menu_{$id}_{$key}";
                $control_id = "firefly_menu_{$id}_{$key}_control";

                switch ($key) {
                    case 'background_colour':
                    case 'text_colour':
                    case 'highlight_background':
                    case 'highlight_text_colour':
                        $wp_customize->add_setting($setting_id, array(
                            'default' => 'black',
                            'transport' => 'refresh',
                            'sanitize_callback' => 'sanitize_text_field',
                        ));
                        $wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
                            $wp_customize,
                            $control_id,
                            array(
                                'label'    => $field_label,
                                'section'  => $section_id,
                                'settings' => $setting_id,
                                'choices'  => $colour_choices,
                            )
                        ));
                        break;
                    case 'padding':

                                if ($id != "mobile") {

                                        $wp_customize->add_setting($setting_id, array(
                                            'default' => '0px',
                                            'transport' => 'refresh',
                                            'sanitize_callback' => 'sanitize_text_field',
                                        ));
                                        $wp_customize->add_control($control_id, array(
                                            'label'    => "$field_label",
                                            'section'  => $section_id,
                                            'settings' => $setting_id,
                                            'type'     => 'select',
                                            'choices'  => $padding_choices,
                                        ));
                                    }

                                        break;
                                    

                                        case 'margin_lr':

                                                if ($id != "mobile") {
                                        $wp_customize->add_setting($setting_id, array(
                                            'default' => '10px',
                                            'transport' => 'refresh'
                                        ));
                                        $wp_customize->add_control($control_id, array(
                                            'label'    => $field_label,
                                            'section'  => $section_id,
                                            'settings' => $setting_id,
                                            'type'     => 'select',
                                            'choices'  => $padding_choices,
                                        ));

                                    }

                                        break;

                        

                    case 'font_size':
                        $wp_customize->add_setting($setting_id, array(
                            'default' => '16px',
                            'transport' => 'refresh',
                            'sanitize_callback' => 'sanitize_text_field',
                        ));
                        $wp_customize->add_control($control_id, array(
                            'label'    => $field_label,
                            'section'  => $section_id,
                            'settings' => $setting_id,
                            'type'     => 'select',
                            'choices'  => $font_size_choices,
                        ));
                        break;
                    case 'font':
                        $wp_customize->add_setting($setting_id, array(
                            'default' => 'Arial, sans-serif',
                            'transport' => 'refresh',
                            'sanitize_callback' => 'sanitize_text_field',
                        ));
                        $wp_customize->add_control($control_id, array(
                            'label'    => $field_label,
                            'section'  => $section_id,
                            'settings' => $setting_id,
                            'type'     => 'select',
                            'choices'  => $google_fonts,
                        ));
                        break;
                    case 'font_weight':
                    case 'highlight_font_weight':
                        $wp_customize->add_setting($setting_id, array(
                            'default' => 'normal',
                            'transport' => 'refresh',
                            'sanitize_callback' => function($input) use ($font_weights) {
                                return array_key_exists($input, $font_weights) ? $input : 'normal';
                            },
                        ));
                        $wp_customize->add_control($control_id, array(
                            'label'    => $field_label,
                            'section'  => $section_id,
                            'settings' => $setting_id,
                            'type'     => 'radio',
                            'choices'  => $font_weights,
                        ));
                        break;
                }
            }


            if ($id === 'dropdown') {
    // Submenu Width dropdown (100px to 400px in 10px steps)
    $submenu_width_choices = [];
    for ($i = 100; $i <= 400; $i += 10) {
        $submenu_width_choices["{$i}px"] = "{$i}px";
    }

    $wp_customize->add_setting('submenuwidth', array(
        'default'           => '250px',
        'transport'         => 'refresh',
        'sanitize_callback' => function($value) use ($submenu_width_choices) {
            return array_key_exists($value, $submenu_width_choices) ? $value : '250px';
        },
    ));

    $wp_customize->add_control('submenuwidth_control', array(
        'label'    => __('Submenu Width', 'my-plugin'),
        'section'  => $section_id,
        'settings' => 'submenuwidth',
        'type'     => 'select',
        'choices'  => $submenu_width_choices,
    ));
}


            if ($id === 'mobile') {
                // Breakpoint dropdown



                // NEW: Hamburger background colour
                $wp_customize->add_setting('firefly_menu_hamburger_background_colour', [
                    'default'   => 'black',
                    'transport' => 'refresh',
                ]);
                $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'firefly_menu_hamburger_background_colour', [
                    'label'    => __('Hamburger background colour', 'firefly'),
                    'section' => $section_id,
                    'settings' => 'firefly_menu_hamburger_background_colour',
                ]));



                // NEW: Hamburger colour
                $wp_customize->add_setting('firefly_menu_hamburger_colour', [
                    'default'   => 'white',
                    'transport' => 'refresh',
                ]);
                $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'firefly_menu_hamburger_colour', [
                    'label'    => __('Hamburger colour', 'firefly'),
                    'section' => $section_id,
                    'settings' => 'firefly_menu_hamburger_colour',
                ]));


                $wp_customize->add_setting('firefly_mobile_breakpoint', [
                    'default' => '768px',
                    'sanitize_callback' => 'sanitize_text_field',
                ]);
                $wp_customize->add_control('firefly_mobile_breakpoint_control', [
                    'label' => __('Page Width for Mobile Menu', 'my-plugin'),
                    'section' => $section_id,
                    'settings' => 'firefly_mobile_breakpoint',
                    'type' => 'select',
                   'choices' => array_combine(
    array_map(function($n) { return "{$n}px"; }, range(480, 1500, 20)),
    array_map(function($n) { return "{$n}px"; }, range(480, 1500, 20))
),

                ]);


                // NEW: Hamburger padding
$wp_customize->add_setting('firefly_menu_hamburger_padding', [
    'default'           => '10px',
   'sanitize_callback' => function($value) {
        return preg_match('/^(?:[0-9]|[1-9][0-9]|1[0-9]{2}|200)px$/', $value)
            ? $value
            : '10px';
    },
    'transport'         => 'refresh',
]);

// Create dropdown choices
$padding_choices = [];
for ($i = 0; $i <= 200; $i++) {
    $padding_choices["{$i}px"] = "{$i}px";
}

// Add the dropdown control
$wp_customize->add_control('firefly_menu_hamburger_padding', [
    'label'    => __('Mobile padding (space between lines)', 'firefly'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_hamburger_padding',
    'type'     => 'select',
    'choices'  => $padding_choices,
]);

            
         // Replace the old checkbox with this radio in your customize_register callback:


         

$choices = [
    'fixed'  => __('Fixed to top of page (default)', 'my-plugin'),
    'above'  => __('Top of page, but can scroll', 'my-plugin'),
    'below'  => __('Below header', 'my-plugin'),
    'sticky' => __('Scrolls but then sticks to the top of the page', 'my-plugin'),
];



// New setting: 'fixed' (default), 'above', 'below', 'sticky' (+ optional 'bilingual')
$wp_customize->add_setting('firefly_mobile_position', [
    'default'           => 'fixed',
    'sanitize_callback' => function ($v) use ($choices) {
        // Only allow currently-available keys
        return array_key_exists($v, $choices) ? $v : 'fixed';
    },
]);

$wp_customize->add_control('firefly_mobile_position_control', [
    'label'    => __('Position of Mobile Menu', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_mobile_position',
    'type'     => 'radio',
    'choices'  => $choices,
]);






// Space above and below logo
$wp_customize->add_setting('firefly_mobile_menu_logo_padding_tb', array(
    'default'           => '0px',
    'sanitize_callback' => function($value) use ($padding_choices) {
        return array_key_exists($value, $padding_choices) ? $value : '0px';
    },
));
$wp_customize->add_control('firefly_mobile_menu_logo_padding_tb_control', array(
    'label'    => __('Space Above and Below Logo on mobile', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_mobile_menu_logo_padding_tb',
    'type'     => 'select',
    'choices'  => $padding_choices,
));

// Space left and right of logo
$wp_customize->add_setting('firefly_mobile_menu_logo_padding_lr', array(
    'default'           => '0px',
    'sanitize_callback' => function($value) use ($padding_choices) {
        return array_key_exists($value, $padding_choices) ? $value : '0px';
    },
));
$wp_customize->add_control('firefly_mobile_menu_logo_padding_lr_control', array(
    'label'    => __('Space Left and Right of Logo on mobile', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_mobile_menu_logo_padding_lr',
    'type'     => 'select',
    'choices'  => $padding_choices,
));



// max height of logo
$wp_customize->add_setting('firefly_mobile_menu_logo_max_height', array(
    'default'           => '0px',
    'sanitize_callback' => function($value) use ($padding_choices) {
        return array_key_exists($value, $padding_choices) ? $value : '300px';
    },
));
$wp_customize->add_control('firefly_mobile_menu_logo_max_height_control', array(
    'label'    => __('Maximum height of Logo on mobile', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_mobile_menu_logo_max_height',
    'type'     => 'select',
    'choices'  => $padding_choices,
));
				


				// there is no menu
				$wp_customize->add_setting('firefly_menu_hamburger_text', [
                    'default' => false,
                    'sanitize_callback' => 'wp_validate_boolean',
                ]);
                $wp_customize->add_control('firefly_menu_hamburger_text_control', [
                    'label' => __('Include the word MENU next to the hamburger', 'my-plugin'),
                    'section' => $section_id,
                    'settings' => 'firefly_menu_hamburger_text',
                    'type' => 'checkbox',
                ]);


				// there is no menu
				$wp_customize->add_setting('firefly_no_menu', [
                    'default' => false,
                    'sanitize_callback' => 'wp_validate_boolean',
                ]);
                $wp_customize->add_control('firefly_no_menu_control', [
                    'label' => __('No menu', 'my-plugin'),
                    'section' => $section_id,
                    'settings' => 'firefly_no_menu',
                    'type' => 'checkbox',
                ]);



                // Mobile dropdown margin-top
$wp_customize->add_setting('firefly_mobile_dropdown_margin_top', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);

$wp_customize->add_control('firefly_mobile_dropdown_margin_top_control', [
    'label'    => __('Mobile dropdown margin top', 'firefly'),
    'section'  => $section_id,
    'settings' => 'firefly_mobile_dropdown_margin_top',
    'type'     => 'select',
    'choices'  => array_combine(
        array_map(function($n) { return "{$n}px"; }, range(0, 100)),
        array_map(function($n) { return "{$n}px"; }, range(0, 100))
    ),
]);



		
			// Build choices: "Full width" + 100px..500px in 2px steps
$dropdown_width_choices = [
    'full' => __('Full width (100%)', 'my-plugin'),
];
for ($i = 100; $i <= 500; $i += 2) {
    $dropdown_width_choices["{$i}px"] = "{$i}px";
}

/**
 * Sanitize: map legacy booleans, then validate against control choices.
 */
function firefly_sanitize_dropdown_width($value, $setting) {
    // Map legacy booleans coming from previous versions
    if ($value === true || $value === '1' || $value === 1 || $value === 'true') {
        $value = 'full';
    } elseif ($value === false || $value === '0' || $value === 0 || $value === 'false') {
        // Choose a sensible non-full default for legacy "false"
        $value = '360px';
    }

    // Validate against control choices
    $control = $setting->manager->get_control($setting->id);
    $choices = is_object($control) ? (array) $control->choices : [];

    return array_key_exists($value, $choices) ? $value : $setting->default;
}

// Setting: keep the same name for backwards compatibility
$wp_customize->add_setting('firefly_mobile_dropdown_full_width', [
    'default'           => 'full', // requested default
    'sanitize_callback' => 'firefly_sanitize_dropdown_width',
    'transport'         => 'refresh',
]);

// Control: switch from checkbox to select with our width options
$wp_customize->add_control('firefly_mobile_dropdown_full_width_control', [
    'label'    => __('Menu drop down width', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_mobile_dropdown_full_width',
    'type'     => 'select',
    'choices'  => $dropdown_width_choices,
]);



              $wp_customize->add_setting('firefly_child_pages_position', [
    'default'           => 'right', // default is "to the right"
    'sanitize_callback' => function( $value ) {
        $valid = ['right', 'below'];
        return in_array($value, $valid, true) ? $value : 'right';
    },
]);

$wp_customize->add_control('firefly_child_pages_position_control', [
    'label'    => __('Position of child pages', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_child_pages_position',
    'type'     => 'radio',
    'choices'  => [
        'right' => __('To the right', 'my-plugin'),
        'below' => __('Below', 'my-plugin'),
    ],
]);



 
            }

if ($id === 'top') {
             

                // Menu alignment setting
$wp_customize->add_setting('firefly_menu_top_align', array(
    'default' => 'left',
    'transport' => 'refresh',
    'sanitize_callback' => function($input) {
        return in_array($input, ['left', 'center', 'right']) ? $input : 'left';
    },
));
$wp_customize->add_control('firefly_menu_top_align_control', array(
    'label'    => __('Menu Alignment', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_top_align',
    'type'     => 'radio',
    'choices'  => [
        'left'   => __('Left', 'my-plugin'),
        'center' => __('Center', 'my-plugin'),
        'right' => __('Right', 'my-plugin'),
    ],
));






// Menu position setting
$wp_customize->add_setting('firefly_menu_position', array(
    'default' => 'below',
    'transport' => 'refresh',
    'sanitize_callback' => function($input) {
        return in_array($input, ['below', 'above', 'fixed', 'bilingual']) ? $input : 'below';
    },
));
// Define base choices
$choices = [
    'below' => __('Below header (default)', 'my-plugin'),
    'above' => __('Above header', 'my-plugin'),
    'fixed' => __('Locked to top of page', 'my-plugin'),
];

// Add bilingual option if plugin active
if ( is_plugin_active('Firefly-bilingual-menu/Firefly-bilingual-menu.php') ) {
    $choices['bilingual'] = __('Bilingual menu (plugin layout)', 'my-plugin');
}

// Register control with choices
$wp_customize->add_control('firefly_menu_position_control', array(
    'label'    => __('Menu Position', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_position',
    'type'     => 'radio',
    'choices'  => $choices,
));


// Menu logo image setting
$wp_customize->add_setting('firefly_menu_logo', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
));
$wp_customize->add_control(new WP_Customize_Image_Control(
    $wp_customize,
    'firefly_menu_logo_control',
    array(
        'label'    => __('Menu Logo', 'my-plugin'),
        'section'  => $section_id,
        'settings' => 'firefly_menu_logo',
    )
));


// Menu logo image setting
$wp_customize->add_setting('firefly_menu_mobile_logo', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
));
$wp_customize->add_control(new WP_Customize_Image_Control(
    $wp_customize,
    'firefly_menu__mobile_logo_control',
    array(
        'label'    => __('Mobile menu logo', 'my-plugin'),
        'section'  => $section_id,
        'settings' => 'firefly_menu_mobile_logo',
    )
));


// Menu logo background colour
$wp_customize->add_setting('firefly_menu_logo_bg_color', array(
    'default' => '#000000',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control(
    $wp_customize,
    'firefly_menu_logo_bg_color_control',
    array(
        'label'    => __('Menu Logo Background Colour', 'my-plugin'),
        'section'  => $section_id,
        'settings' => 'firefly_menu_logo_bg_color',
    )
));

// Space above and below logo
$wp_customize->add_setting('firefly_menu_logo_padding_tb', array(
    'default'           => '0px',
    'sanitize_callback' => function($value) use ($padding_choices) {
        return array_key_exists($value, $padding_choices) ? $value : '0px';
    },
));
$wp_customize->add_control('firefly_menu_logo_padding_tb_control', array(
    'label'    => __('Space Above and Below Logo', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_logo_padding_tb',
    'type'     => 'select',
    'choices'  => $padding_choices,
));

// Space left and right of logo
$wp_customize->add_setting('firefly_menu_logo_padding_lr', array(
    'default'           => '0px',
    'sanitize_callback' => function($value) use ($padding_choices) {
        return array_key_exists($value, $padding_choices) ? $value : '0px';
    },
));
$wp_customize->add_control('firefly_menu_logo_padding_lr_control', array(
    'label'    => __('Space Left and Right of Logo', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_logo_padding_lr',
    'type'     => 'select',
    'choices'  => $padding_choices,
));



// max height of logo
$wp_customize->add_setting('firefly_menu_logo_max_height', array(
    'default'           => '0px',
    'sanitize_callback' => function($value) use ($padding_choices) {
        return array_key_exists($value, $padding_choices) ? $value : '300px';
    },
));
$wp_customize->add_control('firefly_menu_logo_max_height_control', array(
    'label'    => __('Maximum height of Logo', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_logo_max_height',
    'type'     => 'select',
    'choices'  => $padding_choices,
));



// Menu logo background colour
$wp_customize->add_setting('firefly_menu_logo_bg_color', array(
    'default'           => '#000000',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control(
    $wp_customize,
    'firefly_menu_phone_bg_color_control',
    array(
        'label'    => __('Menu Logo Background Colour', 'my-plugin'),
        'section'  => $section_id,
        'settings' => 'firefly_menu_logo_bg_color',
    )
));



// Add the setting
$wp_customize->add_setting('firefly_menu_logo_hide_below', array(
    'default'           => '0',
    'sanitize_callback' => function($value) {
        return preg_match('/^\d+$/', $value) ? $value : '0';
    },
));

// Create an array of choices
$hide_logo_choices = array('0' => '0px - Do not hide');
for ($i = 100; $i <= 1400; $i += 10) {
    $hide_logo_choices[(string)$i] = $i . 'px';
}

// Add the control
$wp_customize->add_control('firefly_menu_logo_hide_below_control', array(
    'label'    => __('Hide logo below this screen size', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_logo_hide_below',
    'type'     => 'select',
    'choices'  => $hide_logo_choices,
));

// hide the phone pic

$wp_customize->add_setting('firefly_phone_pic_hide_below', array(
    'default'           => '0',
    'sanitize_callback' => function($value) {
        return preg_match('/^\d+$/', $value) ? $value : '0';
    },
));

// Add the control
$wp_customize->add_control('firefly_phone_pic_hide_below_control', array(
    'label'    => __('Hide phone pic below this screen size', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_phone_pic_hide_below',
    'type'     => 'select',
    'choices'  => $hide_logo_choices,
));


// hide the phone number

$wp_customize->add_setting('firefly_phone_number_hide_below', array(
    'default'           => '0',
    'sanitize_callback' => function($value) {
        return preg_match('/^\d+$/', $value) ? $value : '0';
    },
));

// Add the control
$wp_customize->add_control('firefly_phone_number_hide_below_control', array(
    'label'    => __('Hide phone number this screen size', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_phone_number_hide_below',
    'type'     => 'select',
    'choices'  => $hide_logo_choices,
));








// text link
$wp_customize->add_setting('firefly_menu_text_link', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('firefly_menu_text_link_control', array(
    'label'    => __('Menu Text Link (eg "/contact-us/")', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_text_link',
    'type'     => 'text',
));

// text
$wp_customize->add_setting('firefly_menu_text', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('firefly_menu_text_control', array(
    'label'    => __('Menu Text (eg "Get a free quote now!")', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_text',
    'type'     => 'text',
));




// Menu phone number
$wp_customize->add_setting('firefly_menu_phone_number', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('firefly_menu_phone_number_control', array(
    'label'    => __('Menu Phone Number', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_phone_number',
    'type'     => 'text',
));

// Menu phone text
$wp_customize->add_setting('firefly_menu_phone_text', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('firefly_menu_phone_text_control', array(
    'label'    => __('Menu Phone Text (e.g. "Call us!")', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_phone_text',
    'type'     => 'text',
));

// Phone icon image setting
$wp_customize->add_setting('firefly_menu_phone_icon', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control(new WP_Customize_Image_Control(
    $wp_customize,
    'firefly_menu_phone_icon_control',
    array(
        'label'    => __('Phone Icon', 'my-plugin'),
        'section'  => $section_id,
        'settings' => 'firefly_menu_phone_icon',
    )
));


// Phone icon height setting
$wp_customize->add_setting('firefly_menu_phone_icon_height', array(
    'default'           => '50',
    'sanitize_callback' => function($value) {
        return preg_match('/^\d+$/', $value) ? $value : '50';
    },
));

// Create dropdown choices from 50 to 200 in 5px steps
$phone_icon_height_choices = [];
for ($i = 5; $i <= 350; $i += 5) {
    $phone_icon_height_choices[(string)$i] = $i . 'px';
}

// Add the control
$wp_customize->add_control('firefly_menu_phone_icon_height_control', array(
    'label'    => __('Phone Icon Height', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_phone_icon_height',
    'type'     => 'select',
    'choices'  => $phone_icon_height_choices,
));



// Phone text/number vertical spacing
$wp_customize->add_setting('firefly_menu_phone_spacing', array(
    'default' => '5px',
    'sanitize_callback' => function($input) {
        return preg_match('/^(?:[0-9]|1[0-9]|20)px$/', $input) ? $input : '5px';
    },
));

$spacing_choices = [];
for ($i = 0; $i <= 20; $i++) {
    $px = $i . 'px';
    $spacing_choices[$px] = $px;
}

$wp_customize->add_control('firefly_menu_phone_spacing_control', array(
    'label'    => __('Space between Phone Text and Number', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_phone_spacing',
    'type'     => 'select',
    'choices'  => $spacing_choices,
));


// Menu phone background colour
$wp_customize->add_setting('firefly_menu_phone_bg_color', array(
    'default' => '#000000',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control(
    $wp_customize,
    'firefly_menu_phone_bg_color_control',
    array(
        'label'    => __('Menu Phone Background Colour', 'my-plugin'),
        'section'  => $section_id,
        'settings' => 'firefly_menu_phone_bg_color',
    )
));


// Phone number font size
$wp_customize->add_setting('firefly_menu_phone_number_font_size', array(
    'default' => '16px',
    'sanitize_callback' => function($input) {
        $valid = ['12px', '14px', '16px', '18px', '20px', '24px', '28px', '30px', '36px'];
        return in_array($input, $valid) ? $input : '16px';
    },
));

$wp_customize->add_control('firefly_menu_phone_number_font_size_control', array(
    'label'    => __('Phone Number Font Size', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_phone_number_font_size',
    'type'     => 'select',
    'choices'  => array(
        '12px' => '12px',
        '14px' => '14px',
        '16px' => '16px',
        '18px' => '18px',
        '20px' => '20px',
        '24px' => '24px',
          '28px' => '28px',
        '30px' => '30px',
        '36px' => '36px',
    ),
));

// Phone text font size
$wp_customize->add_setting('firefly_menu_phone_text_font_size', array(
    'default' => '16px',
    'sanitize_callback' => function($input) {
        $valid = ['12px', '14px', '16px', '18px', '20px', '24px', '30px', '36px'];
        return in_array($input, $valid) ? $input : '16px';
    },
));

$wp_customize->add_control('firefly_menu_phone_text_font_size_control', array(
    'label'    => __('Phone Text Font Size', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_menu_phone_text_font_size',
    'type'     => 'select',
    'choices'  => array(
        '12px' => '12px',
        '14px' => '14px',
        '16px' => '16px',
        '18px' => '18px',
        '20px' => '20px',
        '24px' => '24px',
        '30px' => '30px',
        '36px' => '36px',
    ),
));

// Menu phone text colour
$wp_customize->add_setting('firefly_menu_phone_text_color', array(
    'default' => '#ffffff',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control(
    $wp_customize,
    'firefly_menu_phone_text_color_control',
    array(
        'label'    => __('Menu Phone Text Colour', 'my-plugin'),
        'section'  => $section_id,
        'settings' => 'firefly_menu_phone_text_color',
    )
));











                foreach (['margin_top' => 'Space Above', 'margin_bottom' => 'Space Below'] as $margin_key => $label_txt) {
                    $setting_id = "firefly_menu_top_{$margin_key}";
                    $wp_customize->add_setting($setting_id, array(
                        'default' => '0px',
                        'transport' => 'refresh',
                        'sanitize_callback' => 'sanitize_text_field',
                    ));
                    $wp_customize->add_control("{$setting_id}_control", array(
                        'label'    => __($label_txt, 'my-plugin'),
                        'section'  => $section_id,
                        'settings' => $setting_id,
                        'type'     => 'select',
                        'choices'  => $margin_choices,
                    ));
                }


                    // Show borders around divs for debugging
$wp_customize->add_setting('firefly_show_menu_debug_borders', [
    'default'           => false,
    'sanitize_callback' => 'wp_validate_boolean',
]);

$wp_customize->add_control('firefly_show_menu_debug_borders_control', [
    'label'    => __('Show borders around divs for debugging', 'my-plugin'),
    'section'  => $section_id,
    'settings' => 'firefly_show_menu_debug_borders',
    'type'     => 'checkbox',
]);


            }
        }
    }



}
add_action('customize_register', 'firefly_customizer_menu', 21);

function firefly_get_google_fonts() {
    return [
        'Arial, sans-serif' => 'Arial',
        'Roboto, sans-serif' => 'Roboto',
        'Open Sans, sans-serif' => 'Open Sans',
        'Lato, sans-serif' => 'Lato',
        'Montserrat, sans-serif' => 'Montserrat',
        'Raleway, sans-serif' => 'Raleway',
        'Merriweather, serif' => 'Merriweather',
        'Georgia, serif' => 'Georgia',
        'Times New Roman, serif' => 'Times New Roman',
        'Courier New, monospace' => 'Courier New',
    ];
}

add_action('wp_head', function () {
	
	  if ( get_theme_mod('firefly_no_menu', false) ) {
        return;
    }
	
    $sections = ['top', 'dropdown', 'mobile'];
  











?>




<style id='firefly-custom-menu-styles'>
<?php
// Process all theme mods first
$mobile_bp = get_theme_mod('firefly_mobile_breakpoint', '768px');
$mobile_fixed = get_theme_mod('firefly_mobile_fixed', false);
$menu_padding = get_theme_mod('firefly_menu_top_padding', '10px');
$margin_lr = get_theme_mod('firefly_menu_top_margin_lr', '10px');
$submenuwidth = get_theme_mod('submenuwidth', '550px');
$mobilepadding = get_theme_mod('firefly_menu_hamburger_padding', '5px');
$firefly_show_menu_debug_borders = get_theme_mod('firefly_show_menu_debug_borders', '');
$child_pages_position = get_theme_mod('firefly_child_pages_position', 'right');
$mobile_dropdown_full_width = (bool) get_theme_mod('firefly_mobile_dropdown_full_width', false);
$menu_logo_hide_below = get_theme_mod('firefly_menu_logo_hide_below', '0');

$firefly_phone_pic_hide_below = get_theme_mod('firefly_phone_pic_hide_below', '0');
$firefly_phone_number_hide_below = get_theme_mod('firefly_phone_number_hide_below', '0');

// Process dropdown colors
$drop_bg = get_theme_mod('firefly_menu_dropdown_background_colour', 'black');
$drop_txt = get_theme_mod('firefly_menu_dropdown_text_colour', 'white');



$drop_hbg = get_theme_mod('firefly_menu_dropdown_highlight_background', 'white');
$drop_htxt = get_theme_mod('firefly_menu_dropdown_highlight_text_colour', 'black');
$drop_weight = get_theme_mod('firefly_menu_dropdown_font_weight', 'normal');
$drop_hweight = get_theme_mod('firefly_menu_dropdown_highlight_font_weight', 'bold');

// Process mobile colors
$mobile_txt = get_theme_mod('firefly_menu_mobile_text_colour', 'white');
$mobile_bg = get_theme_mod('firefly_menu_mobile_background_colour', 'black');
$mobile_highlight_txt = get_theme_mod('firefly_menu_mobile_highlight_text_colour', 'white');
$mobile_highlight_bg = get_theme_mod('firefly_menu_mobile_highlight_background', 'black');
$hamburger_bg = get_theme_mod('firefly_menu_hamburger_background_colour', 'black');
$hamburger_colour = get_theme_mod('firefly_menu_hamburger_colour', 'white');
$menu_logo_bg_color = get_theme_mod('firefly_menu_logo_bg_color', 'white');

$menu_logo_padding_tb = get_theme_mod('firefly_menu_logo_padding_tb', '0px');
$menu_logo_padding_lr = get_theme_mod('firefly_menu_logo_padding_lr', '0px');
$menu_position = get_theme_mod('firefly_menu_position', 'below'); 


$mobile_menu_logo_padding_tb = get_theme_mod('firefly_mobile_menu_logo_padding_tb', '0px'); 
$mobile_menu_logo_padding_lr = get_theme_mod('firefly_mobile_menu_logo_padding_lr', '0px'); 
$mobile_menu_logo_max_height = get_theme_mod('firefly_mobile_menu_logo_max_height', '200px'); 









// Color processing function
function process_color($color_value) {
    return match ($color_value) {
        'colour1' => get_theme_mod('firefly_colour_1', '#dd3333'),
        'colour2' => get_theme_mod('firefly_colour_2', '#1e73be'),
        'colour3' => get_theme_mod('firefly_colour_3', '#8224e3'),
        'colour4' => get_theme_mod('firefly_colour_4', '#ededc4'),
        'white'   => '#ffffff',
        default   => '#000000',
    };
}

// Process all colors
$drop_bg = process_color($drop_bg);
$drop_txt = process_color($drop_txt);
$drop_hbg = process_color($drop_hbg);
$drop_htxt = process_color($drop_htxt);
$mobile_txt = process_color($mobile_txt);
$mobile_bg = process_color($mobile_bg);
$mobile_highlight_txt = process_color($mobile_highlight_txt);
$mobile_highlight_bg = process_color($mobile_highlight_bg);

$menu_top_background_colour = get_theme_mod('firefly_menu_top_background_colour', '#FFFFFF'); 
$menu_top_background_colour = process_color($menu_top_background_colour);




// Store section styles
$section_styles = [];

foreach ($sections as $id) {
    $prefix = "firefly_menu_{$id}_";

    $bg = get_theme_mod($prefix . 'background_colour', 'black');
    $txt = get_theme_mod($prefix . 'text_colour', 'white');
    $hlbg = get_theme_mod($prefix . 'highlight_background', 'white');
    $hltxt = get_theme_mod($prefix . 'highlight_text_colour', 'white');
    $pad = get_theme_mod($prefix . 'padding', '10px');
    $fsize = get_theme_mod($prefix . 'font_size', '16px');
    $font = get_theme_mod($prefix . 'font', 'Arial, sans-serif');
    $weight = get_theme_mod($prefix . 'font_weight', 'normal');
    $hlw = get_theme_mod($prefix . 'highlight_font_weight', 'bold');
    $mobile_dropdown_margin_top = get_theme_mod('firefly_mobile_dropdown_margin_top', '0px');
    $mobile_position  = get_theme_mod('firefly_mobile_position', 'fixed');
    $menu_logo_max_height  = get_theme_mod('firefly_menu_logo_max_height', '100px');

  $mobile_dropdown_full_width = get_theme_mod('firefly_mobile_dropdown_full_width', 'full');
    


    // Process colors for this section
    $bg = process_color($bg);
    $txt = process_color($txt);
    $hlbg = process_color($hlbg);
    $hltxt = process_color($hltxt);

    $align = ($id === 'top') ? get_theme_mod('firefly_menu_top_align', 'left') : 'left';
    $m_top = ($id === 'top') ? get_theme_mod('firefly_menu_top_margin_top', '0px') : '0px';
    $m_bot = ($id === 'top') ? get_theme_mod('firefly_menu_top_margin_bottom', '0px') : '0px';

    $selector = match ($id) {
        'top' => 'nav.main-menu',
        'dropdown' => 'nav.main-menu ul.sub-menu',
        'mobile' => 'nav.mobile-menu',
    };

    $section_styles[$id] = [
        'selector' => $selector,
        'bg' => $bg,
        'txt' => $txt,
        'hlbg' => $hlbg,
        'hltxt' => $hltxt,
        'font' => $font,
        'weight' => $weight,
        'hlw' => $hlw,
        'fsize' => $fsize,
        'align' => $align,
        'm_top' => $m_top,
        'm_bot' => $m_bot,
        'pad' => $pad
    ];
}


  $align = get_theme_mod('firefly_menu_top_align', 'left');
if ($align == "right") {

    echo "
    nav.main-menu {

        padding-right:15px !important;
    }

    ";
}


if ($align == "center") {

    echo "
 /* Center the main menu relative to the whole page */
.menu-bar {
    position: relative;
    justify-content: center !important;
}

/* Fix logo on left */
.menu-logo {
    position: absolute;
    left: 0;
    top: 50%;
    transform: translateY(-50%);
}

/* Fix phone block on right */
.menu-phone {
    position: absolute;
    right: 0;
    top: 50%;
    transform: translateY(-50%);
}

/* Make the menu truly centered */
.main-menu {
    width: 100%;
    display: flex;
    justify-content: center !important;
}


    ";
}
?>

/* ===== BASE MENU STYLES ===== */
nav.main-menu, 
nav.main-menu ul.sub-menu, 
nav.mobile-menu {
  margin: 0;
  padding: 0;
  list-style: none;
}

nav.main-menu > ul,
nav.mobile-menu > ul {
  list-style: none;
  margin: 0 auto;
  padding: 0;
  display: table;
}

nav.main-menu > ul > li,
nav.mobile-menu > ul > li {
  display: table-cell;
  padding: 0;
  vertical-align: middle;
}

nav.main-menu ul li a,
nav.mobile-menu ul li a {
  text-decoration: none !important;
  display: block;
  padding: 8px 12px;
  transition: background 0.3s ease, color 0.3s ease;
}

.menu-logo { 
    flex-shrink: 0; 
    background-color:<?php echo $menu_logo_bg_color; ?>; 
    padding-top: <?php echo $menu_logo_padding_tb; ?>; 
    padding-bottom: <?php echo $menu_logo_padding_tb; ?>; 
    padding-left:  <?php echo $menu_logo_padding_lr; ?>; 
    padding-right: <?php echo $menu_logo_padding_lr; ?>; 
}


/* Positioning options */ 
.menu-position-fixed { 
    position: fixed; top: 0; width: 100%; 
    z-index: 999; 
    bbackground-color: <?php echo esc_attr($menu_bg_color); ?>; 
} 
    
    .menu-position-below { 
        position: relative; 
    }


.menu-position-fixed, 
.menu-position-below, 
.menu-position-above,
.fluffydice { 
    background-color: <?php echo esc_html($menu_top_background_colour); ?>;
}  




/* ===== SECTION SPECIFIC STYLES ===== */
<?php foreach ($section_styles as $id => $style): ?>
<?php if ($id === 'top'): ?>
/* Top Menu Styles */
<?php echo $style['selector']; ?> {
  background-color: <?php echo $style['bg']; ?>;
  text-align: <?php echo $style['align']; ?> !important;
  margin-top: <?php echo $style['m_top']; ?>;
  margin-bottom: <?php echo $style['m_bot']; ?>;
  justify-content: <?php echo ($style['align'] === 'center' ? 'center' : 'flex-start'); ?>;
}

<?php echo $style['selector']; ?> ul li a {
  color: <?php echo $style['txt']; ?> !important;
  font-family: <?php echo $style['font']; ?>;
  font-weight: <?php echo $style['weight']; ?>;
  font-size: <?php echo $style['fsize']; ?>;
}

<?php echo $style['selector']; ?> ul li a:hover,
<?php echo $style['selector']; ?> ul li.current-menu-item > a,
<?php echo $style['selector']; ?> ul li.current_page_item > a {
  background-color: <?php echo $style['hlbg']; ?>;
  color: <?php echo $style['hltxt']; ?> !important;
  font-weight: <?php echo $style['hlw']; ?>;
}

<?php elseif ($id === 'dropdown'): ?>
/* Dropdown Menu Styles */
<?php echo $style['selector']; ?> li a {
  background: <?php echo $style['bg']; ?>;
  color: <?php echo $style['txt']; ?> !important;
  font-weight: <?php echo $style['weight']; ?>;
}

<?php echo $style['selector']; ?> li a:hover,
<?php echo $style['selector']; ?> li.current-menu-item > a {
  background: <?php echo $style['hlbg']; ?>;
  color: <?php echo $style['hltxt']; ?> !important;
  font-weight: <?php echo $style['hlw']; ?>;
}
<?php endif; ?>
<?php endforeach; ?>

/* Third-level sub-menu */
nav.main-menu ul.sub-menu li ul.sub-menu {
  display: none;
  position: absolute;
  top: 0;
  left: 100%;
  z-index: 1001;
  padding: 0;
  margin: 0;
  min-width: 100%;
}

nav.main-menu ul.sub-menu li:hover > ul.sub-menu {
  display: block;
}

/* nav.main-menu ul.sub-menu li.menu-item-has-children > a::after {
  content: '▶';
  float: right;
  margin-left: 10px;
  font-size: 12px;
}*/


<?php
$mobile_position = function_exists('firefly_get_mobile_menu_position')
    ? firefly_get_mobile_menu_position()
    : get_theme_mod('firefly_mobile_position', 'fixed'); // fallback
?>




/* 1) Make the parent a 3-column flex row */
.menu-bar{
  display:flex;
  align-items:center;          /* vertically center items */
  justify-content:space-between;
  gap:20px;                    /* space between the 3 columns */
}

/* 2) Center the nav in the middle column and keep it flexible */
.main-menu{ 
  flex:1 1 auto;               /* middle grows to fill */
}
.main-menu ul{
  display:flex;
  align-items:center;
  justify-content:center;      /* center menu items */
  gap:16px;
  margin:0;                    /* reset default UL spacing */
  padding:0;
  list-style:none;
}
.main-menu li{ list-style:none; }

/* 3) Left and right columns size to content */
.menu-logo{ flex:0 0 auto; }
.menu-logo img{ 
  max-height:<?php echo $menu_logo_max_height; ?>; 
  width:auto; 
  display:block;
}
.menu-phone{ 
  flex:0 0 auto;               /* do not stretch full width */
}

/* Optional: make each menu link a tidy block target */
.menu-item a{
  display:block;
  padding:8px 12px;
  text-decoration:none;
}



@media (max-width: <?php 
   echo $menu_logo_hide_below; 
    ?>px) {
    .menu-logo { 
        display:none !important;
    }
}


@media (max-width: <?php 
   echo $firefly_phone_pic_hide_below; 
    ?>px) {
    #menu-phone-pic { 
       display:none !important;
    }
    .snippy {}
}


@media (max-width: <?php 
   echo $firefly_phone_number_hide_below; 
    ?>px) {
    .menu-phone { 
        display:none !important;
    }
}




/* ===== MOBILE MENU STYLES ===== */
@media (max-width: <?php echo $mobile_bp; ?>) {
  /* Hide desktop menu on mobile */
  nav.main-menu { 
    display: none !important; 
  }


.mobile-menu-logo { 
    background-color: <?php echo esc_html($hamburger_bg); ?>;
}

.mobile-menu-logo img { 
    margin-bottom: <?php echo esc_html($mobile_menu_logo_padding_tb); ?>;
    margin-top: <?php echo esc_html($mobile_menu_logo_padding_tb); ?>;
    margin-left: <?php echo esc_html($mobile_menu_logo_padding_lr); ?>;
    margin-right: <?php echo esc_html($mobile_menu_logo_padding_lr); ?>;
    max-height:  <?php echo esc_html($mobile_menu_logo_max_height); ?>;

}  






  .mobile-menu-toggle {
    background: <?php echo $hamburger_bg; ?> !important;
    border: none;
    font-size: 28px;
    color: <?php echo $hamburger_colour; ?>;
    cursor: pointer;
    display: block !important;
  }

  /* === Positioning depends on $mobile_position === */
  <?php if (in_array($mobile_position, ['top','above'], true)) : ?>
    /* TOP mode: menu sits at the top on load and scrolls with the page */
    .mobile-menu-bar {
      position: relative; /* in normal flow */
      top: 0; left: 0; right: 0;
      z-index: 1; /* no need to be huge if it's in flow */
      margin: 0;
      
    }

    nav.mobile-menu {
      display: none;               /* toggled open by your JS */
      position: relative;          /* NOT fixed */
      top: auto;                   /* no offset */
      left: auto; right: auto;
      z-index: 2;                  /* only above content directly below */
      background-color: <?php echo $mobile_bg; ?>;
      margin-top: 0px;            /* keep your spacing */
      padding: 10px 0;
    
   
      <?php 
      
  

            if ($mobile_dropdown_full_width === 'full' || $mobile_dropdown_full_width === '100%') {
                echo 'width: 100%;';
            } else {
                // Safe: value is guaranteed by sanitizer to be one of the choices (e.g., "360px")
                echo 'max-width: ' . esc_attr($mobile_dropdown_full_width) . ';';
            }

      
      
  ?>
      /* remove any forced admin-bar offsets in this mode */
    }

    /* Submenus should also scroll: no absolute/fixed positioning */
    nav.mobile-menu ul.sub-menu {
      display: none;     /* your .open class can set display:block */
      position: static;  /* <— critical: stop fixed/absolute behavior */
      width: 100%;
      height: auto;
      z-index: auto;
      padding: 0;
      margin: 0;
      
    }
  <?php else: ?>
    /* FIXED / STICKY / BELOW modes keep your previous behavior */
    .mobile-menu-bar {
      <?php if ($mobile_position === 'fixed'): ?>
        position: fixed; top: 0; left: 0; right: 0; z-index: 10000;
      <?php elseif ($mobile_position === 'sticky'): ?>
        position: sticky; top: 0; left: 0; right: 0; z-index: 10000;
      <?php else: /* below */ ?>
        position: relative; top: 0; left: 0; right: 0; z-index: 1;
      <?php endif; ?>
      margin: 0;
    }

    nav.mobile-menu {
      display: none;
      background-color: <?php echo $mobile_bg; ?>;
      margin-top: <?php echo $mobile_dropdown_margin_top; ?>;
      padding: 10px 0;
      <?php if ($mobile_position === 'fixed' || $mobile_position === 'sticky'): ?>
        position: fixed;            /* dropdown anchored to viewport */
        top: 46px;                  /* admin bar handled below */
        left: 0; right: 0;
        z-index: 99999;
      <?php else: ?>
        position: relative;
      <?php endif; ?>
      chicken:dog;
      <?php 
      
            if ($mobile_dropdown_full_width === 'full' || $mobile_dropdown_full_width === '100%') {
                echo 'width: 100%;';
            } else {
                // Safe: value is guaranteed by sanitizer to be one of the choices (e.g., "360px")
                echo 'max-width: ' . esc_attr($mobile_dropdown_full_width) . ';';
            }



     ?>
    }

    nav.mobile-menu ul.sub-menu {
      display: none;
      position: absolute; /* keep your old slide-out behavior for non-top modes */
      top: 0;
      left: 100%;
      width: 100%;
      height: 100%;
      z-index: 99999;
      padding: 0;
    }
  <?php endif; ?>

  nav.mobile-menu ul {
    list-style: none;
    margin: 0;
    padding: 0 !important;
    width: 100%;
  }

  nav.mobile-menu ul li { display: block; width: 100%; padding: 0; margin: 0; }

  nav.mobile-menu ul li a {
    color: <?php echo $mobile_txt; ?>;
    text-decoration: none;
    padding: <?php echo $mobilepadding; ?> !important;
    margin: 0;
  
  }

  nav.mobile-menu ul li a:hover {
    background: <?php echo $mobile_highlight_bg; ?>;
     color: <?php echo $mobile_highlight_txt; ?> !important;
  }

  nav.mobile-menu ul.sub-menu.open { display: block; }

  /* Third-level links */
  nav.mobile-menu ul.sub-menu li a {
    background-color: <?php echo $mobile_bg; ?>;
    color: <?php echo $mobile_txt; ?> !important;
    font-weight: <?php echo $drop_weight; ?>;
    padding-left: 50px;
    max-width: 100%;
  }

  nav.mobile-menu ul.sub-menu li a:hover,
  nav.mobile-menu ul.sub-menu li.current-menu-item > a {
    background-color: <?php echo $mobile_highlight_bg; ?> !important;
    color: <?php echo $mobile_highlight_txt; ?> !important;
    font-weight: <?php echo $drop_hweight; ?>;
  }

  .menu-phone { display: none !important; }
}

/* Admin bar offsets ONLY for fixed/sticky modes */
<?php if (!in_array($mobile_position, ['top','above'], true)) : ?>
  body.admin-bar .mobile-menu-bar { top: 32px; }
  @media (max-width: 782px) {
    body.admin-bar .mobile-menu-bar { top: 46px; }
  }
<?php endif; ?>


@media (min-width: <?php echo $mobile_bp; ?>) {
  .mobile-menu-bar, 
  nav.mobile-menu { 
    display: none !important; 
  }
  
  nav.main-menu { 
    display: block; 
  }
  
  /* Desktop menu layout */
  nav.main-menu ul {
    display: inline-block;
    margin: 0 auto;
    padding-left: 0 !important;
    margin-left: 0 !important;
  }
  
  nav.main-menu ul li {
    position: relative;
    display: inline-block;
    margin-left: 0 !important;
    margin-right: 0 !important;
     padding-left: 0 !important;
    padding-right: 0 !important;
  }
  
  nav.main-menu ul li a {
    margin-left:0px !important;
    margin-right:0px !important;
    padding-left: <?php echo $margin_lr; ?> ;
    padding-right: <?php echo $margin_lr; ?> ;
    padding-top: <?php echo $menu_padding; ?> !important;
    padding-bottom: <?php echo $menu_padding; ?> !important;
  }
  
  nav.main-menu ul li ul.sub-menu {
    display: none;
    position: absolute;
    top: 100%;
    left: 0;
    min-width: <?php echo $submenuwidth; ?>;
    z-index: 1000;
    text-align: left;
    padding: 0;
    margin: 0;
  }
  
  nav.main-menu ul li:hover > ul.sub-menu {
    display: block;
  }
  
  nav.main-menu ul.sub-menu li {
    display: block;
    margin: 0;
    padding: 0;
  }
  
  nav.main-menu ul.sub-menu li a {
    padding: 10px 15px;
    text-align: left;
    margin: 0;
  }
}

/* ===== ACTIVE STATES ===== */
.mobile-menu.active {
  display: block !important;
}

/* ===== DEBUG STYLES ===== */
<?php if ($firefly_show_menu_debug_borders): ?>
.main-menu { border: 5px red solid; }
.main-menu ul { border: 5px green solid; }
.menu-item { border: 5px pink solid; }
.menu-logo { border: 5px orange solid; }
.menu-phone { border: 5px green solid; }
.phone-text { border: 5px brown solid; }
.phone-number { border: 5px purple solid; }
.phone-wrapper { border: 5px red solid; }
.menu-item a { border: 5px blue solid; } 
.header-spacer {border:2px black solid;}
.menu-position-fixed { border: 2px purple solid;}
.menu-position-below { border: 2px brown solid;}
.menu-position-above { border: 2px crimson solid;}
<?php endif; ?>

/* ===== ADMIN BAR ADJUSTMENTS ===== */
body.admin-bar .menu-position-fixed,
body.admin-bar .menu-position-above { 
  margin-top: 32px; 
}

@media screen and (max-width: 782px) {
  body.admin-bar .menu-position-fixed,
  body.admin-bar .menu-position-above { 
    margin-top: 46px; 
  }
}



/* Scope to the mobile menu only so desktop is unaffected */
nav.mobile-menu {
  /* your inline style handles display; leave layout to CSS */
  width: 100%;
}

/* reset list styles and make items vertical */
nav.mobile-menu ul {
  list-style: none;
  padding-left: 0;
  margin: 0;
}
nav.mobile-menu li {
  display: block;
}

/* make each link a full-width row */
nav.mobile-menu a {
  display: block;
  text-decoration: none;
  padding: 12px 16px;
  border-bottom: 1px solid #eee;
}

/* —— CRITICAL OVERRIDES for WP dropdown behavior —— */
/* submenus must be visible, not absolutely positioned */
nav.mobile-menu .sub-menu {
  display: block !important;          /* force visible */
  position: static !important;        /* stack vertically */
  visibility: visible !important;     /* some themes toggle this */
  opacity: 1 !important;              /* kill fade tricks */
  transform: none !important;         /* kill slide/scale tricks */
  margin: 0;                          /* we’ll indent below */
  padding: 0;
}

/* indentation by level */
nav.mobile-menu > ul > li > a { padding-left: 16px; }        /* level 1 */
nav.mobile-menu .sub-menu > li > a { padding-left: 32px; }    /* level 2 */
nav.mobile-menu .sub-menu .sub-menu > li > a { padding-left: 48px; } /* level 3 */

/* optional: slightly lighter separators for deeper levels */
nav.mobile-menu .sub-menu > li > a { border-bottom-color: #f2f2f2; }
nav.mobile-menu .sub-menu .sub-menu > li > a { border-bottom-color: #f7f7f7; }

/* optional: highlight current page */
nav.mobile-menu .current-menu-item > a,
nav.mobile-menu .current_page_item > a {
  font-weight: 600;
}

</style>
<?php
});    




// Add JS to handle dropdowns on touch devices
add_action('wp_footer', function() {
    ?>
    <script>


// Mobile submenu toggle
// Mobile submenu flyout

 // Fix for home page highlighting
        function highlightHomePage() {
            if (document.body.classList.contains('home') || document.body.classList.contains('front-page')) {
                const homeMenuItems = document.querySelectorAll('.menu-item-home');
                homeMenuItems.forEach(item => {
                    item.classList.add('current-menu-item');
                });
            }
        }


    (function() {
        var mobileBreakpoint = 768;
        var toggle, menu;

        function initMobileMenu() {
            toggle = document.querySelector('.mobile-menu-toggle');
            menu = document.querySelector('.mobile-menu');

            if (toggle && menu) {
                toggle.onclick = function(e) {
                    if (e) e.preventDefault();
                    menu.classList.toggle('active');
                    toggle.innerHTML = menu.classList.contains('active') ? '✕' : '☰';
                    return false;
                };
            }

            // Enable touch dropdowns
            const menuItems = document.querySelectorAll('nav.main-menu li.menu-item-has-children');
            menuItems.forEach(item => {
                item.addEventListener('touchstart', function(e) {
                    const isOpen = this.classList.contains('hover');
                    menuItems.forEach(i => i.classList.remove('hover'));
                    if (!isOpen) {
                        e.preventDefault();
                        this.classList.add('hover');
                    }
                });
            });

            document.addEventListener('click', function(e) {
                if (!e.target.closest('nav.main-menu')) {
                    document.querySelectorAll('nav.main-menu li.hover').forEach(el => el.classList.remove('hover'));
                }
            });
        }

        function handleResize() {
            if (menu && toggle) {
                if (window.innerWidth > mobileBreakpoint) {
                    menu.classList.remove('active');
                    toggle.innerHTML = '☰';
                }
            }
        }

        if (document.readyState === 'complete' || document.readyState === 'interactive') {
            setTimeout(function() {
                initMobileMenu();
                handleResize();
            }, 1);
        } else {
            document.addEventListener('DOMContentLoaded', function() {
                initMobileMenu();
                handleResize();
            });
        }

          window.addEventListener('load', function() {
            handleResize();
            highlightHomePage(); // Make sure to run this again on load
        });

    })();


function handleResize() {
    if (menu && toggle) {
        if (window.innerWidth > mobileBreakpoint) {
            menu.classList.remove('active');
            toggle.innerHTML = '☰';
            menu.style.display = ''; // <-- Reset mobile menu inline styles
        } else {
            menu.style.display = 'none'; // Reset again for mobile
        }
    }
}


(function($) {
    const mobileBreakpoint = 768;

    function resetMenusOnResize() {
        const windowWidth = $(window).width();

        if (windowWidth > mobileBreakpoint) {
            $('.mobile-menu, .mobile-menu-overlay').removeClass('active');
            $('body').removeClass('mobile-menu-open');
        } else {
            $('.main-menu').removeClass('expanded');
        }
    }

    $(window).on('resize', function () {
        resetMenusOnResize();
    });

    $(document).ready(function () {
        resetMenusOnResize();
    });
})(jQuery);




    </script>
    <?php
});




 



  /* Mobile menu bar */

// Put this inside your plugin file

add_action('wp_head', 'firefly_mobile_menu_styles');

function firefly_mobile_menu_styles() {
    // Fetch customizer values
    $hamburger_bg     = get_theme_mod('firefly_menu_hamburger_background_colour', '#333');
    $hamburger_colour = get_theme_mod('firefly_menu_hamburger_colour', '#fff');
     $mobile_position  = get_theme_mod('firefly_mobile_position', 'fixed');
    // (reuse your helper from before that maps old/new settings)

    ?>
    <style type="text/css">
    /* Mobile menu bar */





    .mobile-menu-bar {

        background-color: <?php echo esc_html($hamburger_bg); ?> !important;
        color: <?php echo esc_html($hamburger_colour); ?> !important;
        width: 100%;
        padding: 10px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        <?php if ($mobile_position === 'fixed') : ?>
            position: fixed;
            top: <?php echo is_admin_bar_showing() ? '32px' : '0'; ?>;
            left: 0;
            right: 0;
            z-index: 1000;

        <?php elseif ($mobile_position === 'above') : ?>
            position: relative;
            top: <?php echo is_admin_bar_showing() ? '32px' : '0'; ?>;
            left: 0;
            right: 0;
            z-index: 1000;
        <?php elseif ($mobile_position === 'sticky') : ?>
            position: sticky;
            top: <?php echo is_admin_bar_showing() ? '32px' : '0'; ?>;
            left: 0;
            right: 0;
            z-index: 1000;
        <?php elseif ($mobile_position === 'below') : ?>
            position: relative;
            left: 0;
            right: 0;
            z-index: 1000;
            /* margin-top: var(--firefly-header-height, 0); */
        <?php endif; ?>
    }
    </style>
    <?php
}
