<?php
// ===== Desktop / Main Menu =====

// Theme mods used by the desktop bar
$menu_position              = get_theme_mod('firefly_menu_position', 'below'); // 'below','above','fixed'
$menu_class                 = 'menu-position-' . $menu_position;

$menu_logo                  = get_theme_mod('firefly_menu_logo', '');
$menu_phone_number          = get_theme_mod('firefly_menu_phone_number', '');
$menu_phone_text            = get_theme_mod('firefly_menu_phone_text', '');
$menu_phone_icon_url        = get_theme_mod('firefly_menu_phone_icon', '');
$menu_phone_icon_height     = get_theme_mod('firefly_menu_phone_icon_height', '100');
$menu_phone_spacing         = get_theme_mod('firefly_menu_phone_spacing', '0px');
$menu_phone_text_font_size  = get_theme_mod('firefly_menu_phone_text_font_size', '16px');
$menu_phone_number_font_size= get_theme_mod('firefly_menu_phone_number_font_size', '24px');
$menu_phone_bg_color        = get_theme_mod('firefly_menu_phone_bg_color', '#ffff00');
$menu_phone_text_color      = get_theme_mod('firefly_menu_phone_text_color', '#000000');

$text_link                  = get_theme_mod('firefly_menu_text_link', '');
$menu_text                  = get_theme_mod('firefly_menu_text', '');



?>

<div class="<?php echo esc_attr($menu_class); ?> menu-bar">
  <?php if ($menu_logo) : ?>
    <div class="menu-logo">
      <a href="<?php echo esc_url(home_url('/')); ?>">
        <img src="<?php echo esc_url($menu_logo); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
      </a>
    </div>
  <?php endif; ?>

  <nav class="main-menu">
    <?php
    wp_nav_menu([
      'theme_location' => 'main-menu',
      'container'      => false,
      'menu_class'     => 'menu-items',
      'fallback_cb'    => false,
    ]);
    ?>
  </nav>
  
  <?php if ($menu_text || $phone_text || $menu_phone_number): ?>

        <div class="menu-phone" style="
      background-color: <?php echo esc_attr($menu_phone_bg_color); ?>;
      color: <?php echo esc_attr($menu_phone_text_color); ?>;
      display: flex; flex-direction: row; align-items: center; gap: 15px; padding: 10px; z-index: 9999; height: auto;">


  <?php if ($menu_phone_number) : ?>

      <?php if ($menu_phone_icon_url): ?>
        <div style="flex-shrink: 0;" id="menu-phone-pic">
          <a href="tel:<?php echo esc_attr(preg_replace('/\D+/', '', $menu_phone_number)); ?>">
            <img src="<?php echo esc_url($menu_phone_icon_url); ?>" alt="Phone Icon"
                 style="height: <?php echo intval($menu_phone_icon_height); ?>px; width: auto; display: block;">
          </a>
        </div>
      <?php endif; ?>

      <div class="phone-wrapper" style="display: flex; flex-direction: column; justify-content: center;">
        <?php if ($menu_phone_text): ?>
          <div class="phone-text" style="
              font-size: <?php echo esc_attr($menu_phone_text_font_size); ?>;
              margin-bottom: <?php echo esc_attr($menu_phone_spacing); ?>; line-height: 1.3;">
            <?php echo esc_html($menu_phone_text); ?>
          </div>
        <?php endif; ?>

        <div class="phone-number" style="font-size: <?php echo esc_attr($menu_phone_number_font_size); ?>; margin: 0; line-height: 1.3;">
          <a href="tel:<?php echo esc_attr(preg_replace('/\D+/', '', $menu_phone_number)); ?>" style="color: inherit; text-decoration: none;">
            <?php echo esc_html($menu_phone_number); ?>
          </a>
        </div>

      </div>

  <?php endif; ?>
  



  
  <?php if ($menu_text) : ?>
   

    

        <div class="phone-number" style="font-size: <?php echo esc_attr($menu_phone_number_font_size); ?>; margin: 0; line-height: 1.3;">
          <a href="<?php echo $text_link; ?>" style="color: inherit; text-decoration: none;">
            <?php echo esc_html($menu_text); ?>
          </a>
        </div>


  <?php endif; ?>    </div>
   <?php endif; ?>
</div>


