<?php
if (!function_exists('firefly_customizer_logo')) {
    function firefly_customizer_logo($wp_customize) {
        $wp_customize->add_section('firefly_logo_section', array(
            'title'    => __('Firefly Logos', 'my-plugin'),
            'priority' => 23,
        ));

        // 🔷 Desktop Logo
        $wp_customize->add_setting('my_plugin_logo_pc', array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        ));

        $wp_customize->add_control(new WP_Customize_Image_Control(
            $wp_customize,
            'my_plugin_logo_pc_control',
            array(
                'label'    => __('Desktop Logo', 'my-plugin'),
                'section'  => 'firefly_logo_section',
                'settings' => 'my_plugin_logo_pc',
            )
        ));

        // 🔷 Mobile Logo
        $wp_customize->add_setting('my_plugin_logo_mobile', array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        ));

        $wp_customize->add_control(new WP_Customize_Image_Control(
            $wp_customize,
            'my_plugin_logo_mobile_control',
            array(
                'label'    => __('Mobile Logo', 'my-plugin'),
                'section'  => 'firefly_logo_section',
                'settings' => 'my_plugin_logo_mobile',
            )
        ));

        // 🔷 Logo Alignment
        $wp_customize->add_setting('my_plugin_logo_alignment', array(
            'default'           => 'center',
            'sanitize_callback' => 'sanitize_text_field',
        ));

        $wp_customize->add_control('my_plugin_logo_alignment_control', array(
            'label'    => __('Align Logo', 'my-plugin'),
            'section'  => 'firefly_logo_section',
            'settings' => 'my_plugin_logo_alignment',
            'type'     => 'select',
            'choices'  => array(
                'left'   => 'Left',
                'center' => 'Center',
                'right'  => 'Right',
                'leftoftext'  => 'Left of text (if there is a banner)',
                'abovetext'  => 'Above text (if there is a banner)',
            ),
        ));

        // 🔷 Max Width of Logo
        $wp_customize->add_setting('my_plugin_logo_max_width', array(
            'default'           => '90%',
            'sanitize_callback' => 'sanitize_text_field',
        ));

        $wp_customize->add_control('my_plugin_logo_max_width_control', array(
            'label'    => __('Max Width of Logo', 'my-plugin'),
            'section'  => 'firefly_logo_section',
            'settings' => 'my_plugin_logo_max_width',
            'type'     => 'select',
            'choices'  => array(
                '100%' => '100%',
                '95%'  => '95%',
                '90%'  => '90%',
                '85%'  => '85%',
                '80%'  => '80%',
            ),
        ));

        // 🟡 Favicon Upload
        $wp_customize->add_setting('my_plugin_favicon', array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        ));

        $wp_customize->add_control(new WP_Customize_Image_Control(
            $wp_customize,
            'my_plugin_favicon_control',
            array(
                'label'    => __('Favicon (Site Icon)', 'my-plugin'),
                'section'  => 'firefly_logo_section',
                'settings' => 'my_plugin_favicon',
            )
        ));


        $wp_customize->add_setting('my_plugin_logo_banner_size', array(
    'default'           => '80px',
    'sanitize_callback' => 'sanitize_text_field',
));
// Get current logo URL and image width
$logo_url = get_theme_mod('my_plugin_logo_pc', '');
$logo_size_label = 'Logo size (if there is a banner)';

if ($logo_url) {
    $image_path = str_replace(home_url(), ABSPATH, $logo_url);
    if (file_exists($image_path)) {
        $size = getimagesize($image_path);
        if ($size) {
            $logo_size_label .= ' – Current image width: ' . $size[0] . 'px';
        }
    }
}

$wp_customize->add_control('my_plugin_logo_banner_size_control', array(
    'label'    => __($logo_size_label, 'my-plugin'),
    'section'  => 'firefly_logo_section',
    'settings' => 'my_plugin_logo_banner_size',
    'type'     => 'text',
    'input_attrs' => array(
        'placeholder' => 'e.g. 80px or 5vw'
    )
));






$wp_customize->add_setting('my_plugin_logo_text_gap', array(
    'default'           => '20px',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_logo_text_gap_control', array(
    'label'    => __('Space between logo and text (if there is a banner)', 'my-plugin'),
    'section'  => 'firefly_logo_section',
    'settings' => 'my_plugin_logo_text_gap',
    'type'     => 'select',
    'choices'  => array(
        '0px'   => '0px',
        '5px'   => '5px',
        '10px'  => '10px',
        '15px'  => '15px',
        '20px'  => '20px',
        '30px'  => '30px',
        '40px'  => '40px',
        '60px'  => '60px',
        '80px'  => '80px',
        '100px' => '100px',
    ),
));




        // 🔲 Hide Logo Checkbox
$wp_customize->add_setting('my_plugin_hide_logo', array(
    'default'           => false,
    'sanitize_callback' => 'wp_validate_boolean',
));

$wp_customize->add_control('my_plugin_hide_logo_control', array(
    'label'    => __('Hide Logo', 'my-plugin'),
    'section'  => 'firefly_logo_section',
    'settings' => 'my_plugin_hide_logo',
    'type'     => 'checkbox',
));


// 🔷 Breakpoint to move logo above text
$wp_customize->add_setting('my_plugin_logo_switch_breakpoint', array(
    'default'           => '768px',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('my_plugin_logo_switch_breakpoint_control', array(
    'label'    => __('Breakpoint to switch logo above text', 'my-plugin'),
    'section'  => 'firefly_logo_section',
    'settings' => 'my_plugin_logo_switch_breakpoint',
    'type'     => 'select',
    'choices'  => array(
        '480px'  => '480px (small phones)',
        '600px'  => '600px (medium phones)',
        '768px'  => '768px (tablets & large phones)',
        '900px'  => '900px (small tablets)',
        '1024px' => '1024px (large tablets)',
    ),
));

// 🔷 Mobile logo size
$wp_customize->add_setting('my_plugin_logo_mobile_size', array(
    'default'           => '60px',
    'sanitize_callback' => 'sanitize_text_field',
));

$mobile_logo_url = get_theme_mod('my_plugin_logo_mobile', '');
$mobile_label = 'Logo size on mobile';

if ($mobile_logo_url) {
    $image_path = str_replace(home_url(), ABSPATH, $mobile_logo_url);
    if (file_exists($image_path)) {
        $size = getimagesize($image_path);
        if ($size) {
            $mobile_label .= ' – Current image width: ' . $size[0] . 'px';
        }
    }
}

$wp_customize->add_control('my_plugin_logo_mobile_size_control', array(
    'label'    => __($mobile_label, 'my-plugin'),
    'section'  => 'firefly_logo_section',
    'settings' => 'my_plugin_logo_mobile_size',
    'type'     => 'text',
    'input_attrs' => array(
        'placeholder' => 'e.g. 60px or 25%'
    )
));


// 🔷 Margin above logo on mobile
$wp_customize->add_setting('my_plugin_logo_mobile_margin_top', array(
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('my_plugin_logo_mobile_margin_top_control', array(
    'label'    => __('Margin above logo on mobile', 'my-plugin'),
    'section'  => 'firefly_logo_section',
    'settings' => 'my_plugin_logo_mobile_margin_top',
    'type'     => 'select',
    'choices'  => array(
        '0px'   => '0px',
        '5px'   => '5px',
        '10px'  => '10px',
        '15px'  => '15px',
        '20px'  => '20px',
        '30px'  => '30px',
        '40px'  => '40px',
        '50px'  => '50px',
        '60px'  => '60px',
        '70px'  => '70px',
        '80px'  => '80px',
        '90px'  => '90px',
        '100px' => '100px',
    ),
));


    }
}
add_action('customize_register', 'firefly_customizer_logo', 4);


// ✅ Output the logo CSS
function firefly_output_logo_css() {
    $alignment = get_theme_mod('my_plugin_logo_alignment', 'center');
    $max_width = get_theme_mod('my_plugin_logo_max_width', '90%');
    $favicon   = get_theme_mod('my_plugin_favicon');
    $logo_size = get_theme_mod('my_plugin_logo_banner_size', '80px');
    $text_gap  = get_theme_mod('my_plugin_logo_text_gap', '20px');
    $logo_mobile_size = get_theme_mod('my_plugin_logo_mobile_size', '60px');
    $breakpoint       = get_theme_mod('my_plugin_logo_switch_breakpoint', '768px');
$logo_mobile_margin_top = get_theme_mod('my_plugin_logo_mobile_margin_top', '0px');

 $breakpoint = get_theme_mod('firefly_mobile_breakpoint', '768px');

    // Map alignment to flexbox justification
    $justify = 'center';
    if ($alignment === 'left') {
        $justify = 'flex-start';
    } elseif ($alignment === 'right') {
        $justify = 'flex-end';
    }

   echo '<style id="firefly-logo-css">
    /* Responsive logo switching */
    .firefly-logo-pc {  
     max-width: ' . esc_attr($max_width) . '; 
        /*  display: block; 
      
      height: auto; */
    }
    .firefly-logo-mobile { 
        display: none; 
        max-width: ' . esc_attr($max_width) . '; 
       /* height: auto; */
    }
    @media (max-width: 768px) {
        .firefly-logo-pc { display: none; }
        .firefly-logo-mobile { display: block; }
    }

    /* Banner background darken overlay */
    .firefly-banner {
        position: relative;
        text-align: center;
    }
    .firefly-banner::before {
        content: "";
        position: absolute;
        inset: 0;
        background: rgba(0,0,0,0.4);
        z-index: 1;
    }

    /* Ensure logo sits above overlay */
    .firefly-logo-wrap img {
        position: relative;
        z-index: 2;
    }

    /* Align logo left of text using inline-block layout */
    .firefly-banner.logo-align-leftoftext .firefly-banner-inner {
        text-align: center;
        white-space: nowrap;
    }
    .firefly-banner.logo-align-leftoftext .firefly-logo-wrap,
    .firefly-banner.logo-align-leftoftext .firefly-banner-text {
        display: inline-block;
        vertical-align: middle;
        text-align: left;
    }
    .firefly-banner.logo-align-leftoftext .firefly-logo-wrap img {
       /* max-height: 80px;*/
        vertical-align: middle;
    }

    /* Align logo above text layout */
    .firefly-banner.logo-align-abovetext .firefly-banner-inner {
        text-align: center;
    }
    .firefly-banner.logo-align-abovetext .firefly-logo-wrap,
    .firefly-banner.logo-align-abovetext .firefly-banner-text {
        display: block;
    }


    .firefly-banner.logo-align-leftoftext .firefly-logo-wrap img {
    max-height: ' . esc_attr($logo_size) . ';
    vertical-align: middle;
    margin-right: ' . esc_attr($text_gap) . ';
}

.firefly-banner.logo-align-abovetext .firefly-logo-wrap img {
    max-height: ' . esc_attr($logo_size) . ';
    vertical-align: middle;
    margin-bottom: ' . esc_attr($text_gap) . ';
}


.firefly-banner.logo-align-leftoftext .firefly-banner-text {
    margin: 0;
    padding: 0;
    display: inline-block;
    vertical-align: middle;
}
.firefly-banner.logo-align-leftoftext .firefly-logo-wrap img {
    max-height: ' . esc_attr($logo_size) . ';
    vertical-align: middle;
    margin-right: ' . esc_attr($text_gap) . ' !important;
}


.firefly-banner.logo-align-abovetext .firefly-banner-inner {
    text-align: center;
}

.firefly-banner.logo-align-abovetext .firefly-logo-wrap,
.firefly-banner.logo-align-abovetext .firefly-banner-text {
    display: block;
    margin-left: auto;
    margin-right: auto;
}
.firefly-banner.logo-align-abovetext .firefly-logo-wrap img {
    max-height: ' . esc_attr($logo_size) . ';
    vertical-align: middle;
    margin-bottom: ' . esc_attr($text_gap) . ';
}


.firefly-banner.logo-align-abovetext .firefly-banner-inner {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
}
.firefly-banner.logo-align-abovetext .firefly-logo-wrap img {
    max-height: ' . esc_attr($logo_size) . ';
}


.firefly-banner.logo-align-abovetext .firefly-banner-inner {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    gap: ' . esc_attr($text_gap) . ';
}

.firefly-logo-wrap-lefttext {

}


/* Override logo layout below the selected breakpoint */
@media (max-width: '. $breakpoint .') {

    .firefly-logo-wrap {
       
    }

    .jeff {
        simmonds:0px;
    }

    .firefly-logo-wrap img {
            margin-top: '.$logo_mobile_margin_top .';
    }

    
    .jeff-beep {}
        
    .firefly-banner.logo-align-leftoftext .firefly-banner-inner {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: ' . $text_gap .';
    }

    .firefly-banner.logo-align-leftoftext .firefly-logo-wrap,
    .firefly-banner.logo-align-leftoftext .firefly-banner-text {
        display: block;
        margin-left: auto;
        margin-right: auto;
        text-align: center;
    }

    .firefly-banner.logo-align-leftoftext .firefly-logo-wrap img,
    .firefly-logo-wrap img
     {
        max-height: ' . $logo_mobile_size . ' !important;
        margin-right: 0 !important;
        margin-bottom: ' . $text_gap . ';
        jeff:yes;
    }
}



</style>';


    // ✅ Output favicon link
    if (!empty($favicon)) {
        echo '<link rel="icon" href="' . esc_url($favicon) . '" type="image/png">';
    }
}
add_action('wp_head', 'firefly_output_logo_css');


