<?php


// ✅ Custom Control for Radio Buttons with Colour Swatches
if (class_exists('WP_Customize_Control')) {
    class Firefly_Radio_Colour_Control extends WP_Customize_Control {
        public $type = 'radio';


        public function render_content() {
            if (empty($this->choices)) return;


            if (!empty($this->label)) {
                echo '<span class="customize-control-title">' . esc_html($this->label) . '</span>';
            }


            if (!empty($this->description)) {
                echo '<span class="description customize-control-description">' . $this->description . '</span>';
            }


            foreach ($this->choices as $value => $info) {
                $color = $info['color'];
                $text  = $info['label'];
                ?>
               <label style="display:flex;align-items:center;margin:4px 0; padding-left: 40px;">
                    <input type="radio" name="<?php echo esc_attr($this->id); ?>"
                        value="<?php echo esc_attr($value); ?>"
                        <?php $this->link(); checked($this->value(), $value); ?> />
                    <span style="background:<?php echo esc_attr($color); ?>;
                                 width:12px;height:12px;display:inline-block;
                                 margin:0 6px;border:1px solid #ccc;"></span>
                    <?php echo esc_html($text); ?>
                </label>
                <?php
            }
        }
    }
}


if (!function_exists('firefly_customizer_layout')) {
    function firefly_customizer_layout($wp_customize) {


        $wp_customize->add_section('firefly_layout_section', array(
            'title'    => __('Firefly Layout', 'my-plugin'),
            'priority' => 22,
        ));


        // 🔷 Page Width
        $wp_customize->add_setting('my_plugin_page_width', array(
            'default'   => 'full-width',
            'transport' => 'refresh',
            'sanitize_callback' => 'firefly_sanitize_width_option',
        ));
        $wp_customize->add_control('my_plugin_page_width_control', array(
            'label'    => __('Page Width', 'my-plugin'),
            'section'  => 'firefly_layout_section',
            'settings' => 'my_plugin_page_width',
            'type'     => 'select',
            'choices'  => array(
                   'full-width' => __('100%', 'my-plugin'),
               '90%'      => __('90%', 'my-plugin'),
               '95%'      => __('95%', 'my-plugin'),
               '700px'      => __('700px', 'my-plugin'),
                '800px'      => __('800px', 'my-plugin'),
                 '900px'      => __('900px', 'my-plugin'),
                  '1000px'      => __('1000px', 'my-plugin'),
                  '1100px'      => __('1100px', 'my-plugin'),
                  '1200px'      => __('1200px', 'my-plugin'),
                  '1300px'      => __('1300px', 'my-plugin'),
                  '1400px'      => __('1400px', 'my-plugin'),
                  '1500px'      => __('1500px', 'my-plugin'),
                  '1600px'      => __('1600px', 'my-plugin'),
                  '1700px'      => __('1700px', 'my-plugin'),
                  '1800px'      => __('1800px', 'my-plugin'),
                  '1900px'      => __('1900px', 'my-plugin'),

                    '500px'      => __('500px', 'my-plugin'),
            ),
        ));


        
        
        
        // 🔷 Max Width
        $wp_customize->add_setting('my_plugin_header_max_width', array(
            'default'   => '100%',
            'transport' => 'refresh',
            'sanitize_callback' => 'firefly_sanitize_width_option',
        ));
        $wp_customize->add_control('my_plugin_header_max_width_control', array(
            'label'    => __('Max Width of Banner', 'my-plugin'),
            'section'  => 'firefly_layout_section',
            'settings' => 'my_plugin_header_max_width',
            'type'     => 'select',
            'choices'  => array(
               '100%' => __('100%', 'my-plugin'),
               '90%'      => __('90%', 'my-plugin'),
               '95%'      => __('95%', 'my-plugin'),
               '700px'      => __('700px', 'my-plugin'),
                '800px'      => __('800px', 'my-plugin'),
                 '900px'      => __('900px', 'my-plugin'),
                  '1000px'      => __('1000px', 'my-plugin'),
                  '1100px'      => __('1100px', 'my-plugin'),
                  '1200px'      => __('1200px', 'my-plugin'),
                  '1300px'      => __('1300px', 'my-plugin'),
                  '1400px'      => __('1400px', 'my-plugin'),
                  '1500px'      => __('1500px', 'my-plugin'),
                  '1600px'      => __('1600px', 'my-plugin'),
                  '1700px'      => __('1700px', 'my-plugin'),
                  '1800px'      => __('1800px', 'my-plugin'),
                  '1900px'      => __('1900px', 'my-plugin'),
                  
                    '500px'      => __('500px', 'my-plugin'),
            ),
        ));





                
        // 🔷 Max Width
        $wp_customize->add_setting('my_plugin_menu_max_width', array(
            'default'   => '100%',
            'transport' => 'refresh',
            'sanitize_callback' => 'firefly_sanitize_width_option',
        ));
        $wp_customize->add_control('my_plugin_menu_max_width_control', array(
            'label'    => __('Max Width of Menu', 'my-plugin'),
            'section'  => 'firefly_layout_section',
            'settings' => 'my_plugin_menu_max_width',
            'type'     => 'select',
            'choices'  => array(
               '100%' => __('100%', 'my-plugin'),
               '90%'      => __('90%', 'my-plugin'),
               '95%'      => __('95%', 'my-plugin'),
               '700px'      => __('700px', 'my-plugin'),
                '800px'      => __('800px', 'my-plugin'),
                 '900px'      => __('900px', 'my-plugin'),
                  '1000px'      => __('1000px', 'my-plugin'),
                  '1100px'      => __('1100px', 'my-plugin'),
                  '1200px'      => __('1200px', 'my-plugin'),
                  '1300px'      => __('1300px', 'my-plugin'),
                  '1400px'      => __('1400px', 'my-plugin'),
                  '1500px'      => __('1500px', 'my-plugin'),
                  '1600px'      => __('1600px', 'my-plugin'),
                  '1700px'      => __('1700px', 'my-plugin'),
                  '1800px'      => __('1800px', 'my-plugin'),
                  '1900px'      => __('1900px', 'my-plugin'),
                  
                    '500px'      => __('500px', 'my-plugin'),
            ),
        ));


        
        // 🔷 Max Width
        $wp_customize->add_setting('my_plugin_footer_max_width', array(
            'default'   => '100%',
            'transport' => 'refresh',
            'sanitize_callback' => 'firefly_sanitize_width_option',
        ));
        $wp_customize->add_control('my_plugin_footer_max_width_control', array(
            'label'    => __('Max Width of Footer', 'my-plugin'),
            'section'  => 'firefly_layout_section',
            'settings' => 'my_plugin_footer_max_width',
            'type'     => 'select',
            'choices'  => array(
               '100%' => __('100%', 'my-plugin'),
               '90%'      => __('90%', 'my-plugin'),
               '95%'      => __('95%', 'my-plugin'),
               '700px'      => __('700px', 'my-plugin'),
                '800px'      => __('800px', 'my-plugin'),
                 '900px'      => __('900px', 'my-plugin'),
                  '1000px'      => __('1000px', 'my-plugin'),
                  '1100px'      => __('1100px', 'my-plugin'),
                  '1200px'      => __('1200px', 'my-plugin'),
                  '1300px'      => __('1300px', 'my-plugin'),
                  '1400px'      => __('1400px', 'my-plugin'),
                  '1500px'      => __('1500px', 'my-plugin'),
                  '1600px'      => __('1600px', 'my-plugin'),
                  '1700px'      => __('1700px', 'my-plugin'),
                  '1800px'      => __('1800px', 'my-plugin'),
                  '1900px'      => __('1900px', 'my-plugin'),
                  
                    '500px'      => __('500px', 'my-plugin'),
            ),
        ));





        // 🔷 Max Width
        $wp_customize->add_setting('my_plugin_max_width', array(
            'default'   => '95%',
            'transport' => 'refresh',
            'sanitize_callback' => 'firefly_sanitize_width_option',
        ));
        $wp_customize->add_control('my_plugin_max_width_control', array(
            'label'    => __('Max Width of Headings & Paragraphs', 'my-plugin'),
            'section'  => 'firefly_layout_section',
            'settings' => 'my_plugin_max_width',
            'type'     => 'select',
            'choices'  => array(
               '100%' => __('100%', 'my-plugin'),
               '90%'      => __('90%', 'my-plugin'),
               '95%'      => __('95%', 'my-plugin'),
               '700px'      => __('700px', 'my-plugin'),
                '800px'      => __('800px', 'my-plugin'),
                 '900px'      => __('900px', 'my-plugin'),
                  '1000px'      => __('1000px', 'my-plugin'),
                  '1100px'      => __('1100px', 'my-plugin'),
                  '1200px'      => __('1200px', 'my-plugin'),
                  '1300px'      => __('1300px', 'my-plugin'),
                  '1400px'      => __('1400px', 'my-plugin'),
                  '1500px'      => __('1500px', 'my-plugin'),
                  '1600px'      => __('1600px', 'my-plugin'),
                  '1700px'      => __('1700px', 'my-plugin'),
                  '1800px'      => __('1800px', 'my-plugin'),
                  '1900px'      => __('1900px', 'my-plugin'),
                  
                    '500px'      => __('500px', 'my-plugin'),
            ),
        ));



        // 🔷 Spacing Options
        $spacing_choices = [];
        for ($i = 0; $i <= 50; $i += 5) {
            $spacing_choices["{$i}px"] = "{$i}px";
        }


        $wp_customize->add_setting('my_plugin_space_above_content', array(
            'default'           => '0px',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        $wp_customize->add_control('my_plugin_space_above_content_control', array(
            'label'    => __('Space Above Content', 'my-plugin'),
            'section'  => 'firefly_layout_section',
            'settings' => 'my_plugin_space_above_content',
            'type'     => 'select',
            'choices'  => $spacing_choices,
        ));



          $wp_customize->add_setting('my_plugin_body_margin', array(
            'default'           => '0px',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        $wp_customize->add_control('my_plugin_body_margin_control', array(
            'label'    => __('Page padding left and right', 'my-plugin'),
            'section'  => 'firefly_layout_section',
            'settings' => 'my_plugin_body_margin',
            'type'     => 'select',
            'choices'  => $spacing_choices,
        ));


        $wp_customize->add_setting('my_plugin_space_above_logo', array(
            'default'           => '0px',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        $wp_customize->add_control('my_plugin_space_above_logo_control', array(
            'label'    => __('Space above content', 'my-plugin'),
            'section'  => 'firefly_layout_section',
            'settings' => 'my_plugin_space_above_logo',
            'type'     => 'select',
            'choices'  => $spacing_choices,
        ));






        // 🔷 Space at Bottom of Page (Above Footer)
$wp_customize->add_setting('my_plugin_space_below_content', array(
    'default'           => '0px',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));


$wp_customize->add_control('my_plugin_space_below_content_control', array(
    'label'    => __('Space at Bottom of Page (Above Footer)', 'my-plugin'),
    'section'  => 'firefly_layout_section',
    'settings' => 'my_plugin_space_below_content',
    'type'     => 'select',
    'choices'  => array_combine(
        array_map(fn($i) => "{$i}px", range(0, 50, 5)),
        array_map(fn($i) => "{$i}px", range(0, 50, 5))
    ),
));






        // 🔷 Left/Right Spacing
        $wp_customize->add_setting('my_plugin_padding_lr', array(
            'default'           => '15px',
            'transport'         => 'refresh',
            'sanitize_callback' => 'firefly_sanitize_padding_option',
        ));
        $wp_customize->add_control('my_plugin_padding_lr_control', array(
            'label'    => __('Left and Right Spacing (Headings & Paragraphs)', 'my-plugin'),
            'section'  => 'firefly_layout_section',
            'settings' => 'my_plugin_padding_lr',
            'type'     => 'select',
            'choices'  => array(
                '0px' => '0px',
                '5px' => '5px',
                '10px' => '10px',
                '15px' => '15px',
                '25px' => '25px',
                '30px' => '30px',
                '35px' => '35px',
                '40px' => '40px',
                '45px' => '45px',
                '50px' => '50px',
            ),
        ));






        // 🔷 Max Width of Form
$wp_customize->add_setting('my_plugin_form_max_width', array(
    'default'           => '1000px',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));


$wp_customize->add_control('my_plugin_form_max_width', array(
    'label'    => __('Max Width of Form', 'my-plugin'),
    'section'  => 'firefly_layout_section',
    'settings' => 'my_plugin_form_max_width',
    'type'     => 'select',
    'choices'  => array(
        '800px'  => '800px',
        '900px'  => '900px',
        '1000px' => '1000px',
        '1100px' => '1100px',
        '1200px' => '1200px',
    ),
));






        // 🔷 Background and Content Colour Choices (Radio with Swatches)
        $wp_customize->add_setting('layout_bg_color_choice', array(
            'default'           => 'black',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        $wp_customize->add_setting('layout_content_color_choice', array(
            'default'           => 'white',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));






       




        $colour_choices = array(
            'colour1' => array(
                'color' => get_theme_mod('firefly_colour_1', '#dd3333'),
                'label' => 'Colour 1',
            ),
            'colour2' => array(
                'color' => get_theme_mod('firefly_colour_2', '#1e73be'),
                'label' => 'Colour 2',
            ),
            'colour3' => array(
                'color' => get_theme_mod('firefly_colour_3', '#8224e3'),
                'label' => 'Colour 3',
            ),
            'colour4' => array(
                'color' => get_theme_mod('firefly_colour_4', '#ededc4'),
                'label' => 'Colour 4',
            ),
            'black' => array(
                'color' => '#000000',
                'label' => 'Black',
            ),
            'white' => array(
                'color' => '#ffffff',
                'label' => 'White',
            ),
        );
       


       
             // 🔷 Form Choices (Radio with Swatches)
             $wp_customize->add_setting('form_background_color_choice', array(
                'default'           => 'white',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));
         


        $wp_customize->add_setting('form_font_color_choice', array(
            'default'           => 'black',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
 
        $wp_customize->add_control(new Firefly_Radio_Colour_Control(
            $wp_customize,
            'form_background_color_choice',
            array(
                'label'       => __('Form background colour', 'my-plugin'),
                'section'     => 'firefly_layout_section',
                'settings'    => 'form_background_color_choice',
                'choices'     => $colour_choices,
                'description' => __('Choose a background colour for Fluent Forms.', 'my-plugin'),
                'priority'    => 95, // 🔽 lower on the page
            )
        ));
       
        $wp_customize->add_control(new Firefly_Radio_Colour_Control(
            $wp_customize,
            'form_font_color_choice',
            array(
                'label'       => __('Form text colour', 'my-plugin'),
                'section'     => 'firefly_layout_section',
                'settings'    => 'form_font_color_choice',
                'choices'     => $colour_choices,
                'description' => __('Choose a text colour for Fluent Forms.', 'my-plugin'),
                'priority'    => 96, // 🔽 lower on the page
            )
        ));
 






        $wp_customize->add_control(new Firefly_Radio_Colour_Control($wp_customize, 'layout_bg_color_choice', array(
            'label'       => __('Page Background Colour', 'my-plugin'),
            'section'     => 'firefly_layout_section',
            'settings'    => 'layout_bg_color_choice',
            'choices'     => $colour_choices,
            'description' => __('Applies to the page <code>&lt;body&gt;</code> background.', 'my-plugin'),
        )));


        $wp_customize->add_control(new Firefly_Radio_Colour_Control($wp_customize, 'layout_content_color_choice', array(
            'label'       => __('Content Background Colour', 'my-plugin'),
            'section'     => 'firefly_layout_section',
            'settings'    => 'layout_content_color_choice',
            'choices'     => $colour_choices,
            'description' => __('Applies to <code>.site</code> and <code>.entry-content</code>.', 'my-plugin'),
        )));



        // 🔷 List Indent
        $wp_customize->add_setting('my_plugin_list_indent', array(
            'default'           => '30px',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_list_indent',
        ));
        $wp_customize->add_control('my_plugin_list_indent', array(
            'label'    => __('Indent for lists', 'my-plugin'),
            'section'  => 'firefly_layout_section',
            'settings' => 'my_plugin_list_indent',
            'type'     => 'select',
            'choices'  => array_combine(
                array_map(fn($i) => $i . 'px', range(0, 70, 5)),
                array_map(fn($i) => $i . 'px', range(0, 70, 5))
            ),
        ));




        



// 🔲 Hide Footer Checkbox
$wp_customize->add_setting('my_plugin_hide_footer', array(
    'default'           => false,
    'sanitize_callback' => 'wp_validate_boolean',
));

$wp_customize->add_control('my_plugin_hide_footer_control', array(
    'label'    => __('Hide Footer', 'my-plugin'),
    'section'  => 'firefly_layout_section',
    'settings' => 'my_plugin_hide_footer',
    'type'     => 'checkbox',
));


// 🔲 Show Terms and Conditions Link Checkbox
$wp_customize->add_setting('my_plugin_show_terms_link', array(
    'default'           => true,
    'sanitize_callback' => 'wp_validate_boolean',
));

$wp_customize->add_control('my_plugin_show_terms_link_control', array(
    'label'    => __('Show Terms and Conditions link in footer', 'my-plugin'),
    'section'  => 'firefly_layout_section',
    'settings' => 'my_plugin_show_terms_link',
    'type'     => 'checkbox',
));







   // Add this right after your padding controls
        $wp_customize->add_setting("firefly_show_layout_borders", [
            'default'           => false,
            'sanitize_callback' => 'wp_validate_boolean',
        ]);

        $wp_customize->add_control("firefly_show_layout_borders_control", [
            'label'       => __('Show borders around divs', 'firefly'),
            'section'     => $section_id,
            'settings'    => "firefly_show_layout_borders",
            'type'        => 'checkbox',
            'description' => __('Enable borders around divs', 'firefly'),
            'priority'    => 2220, // Adjust as needed to fit your control order
        ]);


        // 🔲 Show line around divs
$wp_customize->add_setting('my_plugin_red_lines_on_page_divs', array(
    'default'           => false,
    'sanitize_callback' => 'wp_validate_boolean',
));

$wp_customize->add_control('my_plugin_red_lines_on_page_divs_control', array(
    'label'    => __('Show lines on divs', 'my-plugin'),
    'section'  => 'firefly_layout_section',
    'settings' => 'my_plugin_red_lines_on_page_divs',
    'type'     => 'checkbox',
));

    }
}
add_action('customize_register', 'firefly_customizer_layout', 3);


// ✅ Sanitizers
function sanitize_list_indent($input) {
    return in_array($input, array_map(fn($i) => $i . 'px', range(0, 70, 5))) ? $input : '30px';
}
function firefly_sanitize_width_option($input) {
    $valid = [
      'full-width', '100%',
      '90%','95%',
      '700px','800px','900px',
      '1000px','1100px','1200px',
      '1300px','1400px','1500px',
      '1600px','1700px','1800px','1900px',
    ];
    return in_array($input, $valid, true) ? $input : '95%';
}

function firefly_sanitize_padding_option($input) {
    $valid = ['0px', '5px', '10px', '15px', '25px', '30px', '35px', '40px', '45px', '50px'];
    return in_array($input, $valid) ? $input : '15px';
}


// ✅ Optional: Load live preview JS
function firefly_enqueue_layout_customizer_js() {
    wp_enqueue_script(
        'firefly-layout-controls',
        get_template_directory_uri() . '/customizer/firefly-layout.js',
        array('jquery', 'customize-controls'),
        null,
        true
    );
}
add_action('customize_controls_enqueue_scripts', 'firefly_enqueue_layout_customizer_js');








function firefly_custom_layout_css() {
   
   
    echo "<style id='firefly-custom-layout-css'>
:root {
    --firefly-max-width: {$max_width};
    --firefly-padding-lr: {$padding_lr};
}
";


    $page_width   = get_theme_mod('my_plugin_page_width', 'full-width');
    $max_banner_width   = get_theme_mod('my_plugin_header_max_width', '100%');
    $max_footer_width   = get_theme_mod('my_plugin_footer_max_width', '100%');
    $max_menu_width   = get_theme_mod('my_plugin_menu_max_width', '100%');
    
    $max_width    = get_theme_mod('my_plugin_max_width', '95%');
    $padding_lr   = get_theme_mod('my_plugin_padding_lr', '15px');
    $margin_top   = get_theme_mod('my_plugin_space_above_content', '0px');
    $margin_bottom = get_theme_mod('my_plugin_space_below_content', '0px');
    $padding_top  = get_theme_mod('my_plugin_space_above_logo', '0px');
    $listindent   = get_theme_mod('my_plugin_list_indent', '30px');
    $form_max_width = get_theme_mod('my_plugin_form_max_width', '1000px');
    $body_margin = get_theme_mod('my_plugin_body_margin', '0px');

    $my_plugin_red_lines_on_page_divs = get_theme_mod('my_plugin_red_lines_on_page_divs', '');


    // ✅ NEW: Get selected colour keys (e.g. "colour1", "white")
    $bg_choice     = get_theme_mod('layout_bg_color_choice', 'black');
    $content_choice = get_theme_mod('layout_content_color_choice', 'white');


    // ✅ Resolve choice into actual color values
    $colours = array(
        'colour1' => get_theme_mod('firefly_colour_1', '#dd3333'),
        'colour2' => get_theme_mod('firefly_colour_2', '#1e73be'),
        'colour3' => get_theme_mod('firefly_colour_3', '#8224e3'),
        'colour4' => get_theme_mod('firefly_colour_4', '#ededc4'),
        'black'   => '#000000',
        'white'   => '#ffffff',
    );


    $bg_color = isset($colours[$bg_choice]) ? $colours[$bg_choice] : '#000000';
    $content_color = isset($colours[$content_choice]) ? $colours[$content_choice] : '#ffffff';


    // Optional: Other text-related colors (replace with actual settings if you have them)
    $h1_color = '#111';
    $h2_color = '#222';
    $h3_color = '#333';
    $text_color = '#444';
    $form_color = '#f9f9f9';


    $group_highlight_bg = '#ffffcc';
    $group_highlight_heading_color = '#000';
    $group_highlight_text_color = '#222';


    $group_padded_box_bg = '#eeeeee';
    $group_padded_heading_color = '#000';
    $group_padded_text_color = '#222';


    $padding_value   = (int) $padding_lr;
    $listindent_value = (int) $listindent;
    $newlistindent = $padding_value + $listindent_value;


    $form_bg_choice   = get_theme_mod('form_background_color_choice', 'white');
    $form_text_choice = get_theme_mod('form_font_color_choice', 'black');
   
    $form_bg_color   = isset($colours[$form_bg_choice]) ? $colours[$form_bg_choice] : '#ffffff';
    $form_text_color = isset($colours[$form_text_choice]) ? $colours[$form_text_choice] : '#000000';
   
    $group3_column_width = get_theme_mod('my_plugin_group3_column_width', '250px');
    $group3_text_size = get_theme_mod('my_plugin_group3_text_size', '16px');
    $group3_space_between = get_theme_mod('my_plugin_group3_space_between', '10px');



    echo "<style id='firefly-custom-layout-css'>



    /* these styles come from firefly-layout.php */


body {
    background-color: var(--firefly-body-bg, {$bg_color}) ;
}
.site, .entry-content {
    background-color: var(--firefly-content-bg, {$content_color}) ;
}



      .firefly-banner,
            .firefly-banner-only,
            .firefly-text-only,
          .banner-with-phone,
            .firefly-logo-wrap {
            max-width:{$max_banner_width};
            margin: 0 auto;
        }


   body {
        background-color: {$bg_color} ;
        padding-left:{$body_margin} ;
        padding-right:{$body_margin} ;
        margin-bottom:0px ;
         
    }
    .site, .entry-content {
        background-color: {$content_color} ;
       
    }


 nav {
  max-width:{$max_footer_width};
  margin:0 auto;
}

 .firefly-footer {
  max-width:{$max_footer_width};
}

   
    .entry-content {
         margin-bottom: {$margin_bottom} ;
        
    }




.frm-fluent-form, .upcoming-events-box  {
    width: {$form_max_width};
    max-width:95%;
    margin-left: auto;
    margin-right: auto;
}


    .site, .entry-content, .ccontent-area {
        width: 100%;
        max-width: {$page_width} !important;
        hewhi:true;
        margin: 0 auto;
        margin-top: {$margin_top} !important;
        padding-top: {$padding_top} !important;
          margin-bottom: {$margin_bottom} ;
    }





    h1, h2, h3, p,  ul, ol, 
    .foogallery-container, 
    .newsletter-container, 
    .wp-block-columns, 
    .site-main,
    .wp-block-media-text, 
    table,
    .wp-block-embed,
    .wp-block-embed-vimeo  {
    max-width: {$max_width};
        margin-left: auto;
        margin-right: auto;
        padding-left: {$padding_lr};
        padding-right: {$padding_lr};
    }


.wc-block-checkout__form  {
    max-width: 1200px;              /* or your {$max_width} */
    margin-left: auto !important;
    margin-right: auto !important;  /* keep it centred */
    padding-left: 20px !important;  /* or {$padding_lr} */
    padding-right: 20px !important;

}




.wc-block-checkout__sidebar .wc-block-components-order-summary-item__price {
    right: 30px !important;   /* match your sidebar padding */
}
    .wp-block-woocommerce-checkout,
     .wp-block-woocommerce-cart 
    {

      max-width: {$max_width} !important;
        margin-left: auto  !important;
        margin-right: auto !important;
        padding-left: 25px !important;
        padding-right: 25px !important;
    }



   
  .wp-block-columns,
  .wp-block-group {
        max-width: {$max_width} ;
        margin:0 auto;
        margin-bottom:10px;
        
    }

    


.wp-block-image.is-style-fifty-width {

    display: block;
    max-width: var(--firefly-max-width, 900px); /* match text block */
    margin-left: auto;
    margin-right: auto;
    position: relative;
    padding-left: var(--firefly-padding-lr, 50px);
    padding-right: 50px; /*var(--firefly-padding-lr, 50px);*/
}


figure.wp-block-image.is-style-fifty-width  {
clear:both;
    float: right;
    width: 50%;
    margin: 0 0 1em 1em;
    box-sizing: border-box;
}


.wp-block-image.is-style-fifty-width img {
    width: 100% ;
    height: auto ;
}






.wp-block-image.is-style-33-width {
    display: block;
    max-width: var(--firefly-max-width, 900px); /* match text block */
    margin-left: auto;
    margin-right: auto;
    position: relative;
    padding-left: var(--firefly-padding-lr, 50px);
    padding-right: 50px; /*var(--firefly-padding-lr, 50px);*/
}


figure.wp-block-image.is-style-33-width {
clear:both;
    float: right;
    width: 33%;
    margin: 0 0 1em 1em;
    box-sizing: border-box;
}


.wp-block-image.is-style-33-width img {
    width: 100% ;
    height: auto ;
}








@media only screen and (max-width: 750px) {
    .wp-block-image.is-style-fifty-width figure,
    .wp-block-image.is-style-33-width figure{
        float: none;
        width: 100%;
        margin: 0 auto 1em auto;
       
    }
   
    .wp-block-image.is-style-fifty-width,
    .wp-block-image.is-style-33-width
    {
   
      max-width: {$max_width};
        padding-left: {$padding_lr};
        padding-right: {$padding_lr};
     }
}




/* Apply padding-left only to ULs that are NOT inside .metaslider */
ul:not(.metaslider ul),
ol:not(.metaslider ol) {
    padding-left: {$newlistindent}px ;
}


/* But remove it for sliders */
.metaslider ul,
.metaslider ol {
    padding-left: 0 ;
}



    ul {
        list-style-type: disc ;
        list-style-position: outside ;
    }
    ol {
        list-style-type: decimal ;
        list-style-position: outside ;
    }


    .wp-block-group.is-style-Paragraph-width-coloured-background {
        margin: 0 auto ;
        padding-left: {$padding_lr} ;
        padding-right: {$padding_lr} ;
        max-width: {$max_width};
    }


    .wp-block-group.is-style-container-for-columns {
        padding-left: " . ($padding_value - 10) . "px;
        padding-right: " . ($padding_value - 10) . "px;
        max-width: {$max_width};
        text-align: center ;
        margin: 0 auto;
        padding-top: 0px ;
        margin-top: 0px ;
         flex-wrap: wrap;             /* move to a new row on resize */
        justify-content: center;     /* center the columns horizontally */
        align-items: flex-start;     /* align column tops */
    }


    .wp-block-group.is-style-columns {
        width: 280px;
        margin: {$group3_space_between};
        padding: 0px;
        padding-top: 10px;
        display: inline-block;
        width: {$group3_column_width};
        background-color: white;
        display: flex;           /* optional: lets inner content stack nicely */
        flex-direction: column;  /* keep content vertical */
    }

    .wp-block-group.is-style-columns p {
        font-size: {$group3_text_size} ;
    }

    h1 { color: {$h1_color} ; }
    h2 { color: {$h2_color} ; }
    h3 { color: {$h3_color}; }
    body, p, ul, ol, .entry-content {
        color: {$text_color} ;
    }


    .fluentform, .upcoming-events-wrapper {
    background-color: {$form_bg_color};
    color: {$form_text_color};
    padding-top: 15px;
    margin-top: 15px;
}
.fluentform  {
    color: {$form_text_color};
}
    .wp-block-group.is-style-highlight-section {
        background-color: {$group_highlight_bg};
    }


    .wp-block-group.is-style-highlight-section h1,
    .wp-block-group.is-style-highlight-section h2,
    .wp-block-group.is-style-highlight-section h3,
    .wp-block-group.is-style-highlight-section h4,
    .wp-block-group.is-style-highlight-section h5,
    .wp-block-group.is-style-highlight-section h6 {
        color: {$group_highlight_heading_color} ;
    }


    .wp-block-group.is-style-highlight-section,
    .wp-block-group.is-style-highlight-section p,
    .wp-block-group.is-style-highlight-section ul,
    .wp-block-group.is-style-highlight-section ol {
        color: {$group_highlight_text_color} ;
    }


    .is-style-Paragraph-width-coloured-background .wp-block-group__inner-container {
        background-color: {$group_padded_box_bg} ;
        padding: 10px;
        padding-top: 20px;
       
    }


    .wp-block-group.is-style-Paragraph-width-coloured-background h1,
    .wp-block-group.is-style-Paragraph-width-coloured-background h2,
    .wp-block-group.is-style-Paragraph-width-coloured-background h3,
    .wp-block-group.is-style-Paragraph-width-coloured-background h4,
    .wp-block-group.is-style-Paragraph-width-coloured-background h5,
    .wp-block-group.is-style-Paragraph-width-coloured-background h6 {
        color: {$group_padded_heading_color};
    }


    .wp-block-group.is-style-Paragraph-width-coloured-background,
    .wp-block-group.is-style-Paragraph-width-coloured-background p,
    .wp-block-group.is-style-Paragraph-width-coloured-background ul,
    .wp-block-group.is-style-Paragraph-width-coloured-background ol {
        color: {$group_padded_text_color} ;
    }


    .newsletter-container {
        text-align:center;
    }








        .wp-block-group__inner-container {
            display: flow-root ;
        }


        .alignright img {
        margin-right:0px ;
        }

          .alignright {
           margin-right:0px ;
        }

        .wp-block-image {
                max-width: {$max_width};
                ppppadding-left: {$padding_lr} ;
                ppppadding-right: {$padding_lr} ;
                margin:0 auto;
        }


   .entry-content::after {
    content: '';
    display: table;
    clear: both;
}


.firefly-footer {
    clear:both;
}

b, strong {
	font-weight:bold;
}

/* Ensure image styles apply even within groups */
.wp-block-group .wp-block-image.is-style-fifty-width {
    float: right ;
    width: 50% ;
    margin: 0 0 1em 1em ;
	/*border:2px red solid ;*/
}

/* Clearfix for groups containing floated images */
.wp-block-group__inner-container {
    overflow: auto; /* Ensures the group contains floated children */
    display: block ; /* Override any conflicting flex/grid */
		/* border:2px black solid ;*/
}

@media only screen and (max-width: 750px) {

    .alignright {
        clear:both;
        width:100%;
        margin:0 auto;
        text-align:center;
    }
}

iframe {
    max-width: 100%;
}

";


if ($my_plugin_red_lines_on_page_divs) {






    echo "

    .wp-block-group.is-style-full-width {
        border:5px blue solid;
    }

    .wp-block-group.is-style-full-width::before {
        content: 'Full width block';
        display: block;
        background: blue;
        color: white;
        padding: 4px 8px;
        font-size: 12px;
        font-weight: bold;
       
    }


    .wp-block-group.is-style-paragraph-width {
        border:5px red solid;
    }

    .wp-block-group.is-style-paragraph-width::before {
        content: 'Paragraph width block';
        display: block;
        background: red;
        color: white;
        padding: 4px 8px;
        font-size: 12px;
        font-weight: bold;
         width:100% !important;
        max-width:100% !important;
        margin:0px;
    }


    body {
        border:5px orange solid;
    }
    .entry-content {
        border:5px red solid;
    }

    .wp-block-cover {
         border:2px green solid ; 
    }

    .wp-block-media-text {
         border:2px blue solid ; 
    }
    .foogallery {
         border:2px pink solid ; 
    }

    .foogallery-container {
         border:10px green solid ; 
    }

    h1 {
        border:2px purple solid;
    }

    .frm-fluent-form {
        border:2px brown solid;
    }

     .firefly-banner,
            .firefly-banner-only,
            .firefly-text-only,
          .banner-with-phone,
            .firefly-logo-wrap{
        border:2px yellow solid;
    }

    ";
}


echo "



@media (max-width: 568px) {
		
.wp-block-cover {
	padding-left:10px ; 
	padding-right:10px ;
}
.wp-block-heading {
		padding-left:10px ; 
	padding-right:10px ;
	max-width:100%
}

}

.wp-block-columns {
	width:100% ;
	padding:20px;
}





</style>";
}
add_action('wp_head', 'firefly_custom_layout_css');

