<?php



// 🔍 Gets the actual image width in pixels
function firefly_get_logo_width($url) {
    if (!$url) return 0;

    $path = wp_parse_url($url, PHP_URL_PATH);
    $file = $_SERVER['DOCUMENT_ROOT'] . $path;

    if (file_exists($file)) {
        $size = getimagesize($file);
        return $size[0] ?? 0;
    }
    return 0;
}

// 🔢 Creates a dropdown list from 50px to actual image width
function firefly_generate_size_choices($max) {
    $choices = [];
    for ($i = 50; $i <= $max; $i += 5) {
        $choices["{$i}px"] = "{$i}px";
    }
    return $choices;
}





function firefly_get_uploaded_fonts_from_media_library() {
    $fonts = [];

    $query = new WP_Query([
        'post_type'      => 'attachment',
        'post_status'    => 'inherit',
        'posts_per_page' => -1,
        'meta_query'     => [
            [
                'key'     => '_wp_attached_file',
                'compare' => 'EXISTS',
            ]
        ],
    ]);

foreach ($query->posts as $attachment) {
    $url = wp_get_attachment_url($attachment->ID);
    $ext = pathinfo($url, PATHINFO_EXTENSION);

    if (in_array(strtolower($ext), ['ttf', 'woff', 'woff2', 'otf'])) {
        $filename = basename($url, ".$ext"); // e.g., "palabi"
        $font_label = ucwords(str_replace(['-', '_'], ' ', $filename)); // e.g., "Palabi"
        $font_family = $filename;

        // Key = CSS-safe font-family value: palabi, sans-serif
        // Value = Display name for dropdown
        $fonts["{$font_family}"] = "$font_label (uploaded)";
    }
}


    return $fonts;
}


add_action('customize_register', 'firefly_customize_header_options');
function firefly_customize_header_options($wp_customize) {



        // Font size choices: 16px to 150px
    $font_size_choices = [];
    for ($i = 16; $i <= 150; $i++) {
        $font_size_choices["{$i}px"] = "{$i}px";
    }


$banner_font_choices = [
    'Abril Fatface, cursive' => 'Abril Fatface (dramatic, elegant)',
    'Aclonica, sans-serif' => 'Aclonica (negative space cuts)',
    'Alegreya, serif' => 'Alegreya (dynamic, readable)',
    'Aleo, serif' => 'Aleo (contemporary, slab-serif)',
    'Almendra Display, cursive' => 'Almendra Display (ancient coin)',
    'Amarante, cursive' => 'Amarante (Art Nouveau-inspired shapes)',
    'Anton, sans-serif' => 'Anton (strong, impactful)',
    'Archivo Narrow, sans-serif' => 'Archivo Narrow (condensed, versatile)',
    'Arial, sans-serif' => 'Arial (classic, neutral)',
    'Arvo, serif' => 'Arvo (geometric, slab-serif)',
    'Audiowide, cursive' => 'Audiowide (perfect circles)',
    'Bacasime Antique, serif' => 'Bacasime Antique (classic, antique style)',
    'Bangers, cursive' => 'Bangers (comic, bold, display)',
    'Barlow, sans-serif' => 'Barlow (contemporary, versatile)',
    'Bayon, sans-serif' => 'Bayon (angular Khmer style)',
    'Bebas Neue, sans-serif' => 'Bebas Neue (clean, display)',
    'Bitter, serif' => 'Bitter (contemporary, readable)',
    'Black Ops One, sans-serif' => 'Black Ops One (military stencil)',
    'Blaka Hollow, cursive' => 'Blaka Hollow (batik cutouts)',
    'Bodoni Moda, serif' => 'Bodoni Moda (fashion, high-contrast)',
    'Bowlby One, sans-serif' => 'Bowlby One (movie poster)',
    'Brush Script MT, cursive' => 'Brush Script MT (casual, artistic)',
    'Bungee, sans-serif' => 'Bungee (urban street-style)',
    'Bungee Shade, sans-serif' => 'Bungee Shade (3D shadow effect)',
    'Butterfly Kids, cursive' => 'Butterfly Kids (flower stems)',
    'Cabin, sans-serif' => 'Cabin (contemporary, friendly)',
    'Chango, cursive' => 'Chango (playful deco shapes)',
    'Cinzel, serif' => 'Cinzel (classic, Roman-style headings)',
    'Coda Caption, sans-serif' => 'Coda Caption (compact, bold)',
    'Codystar, cursive' => 'Codystar (constellation lines)',
    'Concert One, cursive' => 'Concert One (bold, fun)',
    'Condiment, cursive' => 'Condiment (condensed, playful)',
    'Cormorant Garamond, serif' => 'Cormorant Garamond (classic, refined)',
    'Courier New, monospace' => 'Courier New (technical, classic)',
    'Creepster, cursive' => 'Creepster (horror punk dripping style)',
    'Dancing Script, cursive' => 'Dancing Script (swirling elegance)',
    'DotGothic16, sans-serif' => 'DotGothic16 (pixel dots)',
    'Dosis, sans-serif' => 'Dosis (light, rounded)',
    'Eater, cursive' => 'Eater (vampire punk)',
    'Emilys Candy, cursive' => 'Emilys Candy (sweet wrappers)',
    'Exo 2, sans-serif' => 'Exo 2 (tech-inspired, readable)',
    'Fascinate, cursive' => 'Fascinate (comic book)',
    'Fasthand, serif' => 'Fasthand (Asian brush strokes)',
    'Faster One, cursive' => 'Faster One (speed lines)',
    'Fira Sans, sans-serif' => 'Fira Sans (technical, clean)',
    'Fjalla One, sans-serif' => 'Fjalla One (bold, compact headings)',
    'Francois One, sans-serif' => 'Francois One (rounded, headline)',
    'Freckle Face, cursive' => 'Freckle Face (spray-paint texture)',
    'Frijole, cursive' => 'Frijole (Day of the Dead)',
    'Georgia, serif' => 'Georgia (elegant, classic)',
    'Gothic A1, sans-serif' => 'Gothic A1 (modern gothic style)',
    'Gravitas One, serif' => 'Gravitas One (bold, slab-serif display)',
    'Great Vibes, cursive' => 'Great Vibes (calligraphic flair)',
    'Helvetica, sans-serif' => 'Helvetica (clean, versatile)',
    'Henny Penny, cursive' => 'Henny Penny (medieval manuscript)',
    'Hind, sans-serif' => 'Hind (simple, readable)',
    'IBM Plex Sans, sans-serif' => 'IBM Plex Sans (technical, professional)',
    'Inconsolata, monospace' => 'Inconsolata (monospace, technical)',
    'Inter, sans-serif' => 'Inter (neutral, readable)',
    'Irish Grover, cursive' => 'Irish Grover (Celtic knots)',
    'Josefin Sans, sans-serif' => 'Josefin Sans (geometric, elegant)',
    'Kanit, sans-serif' => 'Kanit (condensed, modern Thai-style)',
    'Karla, sans-serif' => 'Karla (minimalist, clean)',
    'Kranky, cursive' => 'Kranky (Halloween spooky)',
    'Lato, sans-serif' => 'Lato (warm, sophisticated)',
    'League Gothic, sans-serif' => 'League Gothic (tall, narrow, vintage)',
    'Libre Baskerville, serif' => 'Libre Baskerville (traditional, readable)',
    'Limelight, sans-serif' => 'Limelight (Broadway marquee)',
    'Lobster, cursive' => 'Lobster (50s diner)',
    'Luckiest Guy, cursive' => 'Luckiest Guy (comic, bold, fun)',
    'Major Mono Display, monospace' => 'Major Mono Display (hacking terminal)',
    'MedievalSharp, cursive' => 'MedievalSharp (castle inscriptions)',
    'Merriweather, serif' => 'Merriweather (traditional, readable)',
    'Metal Mania, cursive' => 'Metal Mania (engraved metal)',
    'Metrophobic, sans-serif' => 'Metrophobic (streamlined moderne)',
    'Michroma, sans-serif' => 'Michroma (retro-futuristic)',
    'Miltonian, cursive' => 'Miltonian (woodcut prints)',
    'Monoton, cursive' => 'Monoton (neon tube lights)',
    'Montserrat, sans-serif' => 'Montserrat (geometric, modern)',
    'Mountains of Christmas, cursive' => 'Mountains of Christmas (snowy peaks)',
    'Muli, sans-serif' => 'Muli (minimalist, versatile)',
    'Nabla, cursive' => 'Nabla (colorful layered)',
    'Nasalization, sans-serif' => 'Nasalization (space age)',
    'Neon Tubes, sans-serif' => 'Neon Tubes (retro, glowing lines)',
    'New Rocker, cursive' => 'New Rocker (70s metal band)',
    'Nosifer, cursive' => 'Nosifer (zombie apocalypse)',
    'Noto Sans Cherokee, sans-serif' => 'Noto Sans Cherokee (indigenous)',
    'Noto Sans Linear B, sans-serif' => 'Noto Sans Linear B (ancient Greek)',
    'Noto Sans Mayan, sans-serif' => 'Noto Sans Mayan (hieroglyphic)',
    'Noto Sans Osmanya, sans-serif' => 'Noto Sans Osmanya (ancient script)',
    'Nunito, sans-serif' => 'Nunito (rounded, friendly)',
    'Ojuju, sans-serif' => 'Ojuju (Afro-grotesque style)',
    'Old Standard TT, serif' => 'Old Standard TT (late 19th and early 20th-century style)',
    'Open Sans, sans-serif' => 'Open Sans (neutral, friendly)',
    'Orbitron, sans-serif' => 'Orbitron (sci-fi interface)',
    'Oswald, sans-serif' => 'Oswald (bold, impactful)',
    'Pacifico, cursive' => 'Pacifico (playful, casual)',
    'Palatino, serif' => 'Palatino (traditional, refined)',
    'Parisienne, cursive' => 'Parisienne (Parisian café)',
    'Passion One, cursive' => 'Passion One (extra-bold, expressive)',
    'Patua One, serif' => 'Patua One (slab-serif, display)',
    'Pirata One, cursive' => 'Pirata One (Jolly Roger skull)',
    'Play, sans-serif' => 'Play (compact, modern)',
    'Playfair Display, serif' => 'Playfair Display (classic, elegant)',
    'Poiret One, cursive' => 'Poiret One (geometric deco)',
    'Poppins, sans-serif' => 'Poppins (geometric, friendly)',
    'Press Start 2P, cursive' => 'Press Start 2P (8-bit arcade)',
    'Prompt, sans-serif' => 'Prompt (rounded, condensed)',
    'Quicksand, sans-serif' => 'Quicksand (light, modern)',
    'Racing Sans One, sans-serif' => 'Racing Sans One (fast, sporty)',
    'Rajdhani, sans-serif' => 'Rajdhani (angular tech)',
    'Raleway, sans-serif' => 'Raleway (elegant, stylish)',
    'Rampart One, cursive' => 'Rampart One (chiseled stone effect)',
    'Ribeye Marrow, cursive' => 'Ribeye Marrow (chalk outline)',
    'Righteous, cursive' => 'Righteous (geometric, unique headings)',
    'Roboto Condensed, sans-serif' => 'Roboto Condensed (modern, approachable)',
    'Roboto, sans-serif' => 'Roboto (modern, approachable)',
    'Rubik Beastly, cursive' => 'Rubik Beastly (monster claws)',
    'Rubik Broken Fax, cursive' => 'Rubik Broken Fax (glitch distortion)',
    'Rubik Glitch, cursive' => 'Rubik Glitch (digital distortion)',
    'Rubik Moonrocks, cursive' => 'Rubik Moonrocks (space texture)',
    'Rubik Vinyl, cursive' => 'Rubik Vinyl (70s funk)',
    'Rubik Wet Paint, cursive' => 'Rubik Wet Paint (dripping ink)',
    'Rubik, sans-serif' => 'Rubik (modern, slightly rounded)',
    'Russo One, sans-serif' => 'Russo One (bold geometry)',
    'Rye, serif' => 'Rye (saloon woodtype)',
    'Sacramento, cursive' => 'Sacramento (brush script)',
    'Saira Condensed, sans-serif' => 'Saira Condensed (modern, condensed)',
    'Saira Extra Condensed, sans-serif' => 'Saira Extra Condensed (extra tight)',
    'Share Tech, sans-serif' => 'Share Tech (clean circuitry)',
    'Slabo 27px, serif' => 'Slabo 27px (modern, slab-serif)',
    'Smokum, serif' => 'Smokum (wanted poster)',
    'Snowburst One, cursive' => 'Snowburst One (crystal shards)',
    'Smythe, serif' => 'Smythe (Arts and Crafts movement-inspired)',
    'Source Sans Pro, sans-serif' => 'Source Sans Pro (clean, reliable)',
    'Space Mono, monospace' => 'Space Mono (retro-futuristic style)',
    'Spectral, serif' => 'Spectral (elegant, modern)',
    'Staatliches, sans-serif' => 'Staatliches (Bauhaus blocks)',
    'Stardos Stencil, serif' => 'Stardos Stencil (circus deco)',
    'Stick, sans-serif' => 'Stick (basic lineart)',
    'Syncopate, sans-serif' => 'Syncopate (negative space)',
    'Tahoma, sans-serif' => 'Tahoma (modern, legible)',
    'Tajawal, sans-serif' => 'Tajawal (clean, modern)',
    'Tangerine, cursive' => 'Tangerine (delicate quill)',
    'Teko, sans-serif' => 'Teko (angular, strong headings)',
    'Times New Roman, serif' => 'Times New Roman (traditional, formal)',
    'Titillium Web, sans-serif' => 'Titillium Web (modern, stylish)',
    'Tourney, sans-serif' => 'Tourney (multiple weights)',
    'Train One, cursive' => 'Train One (railroad tracks)',
    'Trebuchet MS, sans-serif' => 'Trebuchet MS (friendly, modern)',
    'Ubuntu, sans-serif' => 'Ubuntu (humanist, approachable)',
    'Uncial Antiqua, cursive' => 'Uncial Antiqua (ancient manuscript)',
    'UnifrakturMaguntia, cursive' => 'UnifrakturMaguntia (medieval blackletter)',
    'Unica One, sans-serif' => 'Unica One (condensed, clean headings)',
    'Varela Round, sans-serif' => 'Varela Round (rounded, friendly)',
    'Vast Shadow, cursive' => 'Vast Shadow (long drop shadows)',
    'Verdana, sans-serif' => 'Verdana (modern, readable)',
    'VT323, monospace' => 'VT323 (pixel terminal)',
    'Wallpoet, sans-serif' => 'Wallpoet (digital stencil)',
    'Work Sans, sans-serif' => 'Work Sans (technical, clean)',
    'Yanone Kaffeesatz, sans-serif' => 'Yanone Kaffeesatz (clean, light condensed)',
    'Yeseva One, serif' => 'Yeseva One (1920s deco elegance)',
    'Zeyada, cursive' => 'Zeyada (handwritten, casual)',
    'Zilla Slab Highlight, cursive' => 'Zilla Slab Highlight (comic book emphasis)',
    'Zen Tokyo Zoo, cursive' => 'Zen Tokyo Zoo (animal shapes)'
];



$banner_font_choices['Jeff'] = 'Jeff';

foreach (firefly_get_uploaded_fonts_from_media_library() as $label => $url) {
    $banner_font_choices["'$label', sans-serif"] = "$label (uploaded)";
}

 



    // Section
    $wp_customize->add_section('firefly_header_section', array(
        'title'    => __('Firefly Header (logo and banner)', 'firefly'),
        'priority' => 30,
    ));

    // Header Type Selector
    $wp_customize->add_setting('firefly_header_choice', array(
        'default'           => 'logo_only',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('firefly_header_choice', array(
        'label'    => __('What do you want on this site?', 'firefly'),
        'section'  => 'firefly_header_section',
        'type'     => 'radio',
        'choices'  => array(
            'none'       => 'No header',
            'logo_only'       => 'Logo only',
            'text_only'       => 'Text only',
            'banner_only'     => 'Banner only (background image and text)',
            'banner_and_logo' => 'Banner and logo (background image, text, and logo)',
            'logo_text_icons' => 'Logo, text and icons (phone number and social media icons)',
        ),
    ));

    // ========================================
    // LOGO CONTROLS
    // ========================================
    $logo_active = function() {
        $choice = get_theme_mod('firefly_header_choice', 'logo_only');
        return in_array($choice, ['logo_only', 'banner_and_logo', 'logo_text_icons']);
    };

    $everything = function($control) {
        $choice = $control->manager->get_setting('firefly_header_choice')->value();
        return in_array($choice, ['logo_only', 'banner_and_logo', 'banner_only', 'logo_text_icons', 'text_only']);
    };

        $headerchoice = get_theme_mod('firefly_header_choice');
        if ($headerchoice == "text_only") {
            $headerslug = "_text_only";
        }
        else
        {
              $headerslug = "";
        }


        // Banner Text
    $wp_customize->add_setting('firefly_header_margin_top_desktop', array(
           'default' => '0px',
    'sanitize_callback' => 'sanitize_text_field',
    ));


    $wp_customize->add_control('firefly_header_margin_top_desktop_control', array(
        'label'           => __('Space above header on desktop (to allow room for mobile menu)', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'firefly_header_margin_top_desktop',
         'type' => 'select',
    'choices' => [
        '0px' => '0px',
        '10px' => '10px',
        '20px' => '20px',
         '25px' => '25px',
        '30px' => '30px',
         '35px' => '35px',
        '40px' => '40px',
        '45px' => '45px',
           '50px' => '50px',
    '51px' => '51px',
    '52px' => '52px',
    '53px' => '53px',
    '54px' => '54px',
    '55px' => '55px',
    '56px' => '56px',
    '57px' => '57px',
    '58px' => '58px',
    '59px' => '59px',
    '60px' => '60px',
    '61px' => '61px',
    '62px' => '62px',
    '63px' => '63px',
    '64px' => '64px',
    '65px' => '65px',
    '66px' => '66px',
    '67px' => '67px',
    '68px' => '68px',
    '69px' => '69px',
    '70px' => '70px',
    '71px' => '71px',
    '72px' => '72px',
'76px' => '76px',
'77px' => '77px',
'78px' => '78px',
'79px' => '79px',
'80px' => '80px',
'81px' => '81px',
'82px' => '82px',
'83px' => '83px',
'84px' => '84px',
'85px' => '85px',
'86px' => '86px',
'87px' => '87px',
'88px' => '88px',
'89px' => '89px',
'90px' => '90px',
'91px' => '91px',
'92px' => '92px',
'93px' => '93px',
'94px' => '94px',
'95px' => '95px',
'96px' => '96px',
'97px' => '97px',
'98px' => '98px',
'99px' => '99px',
'100px' => '100px',
'101px' => '101px',
'102px' => '102px',
'103px' => '103px',
'104px' => '104px',
'105px' => '105px',
'106px' => '106px',
'107px' => '107px',
'108px' => '108px',
'109px' => '109px',
'110px' => '110px',
'111px' => '111px',
'112px' => '112px',
'113px' => '113px',
'114px' => '114px',
'115px' => '115px',
'116px' => '116px',
'117px' => '117px',
'118px' => '118px',
'119px' => '119px',
'120px' => '120px',
'121px' => '121px',
'122px' => '122px',
'123px' => '123px',
'124px' => '124px',
'125px' => '125px',
'126px' => '126px',
'127px' => '127px',
'128px' => '128px',
'129px' => '129px',
'130px' => '130px',
'131px' => '131px',
'132px' => '132px',
'133px' => '133px',
'134px' => '134px',
'135px' => '135px',
'136px' => '136px',
'137px' => '137px',
'138px' => '138px',
'139px' => '139px',
'140px' => '140px',
'141px' => '141px',
'142px' => '142px',
'143px' => '143px',
'144px' => '144px',
'145px' => '145px',
'146px' => '146px',
'147px' => '147px',
'148px' => '148px',
'149px' => '149px',
'150px' => '150px',

    ],
        'active_callback' => $banner_active,
    ));


    

        // Banner Text
    $wp_customize->add_setting('firefly_header_margin_top_mobile', array(
           'default' => '35px',
    'sanitize_callback' => 'sanitize_text_field',
    ));


    $wp_customize->add_control('firefly_header_margin_top_mobile_control', array(
        'label'           => __('Space above header on mobile (to allow room for mobile menu)', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'firefly_header_margin_top_mobile',
         'type' => 'select',
    'choices' => [
        '0px' => '0px',
        '10px' => '10px',
        '20px' => '20px',
         '25px' => '25px',
        '30px' => '30px',
         '35px' => '35px',
        '40px' => '40px',
        '45px' => '45px',
           '50px' => '50px',
    '51px' => '51px',
    '52px' => '52px',
    '53px' => '53px',
    '54px' => '54px',
    '55px' => '55px',
    '56px' => '56px',
    '57px' => '57px',
    '58px' => '58px',
    '59px' => '59px',
    '60px' => '60px',
    '61px' => '61px',
    '62px' => '62px',
    '63px' => '63px',
    '64px' => '64px',
    '65px' => '65px',
    '66px' => '66px',
    '67px' => '67px',
    '68px' => '68px',
    '69px' => '69px',
    '70px' => '70px',
    '71px' => '71px',
    '72px' => '72px',
   '76px' => '76px',
'77px' => '77px',
'78px' => '78px',
'79px' => '79px',
'80px' => '80px',
'81px' => '81px',
'82px' => '82px',
'83px' => '83px',
'84px' => '84px',
'85px' => '85px',
'86px' => '86px',
'87px' => '87px',
'88px' => '88px',
'89px' => '89px',
'90px' => '90px',
'91px' => '91px',
'92px' => '92px',
'93px' => '93px',
'94px' => '94px',
'95px' => '95px',
'96px' => '96px',
'97px' => '97px',
'98px' => '98px',
'99px' => '99px',
'100px' => '100px',
'101px' => '101px',
'102px' => '102px',
'103px' => '103px',
'104px' => '104px',
'105px' => '105px',
'106px' => '106px',
'107px' => '107px',
'108px' => '108px',
'109px' => '109px',
'110px' => '110px',
'111px' => '111px',
'112px' => '112px',
'113px' => '113px',
'114px' => '114px',
'115px' => '115px',
'116px' => '116px',
'117px' => '117px',
'118px' => '118px',
'119px' => '119px',
'120px' => '120px',
'121px' => '121px',
'122px' => '122px',
'123px' => '123px',
'124px' => '124px',
'125px' => '125px',
'126px' => '126px',
'127px' => '127px',
'128px' => '128px',
'129px' => '129px',
'130px' => '130px',
'131px' => '131px',
'132px' => '132px',
'133px' => '133px',
'134px' => '134px',
'135px' => '135px',
'136px' => '136px',
'137px' => '137px',
'138px' => '138px',
'139px' => '139px',
'140px' => '140px',
'141px' => '141px',
'142px' => '142px',
'143px' => '143px',
'144px' => '144px',
'145px' => '145px',
'146px' => '146px',
'147px' => '147px',
'148px' => '148px',
'149px' => '149px',
'150px' => '150px',

    ],
        'active_callback' => $banner_active,
    ));



 // 📏 Banner Heights
foreach (['desktop' => 400, 'tablet' => 300, 'mobile' => 250] as $device => $default) {
    $wp_customize->add_setting("firefly_banner_height_$device", [
        'default'           => $default,
        'sanitize_callback' => 'absint',
    ]);
    $wp_customize->add_control("firefly_banner_height_{$device} _control", [
        'label'           => __("Banner Height ($device)", 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => "firefly_banner_height_$device",
        'type'            => 'range',
        'input_attrs'     => ['min' => 100, 'max' => 1000, 'step' => 10],
        'active_callback' => $banner_active,
    ]);
}




    // Desktop Logo
    $wp_customize->add_setting('my_plugin_logo_pc', array(
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'my_plugin_logo_pc_control', array(
        'label'           => __('Desktop Logo', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'my_plugin_logo_pc',
        'active_callback' => $logo_active,
    )));



    
    // Mobile Logo
    $wp_customize->add_setting('my_plugin_logo_mobile', array(
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'my_plugin_logo_mobile_control', array(
        'label'           => __('Mobile Logo', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'my_plugin_logo_mobile',
        'active_callback' => $logo_active,
    )));

    // Logo Alignment
    $wp_customize->add_setting('my_plugin_logo_alignment', array(
        'default'           => 'center',
        'sanitize_callback' => 'sanitize_text_field',
    ));


    $wp_customize->add_control('my_plugin_logo_alignment_control', array(
    'label'    => __('Align Logo', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'my_plugin_logo_alignment',
    'type'     => 'select',
    'choices'  => array(
        'leftoftext' => 'Left of text',
        'abovetext'  => 'Above text',
    ),
    'active_callback' => function() {
        return get_theme_mod('firefly_header_choice') === 'banner_and_logo';
    }
));


$breakpoints = [];
for ($i = 480; $i <= 1280; $i += 40) {
    $breakpoints["{$i}px"] = "{$i}px";
}

$wp_customize->add_setting('my_plugin_logo_text_breakpoint', array(
    'default'           => '768px',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('my_plugin_logo_text_breakpoint_control', array(
    'label'           => __('Breakpoint to Move Logo Above Text', 'my-plugin'),
    'section'         => 'firefly_header_section',
    'settings'        => 'my_plugin_logo_text_breakpoint',
    'type'            => 'select',
    'choices'         => $breakpoints,
    'active_callback' => function() {
        return get_theme_mod('firefly_header_choice') === 'banner_and_logo';
    },
));





$wp_customize->add_setting('my_plugin_logo_size_breakpoint', array(
    'default'           => '768px',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('my_plugin_logo_size_breakpoint_control', array(
    'label'           => __('Breakpoint to use small logo', 'my-plugin'),
    'section'         => 'firefly_header_section',
    'settings'        => 'my_plugin_logo_size_breakpoint',
    'type'            => 'select',
    'choices'         => $breakpoints,
    'active_callback' => $logo_active,
));




$wp_customize->add_setting('my_plugin_logo_only_alignment', array(
    'default'           => 'center',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('my_plugin_logo_only_alignment_control', array(
    'label'           => __('Logo Align (Logo Only)', 'my-plugin'),
    'section'         => 'firefly_header_section',
    'settings'        => 'my_plugin_logo_only_alignment',
    'type'            => 'select',
    'choices'         => array(
        'left'   => 'Left',
        'center' => 'Center',
        'right'  => 'Right',
    ),
    'active_callback' => function() {
        return get_theme_mod('firefly_header_choice') === 'logo_only';
    },
));

        // ==========================
    // Logo Size (text inputs)
    // ==========================

// Get uploaded logo widths
$logo_url_pc     = get_theme_mod('my_plugin_logo_pc');
$logo_url_mobile = get_theme_mod('my_plugin_logo_mobile');

$logo_width_pc     = firefly_get_logo_width($logo_url_pc);
$logo_width_mobile = firefly_get_logo_width($logo_url_mobile);

$max_width_pc     = $logo_width_pc ?: 300;
$max_width_mobile = $logo_width_mobile ?: 200;

$size_choices_pc     = firefly_generate_size_choices($max_width_pc);
$size_choices_mobile = firefly_generate_size_choices($max_width_mobile);


$wp_customize->add_setting('my_plugin_logo_size_desktop', array(
    'default'           => '1200px',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'my_plugin_logo_size_desktop_control', array(
    'label'           => __('Desktop Logo Size', 'my-plugin'),
    'description'     => 'Logo size: ' . $logo_width_pc . 'px',
    'section'         => 'firefly_header_section',
    'settings'        => 'my_plugin_logo_size_desktop',
    'type'            => 'select',
    'choices'         => firefly_generate_size_choices($max_width_pc),
    'active_callback' => $logo_active,
)));



// =============================
// Tablet Logo Size (uses PC logo)
// =============================
$wp_customize->add_setting('my_plugin_logo_size_tablet', array(
    'default'           => '600px',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'my_plugin_logo_size_tablet_control', array(
    'label'           => __('Tablet Logo Size', 'my-plugin'),
    'description'     => 'Logo size: ' . $logo_width_pc . 'px',
    'section'         => 'firefly_header_section',
    'settings'        => 'my_plugin_logo_size_tablet',
    'type'            => 'select',
    'choices'         => $size_choices_pc,
    'active_callback' => $logo_active,
)));

// =============================
// Mobile Logo Size (uses mobile logo)
// =============================
$wp_customize->add_setting('my_plugin_logo_size_mobile', array(
    'default'           => '480px',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'my_plugin_logo_size_mobile_control', array(
    'label'           => __('Mobile Logo Size', 'my-plugin'),
    'description'     => 'Logo size: ' . $logo_width_mobile . 'px',
    'section'         => 'firefly_header_section',
    'settings'        => 'my_plugin_logo_size_mobile',
    'type'            => 'select',
    'choices'         => $size_choices_mobile,
    'active_callback' => $logo_active,
)));




// Repeat for tablet and mobile using $max_width_mobile...



    // Logo Max Width
    $wp_customize->add_setting('my_plugin_logo_max_width', array(
        'default'           => '90%',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('my_plugin_logo_max_width_control', array(
        'label'           => __('Max Width of Logo', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'my_plugin_logo_max_width',
        'type'            => 'select',
        'choices'         => array(
            '100%' => '100%',
            '95%'  => '95%',
            '90%'  => '90%',
            '85%'  => '85%',
            '80%'  => '80%',
        ),
        'active_callback' => $logo_active,
    ));


    
        // Padding choices (0px to 100px in 2px steps)
    $padding_choices = [];
    for ($i = 0; $i <= 100; $i += 2) {
        $padding_choices["{$i}px"] = "{$i}px";
    }

    // Padding Above Logo
    $wp_customize->add_setting('my_plugin_logo_padding_top', array(
        'default'           => '0px',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('my_plugin_logo_padding_top_control', array(
        'label'           => __('Padding Above Logo', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'my_plugin_logo_padding_top',
        'type'            => 'select',
        'choices'         => $padding_choices,
        'active_callback' => function() {
            return get_theme_mod('firefly_header_choice', 'logo_only') === 'logo_only';
        },
    ));

    // Padding Below Logo
    $wp_customize->add_setting('my_plugin_logo_padding_bottom', array(
        'default'           => '0px',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('my_plugin_logo_padding_bottom_control', array(
        'label'           => __('Padding Below Logo', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'my_plugin_logo_padding_bottom',
        'type'            => 'select',
        'choices'         => $padding_choices,
        'active_callback' => function() {
            return get_theme_mod('firefly_header_choice', 'logo_only') === 'logo_only';
        },
    ));



        // Padding Below Logo
    $wp_customize->add_setting('my_plugin_logo_padding_leftright', array(
        'default'           => '0px',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('my_plugin_logo_padding_leftright_control', array(
        'label'           => __('Padding Left/Right of Logo', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'my_plugin_logo_padding_leftright',
        'type'            => 'select',
        'choices'         => $padding_choices,
        'active_callback' => function() {
            return get_theme_mod('firefly_header_choice', 'logo_only') === 'logo_only';
        },
    ));


$padding_choices = [];
for ($i = 0; $i <= 300; $i += 2) {
    $padding_choices["{$i}px"] = "{$i}px";
}



    // Background Colour for Logo-Only Container
$wp_customize->add_setting('my_plugin_logo_background', array(
    'default'           => '#ffffff',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control(
    $wp_customize,
    'my_plugin_logo_background_control',
    array(
        'label'           => __('Logo Container Background Colour (Logo Only)', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'my_plugin_logo_background',
        'active_callback' => function() {
            return get_theme_mod('firefly_header_choice') === 'logo_only';
        },
    )
));






    // padding for logo with banner


$wp_customize->add_setting('my_plugin_banner_logo_space', array(
    'default'           => '20px', // Or whatever default you want
    'sanitize_callback' => 'sanitize_text_field', // or create a sanitize_padding_value function
));

$wp_customize->add_control('my_plugin_banner_logo_space_control', array(
    'label'           => __('Padding around logo', 'my-plugin'),
    'section'         => 'firefly_header_section',
     'settings'        => 'my_plugin_banner_logo_space',
    'type'            => 'select',
    'choices'         => $padding_choices, // e.g. ['10px' => '10px', '20px' => '20px', ...]
    'active_callback' => function() {
        return get_theme_mod('firefly_header_choice') === 'banner_and_logo';
    },
));



    // ========================================
    // BANNER CONTROLS
    // ========================================
    $banner_active = function() {
        $choice = get_theme_mod('firefly_header_choice', 'logo_only');
        return in_array($choice, ['banner_only', 'banner_and_logo']);
    };


     $backgroud_colour_active = function() {
        $choice = get_theme_mod('firefly_header_choice');
        return in_array($choice, ['text_only', 'logo_text_icons']);
    };


    $text_active = function() {
        $choice = get_theme_mod('firefly_header_choice', 'logo_only');
        return in_array($choice, ['banner_only', 'banner_and_logo','text_only']);
    };

    // Banner images
    $banners = array(
        'desktop' => 'Desktop Banner Image',
        'tablet'  => 'Tablet Banner Image',
        'mobile'  => 'Mobile Banner Image',
    );
    foreach ($banners as $key => $label) {
        $setting = "firefly_banner_{$key}";
        $control = "firefly_banner_{$key}_control";
        $wp_customize->add_setting($setting, array(
            'sanitize_callback' => 'esc_url_raw',
        ));
        $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, $control, array(
            'label'           => __($label, 'my-plugin'),
            'section'         => 'firefly_header_section',
            'settings'        => $setting,
            'active_callback' => $banner_active,
        )));
    }


        // Banner Text
    $wp_customize->add_setting('firefly_banner_darken', array(
           'default' => 0,
    'sanitize_callback' => 'absint',
    ));
    $wp_customize->add_control('firefly_banner_darken_control', array(
        'label'           => __('Darken background image', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'firefly_banner_darken',
         'type' => 'range',
    'input_attrs' => [
        'min' => 0,
        'max' => 100,
        'step' => 1,
    ],
        'active_callback' => $banner_active,
    ));


 
    // Show borders around divs for debugging
$wp_customize->add_setting('firefly_just_darken_heading', [
    'default'           => false,
    'sanitize_callback' => 'wp_validate_boolean',
]);

$wp_customize->add_control('firefly_just_darken_heading_control', [
    'label'    => __('Only darken heading', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_just_darken_heading',
    'type'     => 'checkbox',
]);

    // Space below text desktiopo
$wp_customize->add_setting('firefly_heading_space_bottom_desktop', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_heading_space_bottom_desktop_control', [
    'label'    => __('Space Below Heading Desktop', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_heading_space_bottom_desktop',
    'type'     => 'select',
    'choices'  => $padding_choices,
      'active_callback' => $banner_active,
]);




    // Space below text tablet
$wp_customize->add_setting('firefly_heading_space_bottom_tablet', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_heading_space_bottom_tablet_control', [
    'label'    => __('Space Below Heading Tablet', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_heading_space_bottom_tablet',
    'type'     => 'select',
    'choices'  => $padding_choices,
      'active_callback' => $banner_active,
]);



    // Space below text mobile
$wp_customize->add_setting('firefly_heading_space_bottom_mobile', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_heading_space_bottom_mobile_control', [
    'label'    => __('Space Below Heading Mobile', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_heading_space_bottom_mobile',
    'type'     => 'select',
    'choices'  => $padding_choices,
      'active_callback' => $banner_active,
]);



        // 📐 Background Display Style
        $wp_customize->add_setting('firefly_banner_background_style', [
            'default'           => 'cover',
            'sanitize_callback' => 'sanitize_text_field',
        ]);
        $wp_customize->add_control('firefly_banner_background_style_control', [
            'label'    => __('Background Image Display Style', 'my-plugin'),
            'section'  => 'firefly_header_section',
            'settings' => 'firefly_banner_background_style',
            'type'     => 'select',
            'choices'  => [
                'cover'      => 'Cover (Fill & Crop)',
                'contain'    => 'Contain (Fit Inside)',
                'repeat'     => 'Repeat (Tile)',
                'no-repeat'  => 'No Repeat',
                'repeat-x'   => 'Repeat Horizontally',
                'repeat-y'   => 'Repeat Vertically',
            ],
            'active_callback' => $banner_active,
        ]);

    // Banner Text
    $wp_customize->add_setting("firefly_banner_text", array(
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control("firefly_banner_text_controlbackgroud_colour_active", array(
        'label'           => __('Banner Text', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => "firefly_banner_text",
        'type'            => 'text',
        'active_callback' => $text_active,
    ));

	
	
	    $wp_customize->add_setting("firefly_subheading_text", array(
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control("firefly_subheading_text_control", array(
        'label'           => __('Subheading Text', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => "firefly_subheading_text",
        'type'            => 'text',
       'active_callback' => $text_active,
    ));

	
	
    // Banner Text Colour
    $wp_customize->add_setting("firefly_banner_text_color", array(
        'default'           => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, "firefly_banner_text_color_control", array(
        'label'           => __("Banner Text Colour", 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => "firefly_banner_text_color",
          'active_callback' => $banner_active,
     
    )));



        // Banner Text Colour
    $wp_customize->add_setting("firefly_banner_text_color_text_only", array(
        'default'           => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, "firefly_banner_text_color_text_only_control", array(
        'label'           => __("Banner Text Colour (text only))", 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => "firefly_banner_text_color_text_only",
        'active_callback' => function() {
        return get_theme_mod('firefly_header_choice') === 'text_only';
    },
    )));



    // Space Above Logo
$wp_customize->add_setting('firefly_text_only_heading_padding_top', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_text_only_heading_padding_top_control', [
    'label'    => __('Space Above Heading', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_text_only_heading_padding_top',
    'type'     => 'select',
    'choices'  => $padding_choices,
        'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'text_only',
]);



$wp_customize->add_setting('firefly_text_only_heading_padding_bottom', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_text_only_heading_padding_bottom_control', [
    'label'    => __('Space Below Heading', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_text_only_heading_padding_bottom',
    'type'     => 'select',
    'choices'  => $padding_choices,
        'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'text_only',
]);


$wp_customize->add_setting('firefly_subheading_padding_top', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_subheading_padding_top_control', [
    'label'    => __('Space Above Subhading', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_subheading_padding_top',
    'type'     => 'select',
     'choices'  => $padding_choices,
     'active_callback' => $text_active,
]);



$wp_customize->add_setting('firefly_subheading_padding_bottom', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_subheading_padding_bottom_control', [
    'label'    => __('Space Below Subhading', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_subheading_padding_bottom',
    'type'     => 'select',
     'choices'  => $padding_choices,
     'active_callback' => $text_active,
]);



        // Banner Font Family
    $wp_customize->add_setting('firefly_banner_font_family', array(
        'default'           => 'default',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('firefly_banner_font_family_control', array(
        'label'           => __('Banner Text Font', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'firefly_banner_font_family',
        'type'            => 'select',
        'choices'         => $banner_font_choices,
        'active_callback' => $text_active,
    ));

$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'firefly_view_fonts_link', array(
    'label' => '',
    'section' => 'firefly_header_section',
    'settings' => [],
    'type' => 'hidden',
    'description' => '<a href="' . esc_url(site_url('/firefly-view-fonts')) . '" target="_blank">🎨 View Fonts</a>',
    'active_callback' => $text_active,
)));






    // Banner Font Weight
    $wp_customize->add_setting('firefly_banner_font_weight', array(
        'default'           => 'normal',
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('firefly_banner_font_weight_control', array(
        'label'           => __('Font Weight', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'firefly_banner_font_weight',
        'type'            => 'select',
        'choices'         => array(
            'normal' => 'Normal',
            'bold'   => 'Bold',
        ),
        'active_callback' => $text_active,
    ));


    function firefly_create_font_viewer_page_if_missing() {
    $slug = 'firefly-view-fonts';

    // Check if a page with this slug already exists
    $existing = get_page_by_path($slug, OBJECT, 'page');
    if ($existing) {
        return; // Page already exists, no need to create
    }

    // Create the page
    wp_insert_post(array(
        'post_title'     => 'Font Viewer',
        'post_name'      => $slug,
        'post_status'    => 'publish',
        'post_type'      => 'page',
        'post_content'   => '',
        'post_author'    => get_current_user_id(),
        'page_template'  => 'page-firefly-view-fonts.php', // optional if you want to force the template
        'meta_input' => array(
    '_menu_item_orphaned' => true,
    '_wp_page_template' => 'page-firefly-view-fonts.php',
),

    ));
}




       // Line height percentages
       $wp_customize->add_setting('firefly_banner_line_height', [
        'default'           => '1.2',
        'sanitize_callback' => 'sanitize_text_field',
    ]);
    $wp_customize->add_control('firefly_banner_line_height_control', [
        'label'    => __('Line Spacing', 'my-plugin'),
        'section'  => 'firefly_header_section',
        'settings' => 'firefly_banner_line_height',
        'type'     => 'select',
        'choices'  => array_combine(
            array_map(fn($n) => number_format($n / 100, 2), range(80, 250, 5)),
            array_map(fn($n) => $n . '%', range(80, 250, 5))
        ),
        'active_callback' => $text_active,
    ]);



    // Banner Text Sizes
       // Banner Text Size Dropdowns
    $text_sizes = array(
        'text_size'         => 'Desktop Text Size',
        'text_size_tablet'  => 'Tablet Text Size',
        'text_size_mobile'  => 'Mobile Text Size',
    );

    foreach ($text_sizes as $key => $label) {
        $setting_id = "firefly_banner_{$key}";
        $control_id = "firefly_banner_{$key}_control";

        $wp_customize->add_setting($setting_id, array(
            'default'           => '32px',
            'sanitize_callback' => 'sanitize_text_field',
        ));

        $wp_customize->add_control($control_id, array(
            'label'           => __($label, 'my-plugin'),
            'section'         => 'firefly_header_section',
            'settings'        => $setting_id,
            'type'            => 'select',
            'choices'         => $font_size_choices,
            'active_callback' => $banner_active,
        ));
    }


// Show borders around divs for debugging
$wp_customize->add_setting('firefly_show_debug_borders', [
    'default'           => false,
    'sanitize_callback' => 'wp_validate_boolean',
]);

$wp_customize->add_control('firefly_show_debug_borders_control', [
    'label'    => __('Show borders around divs for debugging', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_show_debug_borders',
    'type'     => 'checkbox',
]);




// Phone Number (only when "logo_text_icons" is selected)
$wp_customize->add_setting('firefly_logo_phone_number', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('firefly_logo_phone_number_control', array(
    'label'           => __('Phone Number', 'my-plugin'),
    'section'         => 'firefly_header_section',
    'settings'        => 'firefly_logo_phone_number',
    'type'            => 'text',
    'active_callback' => function() {
        return get_theme_mod('firefly_header_choice') === 'logo_text_icons';
    },
));


// Phone Number
$wp_customize->add_setting('firefly_logo_phone_number', [
    'default' => '',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_logo_phone_number_control', [
    'label' => __('Phone Number', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_phone_number',
    'type' => 'text',
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);


// Phone Number Prefix Text (e.g., "Phone:", "Call:")
$wp_customize->add_setting('firefly_logo_phone_prefix', [
    'default'           => 'Phone:',
    'sanitize_callback' => 'sanitize_text_field',
]);

$wp_customize->add_control('firefly_logo_phone_prefix_control', [
    'label' => __('Phone Number Text (e.g., "Phone:", "Ph:", "Call:")', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_phone_prefix',
    'type' => 'text',
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);

// Phone Number Font
$wp_customize->add_setting('firefly_logo_phone_font', [
    'default' => 'default',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_logo_phone_font_control', [
    'label' => __('Phone Number Font', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_phone_font',
    'type' => 'select',
    'choices' => $banner_font_choices,
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);

// Phone Number Size
$wp_customize->add_setting('firefly_logo_phone_size', [
    'default' => '18px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_logo_phone_size_control', [
    'label' => __('Phone Number Size', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_phone_size',
    'type' => 'select',
    'choices' => $font_size_choices,
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);

// Phone Number Colour
$wp_customize->add_setting('firefly_logo_phone_color', [
    'default' => '#000000',
    'sanitize_callback' => 'sanitize_hex_color',
]);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'firefly_logo_phone_color_control', [
    'label' => __('Phone Number Colour', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_phone_color',
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]));




// Banner Background Colour
$wp_customize->add_setting("firefly_banner_background_color", [
    'default'           => '#ffffff',
    'sanitize_callback' => 'sanitize_hex_color',
]);

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, "firefly_banner_background_color_control", [
    'label'           => __("Banner Background Colour", 'my-plugin'),
    'section'         => 'firefly_header_section',
    'settings'        => "firefly_banner_background_color",
   'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]));



$wp_customize->add_setting('firefly_heading_size_text_only', [
    'default' => '18px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_heading_size_text_only_control', [
    'label' => __('Heading Size (text only)', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_heading_size_text_only',
    'type' => 'select',
    'choices' => $font_size_choices,
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'text_only',
]);

	
	
	
	$wp_customize->add_setting('firefly_heading_size_tablet_text_only', [
    'default' => '18px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_heading_size_tablet_text_only_control', [
    'label' => __('Heading Size on tablet', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_heading_size_tablet_text_only',
    'type' => 'select',
    'choices' => $font_size_choices,
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'text_only',
]);

	
	
		$wp_customize->add_setting('firefly_heading_size_mobile_text_only', [
    'default' => '18px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_heading_size_mobile_text_only_control', [
    'label' => __('Heading Size on mobile', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_heading_size_mobile_text_only',
    'type' => 'select',
    'choices' => $font_size_choices,
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'text_only',
]);

	
	
	
$wp_customize->add_setting('firefly_subheading_size_text_only', [
    'default' => '18px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_subheading_size_text_only_control', [
    'label' => __('Subheading Size on desktop', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_subheading_size_text_only',
    'type' => 'select',
    'choices' => $font_size_choices,
     'active_callback' => $text_active,
]);


		
	$wp_customize->add_setting('firefly_subheading_size_tablet_text_only', [
    'default' => '18px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_subheading_size_tablet_text_only_control', [
    'label' => __('Subeading Size on tablet', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_subheading_size_tablet_text_only',
    'type' => 'select',
    'choices' => $font_size_choices,
    'active_callback' => $text_active,
]);

	
	
		$wp_customize->add_setting('firefly_subheading_size_mobile_text_only', [
    'default' => '18px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_subheading_size_mobile_text_only_control', [
    'label' => __('Subeading Size on mobile', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_subheading_size_mobile_text_only',
    'type' => 'select',
    'choices' => $font_size_choices,
     'active_callback' => $text_active,
]);


// Banner Background Colour
$wp_customize->add_setting("firefly_banner_background_color_text_only", [
    'default'           => '#ffffff',
    'sanitize_callback' => 'sanitize_hex_color',
]);

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, "firefly_banner_background_color_text_only_control", [
    'label'           => __("Banner Background Colour $headerslug", 'my-plugin'),
    'section'         => 'firefly_header_section',
    'settings'        => "firefly_banner_background_color_text_only",
   'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'text_only',
]));



// Phone Number Position
$wp_customize->add_setting('firefly_logo_phone_position', [
    'default' => 'top',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_logo_phone_position_control', [
    'label' => __('Phone Number Position', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_phone_position',
    'type' => 'select',
    'choices' => [
        'top' => 'Top',
        'bottom' => 'Bottom',
    ],
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);


// Other Text
$wp_customize->add_setting('firefly_logo_other_text', [
    'default' => '',
    'sanitize_callback' => 'sanitize_textarea_field',
]);
$wp_customize->add_control('firefly_logo_other_text_control', [
    'label' => __('Other Text', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_other_text',
    'type' => 'textarea',
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);

// Other Text Font
$wp_customize->add_setting('firefly_logo_other_font', [
    'default' => 'default',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_logo_other_font_control', [
    'label' => __('Other Text Font', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_other_font',
    'type' => 'select',
    'choices' => $banner_font_choices,
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);

// Other Text Size
$wp_customize->add_setting('firefly_logo_other_size', [
    'default' => '18px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_logo_other_size_control', [
    'label' => __('Other Text Size', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_other_size',
    'type' => 'select',
    'choices' => $font_size_choices,
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);

// Other Text Colour
$wp_customize->add_setting('firefly_logo_other_color', [
    'default' => '#000000',
    'sanitize_callback' => 'sanitize_hex_color',
]);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'firefly_logo_other_color_control', [
    'label' => __('Other Text Colour', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_other_color',
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]));

// Space Above Phone
$space_above_choices = [];
for ($i = 0; $i <= 50; $i++) {
    $space_above_choices["{$i}px"] = "{$i}px";
}

$wp_customize->add_setting('firefly_logo_phone_margin_top', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);

$wp_customize->add_control('firefly_logo_phone_margin_top_control', [
    'label' => __('Space above phone number', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_phone_margin_top',
    'type' => 'select',
    'choices' => $space_above_choices,
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);


$wp_customize->add_setting('firefly_logo_phone_margin_bottom', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);

$wp_customize->add_control('firefly_logo_phone_margin_bottom_control', [
    'label' => __('Space below phone number', 'my-plugin'),
    'section' => 'firefly_header_section',
    'settings' => 'firefly_logo_phone_margin_bottom',
    'type' => 'select',
    'choices' => $space_above_choices,
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);

// Vertical Align: Phone Number and Text
$wp_customize->add_setting('firefly_logo_phone_vertical_align', [
    'default'           => 'top',
    'sanitize_callback' => 'sanitize_text_field',
]); 

$wp_customize->add_control('firefly_logo_phone_vertical_align_control', [
    'label'    => __('Vertical Align (Phone & Text)', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_logo_phone_vertical_align',
    'type'     => 'radio',
    'choices'  => [
        'top'    => 'Top',
        'middle' => 'Middle',
        'bottom' => 'Bottom',
    ],
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);




// Space Above Logo
$wp_customize->add_setting('firefly_logo_padding_top', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_logo_padding_top_control', [
    'label'    => __('Space Above Logo', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_logo_padding_top',
    'type'     => 'select',
    'choices'  => $padding_choices,
        'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);

// Space Below Logo
$wp_customize->add_setting('firefly_logo_padding_bottom', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_logo_padding_bottom_control', [
    'label'    => __('Space Below Logo', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_logo_padding_bottom',
    'type'     => 'select',
    'choices'  => $padding_choices,
        'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);

// Space Left/Right of Logo
$wp_customize->add_setting('firefly_logo_padding_leftright', [
    'default'           => '0px',
    'sanitize_callback' => 'sanitize_text_field',
]);
$wp_customize->add_control('firefly_logo_padding_leftright_control', [
    'label'    => __('Space Left/Right of Logo', 'my-plugin'),
    'section'  => 'firefly_header_section',
    'settings' => 'firefly_logo_padding_leftright',
    'type'     => 'select',
    'choices'  => $padding_choices,
       'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);

for ($i = 1; $i <= 4; $i++) {
    // Icon upload
    $wp_customize->add_setting("firefly_logo_icon_{$i}", [
        'sanitize_callback' => 'esc_url_raw',
    ]);
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, "firefly_logo_icon_{$i}_control", [
        'label'           => __("Icon {$i}", 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => "firefly_logo_icon_{$i}",
        'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
    ]));

    // Icon link
    $wp_customize->add_setting("firefly_logo_icon_{$i}_link", [
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ]);
    $wp_customize->add_control("firefly_logo_icon_{$i}_link_control", [
        'label'           => __("Icon {$i} Link", 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => "firefly_logo_icon_{$i}_link",
        'type'            => 'url',
        'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
    ]);
}


// Icon Height (10px to 250px)
$icon_height_choices = [];
for ($i = 10; $i <= 250; $i++) {
    $icon_height_choices["{$i}px"] = "{$i}px";
}

$wp_customize->add_setting('firefly_logo_icon_height', [
    'default'           => '24px',
    'sanitize_callback' => 'sanitize_text_field',
]);

$wp_customize->add_control('firefly_logo_icon_height_control', [
    'label'           => __('Icon Height', 'my-plugin'),
    'section'         => 'firefly_header_section',
    'settings'        => 'firefly_logo_icon_height',
    'type'            => 'select',
    'choices'         => $icon_height_choices,
    'active_callback' => fn() => get_theme_mod('firefly_header_choice') === 'logo_text_icons',
]);





    // ─────────────────────────────────────────────────────────────────
    // LINE BETWEEN HEADING & SUBHEADING
    // ─────────────────────────────────────────────────────────────────

    // 1) Show line?
    $wp_customize->add_setting('firefly_show_line_between', [
        'default'           => false,
        'sanitize_callback' => 'wp_validate_boolean',
    ]);
    $wp_customize->add_control('firefly_show_line_between_control', [
        'label'    => __('Line between heading and subheading', 'my-plugin'),
        'section'  => 'firefly_header_section',
        'settings' => 'firefly_show_line_between',
        'type'     => 'checkbox',
           'active_callback' => $text_active,
    ]);

    // Convenience callback for the dependent controls
 // Convenience callback for the dependent controls
$line_active = function( $control ) {
    // 1) only for "text_only" header choice
    $is_text_only = $control->manager
                           ->get_setting( 'firefly_header_choice' )
                           ->value() === 'text_only';

    // 2) only if they've checked "show line between"
    $has_line = (bool) $control->manager
                               ->get_setting( 'firefly_show_line_between' )
                               ->value();

    return $is_text_only && $has_line;
};


    // 2) Line width (px)
    $wp_customize->add_setting('firefly_line_width', [
        'default'           => 1,
        'sanitize_callback' => 'absint',
    ]);
    $wp_customize->add_control('firefly_line_width_control', [
        'label'       => __('Line Width (px)', 'my-plugin'),
        'section'     => 'firefly_header_section',
        'settings'    => 'firefly_line_width',
        'type'        => 'range',
        'input_attrs' => [
            'min'  => 1,
            'max'  => 10,
            'step' => 1,
        ],
        'active_callback' => $line_active,
    ]);

    // 3) Line colour
    $wp_customize->add_setting('firefly_line_color', [
        'default'           => '#000000',
        'sanitize_callback' => 'sanitize_hex_color',
    ]);
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'firefly_line_color_control', [
        'label'           => __('Line Colour', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'firefly_line_color',
        'active_callback' => $line_active,
    ]));

    // Re-use your $padding_choices array (0px–100px in 2px steps) for spacing
    // 4) Space above line
    $wp_customize->add_setting('firefly_line_space_above', [
        'default'           => '10px',
        'sanitize_callback' => 'sanitize_text_field',
    ]);
    $wp_customize->add_control('firefly_line_space_above_control', [
        'label'           => __('Space Above Line', 'my-plugin'),
        'section'         => 'firefly_header_section',
        'settings'        => 'firefly_line_space_above',
        'type'            => 'select',
        'choices'         => $padding_choices,
        'active_callback' => $line_active,
    ]);




}


add_action('wp_head', 'firefly_output_google_font_for_banner');
function firefly_output_google_font_for_banner() {


    $font_raw = get_theme_mod('firefly_banner_font_family', 'default');

    


    // Skip if default or empty
    if (!$font_raw || $font_raw === 'default') return;

    // Extract the font name before the comma
    $font_name = trim(explode(',', $font_raw)[0]);

    // Replace spaces with + for URL encoding
    $google_font = str_replace(' ', '+', $font_name);

    echo '<link href="https://fonts.googleapis.com/css2?family=' . esc_attr($google_font) . '&display=swap" rel="stylesheet">' . "\n";
}



add_action('wp_head', 'firefly_output_custom_header_css');add_action('wp_head', 'firefly_output_custom_header_css');
function firefly_output_custom_header_css() {
    if (!is_customize_preview() && !is_front_page() && !is_page()) return;

        $overlay_opacity = intval(get_theme_mod('firefly_banner_darken', 0)) / 100;
        $mobile_menu_breakpoint = get_theme_mod('firefly_mobile_breakpoint', '768px');
        $firefly_header_margin_top_mobile        = get_theme_mod('firefly_header_margin_top_mobile', '35px');
        $bg_style        = get_theme_mod('firefly_banner_background_style', 'cover');



    $just_darken_heading = get_theme_mod('firefly_just_darken_heading', false);
    $heading_space_bottom_desktop = get_theme_mod('firefly_heading_space_bottom_desktop', '0px');
    $heading_space_bottom_tablet = get_theme_mod('firefly_heading_space_bottom_tablet', '0px');
    $heading_space_bottom_mobile = get_theme_mod('firefly_heading_space_bottom_mobile', '0px');
    $firefly_header_margin_top_desktop = get_theme_mod('firefly_header_margin_top_desktop', '0px');
    

echo    "

<style>


.firefly-banner-only::before,
    .firefly-banner::before {
        content: '';
        position: absolute;
        inset: 0;
        ";

        if( !$just_darken_heading) {
             echo " background-color: rgba(0, 0, 0, $overlay_opacity);";
        } 

        echo "
        z-index: 1;
    }

    ";

     if ($just_darken_heading) {
            echo ".firefly-banner-text {
	    background-color:black;
	    background-color: rgba(0, 0, 0, $overlay_opacity); 
	    padding:20px;
 
        }
        ";
    }

echo "

.firefly-banner-text-wrapper {
       padding-bottom:{$heading_space_bottom_desktop};
}

@media (min-width: 701px) and (max-width: 1024px) {
    .firefly-banner-text-wrapper {
            padding-bottom:{$heading_space_bottom_tablet};
    }
}
@media (max-width: 700px) {
    .firefly-banner-text-wrapper {
            padding-bottom:{$heading_space_bottom_mobile};
    }
}
luang{}
     .firefly-banner,
            .firefly-banner-only,
            .firefly-text-only,
          .banner-with-phone,
            .firefly-logo-wrap,
            .header-spacer {
    
            margin-top: $firefly_header_margin_top_desktop;
        }
        ";

    

    echo "
      @media (max-width: $mobile_menu_breakpoint ) {
            
        .firefly-banner,
            .firefly-banner-only,
            .firefly-text-only,
          .banner-with-phone,
            .firefly-logo-wrap,
            .header-spacer {
          
            display:block;
              margin-left: 0px;
            margin-top: $firefly_header_margin_top_mobile;
        }

   
}




    @media (min-width: 1025px) {
            .firefly-banner,
            .firefly-banner-only,
              .firefly-text-only,
          .banner-with-phone,
            .firefly-logo-wrap {
                min-height: " . get_theme_mod('firefly_banner_height_desktop', 400) . "px;
               /* border:5px red solid !important; */
          
            }
        }

    @media (min-width: 701px) and (max-width: 1024px) {
        .firefly-banner,
         .firefly-banner-only,
           .firefly-text-only,
          .banner-with-phone,
        .firefly-logo-wrap  {
        /*  border:5px green solid !important;*/
            min-height: " . get_theme_mod('firefly_banner_height_tablet', 300) ."px;
        }
    }

    @media (max-width: 700px) {
        .firefly-banner,
        .firefly-banner-only,
          .firefly-text-only,
          .banner-with-phone,
        .firefly-logo-wrap  {

            min-height: ".  get_theme_mod('firefly_banner_height_mobile', 250) ."px;

         }
    }

";

if (get_theme_mod('firefly_show_debug_borders')) {

echo "
        .firefly-banner {
         border:10px red solid;
        }

        .firefly-banner-only {
         border:10px blue solid;
        }


        .firefly-logo-wrap {
         border:5px green solid;
        }

        .firefly-logo-pc {
            border:5px orange solid;
        }
        .firefly-logo-mobile {
            border:5px yellow solid;
        }

        .firefly-banner-text{
            border:5px cyan solid;
        }


        .firefly-banner-with-logo-left {
            border:5px olive solid;
        }

          .firefly-banner-with-logo-left {
            border:5px Khaki solid;
        }

        .banner-with-phone{
            border:5px red solid;
        }

        .banner-extracontent{
            border:5px blue solid;
        }

        .banner-icons {
            border:5px orange solid;
        }
        .banner-phonenumber {
            border:5px pink solid;
        }
        .firefly_logo_other_text{
            border:5px Khaki solid;
        }

        .logo-mobile {
            border:5px brown solid;
        }
";
}

echo "

</style>
        ";



}



add_action('wp_head', 'firefly_embed_uploaded_fonts');
function firefly_embed_uploaded_fonts() {
    $query = new WP_Query([
        'post_type'      => 'attachment',
        'post_status'    => 'inherit',
        'posts_per_page' => -1,
        'meta_query'     => [
            [
                'key'     => '_wp_attached_file',
                'compare' => 'EXISTS',
            ]
        ],
    ]);

    foreach ($query->posts as $attachment) {
        $url = wp_get_attachment_url($attachment->ID);
        $ext = pathinfo($url, PATHINFO_EXTENSION);
        $font_family = basename($url, ".$ext");

        if (in_array(strtolower($ext), ['ttf', 'woff', 'woff2', 'otf'])) {
            $format = match (strtolower($ext)) {
                'ttf'   => 'truetype',
                'otf'   => 'opentype',
                'woff'  => 'woff',
                'woff2' => 'woff2',
                default => 'truetype'
            };

          echo "<style>
@font-face {
    font-family: '{$font_family}'; 
    src: url(\"" . esc_url($url) . "\") format('{$format}');
    font-weight: normal;
    font-style: normal;
}

.bambam {}
</style>";

        }
    }
}
