<?php

// --- GET ONLY USED THEME MODS ---
$logo_pc         = get_theme_mod('my_plugin_logo_pc');
$logo_mobile     = get_theme_mod('my_plugin_logo_mobile');
$firefly_banner_text_color = get_theme_mod('firefly_banner_text_color', '#ffffff');
$firefly_banner_text_size = get_theme_mod('firefly_banner_text_size', '60px');
$firefly_banner_text_size_tablet = get_theme_mod('firefly_banner_text_size_tablet', '48px');
$firefly_banner_text_size_mobile = get_theme_mod('firefly_banner_text_size_mobile', '36px');
$firefly_banner_font_family = get_theme_mod('firefly_banner_font_family', 'Arial, sans-serif');
$firefly_banner_font_weight = get_theme_mod('firefly_banner_font_weight', 'normal');
$firefly_banner_desktop = get_theme_mod('firefly_banner_desktop', '');
$firefly_banner_tablet = get_theme_mod('firefly_banner_tablet', '');
$firefly_banner_mobile = get_theme_mod('firefly_banner_mobile', '');
$overlay_opacity = intval(get_theme_mod('firefly_banner_darken', 0)) / 100;
$line_height = get_theme_mod('firefly_banner_line_height', '1.2');
$firefly_header_margin_top_mobile = get_theme_mod('firefly_header_margin_top_mobile', '35px');
$firefly_mobile_breakpoint = get_theme_mod('firefly_mobile_breakpoint', '768px');
$my_plugin_banner_logo_space = get_theme_mod('my_plugin_banner_logo_space', '35px');
$my_plugin_logo_alignment = get_theme_mod('my_plugin_logo_alignment', 'above text');
$my_plugin_logo_size_breakpoint = get_theme_mod('my_plugin_logo_size_breakpoint', '800px');
$logo_size_desktop = get_theme_mod('my_plugin_logo_size_desktop', '980px');
$logo_size_tablet  = get_theme_mod('my_plugin_logo_size_tablet', '780px');
$logo_size_mobile  = get_theme_mod('my_plugin_logo_size_mobile', '560px');
$my_plugin_logo_text_breakpoint  = get_theme_mod('my_plugin_logo_text_breakpoint', '560px');
$bg_style        = get_theme_mod('firefly_banner_background_style', 'cover');

?>

<div class="firefly-banner">
    <div class="firefly-banner-inner">
        <div class="firefly-banner-flex">
            <div class="firefly-banner-with-logo-left">
                <?php if (!empty($logo_pc)) : ?>
                    <img class="firefly-logo-pc" src="<?php echo esc_url($logo_pc); ?>" alt="Site Logo">
                <?php endif; ?>
                <?php if (!empty($logo_mobile)) : ?>
                    <img class="firefly-logo-mobile" src="<?php echo esc_url($logo_mobile); ?>" alt="Mobile Logo">
                <?php endif; ?>
            </div>
            <div class="firefly-banner-text" style="<?php echo esc_attr("font-family: {$firefly_banner_font_family};"); ?>">
                <?php echo esc_html($banner_text); ?>
            </div>
        </div>
    </div>
</div>

<?php
echo "<style id='firefly-header-css'>



.firefly-banner {
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    text-align: center;
    padding: 40px 20px;
    width: 100%;
    position: relative;
    color: {$firefly_banner_text_color};
    font-size: {$firefly_banner_text_size};
    font-family: {$firefly_banner_font_family};
    font-weight: {$firefly_banner_font_weight};
    line-height: {$line_height};
    background-image: url('{$firefly_banner_desktop}');
    background-position: center center;
    background-repeat: " . (in_array($bg_style, ['repeat', 'repeat-x', 'repeat-y']) ? $bg_style : 'no-repeat') . ";
    background-size: " . (in_array($bg_style, ['cover', 'contain']) ? $bg_style : 'auto') . ";

}

.firefly-banner-inner {
    display: flex;
    justify-content: center;
    align-items: center;
    width: 100%;
}

.firefly-banner-flex {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: {$my_plugin_banner_logo_space};
    flex-direction: row;
}

.firefly-banner-text {
    position: relative;
    z-index: 2;
    max-width: 1200px;
    word-wrap: break-word;
    hyphens: auto;
    line-height: {$line_height};
    margin: 0 auto;
}

.firefly-logo-pc {
    width: {$logo_size_desktop};
    max-width: 100%;
    height: auto;
    z-index: 2 !important;
    position: relative;
}

.firefly-logo-mobile {
    width: {$logo_size_mobile} !important;
    max-width: 100%;
    height: auto;
    display: none;
    z-index: 2 !important;
    position: relative;
}

.firefly-banner-with-logo-left {
    position: relative;
    z-index: 2;
    display: flex;
    align-items: center;
}

@media (max-width: {$my_plugin_logo_text_breakpoint}) {
    .firefly-banner-flex {
        flex-direction: column;
    }
    .firefly-banner-text {
        margin-top: {$my_plugin_banner_logo_space};
    }
}

@media (min-width: 601px) and (max-width: 1024px) {
    .firefly-banner {
        font-size: {$firefly_banner_text_size_tablet};
        background-image: url('{$firefly_banner_tablet}');

    }
    .firefly-logo-pc {
        width: {$logo_size_tablet} !important;
    }
    .firefly-logo-mobile {
        width: {$logo_size_tablet} !important;
    }
}

@media (max-width: 600px) {
    .firefly-banner {
        font-size: {$firefly_banner_text_size_mobile};
        background-image: url('{$firefly_banner_mobile}');

        padding: 20px 10px;
    }
    .firefly-logo-pc {
        width: {$logo_size_mobile} !important;
    }
    .firefly-logo-mobile {
        width: {$logo_size_mobile} !important;
    }
}

@media (max-width: {$my_plugin_logo_size_breakpoint}) {
    .firefly-logo-pc {
        display: none !important;
    }
    .firefly-logo-mobile {
        display: block;
        margin: 0 auto;
    }
}

</style>";
?>
