<?php
// firefly-footer.php

function firefly_customize_footer_section($wp_customize) {
    // === Add a new section ===
    $wp_customize->add_section('firefly_footer_section', array(
        'title'       => __('Firefly Footer', 'firefly-theme'),
        'priority'    => 90,
        'description' => __('Customize the footer background, text color, and contact information.', 'firefly-theme'),
    ));


        // === Show Footer Checkbox ===
    $wp_customize->add_setting('firefly_footer_show', array(
        'default'           => false,
        'sanitize_callback' => 'wp_validate_boolean',
        'transport'         => 'refresh',
    ));
    $wp_customize->add_control('firefly_footer_show_control', array(
        'label'    => __('Show Footer', 'firefly-theme'),
        'section'  => 'firefly_footer_section',
        'settings' => 'firefly_footer_show',
        'type'     => 'checkbox',
    ));


    // === Footer Logo ===
$wp_customize->add_setting('firefly_footer_logo', array(
    'default'           => '',
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'firefly_footer_logo_control', array(
    'label'    => __('Footer Logo', 'firefly-theme'),
    'section'  => 'firefly_footer_section',
    'settings' => 'firefly_footer_logo',
)));



for ($i = 1; $i <= 6; $i++) {

    
    if ($i == 1) {
        $thisone = "Column 1 section 1";
    }
      if ($i == 2) {
        $thisone = "Column 1 section 2";
    }
      if ($i == 3) {
        $thisone = "Column 2 section 1";
    }
      if ($i == 4) {
        $thisone = "Column 2 section 2";
    }
      if ($i == 5) {
        $thisone = "Column 3 section 1";
    }
      if ($i == 6) {
        $thisone = "Column 3 section 2";
    }



    $wp_customize->add_setting("firefly_footer_heading_$i", [
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field',
    ]);
    $wp_customize->add_control("firefly_footer_heading_{$i}_control", [
        'label' => __("Heading $thisone", 'firefly-theme'),
        'section' => 'firefly_footer_section',
        'settings' => "firefly_footer_heading_$i",
        'type' => 'text',
    ]);

    $wp_customize->add_setting("firefly_footer_text_$i", [
        'default' => '',
        'sanitize_callback' => 'wp_kses_post',
    ]);



    $wp_customize->add_control("firefly_footer_text_{$i}_control", [
        'label' => __("Text for $thisone", 'firefly-theme'),
        'section' => 'firefly_footer_section',
        'settings' => "firefly_footer_text_$i",
        'type' => 'textarea',
    ]);
}

    // === Background Colour ===
    $wp_customize->add_setting('firefly_footer_background_color', array(
        'default'           => '#222222',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'firefly_footer_background_color_control', array(
        'label'    => __('Footer Background Colour', 'firefly-theme'),
        'section'  => 'firefly_footer_section',
        'settings' => 'firefly_footer_background_color',
    )));


        // === Text Colour ===
    $wp_customize->add_setting('firefly_footer_heading_color', array(
        'default'           => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'firefly_footer_heading_color_control', array(
        'label'    => __('Footer Heading Colour', 'firefly-theme'),
        'section'  => 'firefly_footer_section',
        'settings' => 'firefly_footer_heading_color',
    )));

        // === Text Colour ===
    $wp_customize->add_setting('firefly_footer_text_color', array(
        'default'           => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'firefly_footer_text_color_control', array(
        'label'    => __('Footer Text Colour', 'firefly-theme'),
        'section'  => 'firefly_footer_section',
        'settings' => 'firefly_footer_text_color',
    )));



            // === Text Colour ===
    $wp_customize->add_setting('firefly_footer_link_color', array(
        'default'           => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color',
    ));
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'firefly_footer_link_color_control', array(
        'label'    => __('Footer link Colour', 'firefly-theme'),
        'section'  => 'firefly_footer_section',
        'settings' => 'firefly_footer_link_color',
    )));

    // === Text Size (px) ===
$wp_customize->add_setting('firefly_footer_heading_size', array(
    'default' => '16px',
    'sanitize_callback' => function ($input) {
        return preg_match('/^\d{2}px$/', $input) ? $input : '16px';
    },
));

$wp_customize->add_control('firefly_footer_text_heading_size_control', array(
    'label'    => __('Heading Size (px)', 'firefly-theme'),
    'section'  => 'firefly_footer_section',
    'settings' => 'firefly_footer_heading_size',
    'type'     => 'select',
    'choices'  => array_combine(
        $sizes = array_map(function($i){ return "{$i}px"; }, range(12, 36)),
        $sizes
    ),
));


    // === Text Size (px) ===
$wp_customize->add_setting('firefly_footer_text_size', array(
    'default' => '16px',
    'sanitize_callback' => function ($input) {
        return preg_match('/^\d{2}px$/', $input) ? $input : '16px';
    },
));

$wp_customize->add_control('firefly_footer_text_size_control', array(
    'label'    => __('Text Size (px)', 'firefly-theme'),
    'section'  => 'firefly_footer_section',
    'settings' => 'firefly_footer_text_size',
    'type'     => 'select',
    'choices'  => array_combine(
        $sizes = array_map(function($i){ return "{$i}px"; }, range(12, 36)),
        $sizes
    ),
));






    // === Footer Map ===
  $wp_customize->add_setting('firefly_footer_map', array(
    'default'           => '',
    'sanitize_callback' => 'firefly_allow_iframe_only',
));

    $wp_customize->add_control('firefly_footer_map_control', array(
        'label'    => __('Map Embed Code or Address', 'firefly-theme'),
        'section'  => 'firefly_footer_section',
        'settings' => 'firefly_footer_map',
        'type'     => 'textarea',
    ));



    // === Footer Padding Left/Right ===
$wp_customize->add_setting('firefly_footer_padding_lr', array(
    'default' => '20px',
    'sanitize_callback' => function($input) {
        return preg_match('/^\d{1,3}px$/', $input) ? $input : '20px';
    },
));
$wp_customize->add_control('firefly_footer_padding_lr_control', array(
    'label' => __('Left/Right Padding', 'firefly-theme'),
    'section' => 'firefly_footer_section',
    'settings' => 'firefly_footer_padding_lr',
    'type' => 'select',
    'choices' => array_combine(
        $px = array_map(fn($i) => "{$i}px", range(0, 100)),
        $px
    ),
));



    // === Footer Padding Left/Right ===
$wp_customize->add_setting('firefly_footer_logo_padding_right', array(
    'default' => '20px',
    'sanitize_callback' => function($input) {
        return preg_match('/^\d{1,3}px$/', $input) ? $input : '20px';
    },
));
$wp_customize->add_control('firefly_footer_logo_padding_right_control', array(
    'label' => __('Space to right of logo', 'firefly-theme'),
    'section' => 'firefly_footer_section',
    'settings' => 'firefly_footer_logo_padding_right',
    'type' => 'select',
    'choices' => array_combine(
        $px = array_map(fn($i) => "{$i}px", range(0, 100)),
        $px
    ),
));



// === Footer Line Height ===
$wp_customize->add_setting('firefly_footer_line_height', array(
    'default' => '150%',
    'sanitize_callback' => function($input) {
        return preg_match('/^\d{3}%$/', $input) ? $input : '150%';
    },
));
$wp_customize->add_control('firefly_footer_line_height_control', array(
    'label' => __('Line Height', 'firefly-theme'),
    'section' => 'firefly_footer_section',
    'settings' => 'firefly_footer_line_height',
    'type' => 'select',
    'choices' => array_combine(
        $lh = array_map(fn($i) => "{$i}%", range(100, 300, 5)),
        $lh
    ),
));

// === Space Below Headings ===
$wp_customize->add_setting('firefly_footer_heading_margin_bottom', array(
    'default' => '15px',
    'sanitize_callback' => function($input) {
        return preg_match('/^\d{1,2}px$/', $input) ? $input : '15px';
    },
));
$wp_customize->add_control('firefly_footer_heading_margin_bottom_control', array(
    'label' => __('Space Below Heading', 'firefly-theme'),
    'section' => 'firefly_footer_section',
    'settings' => 'firefly_footer_heading_margin_bottom',
    'type' => 'select',
    'choices' => array_combine(
        $mb = array_map(fn($i) => "{$i}px", range(0, 50, 2)),
        $mb
    ),
));


// === Display Logo Column Option ===
$wp_customize->add_setting('firefly_footer_logo_column', [
    'default'           => 'none',
    'sanitize_callback' => function ($input) {
        return in_array($input, ['col1', 'col2', 'col3', 'none']) ? $input : 'none';
    },
]);
$wp_customize->add_control('firefly_footer_logo_column_control', [
    'label'    => __('Display logo in:', 'firefly-theme'),
    'section'  => 'firefly_footer_section',
    'settings' => 'firefly_footer_logo_column',
    'type'     => 'radio',
    'choices'  => [
        'col1' => __('Column 1', 'firefly-theme'),
        'col2' => __('Column 2', 'firefly-theme'),
        'col3' => __('Column 3', 'firefly-theme'),
        'none' => __("Don't show", 'firefly-theme'),
    ],
]);

// === Display Map Column Option ===
$wp_customize->add_setting('firefly_footer_map_column', [
    'default'           => 'none',
    'sanitize_callback' => function ($input) {
        return in_array($input, ['col1', 'col2', 'col3', 'none']) ? $input : 'none';
    },
]);
$wp_customize->add_control('firefly_footer_map_column_control', [
    'label'    => __('Display map in:', 'firefly-theme'),
    'section'  => 'firefly_footer_section',
    'settings' => 'firefly_footer_map_column',
    'type'     => 'radio',
    'choices'  => [
        'col1' => __('Column 1', 'firefly-theme'),
        'col2' => __('Column 2', 'firefly-theme'),
        'col3' => __('Column 3', 'firefly-theme'),
        'none' => __("Don't show", 'firefly-theme'),
    ],
]);


}

add_action('customize_register', 'firefly_customize_footer_section');



function firefly_allow_iframe_only($input) {
    return wp_kses($input, array(
        'iframe' => array(
            'src' => true,
            'width' => true,
            'height' => true,
            'frameborder' => true,
            'style' => true,
            'allowfullscreen' => true,
        )
    ));
}



function firefly_render_custom_footer() {

  

if (get_theme_mod('firefly_footer_show')) : 
    
    $footer_text_size = get_theme_mod('firefly_footer_text_size', '12px');
    $footer_heading_size = get_theme_mod('firefly_footer_heading_size', '18px');

    $bg_color = get_theme_mod('firefly_footer_background_color', '#222');
    $footer_text_color = get_theme_mod('firefly_footer_text_color', '#fff');
    $footer_heading_color = get_theme_mod('firefly_footer_heading_color', '#fff');
    $footer_link_color = get_theme_mod('firefly_footer_link_color', '#fff');
    $hours = get_theme_mod('firefly_footer_hours');
    $contact = get_theme_mod('firefly_footer_contact');
    $map = get_theme_mod('firefly_footer_map'); // accepts iframe

    $padding_lr = get_theme_mod('firefly_footer_padding_lr', '20px');
$line_height = get_theme_mod('firefly_footer_line_height', '150%');
$heading_margin = get_theme_mod('firefly_footer_heading_margin_bottom', '15px');

$firefly_footer_logo = get_theme_mod('firefly_footer_logo', '');
$logo_col = get_theme_mod('firefly_footer_logo_column', 'none');
$map = get_theme_mod('firefly_footer_map', '');
$map_col = get_theme_mod('firefly_footer_map_column', 'none');
$firefly_footer_logo_padding_right = get_theme_mod('firefly_footer_logo_padding_right', '');

?>

<style>
.firefly-footer {
    background-color: <?php echo esc_attr($bg_color); ?>;
    color: <?php echo esc_attr($text_color); ?>;
    padding-top: 20px;
    padding-bottom: 20px;
    padding-left: <?php echo $padding_lr; ?>;
    padding-right: <?php echo $padding_lr; ?>;
    font-family: Arial, sans-serif;
}

.firefly-footer .footer-columns {
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
    gap: 20px;
    max-width: 1200px;
    margin: auto;
}

.firefly-footer .footer-column {
    flex: 1 1 30%;
    min-width: 250px;
    max-width: 320px;
}

/* Center column 2 */
.firefly-footer .footer-column:nth-child(2) {
    margin-left: auto;
    margin-right: auto;
    text-align: center;
}

/* Optional: tweak first and third for symmetry if needed */
/*
.firefly-footer .footer-column:first-child {
    text-align: left;
}
.firefly-footer .footer-column:last-child {
    text-align: right;
}
*/

.firefly-footer .footer-column h3 {
    border-bottom: 1px solid rgba(255, 255, 255, 0.3);
    padding-bottom: 10px;
    margin-bottom: 15px;
    font-size: 1.2em;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.firefly-footer .footer-column p {
    margin: 0 0 10px 0;
    line-height: 1.6;
}

.firefly-footer iframe {
    width: 100%;
    height: 200px;
    border: none;
}

.firefly-footer,
.firefly-footer h3,
.firefly-footer p,
.firefly-footer a {
    color: <?php echo esc_attr($text_color); ?> !important;
}

.footer-heading {
    font-size: <?php echo $footer_heading_size; ?>;
    color: <?php echo $footer_heading_color; ?>;
    line-height: <?php echo $line_height; ?>;
    margin-bottom: <?php echo $heading_margin; ?>;
      text-align: left;
}


.footer-text {
    font-size: <?php echo $footer_text_size; ?>;
    color: <?php echo $footer_text_color; ?>;
    line-height: <?php echo $line_height; ?>;
    margin-bottom: 10px;
      text-align: left;
}

.footer-text a {
    color: <?php echo $footer_link_color; ?> !important;
}

.footer-text a:hover {
   text-decoration:underline !important;
}

@media (max-width: 768px) {
    .firefly-footer .footer-columns {
        flex-direction: column;
        align-items: left;
    }

    .firefly-footer .footer-column {
        width: 100%;
        max-width: 600px;
        text-align: left;
    }
}
</style>


<footer class="firefly-footer">
    <div class="footer-columns">

       <?php





$columns = [];
for ($i = 1; $i <= 6; $i++) {
    $columns[] = [
        'heading' => get_theme_mod("firefly_footer_heading_$i", ''),
        'text'    => get_theme_mod("firefly_footer_text_$i", ''),
    ];
}


?>

<div class="footer-columns">
   <?php for ($col = 0; $col < 3; $col++) : ?>
    <div class="footer-column">
        <?php
        $column_id = 'col' . ($col + 1);

        // Display logo if assigned to this column
        if ($firefly_footer_logo && $logo_col === $column_id) {
            echo "<img src=\"$firefly_footer_logo\" style=\"max-width:100%;margin-bottom:15px;padding-right:{$firefly_footer_logo_padding_right};\">";
        }

        // Display map if assigned to this column
        if ($map && $map_col === $column_id) {
          
            echo '<div class="footer-text">' . $map . '</div>';
        }

        // Output two heading/text blocks
        for ($row = 0; $row < 2; $row++) :
            $index = ($col * 2) + $row;
            if (!empty($columns[$index]['heading']) || !empty($columns[$index]['text'])) :
                echo '<div class="footer-heading">' . esc_html($columns[$index]['heading']) . '</div>';
                echo '<div class="footer-text">' . wp_kses_post(nl2br($columns[$index]['text'])) . '</div>';
            endif;
        endfor;
        ?>
    </div>
<?php endfor; ?>

</div>
    </div></footer>



<?php endif; 
}
add_action('wp_footer', 'firefly_render_custom_footer', 1); // Priority 99 to render near end
?>
