<?php

if (!function_exists('firefly_customizer_blocks')) {
    function firefly_customizer_blocks($wp_customize) {

        // Main Panel
        $wp_customize->add_panel('firefly_blocks_panel', array(
            'title'       => __('Firefly Blocks', 'my-plugin'),
            'priority'    => 40,
            'description' => __('Customize blocks for group styles.', 'my-plugin'),
        ));

        // Define block sections
        $wp_customize->add_section('firefly_blocks_section_group1_fullwidth', array(
            'title'    => __('Group 1 - Full Width', 'my-plugin'),
            'panel'    => 'firefly_blocks_panel',
            'priority' => 30,
        ));

        $wp_customize->add_section('firefly_blocks_section_group2_paragraph', array(
            'title'    => __('Group 2 - Paragraph Width', 'my-plugin'),
            'panel'    => 'firefly_blocks_panel',
            'priority' => 35,
        ));

        $wp_customize->add_section('firefly_blocks_section_group_3_columns', array(
            'title'    => __('Group 3: Columns!!', 'my-plugin'),
            'panel'    => 'firefly_blocks_panel',
            'priority' => 60,
        ));


        $wp_customize->add_section('firefly_blocks_section_buttons', array(
            'title'    => __('Buttons', 'my-plugin'),
            'panel'    => 'firefly_blocks_panel',
            'priority' => 70,
        ));

            // Define block sections
        $wp_customize->add_section('firefly_blocks_section_text_and_image', array(
            'title'    => __('Text and image (side by side)', 'my-plugin'),
            'panel'    => 'firefly_blocks_panel',
            'priority' => 80,
        ));


                // Define block sections
        $wp_customize->add_section('firefly_blocks_section_cover', array(
            'title'    => __('Text and image (image with text over the top)', 'my-plugin'),
            'panel'    => 'firefly_blocks_panel',
            'priority' => 80,
        ));



                // === Horizontal rules ===
        $wp_customize->add_section('firefly_blocks_section_horizontal_rules', array(
            'title'    => __('Horizontal rules', 'my-plugin'),
            'panel'    => 'firefly_blocks_panel',
            'priority' => 85,
        ));

        // Style (radio)
        $wp_customize->add_setting('firefly_hr_style', array(
            'default'           => 'break-noline',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        $wp_customize->add_control('firefly_hr_style_control', array(
            'label'    => __('Style', 'my-plugin'),
            'section'  => 'firefly_blocks_section_horizontal_rules',
            'settings' => 'firefly_hr_style',
            'type'     => 'radio',
            'choices'  => array(
                'break-noline' => __('No line, but make a break (to place next section below a picture) – default', 'my-plugin'),
                'line-break'   => __('Black line, make a break', 'my-plugin'),
                'line-nobreak' => __('Black line – no break', 'my-plugin'),
            ),
        ));

        // Horizontal line height (select)
        $hr_heights = array('0px','2px','4px','6px','8px','10px','12px','14px','16px','18px','20px');
        $wp_customize->add_setting('firefly_hr_height', array(
            'default'           => '2px',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        $wp_customize->add_control('firefly_hr_height_control', array(
            'label'    => __('Horizontal line height', 'my-plugin'),
            'section'  => 'firefly_blocks_section_horizontal_rules',
            'settings' => 'firefly_hr_height',
            'type'     => 'select',
            'choices'  => array_combine($hr_heights, $hr_heights),
        ));

 
        // COLOR SETTINGS FOR GROUP 1
        // Background Color
        $wp_customize->add_setting('my_plugin_group1_background_color', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field', // Changed from sanitize_hex_color
        ));
        
        $colour_choices = array(
            'colour1' => array('color' => get_theme_mod('firefly_colour_1', '#dd3333'), 'label' => 'Colour 1'),
            'colour2' => array('color' => get_theme_mod('firefly_colour_2', '#1e73be'), 'label' => 'Colour 2'),
            'colour3' => array('color' => get_theme_mod('firefly_colour_3', '#8224e3'), 'label' => 'Colour 3'),
            'colour4' => array('color' => get_theme_mod('firefly_colour_4', '#ededc4'), 'label' => 'Colour 4'),
            'black'   => array('color' => '#000000', 'label' => 'Black'),
            'white'   => array('color' => '#ffffff', 'label' => 'White'),
        );
        
        $wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
            $wp_customize,
            'my_plugin_group1_background_color_control',
            array(
                'label'    => __('Background Colour', 'my-plugin'),
                'section'  => 'firefly_blocks_section_group1_fullwidth',
                'settings' => 'my_plugin_group1_background_color',
                'choices'  => $colour_choices,
            )
        ));
        
        // Heading Color
        $wp_customize->add_setting('my_plugin_group1_heading_color', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
            $wp_customize,
            'my_plugin_group1_heading_color_control',
            array(
                'label'    => __('Heading Colour', 'my-plugin'),
                'section'  => 'firefly_blocks_section_group1_fullwidth',
                'settings' => 'my_plugin_group1_heading_color',
                'choices'  => $colour_choices,
            )
        ));
        
        // Text Color
        $wp_customize->add_setting('my_plugin_group1_text_color', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
            $wp_customize,
            'my_plugin_group1_text_color_control',
            array(
                'label'    => __('Text Colour', 'my-plugin'),
                'section'  => 'firefly_blocks_section_group1_fullwidth',
                'settings' => 'my_plugin_group1_text_color',
                'choices'  => $colour_choices,
            )
        ));
        
        // Heading Size
        $wp_customize->add_setting('my_plugin_group1_heading_size', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control('my_plugin_group1_heading_size_control', array(
            'label'    => __('Heading Size', 'my-plugin'),
            'section'  => 'firefly_blocks_section_group1_fullwidth',
            'settings' => 'my_plugin_group1_heading_size',
            'type'     => 'select',
            'choices'  => [
                '14px' => '14px',
                '16px' => '16px',
                '18px' => '18px',
                '20px' => '20px',
                '24px' => '24px',
                '28px' => '28px',
                '32px' => '32px',
                '36px' => '36px',
                '42px' => '42px',
                '48px' => '48px',
                '56px' => '56px',
                '68px' => '68px',
            ],
        ));
        
        // Text Size
        $wp_customize->add_setting('my_plugin_group1_text_size', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control('my_plugin_group1_text_size_control', array(
            'label'    => __('Text Size', 'my-plugin'),
            'section'  => 'firefly_blocks_section_group1_fullwidth',
            'settings' => 'my_plugin_group1_text_size',
            'type'     => 'select',
            'choices'  => [
                '14px' => '14px',
                '16px' => '16px',
                '18px' => '18px',
                '20px' => '20px',
                '24px' => '24px',
                '28px' => '28px',
                '32px' => '32px',
            ],
        ));
        
        // Padding
        $wp_customize->add_setting('my_plugin_group1_padding', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control('my_plugin_group1_padding_control', array(
            'label'    => __('Padding', 'my-plugin'),
            'section'  => 'firefly_blocks_section_group1_fullwidth',
            'settings' => 'my_plugin_group1_padding',
            'type'     => 'select',
            'choices'  => [
                '0px' => '0px',
                '2px' => '2px',
                '5px' => '5px',
                '10px' => '10px',
                '15px' => '15px',
                '20px' => '20px',
                '25px' => '25px',
                '30px' => '30px',
            ],
        ));

        // GROUP 2 SETTINGS
        // Similar approach as Group 1 but individually defining each control
        // Background Color
        $wp_customize->add_setting('my_plugin_group2_background_color', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
            $wp_customize,
            'my_plugin_group2_background_color_control',
            array(
                'label'    => __('Background Colour', 'my-plugin'),
                'section'  => 'firefly_blocks_section_group2_paragraph',
                'settings' => 'my_plugin_group2_background_color',
                'choices'  => $colour_choices,
            )
        ));
        
        // Heading Color
        $wp_customize->add_setting('my_plugin_group2_heading_color', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
            $wp_customize,
            'my_plugin_group2_heading_color_control',
            array(
                'label'    => __('Heading Colour', 'my-plugin'),
                'section'  => 'firefly_blocks_section_group2_paragraph',
                'settings' => 'my_plugin_group2_heading_color',
                'choices'  => $colour_choices,
            )
        ));
        
        // Text Color
        $wp_customize->add_setting('my_plugin_group2_text_color', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
            $wp_customize,
            'my_plugin_group2_text_color_control',
            array(
                'label'    => __('Text Colour', 'my-plugin'),
                'section'  => 'firefly_blocks_section_group2_paragraph',
                'settings' => 'my_plugin_group2_text_color',
                'choices'  => $colour_choices,
            )
        ));
        
        // Heading Size
        $wp_customize->add_setting('my_plugin_group2_heading_size', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control('my_plugin_group2_heading_size_control', array(
            'label'    => __('Heading Size', 'my-plugin'),
            'section'  => 'firefly_blocks_section_group2_paragraph',
            'settings' => 'my_plugin_group2_heading_size',
            'type'     => 'select',
            'choices'  => [
                '14px' => '14px',
                '16px' => '16px',
                '18px' => '18px',
                '20px' => '20px',
                '24px' => '24px',
                '28px' => '28px',
                '32px' => '32px',
                '36px' => '36px',
                '42px' => '42px',
                '48px' => '48px',
                '56px' => '56px',
                '68px' => '68px',
            ],
        ));
        
        // Text Size
        $wp_customize->add_setting('my_plugin_group2_text_size', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control('my_plugin_group2_text_size_control', array(
            'label'    => __('Text Size', 'my-plugin'),
            'section'  => 'firefly_blocks_section_group2_paragraph',
            'settings' => 'my_plugin_group2_text_size',
            'type'     => 'select',
            'choices'  => [
                '14px' => '14px',
                '16px' => '16px',
                '18px' => '18px',
                '20px' => '20px',
                '24px' => '24px',
                '28px' => '28px',
                '32px' => '32px',
            ],
        ));
        
        // Padding
        $wp_customize->add_setting('my_plugin_group2_padding', array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
        $wp_customize->add_control('my_plugin_group2_padding_control', array(
            'label'    => __('Padding', 'my-plugin'),
            'section'  => 'firefly_blocks_section_group2_paragraph',
            'settings' => 'my_plugin_group2_padding',
            'type'     => 'select',
            'choices'  => [
                '0px' => '0px',
                '2px' => '2px',
                '5px' => '5px',
                '10px' => '10px',
                '15px' => '15px',
                '20px' => '20px',
                '25px' => '25px',
                '30px' => '30px',
            ],
        ));

        // GROUP 3 SETTINGS - Same individual approach
        // Only including a few examples for brevity - expand for all needed controls
                // === Group 3: Columns ===
                $group3_settings = [
                    'background_color' => 'Background Colour',
                    'heading_color'    => 'Heading Colour',
                    'text_color'       => 'Text Colour',
                    'border_color'     => 'Border Colour',
                    'column_width'     => 'Column Width',
                    'border_width'     => 'Border Width',
                    'margin_top'       => 'Margin Top',
                    'margin_bottom'    => 'Margin Bottom',
                    'padding'          => 'Padding',
                    'heading_size'     => 'Heading Size',
                    'text_size'        => 'Text Size',
                    'space_between'    => 'Space Between Columns',
                ];
        
                foreach ($group3_settings as $key => $label) {
                    $setting_id = "my_plugin_group3_{$key}";
                    $control_id = "{$setting_id}_control";
        
                    $wp_customize->add_setting($setting_id, array(
                        'default'           => '',
                        'transport'         => 'refresh',
                        'sanitize_callback' => in_array($key, ['background_color', 'heading_color', 'text_color', 'border_color']) ? 'sanitize_text_field' : 'sanitize_text_field',
                    ));
        
                    if (in_array($key, ['background_color', 'heading_color', 'text_color', 'border_color'])) {
                        $colour_choices = array(
                            'colour1' => array('color' => get_theme_mod('firefly_colour_1', '#dd3333'), 'label' => 'Colour 1'),
                            'colour2' => array('color' => get_theme_mod('firefly_colour_2', '#1e73be'), 'label' => 'Colour 2'),
                            'colour3' => array('color' => get_theme_mod('firefly_colour_3', '#8224e3'), 'label' => 'Colour 3'),
                            'colour4' => array('color' => get_theme_mod('firefly_colour_4', '#ededc4'), 'label' => 'Colour 4'),
                            'black'   => array('color' => '#000000', 'label' => 'Black'),
                            'white'   => array('color' => '#ffffff', 'label' => 'White'),
                        );
        
                        $wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
                            $wp_customize,
                            $control_id,
                            array(
                                'label'    => __($label, 'my-plugin'),
                                'section'  => 'firefly_blocks_section_group_3_columns',
                                'settings' => $setting_id,
                                'choices'  => $colour_choices,
                            )
                        ));
                    } elseif (in_array($key, ['heading_size', 'text_size'])) {
                        $wp_customize->add_control($control_id, array(
                            'label'    => __($label, 'my-plugin'),
                            'section'  => 'firefly_blocks_section_group_3_columns',
                            'settings' => $setting_id,
                            'type'     => 'select',
                            'choices'  => [
                                '14px' => '14px',
                                '16px' => '16px',
                                '18px' => '18px',
                                '20px' => '20px',
                                '24px' => '24px',
                                '28px' => '28px',
                                '32px' => '32px',
                                '36px' => '36px',
                                '42px' => '42px',
                                '48px' => '48px',
                                '56px' => '56px',
                                '68px' => '68px',
                            ],
                        ));
                    } elseif (in_array($key, ['margin_top', 'margin_bottom', 'padding', 'space_between'])) {
                        $wp_customize->add_control($control_id, array(
                            'label'    => __($label, 'my-plugin'),
                            'section'  => 'firefly_blocks_section_group_3_columns',
                            'settings' => $setting_id,
                            'type'     => 'select',
                            'choices'  => [
                                '0px'   => '0px',
                                '5px'   => '5px',
                                '10px'  => '10px',
                                '15px'  => '15px',
                                '20px'  => '20px',
                                '25px'  => '25px',
                                '30px'  => '30px',
                                '40px'  => '40px',
                                '50px'  => '50px',
                            ],
                        ));
                    } elseif ($key === 'border_width') {
                        $wp_customize->add_control($control_id, array(
                            'label'    => __($label, 'my-plugin'),
                            'section'  => 'firefly_blocks_section_group_3_columns',
                            'settings' => $setting_id,
                            'type'     => 'select',
                            'choices'  => [
                                '1px' => '1px',
                                '2px' => '2px',
                                '3px' => '3px',
                                '4px' => '4px',
                                '5px' => '5px',
                                '6px' => '6px',
                            ],
                        ));
                    } elseif ($key === 'column_width') {
                        $choices = [];
                        for ($i = 200; $i <= 500; $i += 10) {
                            $choices["{$i}px"] = "{$i}px";
                        }
        
                        $wp_customize->add_control($control_id, array(
                            'label'    => __($label, 'my-plugin'),
                            'section'  => 'firefly_blocks_section_group_3_columns',
                            'settings' => $setting_id,
                            'type'     => 'select',
                            'choices'  => $choices,
                        ));
                    }

                    // === Background Behind Columns ===
$wp_customize->add_setting('my_plugin_group3_outer_background_color', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));

$colour_choices = array(
    'colour1' => array('color' => get_theme_mod('firefly_colour_1', '#dd3333'), 'label' => 'Colour 1'),
    'colour2' => array('color' => get_theme_mod('firefly_colour_2', '#1e73be'), 'label' => 'Colour 2'),
    'colour3' => array('color' => get_theme_mod('firefly_colour_3', '#8224e3'), 'label' => 'Colour 3'),
    'colour4' => array('color' => get_theme_mod('firefly_colour_4', '#ededc4'), 'label' => 'Colour 4'),
    'black'   => array('color' => '#000000', 'label' => 'Black'),
    'white'   => array('color' => '#ffffff', 'label' => 'White'),
);

$wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
    $wp_customize,
    'my_plugin_group3_outer_background_color_control',
    array(
        'label'    => __('Background colour behind columns', 'my-plugin'),
        'section'  => 'firefly_blocks_section_group_3_columns',
        'settings' => 'my_plugin_group3_outer_background_color',
        'choices'  => $colour_choices,
    )
));


// === Space Above Heading ===
$wp_customize->add_setting('my_plugin_group3_heading_margin_top', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_group3_heading_margin_top_control', array(
    'label'    => __('Space above heading', 'my-plugin'),
    'section'  => 'firefly_blocks_section_group_3_columns',
    'settings' => 'my_plugin_group3_heading_margin_top',
    'type'     => 'select',
    'choices'  => [
        '0px'  => '0px',
        '5px'  => '5px',
        '10px' => '10px',
        '15px' => '15px',
        '20px' => '20px',
        '25px' => '25px',
        '30px' => '30px',
        '40px' => '40px',
        '50px' => '50px',
    ],
));

// === Space Below Heading ===
$wp_customize->add_setting('my_plugin_group3_heading_margin_bottom', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_group3_heading_margin_bottom_control', array(
    'label'    => __('Space below heading', 'my-plugin'),
    'section'  => 'firefly_blocks_section_group_3_columns',
    'settings' => 'my_plugin_group3_heading_margin_bottom',
    'type'     => 'select',
    'choices'  => [
        '0px'  => '0px',
        '5px'  => '5px',
        '10px' => '10px',
        '15px' => '15px',
        '20px' => '20px',
        '25px' => '25px',
        '30px' => '30px',
        '40px' => '40px',
        '50px' => '50px',
    ],
));
// === Button: Button Colour ===
$wp_customize->add_setting('my_plugin_button_colour', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
    $wp_customize,
    'my_plugin_button_colour_control',
    array(
        'label'    => __('Button Colour', 'my-plugin'),
        'section'  => 'firefly_blocks_section_buttons',
        'settings' => 'my_plugin_button_colour',
        'choices'  => $colour_choices,
    )
));

// === Button: Text Colour ===
$wp_customize->add_setting('my_plugin_button_text_colour', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
    $wp_customize,
    'my_plugin_button_text_colour_control',
    array(
        'label'    => __('Text Colour', 'my-plugin'),
        'section'  => 'firefly_blocks_section_buttons',
        'settings' => 'my_plugin_button_text_colour',
        'choices'  => $colour_choices,
    )
));


$wp_customize->add_setting('firefly_button_border_radius', [
    'default'           => '30px',
    'sanitize_callback' => 'sanitize_text_field',
]);

$wp_customize->add_control('firefly_button_border_radius_control', [
    'label'    => __('Button corner rounding', 'firefly-theme'),
    'section'  => 'firefly_blocks_section_buttons',
    'settings' => 'firefly_button_border_radius',
    'type'     => 'select',
    'choices'  => array_combine(
        array_map(fn($i) => "{$i}px", range(0, 50)),
        array_map(fn($i) => "{$i}px", range(0, 50))
    ),
]);



// === Button: Text Size ===
$wp_customize->add_setting('my_plugin_button_text_size', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_button_text_size_control', array(
    'label'    => __('Text Size', 'my-plugin'),
    'section'  => 'firefly_blocks_section_buttons',
    'settings' => 'my_plugin_button_text_size',
    'type'     => 'select',
    'choices'  => [
        '14px' => '14px',
        '16px' => '16px',
        '18px' => '18px',
        '20px' => '20px',
        '24px' => '24px',
        '28px' => '28px',
        '32px' => '32px',
        '36px' => '36px',
    ],
));

$wp_customize->add_setting('my_plugin_button_alignment', array(
    'default'           => 'center',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_button_alignment_control', array(
    'label'    => __('Button Alignment', 'my-plugin'),
    'section'  => 'firefly_blocks_section_buttons',
    'settings' => 'my_plugin_button_alignment',
    'type'     => 'select',
    'choices'  => [
        'left'   => 'Left',
        'center' => 'Center',
        'right'  => 'Right',
    ],
));


// Padding Above
$wp_customize->add_setting('my_plugin_button_padding_top', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_button_padding_top_control', array(
    'label'    => __('Padding Above Button', 'my-plugin'),
    'section'  => 'firefly_blocks_section_buttons',
    'settings' => 'my_plugin_button_padding_top',
    'type'     => 'select',
    'choices'  => [
           '0px'  => '0px',
        '5px'  => '5px',
        '10px' => '10px',
        '15px' => '15px',
        '20px' => '20px',
        '25px' => '25px',
        '30px' => '30px',
        '35px' => '35px',
        '40px' => '40px',
        '45px' => '45px',
        '50px' => '50px',
    ],
));

// Padding Below
$wp_customize->add_setting('my_plugin_button_padding_bottom', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_button_padding_bottom_control', array(
    'label'    => __('Padding Below Button', 'my-plugin'),
    'section'  => 'firefly_blocks_section_buttons',
    'settings' => 'my_plugin_button_padding_bottom',
    'type'     => 'select',
    'choices'  => [
           '0px'  => '0px',
        '5px'  => '5px',
        '10px' => '10px',
        '15px' => '15px',
        '20px' => '20px',
        '25px' => '25px',
        '30px' => '30px',
        '35px' => '35px',
        '40px' => '40px',
        '45px' => '45px',
        '50px' => '50px',
    ],
));



// === Text and Image: Padding Top ===
$wp_customize->add_setting('my_plugin_text_image_padding_top', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_text_image_padding_top_control', array(
    'label'    => __('Padding Top', 'my-plugin'),
    'section'  => 'firefly_blocks_section_text_and_image',
    'settings' => 'my_plugin_text_image_padding_top',
    'type'     => 'select',
    'choices'  => [
           '0px'  => '0px',
        '5px'  => '5px',
        '10px' => '10px',
        '15px' => '15px',
        '20px' => '20px',
        '25px' => '25px',
        '30px' => '30px',
        '35px' => '35px',
        '40px' => '40px',
        '45px' => '45px',
        '50px' => '50px',
    ],
));

// === Text and Image: Padding Bottom ===
$wp_customize->add_setting('my_plugin_text_image_padding_bottom', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_text_image_padding_bottom_control', array(
    'label'    => __('Padding Bottom', 'my-plugin'),
    'section'  => 'firefly_blocks_section_text_and_image',
    'settings' => 'my_plugin_text_image_padding_bottom',
    'type'     => 'select',
    'choices'  => [
        '0px'  => '0px',
        '5px'  => '5px',
        '10px' => '10px',
        '15px' => '15px',
        '20px' => '20px',
        '25px' => '25px',
        '30px' => '30px',
        '35px' => '35px',
        '40px' => '40px',
        '45px' => '45px',
        '50px' => '50px',
    ],
));


// === Text and Image: Margin Bottom ===
$wp_customize->add_setting('my_plugin_text_image_margin_top', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_text_image_margin_top_control', array(
    'label'    => __('Margin top', 'my-plugin'),
    'section'  => 'firefly_blocks_section_text_and_image',
    'settings' => 'my_plugin_text_image_margin_top',
    'type'     => 'select',
    'choices'  => [
        '0px'  => '0px',
        '5px'  => '5px',
        '10px' => '10px',
        '15px' => '15px',
        '20px' => '20px',
        '25px' => '25px',
        '30px' => '30px',
        '35px' => '35px',
        '40px' => '40px',
        '45px' => '45px',
        '50px' => '50px',
    ],
));



// === Text and Image: Margin Bottom ===
$wp_customize->add_setting('my_plugin_text_image_margin_bottom', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_text_image_margin_bottom_control', array(
    'label'    => __('Margin bottom', 'my-plugin'),
    'section'  => 'firefly_blocks_section_text_and_image',
    'settings' => 'my_plugin_text_image_margin_bottom',
    'type'     => 'select',
    'choices'  => [
        '0px'  => '0px',
        '5px'  => '5px',
        '10px' => '10px',
        '15px' => '15px',
        '20px' => '20px',
        '25px' => '25px',
        '30px' => '30px',
        '35px' => '35px',
        '40px' => '40px',
        '45px' => '45px',
        '50px' => '50px',
    ],
));




// === cover Margin Bottom ===
$wp_customize->add_setting('my_plugin_cover_margin_top', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_margin_top_control', array(
    'label'    => __('Margin top', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_margin_top',
    'type'     => 'select',
    'choices'  => [
        '0px'  => '0px',
        '5px'  => '5px',
        '10px' => '10px',
        '15px' => '15px',
        '20px' => '20px',
        '25px' => '25px',
        '30px' => '30px',
        '35px' => '35px',
        '40px' => '40px',
        '45px' => '45px',
        '50px' => '50px',
    ],
));



// === Text and Image: Margin Bottom ===
$wp_customize->add_setting('my_plugin_cover_margin_bottom', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_margin_bottom_control', array(
    'label'    => __('Margin bottom', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_margin_bottom',
    'type'     => 'select',
    'choices'  => [
        '0px'  => '0px',
        '5px'  => '5px',
        '10px' => '10px',
        '15px' => '15px',
        '20px' => '20px',
        '25px' => '25px',
        '30px' => '30px',
        '35px' => '35px',
        '40px' => '40px',
        '45px' => '45px',
        '50px' => '50px',
    ],
));



$ff_px_choices_0_50 = [];
for ($i = 0; $i <= 50; $i += 5) {
    $ff_px_choices_0_50["{$i}px"] = "{$i}px";
}

/* =========================
 * Padding controls
 * ========================= */

// Padding top
$wp_customize->add_setting('my_plugin_cover_padding_top', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_padding_top_control', array(
    'label'    => __('Padding top', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_padding_top',
    'type'     => 'select',
    'choices'  => $ff_px_choices_0_50,
));

// Padding bottom
$wp_customize->add_setting('my_plugin_cover_padding_bottom', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_padding_bottom_control', array(
    'label'    => __('Padding bottom', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_padding_bottom',
    'type'     => 'select',
    'choices'  => $ff_px_choices_0_50,
));

// Padding left & right (applies to both L/R)
$wp_customize->add_setting('my_plugin_cover_padding_lr', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_padding_lr_control', array(
    'label'    => __('Padding left/right', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_padding_lr',
    'type'     => 'select',
    'choices'  => $ff_px_choices_0_50,
));



// Choices: 20px–200px in 10px steps
$ff_px_choices_20_200 = [];
for ($i = 20; $i <= 200; $i += 10) {
    $ff_px_choices_20_200["{$i}px"] = "{$i}px";
}

// Extra large heading size (PC)
$wp_customize->add_setting('my_plugin_cover_heading_xl_pc', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_heading_xl_pc_control', array(
    'label'    => __('Extra large heading size (PC)', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_heading_xl_pc',
    'type'     => 'select',
    'choices'  => $ff_px_choices_20_200,
));

// Extra large heading size (tablet)
$wp_customize->add_setting('my_plugin_cover_heading_xl_tablet', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_heading_xl_tablet_control', array(
    'label'    => __('Extra large heading size (tablet)', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_heading_xl_tablet',
    'type'     => 'select',
    'choices'  => $ff_px_choices_20_200,
));


// Extra large heading size (mobile)
$wp_customize->add_setting('my_plugin_cover_heading_xl_mobile', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_heading_xl_mobile_control', array(
    'label'    => __('Extra large heading size (mobile)', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_heading_xl_mobile',
    'type'     => 'select',
    'choices'  => $ff_px_choices_20_200,
));



            // Extra large heading size (PC)
$wp_customize->add_setting('my_plugin_cover_heading_l_pc', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_heading_l_pc_control', array(
    'label'    => __('Large heading size (PC)', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_heading_l_pc',
    'type'     => 'select',
    'choices'  => $ff_px_choices_20_200,
));

// Extra large heading size (tablet)
$wp_customize->add_setting('my_plugin_cover_heading_l_tablet', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_heading_l_tablet_control', array(
    'label'    => __('Large heading size (tablet)', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_heading_l_tablet',
    'type'     => 'select',
    'choices'  => $ff_px_choices_20_200,
));


// Extra large heading size (mobile)
$wp_customize->add_setting('my_plugin_cover_heading_l_mobile', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_heading_l_mobile_control', array(
    'label'    => __('Large heading size (mobile)', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_heading_l_mobile',
    'type'     => 'select',
    'choices'  => $ff_px_choices_20_200,
));





// Extra large heading size (PC)
$wp_customize->add_setting('my_plugin_cover_heading_m_pc', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_heading_m_pc_control', array(
    'label'    => __('Medium heading size (PC)', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_heading_m_pc',
    'type'     => 'select',
    'choices'  => $ff_px_choices_20_200,
));

// Extra large heading size (tablet)
$wp_customize->add_setting('my_plugin_cover_heading_m_tablet', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_heading_m_tablet_control', array(
    'label'    => __('Medium heading size (tablet)', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_heading_m_tablet',
    'type'     => 'select',
    'choices'  => $ff_px_choices_20_200,
));


// Extra large heading size (mobile)
$wp_customize->add_setting('my_plugin_cover_heading_m_mobile', array(
    'default'           => '',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('my_plugin_cover_heading_m_mobile_control', array(
    'label'    => __('Medium heading size (mobile)', 'my-plugin'),
    'section'  => 'firefly_blocks_section_cover',
    'settings' => 'my_plugin_cover_heading_m_mobile',
    'type'     => 'select',
    'choices'  => $ff_px_choices_20_200,
));



// === Block group (wp-block-group) ===
$wp_customize->add_section('firefly_blocks_section_block_group', array(
    'title'    => __('Block group (wp-block-group)', 'my-plugin'),
    'panel'    => 'firefly_blocks_panel',
    'priority' => 25,
));

// choices 0px..50px in 2px steps
$ff_px_0_50_step2 = [];
for ($i = 0; $i <= 50; $i += 2) {
    $ff_px_0_50_step2["{$i}px"] = "{$i}px";
}

// Space above (margin-top)
$wp_customize->add_setting('firefly_block_group_margin_top', array(
    'default'           => '0px',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('firefly_block_group_margin_top_control', array(
    'label'    => __('Space above (margin-top)', 'my-plugin'),
    'section'  => 'firefly_blocks_section_block_group',
    'settings' => 'firefly_block_group_margin_top',
    'type'     => 'select',
    'choices'  => $ff_px_0_50_step2,
));

// Space below (margin-bottom)
$wp_customize->add_setting('firefly_block_group_margin_bottom', array(
    'default'           => '0px',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('firefly_block_group_margin_bottom_control', array(
    'label'    => __('Space below (margin-bottom)', 'my-plugin'),
    'section'  => 'firefly_blocks_section_block_group',
    'settings' => 'firefly_block_group_margin_bottom',
    'type'     => 'select',
    'choices'  => $ff_px_0_50_step2,
));




// Space above (margin-top)
$wp_customize->add_setting('firefly_block_group_padding_top', array(
    'default'           => '0px',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('firefly_block_group_padding_top_control', array(
    'label'    => __('Padding top', 'my-plugin'),
    'section'  => 'firefly_blocks_section_block_group',
    'settings' => 'firefly_block_group_padding_top',
    'type'     => 'select',
    'choices'  => $ff_px_0_50_step2,
));

// Space below (margin-bottom)
$wp_customize->add_setting('firefly_block_group_padding_bottom', array(
    'default'           => '0px',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('firefly_block_group_padding_bottom_control', array(
    'label'    => __('Padding bottom', 'my-plugin'),
    'section'  => 'firefly_blocks_section_block_group',
    'settings' => 'firefly_block_group_padding_bottom',
    'type'     => 'select',
    'choices'  => $ff_px_0_50_step2,
));





// Width: 100% vs Paragraph width
$wp_customize->add_setting('firefly_block_group_width_mode', array(
    'default'           => 'full', // 'full' or 'content'
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('firefly_block_group_width_mode_control', array(
    'label'    => __('Width', 'my-plugin'),
    'section'  => 'firefly_blocks_section_block_group',
    'settings' => 'firefly_block_group_width_mode',
    'type'     => 'select',
    'choices'  => array(
        'full'    => __('100% (full width)', 'my-plugin'),
        'content' => __('Paragraph width (content size)', 'my-plugin'),
    ),
));

// Checkbox: Show borders for debugging
if ( ! function_exists('firefly_sanitize_checkbox') ) {
    function firefly_sanitize_checkbox( $checked ) {
        return ( isset( $checked ) && ( true === $checked || '1' === $checked || 1 === $checked ) ) ? 1 : 0;
    }
}

$wp_customize->add_setting('firefly_block_group_debug_borders', array(
    'default'           => 0,
    'transport'         => 'refresh',
    'sanitize_callback' => 'firefly_sanitize_checkbox',
));

$wp_customize->add_control('firefly_block_group_debug_borders_control', array(
    'label'    => __('Show borders for debugging', 'my-plugin'),
    'section'  => 'firefly_blocks_section_block_group',
    'settings' => 'firefly_block_group_debug_borders',
    'type'     => 'checkbox',
));




 }
        
        
        // Additional Group 3 settings would continue here...
    }
}
add_action('customize_register', 'firefly_customizer_blocks');

function firefly_output_group_styles() {
    function get_firefly_color($key) {
        return match ($key) {
            'colour1' => get_theme_mod('firefly_colour_1', '#dd3333'),
            'colour2' => get_theme_mod('firefly_colour_2', '#1e73be'),
            'colour3' => get_theme_mod('firefly_colour_3', '#8224e3'),
            'colour4' => get_theme_mod('firefly_colour_4', '#ededc4'),
            'black'   => '#000000',
            'white'   => '#ffffff',
            default   => $key,
        };
    }



    $colour1 = get_theme_mod('firefly_colour_1');
    $colour2 = get_theme_mod('firefly_colour_2');
    $colour3 = get_theme_mod('firefly_colour_3');
    $colour4 = get_theme_mod('firefly_colour_4');


        $hr_style  = get_theme_mod('firefly_hr_style', 'break-noline');
    $hr_height = get_theme_mod('firefly_hr_height', '2px');

$gg_margin_top    = get_theme_mod('firefly_block_group_margin_top', '0px');
$gg_margin_bottom = get_theme_mod('firefly_block_group_margin_bottom', '0px');
$gg_width_mode    = get_theme_mod('firefly_block_group_width_mode', 'full');


        $margin_top = get_theme_mod("my_plugin_body_margin_top", '0px');
        $margin_bottom = get_theme_mod("my_plugin_body_margin_bottom", '0px');

          $block_group_width_mode = get_theme_mod('firefly_block_group_width_mode', 'content');

          $block_group_padding_top = get_theme_mod("firefly_block_group_padding_top", '20px');
          $block_group_padding_bottom = get_theme_mod("firefly_block_group_padding_bottom", '20px');

    echo "<style id='firefly-group-styles-css'>\n";


            echo " .wwp-block-group {
                margin-top: {$gg_margin_top} ;
                margin-bottom: {$gg_margin_bottom} ;

                padding-top: {$block_group_padding_top} ;
                padding-bottom: {$block_group_padding_bottom} ;
            }
            
                .is-style-full-width-image {
           
                  
                    padding-left:0px ;
                    padding-right:0px ;
                    width:100% ;
                    max-width:100%;
                }           

              .wp-block-group, 
              .wp-block-cover,
              .wp-block-cover__background,
              .wp-block-cover__image-background,
              .p-block-cover__inner-container {     
                   max-width:100% ; /**/
                }


            ";



            
            if($block_group_width_mode == "full") {

                    echo " 
                    
                    .wp-block-group, .wp-block-cover__background {
                            width:100% ;
                        }
                            ";
            }else{
                 echo " 
                 .wp-block-group {
                        }
                            ";
            }




            echo "
            
            
           /* 1) Direct children of a flex stack group (no inner container needed) */
            .wp-block-group.is-layout-flex > p,
            .wp-block-group.is-vertical.is-layout-flex > p,
            .wp-block-group.wp-block-group-is-layout-flex > p,

            /* 2) Groups that wrap children in an inner container */
            .wp-block-group > .wp-block-group__inner-container > p,

            /* …and inner-container layout variants you’ll see */
            .wp-block-group__inner-container.is-layout-constrained > p,
            .wp-block-group__inner-container.is-layout-flow > p,
            .wp-block-group__inner-container.is-layout-flex > p,

            /* 3) Some themes add the layout class on the outer group (duplicate pattern) */
            .wp-block-group.wp-block-group-is-layout-constrained > .wp-block-group__inner-container > p,
            .wp-block-group.wp-block-group-is-layout-flow > .wp-block-group__inner-container > p {
                    padding-top: {$margin_top} ;
                    padding-bottom: {$margin_bottom} ;
            }

            .wp-block-list {
               margin-top: {$margin_top} ;
               margin-bottom: {$margin_bottom} ;
            }
            

            .wp-block-group.is-vertical.is-layout-flex{
                /* disable the WP block gap so margins actually show */
                --wp--style--block-gap: 0 ;
                gap: 0 ;
                row-gap: 0 ;
            }

        /* give every direct child (p, h2, etc.) your margins */
            .wp-block-group.is-vertical.is-layout-flex > *{
            margin-top: {$margin_top} ;
            margin-bottom: {$margin_bottom} ;
        }   
                                ";




 $gg_debug_borders = (int) get_theme_mod('firefly_block_group_debug_borders', 0);



    if ( $gg_debug_borders ) {
        echo "
        
        .wp-block-group p,
            .wp-block-group-is-layout-flex p  {
                border:2px red solid  ;
            }

            .wp-block-list {
                border:2px green solid;
            }


             .wp-block-group  {
                border:2px blue solid;
            }


                ";
    }



    if ($hr_style === 'break-noline') {
    // No visible line, just vertical space (a 'break')
    echo "
.wp-block-separator.is-style-firefly-hr, hr {
    display: block ;
    clear: both ;
    margin-top: {$hr_height} ;
    margin-bottom: {$hr_height}  ;
     border-top: 0px solid #000 ;
     max-width:80%;
}
";
} elseif ($hr_style === 'line-break') {
    // Black line + break
    echo "
.wp-block-separator.is-style-firefly-hr, hr {
    display: block ;
    clear: both ;
    border-top: 1px solid #000 ;
    margin-top: {$hr_height}  ;
    margin-bottom: {$hr_height}  ;
     max-width:80%;
}
";
} else { // 'line-nobreak'
    echo "
.wp-block-separator.is-style-firefly-hr, hr {
    display: block ;
    /* no clear for no-break */
    border-top: 1px solid #000 ;
    margin-top: {$hr_height}  ;
    margin-bottom: {$hr_height}  ;
     max-width:80%;
}
";
}

    

    //=============================================================
    // === Group 1 ===
    //=============================================================
    $bg_key1 = get_theme_mod("my_plugin_group1_background_color", '');
    $bg1 = $bg_key1 ? get_firefly_color($bg_key1) : '';
    $head_key1 = get_theme_mod("my_plugin_group1_heading_color", '');
    $head1 = $head_key1 ? get_firefly_color($head_key1) : '';
    $text_key1 = get_theme_mod("my_plugin_group1_text_color", '');
    $text1 = $text_key1 ? get_firefly_color($text_key1) : '';
    $hsize1 = get_theme_mod("my_plugin_group1_heading_size", '');
    $tsize1 = get_theme_mod("my_plugin_group1_text_size", '');
    $pad1 = get_theme_mod("my_plugin_group1_padding", '');




    

    echo "
    /* Group 1 - Full Width */
    .wp-block-group.is-style-highlight-section .wp-block-heading,
    .wp-block-group.is-style-highlight-section h1,
    .wp-block-group.is-style-highlight-section h2,
    .wp-block-group.is-style-highlight-section h3,
    .wp-block-group.is-style-highlight-section h4,
    .wp-block-group.is-style-highlight-section h5,
    .wp-block-group.is-style-highlight-section h6
     {
        " . ($head1 ? "color: {$head1} ;" : '') .
           ($hsize1 ? "font-size: {$hsize1} ;" : '') . "
    }

    .wp-block-group.is-style-highlight-section p {
        " . ($text1 ? "color: {$text1};" : '') .
           ($tsize1 ? "font-size: {$tsize1};" : '') . "
    }

    .wp-block-group.is-style-highlight-section .wp-block-group__inner-container {  /* WORKS */
        " . ($bg1 ? "background-color: {$bg1} ;" : '') .
           ($pad1 ? "padding: {$pad1};" : '') . "
    }\n
    
    .wp-block-group.is-style-highlight-section { /* WORKS */
        background-color:white ;
        padding:0px ;
    }
    ";

    //=============================================================
    // // === Group 2 ===
    //=============================================================
    $bg_key2 = get_theme_mod("my_plugin_group2_background_color", '');
    $bg2 = $bg_key2 ? get_firefly_color($bg_key2) : '';
    $head_key2 = get_theme_mod("my_plugin_group2_heading_color", '');
    $head2 = $head_key2 ? get_firefly_color($head_key2) : '';
    $text_key2 = get_theme_mod("my_plugin_group2_text_color", '');
    $text2 = $text_key2 ? get_firefly_color($text_key2) : '';
    $hsize2 = get_theme_mod("my_plugin_group2_heading_size", '');
    $tsize2 = get_theme_mod("my_plugin_group2_text_size", '');
    $pad2 = get_theme_mod("my_plugin_group2_padding", '');

    echo "
    /* Group 2 - Paragraph Width */
    .wp-block-group.is-style-Paragraph-width-coloured-background .wp-block-heading,
    .wp-block-group.is-style-Paragraph-width-coloured-background h1,
    .wp-block-group.is-style-Paragraph-width-coloured-background h2,
    .wp-block-group.is-style-Paragraph-width-coloured-background h3,
    .wp-block-group.is-style-Paragraph-width-coloured-background h4,
    .wp-block-group.is-style-Paragraph-width-coloured-background h5,
    .wp-block-group.is-style-Paragraph-width-coloured-background h6 {
        " . ($head2 ? "color: {$head2} ;" : '') .
           ($hsize2 ? "font-size: {$hsize2};" : '') . "
    }

    .wp-block-group.is-style-Paragraph-width-coloured-background p {
        " . ($text2 ? "color: {$text2};" : '') .
           ($tsize2 ? "font-size: {$tsize2} ;" : '') . "
    }

    .wp-block-group.is-style-Paragraph-width-coloured-background .wp-block-group__inner-container {
        " . ($bg2 ? "background-color: {$bg2} ;" : '') .
           ($pad2 ? "padding: {$pad2};" : '') . "
    }\n";

    //==============================
    // === Group 3 ===
    //==============================

    // === Group 3 ===
    $bg_key3      = get_theme_mod("my_plugin_group3_background_color", '');
    $bg3          = $bg_key3 ? get_firefly_color($bg_key3) : '';
    $head_key3    = get_theme_mod("my_plugin_group3_heading_color", '');
    $head3        = $head_key3 ? get_firefly_color($head_key3) : '';
    $text_key3    = get_theme_mod("my_plugin_group3_text_color", '');
    $text3        = $text_key3 ? get_firefly_color($text_key3) : '';
    $bcolor_key3  = get_theme_mod("my_plugin_group3_border_color", '');
    $bcolor3      = $bcolor_key3 ? get_firefly_color($bcolor_key3) : '';
    $hsize3       = get_theme_mod("my_plugin_group3_heading_size", '');
    $tsize3       = get_theme_mod("my_plugin_group3_text_size", '');
    $pad3         = get_theme_mod("my_plugin_group3_padding", '');
    $mtop3        = get_theme_mod("my_plugin_group3_margin_top", '');
    $mbot3        = get_theme_mod("my_plugin_group3_margin_bottom", '');
    $bw3          = get_theme_mod("my_plugin_group3_border_width", '');
    $gap3         = get_theme_mod("my_plugin_group3_space_between", '');
    $colwidth3    = get_theme_mod("my_plugin_group3_column_width", '');
    $outer_bg_key3 = get_theme_mod("my_plugin_group3_outer_background_color", '');
$outer_bg3     = $outer_bg_key3 ? get_firefly_color($outer_bg_key3) : '';
$hmtop3  = get_theme_mod("my_plugin_group3_heading_margin_top", '');
$hmbot3  = get_theme_mod("my_plugin_group3_heading_margin_bottom", '');



    echo "
    /* Group 3 - Columns */
    .wp-block-group.is-style-columns {

        " . ($mtop3 ? "margin-top: {$mtop3};" : '') . "
        " . ($mbot3 ? "margin-bottom: {$mbot3};" : '') . "
        " . ($bw3 ? "border-width: {$bw3}; border-style: solid;" : '') . "
        " . ($bcolor3 ? "border-color: {$bcolor3};" : '') . "
        " . ($gap3 ? "gap: {$gap3} ;" : '') . "
        padding:0px;
    }

    .wp-block-group.is-style-columns .wp-block-group__inner-container {
        margin-top:0px ;
        padding-top:0px ;
        border:1px {$bg3}  solid ;
        " . ($bg3 ? "background-color: {$bg3} ;" : '') . "
        " . ($pad3 ? "padding-left: {$pad3} ;" : '') . "
         " . ($pad3 ? "padding-right: {$pad3} ;" : '') . "
    }

    .wp-block-group.is-style-container-for-columns {

    " . ($outer_bg3 ? "background-color: {$outer_bg3};" : '') . "
}


    .wp-block-group.is-style-columns .wp-block-heading,
    .wp-block-group.is-style-columns h1,
    .wp-block-group.is-style-columns h22,
    .wp-block-group.is-style-columns h33,
    .wp-block-group.is-style-columns h4,
    .wp-block-group.is-style-columns h5,
    .wp-block-group.is-style-columns h6 {

      padding-top: 0px ;
      padding-bottom: 0px ;
      line-height:100% ;

        " . ($head3 ? "color: {$head3} ;" : '') . "
        " . ($hsize3 ? "font-size: {$hsize3} ;" : '') . "
    " . ($head3 ? "color: {$head3} ;" : '') . "
    " . ($hsize3 ? "font-size: {$hsize3};" : '') . "
    " . ($hmtop3 ? "margin-top: {$hmtop3} ;" : '') . "
    " . ($hmbot3 ? "margin-bottom: {$hmbot3} ;" : '') . "
 
    
}



    .wp-block-group.is
    -style-columns p {
        " . ($text3 ? "color: {$text3} ;" : '') . "
        " . ($tsize3 ? "font-size: {$tsize3} ;;" : '') . "
    }

    .wp-block-group.is-style-columns > .wp-block-column {
        " . ($colwidth3 ? "max-width: {$colwidth3} ;" : '') . "
    }



    ";



  //  <div class="wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex">
//<div class="wp-block-button"><a class="wp-block-button__link wp-element-button">Make a booking</a></div>

$button_padding_top = get_theme_mod("my_plugin_button_padding_top", '10px');
$button_padding_bottom = get_theme_mod("my_plugin_button_padding_bottom", '10px');
$button_alignment = get_theme_mod("my_plugin_button_alignment", 'center');

$button_colour_key = get_theme_mod("my_plugin_button_colour", 'black');
$button_text_colour_key = get_theme_mod("my_plugin_button_text_colour", 'white');

 $button_colour = $button_colour_key ? get_firefly_color($button_colour_key) : '';
 $button_text_colour = $button_text_colour_key ? get_firefly_color($button_text_colour_key) : '';


 $button_border_radius = get_theme_mod("firefly_button_border_radius", '50px');
 $button_text_size = get_theme_mod("my_plugin_button_text_size", '16px');

 $cover_heading_xl_pc = get_theme_mod("my_plugin_cover_heading_xl_pc", '76px');
 $cover_heading_xl_tablet = get_theme_mod("my_plugin_cover_heading_xl_tablet", '48px');
 $cover_heading_xl_mobile = get_theme_mod("my_plugin_cover_heading_xl_mobile", '36px');
   

  $cover_heading_l_pc = get_theme_mod("my_plugin_cover_heading_l_pc", '76px');
 $cover_heading_l_tablet = get_theme_mod("my_plugin_cover_heading_l_tablet", '48px');
 $cover_heading_l_mobile = get_theme_mod("my_plugin_cover_heading_l_mobile", '36px');
   

  $cover_heading_m_pc = get_theme_mod("my_plugin_cover_heading_m_pc", '76px');
 $cover_heading_m_tablet = get_theme_mod("my_plugin_cover_heading_m_tablet", '48px');
 $cover_heading_m_mobile = get_theme_mod("my_plugin_cover_heading_m_mobile", '36px');
   



// button styles

echo "


       ";
       
       if ($button_alignment == "center") {
        echo " 
        
            .wp-block-buttons {
                margin: 0 auto;
                text-align:center;
            }               
                
            .wp-block-button {
                margin:0 auto;
            }

       
        ";
       }


          if ($button_alignment == "right") {
        echo " 
        
            .wp-block-buttons {
                 display: flex ;
                 justify-content: flex-end; 
                text-align:right;
            }               
                
        

       
        ";
       }
 

       echo "

       

        .wp-block-button__link {
            margin-top: {$button_padding_top} ;
            margin-bottom: {$button_padding_bottom} ;
            background-color: {$button_colour};
            color: {$button_text_colour};
            border-radius: {$button_border_radius};
            font-size: {$button_text_size};
            june:no;
        }

        ";


        // media and text options

        $text_image_padding_top = get_theme_mod("my_plugin_text_image_padding_top", '10px');
        $text_image_padding_bottom = get_theme_mod("my_plugin_text_image_padding_bottom", '10px');
        $text_image_margin_top = get_theme_mod("my_plugin_text_image_margin_top", '');
        $text_image_margin_bottom = get_theme_mod("my_plugin_text_image_margin_bottom", '');

        $cover_margin_top = get_theme_mod("my_plugin_cover_margin_top", '');
        $cover_margin_bottom = get_theme_mod("my_plugin_cover_margin_bottom", '');



echo "
        .wp-block-media-text__content {
            padding-top: {$text_image_padding_top} ;
            padding-bottom: {$text_image_padding_bottom} ;
      }

        .wp-block-media-text {
            margin-top: {$text_image_margin_top};
             margin-bottom: {$text_image_margin_bottom};
             padding-right:0px;
             padding-left:0px;
     }
          





           . .wp-block-cover {
                margin-top: {$cover_margin_top} ;
                margin-bottom: {$cover_margin_bottom} ;
            }
            .flippy {}

             


        .wp-block-cover .has-x-large-font-size {
            font-size:{$cover_heading_xl_pc} ;
            line-height:110% ;
        }

        .wp-block-cover .has-large-font-size {
            font-size:{$cover_heading_l_pc} ;
            line-height:110% ;
        }


        @media (min-width: 701px) and (max-width: 1024px) {
            .wp-block-cover .has-x-large-font-size {
                font-size:{$cover_heading_xl_tablet} ;
            }
            .wp-block-cover .has-large-font-size {
                font-size:{$cover_heading_l_tablet} ;
                line-height:110% ;
            }

        }

        @media (max-width: 700px) {
            .wp-block-cover .has-x-large-font-size {
                font-size:{$cover_heading_xl_mobile} ;
            }
            .wp-block-cover .has-large-font-size {
                font-size:{$cover_heading_l_mobile} ;
                line-height:110% ;
            }

        }



    /* Target the parent wrapper */
.wp-block-group.is-style-container-for-columns > .wp-block-group__inner-container {
  display: flex ;
  flex-wrap: wrap;       /* allows wrapping on smaller screens */
  gap: 20px;             /* space between columns */
    justify-content: center;   
}

/* Each column */
.wp-block-group.is-style-columns {
 /* flex: 1 1 45%;         /* grow, shrink, basis (about half width) */
  box-sizing: border-box;
/*  max-width: 48%;        /* keep them from stretching too wide */
}

/* Optional: make them stack on mobile */
@media (max-width: 768px) {
  .wp-block-group.is-style-columns {
    flex: 1 1 100%;
    max-width: 100%;
  }
}

 ";


        $line_height = get_theme_mod("my_plugin_{$tag}_line_height", '100%');
        $margin_top = get_theme_mod("my_plugin_{$tag}_margin_top", '0px');
        $margin_bottom = get_theme_mod("my_plugin_{$tag}_margin_bottom", '0px');

            echo " .wp-block-group p,
            .wp-block-group-is-layout-flex p {
                margin-top: {$margin_top} ;
                margin-bottom: {$margin_bottom} ;
            }

            .wp-block-group.is-vertical.is-layout-flex{
            /* disable the WP block gap so margins actually show */
            --wp--style--block-gap: 0 ;
            gap: 0 ;
            row-gap: 0 ;
        }

        /* give every direct child (p, h2, etc.) your margins */
                .wp-block-group.is-vertical.is-layout-flex > *{
                margin-top: {$margin_top} ;
                margin-bottom: {$margin_bottom} ;
        }
                        ";



    echo "</style>\n";
}
add_action('wp_head', 'firefly_output_group_styles');
add_action('customize_preview_head', 'firefly_output_group_styles');

