jQuery(document).ready(function($) {
    'use strict';
    console.log('Customizer script loaded');

    // Ensure wp.customize is available
    if (typeof wp === 'undefined' || typeof wp.customize === 'undefined') {
        console.error('wp.customize is not available');
        return;
    }

    var api = wp.customize;

    // Existing updateCSS functionality
    function updateCSS() {
        var width = api('my_plugin_page_width')();
        var maxWidth = api('my_plugin_max_width')();
        var pAbove = api('my_plugin_paragraph_spacing_above')();
        var pBelow = api('my_plugin_paragraph_spacing_below')();
        var hAbove = api('my_plugin_heading_spacing_above')();
        var hBelow = api('my_plugin_heading_spacing_below')();

        $('.site').css({
            'width': width === 'full-width' ? '100%' : width
        });

        $('p, h1, h2, h3, h4, h5, ul, ol, .wp-block-heading, .frm-fluent-form, .wp-block-image').css({
            'max-width': maxWidth
        });

        $('p').css({
            'margin-top': pAbove + 'px',
            'margin-bottom': pBelow + 'px'
        });

        $('h1, h2, h3').css({
            'margin-top': hAbove + 'px',
            'margin-bottom': hBelow + 'px'
        });
    }

    // Watch for changes and update live
    [
        'page_width', 'max_width', 'paragraph_spacing_above', 'paragraph_spacing_below', 
        'heading_spacing_above', 'heading_spacing_below'
    ].forEach(setting => {
        api(`my_plugin_${setting}`, function(value) {
            value.bind(updateCSS);
        });
    });

    // Firefly preset functionality
    function applyPreset(colors) {
        console.log('Applying preset with colors:', colors);
        
        if (!Array.isArray(colors) || colors.length !== 4) {
            console.error('Invalid colors array:', colors);
            return;
        }

      // Within the applyPreset function:
colors.forEach(function(color, index) {
    var settingId = 'firefly_colour_' + (index + 1);
    var $input = $('#' + controlId + ' .wp-color-picker');
    var setting = api(settingId);

    if (setting) {
        setting.set(color);
        console.log('Set ' + settingId + ' to ' + color);

        // Corrected selector with '#' for ID
        var $input = $('#' + controlId + ' .wp-color-picker');
        if ($input.length) {
            $input.val(color).trigger('change');
            // Properly update the WordPress color picker
            $input.wpColorPicker('color', color); // Ensure this is the correct method
            console.log('Updated UI for ' + settingId);
        } else {
            console.warn('Color picker input not found for ' + settingId);
        }
    }
});
    }

    api.bind('ready', function() {
        console.log('Customizer API ready');

        var $presets = $('.firefly-preset');
        console.log('Number of .firefly-preset elements found:', $presets.length);
        if ($presets.length === 0) {
            console.warn('No .firefly-preset elements found in DOM');
        }

        $(document).on('click', '.firefly-preset', function(e) {
            e.preventDefault();
            alert('Preset clicked!');
            console.log('Click event triggered on preset:', this);
            
            var colors = $(this).data('colors');
            console.log('Preset colors:', colors);

            if (colors && Array.isArray(colors)) {
                applyPreset(colors);
            } else {
                console.error('Invalid or missing colors data:', colors);
            }
        });

        setTimeout(function() {
            var $latePresets = $('.firefly-preset');
            console.log('After 1s - Number of .firefly-preset elements:', $latePresets.length);
        }, 1000);

        // Ensure CSS updates when Customizer loads
        updateCSS();
    });
});
