<?php

add_action('customize_register', function ($wp_customize) {
    $section = 'firefly_blocks_section_group_3_columns';

    $wp_customize->add_section($section, array(
        'title'    => __('Group 3 - Columns', 'my-plugin'),
        'panel'    => 'firefly_blocks_panel',
        'priority' => 60,
    ));

    $settings = [
        'background_color' => 'Background Colour',
        'heading_color'    => 'Heading Colour',
        'text_color'       => 'Text Colour',
        'heading_size'     => 'Heading Size',
        'text_size'        => 'Text Size',
        'padding'          => 'Padding',
    ];

    foreach ($settings as $key => $label) {
        $id = "my_plugin_group3_{$key}";

        $wp_customize->add_setting($id, array(
            'default'           => '',
            'transport'         => 'refresh',
            'sanitize_callback' => in_array($key, ['background_color', 'heading_color', 'text_color']) ? 'sanitize_hex_color' : 'sanitize_text_field',
        ));

        if (strpos($key, 'color') !== false) {
            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, "{$id}_control", array(
                'label'    => __($label, 'my-plugin'),
                'section'  => $section,
                'settings' => $id,
            )));
        } elseif (strpos($key, 'size') !== false) {
            $wp_customize->add_control("{$id}_control", array(
                'label'    => __($label, 'my-plugin'),
                'section'  => $section,
                'settings' => $id,
                'type'     => 'select',
                'choices'  => [
                    '14px' => '14px', '16px' => '16px', '18px' => '18px', '20px' => '20px',
                    '24px' => '24px', '28px' => '28px', '32px' => '32px', '36px' => '36px',
                    '42px' => '42px', '48px' => '48px', '56px' => '56px', '68px' => '68px',
                ],
            ));
        } elseif ($key === 'padding') {
            $wp_customize->add_control("{$id}_control", array(
                'label'    => __($label, 'my-plugin'),
                'section'  => $section,
                'settings' => $id,
                'type'     => 'select',
                'choices'  => [
                    '0px' => '0px', '5px' => '5px', '10px' => '10px',
                    '15px' => '15px', '20px' => '20px', '25px' => '25px', '30px' => '30px',
                ],
            ));
        }
    }
});

add_action('wp_head', function () {
    $bg    = get_theme_mod('my_plugin_group3_background_color', '');
    $head  = get_theme_mod('my_plugin_group3_heading_color', '');
    $text  = get_theme_mod('my_plugin_group3_text_color', '');
    $hsize = get_theme_mod('my_plugin_group3_heading_size', '');
    $tsize = get_theme_mod('my_plugin_group3_text_size', '');
    $pad   = get_theme_mod('my_plugin_group3_padding', '');

    echo "<style>
    .wp-block-group.is-style-columns .wp-block-heading h1,
    .wp-block-group.is-style-columns .wp-block-heading h2,
    .wp-block-group.is-style-columns .wp-block-heading h3 {
        " . ($head ? "color: {$head} !important;" : '') .
           ($hsize ? "font-size: {$hsize} !important;" : '') . "
    }

    .wp-block-group.is-style-columns p {
        " . ($text ? "color: {$text} !important;" : '') .
           ($tsize ? "font-size: {$tsize};" : '') . "
    }

    .wp-block-group.is-style-columns .wp-block-group__inner-container {
        " . ($bg ? "background-color: {$bg} !important;" : '') .
           ($pad ? "padding: {$pad};" : '') . "
    }
    </style>";
});
