<?php

add_action('customize_register', 'firefly_customize_plugins_section');
function firefly_customize_plugins_section($wp_customize) {
    include_once ABSPATH . 'wp-admin/includes/plugin.php';

    // Split plugins into setup and live groups
    $setup_plugins = [
        [
            'name' => 'Fluent Forms',
            'slug' => 'fluentform',
            'file' => 'fluentform/fluentform.php',
        ],
        [
            'name' => 'Fluent SMTP',
            'slug' => 'fluent-smtp',
            'file' => 'fluent-smtp/fluent-smtp.php',
        ],   
        [
            'name' => 'FooGallery',
            'slug' => 'foogallery',
            'file' => 'foogallery/foogallery.php',
        ],
        [
            'name' => 'FooBox Image Lightbox',
            'slug' => 'foobox-image-lightbox',
            'file' => 'foobox-image-lightbox/foobox-free.php',
        ],

           [
        'name' => 'WPS Hide Login',
        'slug' => 'wps-hide-login',
        'file' => 'wps-hide-login/wps-hide-login.php',
    ],
    [
        'name' => 'MetaSlider – Slider, Gallery, and Carousel',
        'slug' => 'ml-slider',
        'file' => 'ml-slider/ml-slider.php',
    ],
   
    ];



    

    $live_plugins = [
        [
            'name' => 'Cloudflare',
            'slug' => 'cloudflare',
            'file' => 'cloudflare/cloudflare.php',
        ],
        [
            'name' => 'Site Kit by Google',
            'slug' => 'google-site-kit',
            'file' => 'google-site-kit/google-site-kit.php',
        ],
        [
            'name' => 'MetaSlider',
            'slug' => 'ml-slider',
            'file' => 'ml-slider/ml-slider.php',
        ],
     
        [
            'name' => 'UpdraftPlus',
            'slug' => 'updraftplus',
            'file' => 'updraftplus/updraftplus.php',
        ],
        [
            'name' => 'Wordfence Security',
            'slug' => 'wordfence',
            'file' => 'wordfence/wordfence.php',
        ],
    ];

    $wp_customize->add_section('firefly_plugins_section', array(
        'title'    => __('Recommended Plugins', 'your-textdomain'),
        'priority' => 999,
    ));

    $wp_customize->add_setting('firefly_plugins_setup_info', array(
        'sanitize_callback' => '__return_null',
    ));

    $wp_customize->add_setting('firefly_plugins_live_info', array(
        'sanitize_callback' => '__return_null',
    ));

    // Output HTML for plugin group
    function render_plugin_list($plugins) {
        $output = '<ul>';
        foreach ($plugins as $plugin) {
            $is_installed = file_exists(WP_PLUGIN_DIR . '/' . $plugin['file']);
            $is_active = $is_installed && is_plugin_active($plugin['file']);

            $output .= '<li><strong>' . esc_html($plugin['name']) . '</strong> – ';
            if (!$is_installed) {
                $install_url = wp_nonce_url(
                    admin_url('update.php?action=install-plugin&plugin=' . $plugin['slug']),
                    'install-plugin_' . $plugin['slug']
                );
                $output .= '<a href="' . esc_url($install_url) . '" target="_blank">Install</a>';
            } elseif (!$is_active) {
                $activate_url = wp_nonce_url(
                    admin_url('plugins.php?action=activate&plugin=' . $plugin['file']),
                    'activate-plugin_' . $plugin['file']
                );
                $output .= '<a href="' . esc_url($activate_url) . '" target="_blank">Activate</a>';
            } else {
                $output .= '<span style="color:green;">Active</span>';
            }
            $output .= '</li>';
        }
        $output .= '</ul>';
        return $output;
    }

    $setup_html = '<p><strong>Install these plugins on setting up the theme:</strong></p>' . render_plugin_list($setup_plugins);
    $live_html = '<p><strong>Install these plugins when going live:</strong></p>' . render_plugin_list($live_plugins);

    // Add two controls
    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'firefly_plugins_setup_info_control', array(
        'section'     => 'firefly_plugins_section',
        'settings'    => 'firefly_plugins_setup_info',
        'type'        => 'hidden',
        'description' => $setup_html,
    )));

    $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'firefly_plugins_live_info_control', array(
        'section'     => 'firefly_plugins_section',
        'settings'    => 'firefly_plugins_live_info',
        'type'        => 'hidden',
        'description' => $live_html,
    )));


        // Add "Set up site" link if domain is test or no front page is set
        $current_host = $_SERVER['HTTP_HOST'] ?? '';
        $front_page_id = get_option('page_on_front');
        $show_on_front = get_option('show_on_front');
    
        $should_show_setup_link = (
            $current_host === 'hippiedreads.rainbowdigital.co.nz' ||
            $show_on_front !== 'page' ||
            !$front_page_id ||
            get_post_status($front_page_id) !== 'publish'
        );
    
        if ($should_show_setup_link) {
           // $setup_url = add_query_arg('my_plugin_rerun_setup', '1', home_url('/'));

            $setup_url = home_url('/'); 
    
            $wp_customize->add_setting('firefly_setup_site_link', [
                'sanitize_callback' => '__return_null',
            ]);
    
            $wp_customize->add_control(new WP_Customize_Control($wp_customize, 'firefly_setup_site_link_control', [
                'section'     => 'firefly_plugins_section',
                'settings'    => 'firefly_setup_site_link',
                'type'        => 'hidden',
                'description' => '<p style="margin-top:20px;"><a href="' . esc_url($setup_url) . '" style="display:inline-block; padding:8px 16px; background:#0073aa; color:white; border-radius:4px; text-decoration:none;" target="_blank">Set up site</a></p>',
            ]));
        }
    
}
