<?php

$image_url = esc_url( get_stylesheet_directory_uri() . '/patterns/assets/bush.jpg' );


return [
	'title'      => __( 'Firefly - Contact Section Fixed', 'firefly' ),
	'categories' => [ 'firefly', 'firefly-text-bg-image' ],
	'content'    => '

<!-- wp:cover {"url":"' . $image_url . '","dimRatio":0,"minHeight":500,"align":"full"} -->
<div class="wp-block-cover alignfull" style="min-height:500px">
	<span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span>
	<img class="wp-block-cover__image-background" alt="" src="' . $image_url . '" data-object-fit="cover"/>
	<div class="wp-block-cover__inner-container">


		<!-- wp:spacer {"height":"350px"} -->
		<div style="height:350px" aria-hidden="true" class="wp-block-spacer"></div>
		<!-- /wp:spacer -->

			<!-- wp:group {"layout":{"type":"constrained","contentSize":"450px","justifyContent":"left"},"style":{"color":{"background":"#00000080"},"spacing":{"padding":{"top":"2rem","bottom":"2rem","left":"2rem","right":"2rem"}}},"className":"contact-box"} -->
		<div class="wp-block-group contact-box has-background" style="background-color:#00000080;padding-top:2rem;padding-right:2rem;padding-bottom:2rem;padding-left:2rem">

			<!-- wp:heading {"level":1,"textAlign":"left","textColor":"white","fontSize":"x-large"} -->
			<h1 class="wp-block-heading has-text-align-left has-white-color has-text-color has-x-large-font-size">CONTACT US</h1>
			<!-- /wp:heading -->

			<!-- wp:paragraph {"align":"left","textColor":"white"} -->
			<p class="has-text-align-left has-white-color has-text-color">If you need assistance, contact 04 232 1000.</p>
			<!-- /wp:paragraph -->

			<!-- wp:paragraph {"align":"left","textColor":"white"} -->
			<p class="has-text-align-left has-white-color has-text-color">
				<span style="
					background-color: var(--wp--preset--color--firefly-colour-1);
					color: white;
					padding: 0.8em 1.2em;
					border-radius: 0px;
					display: inline-block;
					font-weight: 600;
					font-size: 1rem;
					cursor: pointer;
					margin-top: 1em;
				" onclick="window.location.href=\'tel:042321000\'">📞 CALL NOW FOR HELP</span>
			</p>
			<!-- /wp:paragraph -->

		</div>
		<!-- /wp:group -->

	</div>
</div>
<!-- /wp:cover -->
'
];