<?php

$image_url = esc_url( get_stylesheet_directory_uri() . '/patterns/assets/bush.jpg' );

return [
	'title'      => __( 'Firefly - simple section 2 - Cover with Theme Colors', 'firefly' ),
	'categories' => [ 'firefly','firefly-text-bg-image' ],
	'content'    => '
<!-- wp:cover {"url":"' . $image_url . '","dimRatio":50,"minHeight":500,"align":"full","isDark":false,"layout":{"type":"constrained"},"style":{"spacing":{"padding":{"top":"4rem","bottom":"4rem"}}}} -->
<div class="wp-block-cover alignfull has-background-dim-50 has-background-dim" style="min-height:500px;padding-top:4rem;padding-bottom:4rem">
	<img class="wp-block-cover__image-background" alt="" src="' . $image_url . '" data-object-fit="cover"/>
	<div class="wp-block-cover__inner-container">

		<!-- wp:heading {"textAlign":"center","textColor":"firefly-colour-3"} -->
		<h2 class="wp-block-heading has-text-align-center has-firefly-colour-3-color has-text-color">Heading using theme palette #1</h2>
		<!-- /wp:heading -->

		<!-- wp:paragraph {"align":"center","textColor":"white"} -->
		<p class="has-text-align-center has-white-color has-text-color">Paragraph with white text.</p>
		<!-- /wp:paragraph -->

	</div>
</div>
<!-- /wp:cover -->
'
];
