<!DOCTYPE html>
<html <?php language_attributes(); ?> <?php blankslate_schema_type(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">


    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <?php wp_head(); ?>
    <?php
    $favicon = get_theme_mod('my_plugin_favicon');
    if (!empty($favicon)) {
        echo '<link rel="icon" href="' . esc_url($favicon) . '" type="image/png">';
    }

    $font_family = get_theme_mod('firefly_banner_font', 'Roboto');
    if (!empty($font_family)) {
        $font_name = explode(',', $font_family)[0];
        echo '<link href="https://fonts.googleapis.com/css2?family=' . urlencode(str_replace(' ', '+', $font_name)) . '&display=swap" rel="stylesheet">';
    }
    ?>


  <meta name="firefly-theme-version" content="<?php echo esc_attr( wp_get_theme()->get( 'Version' ) ); ?>" />

  <meta name="firefly-theme-location" content="<?php echo esc_attr( $_SERVER['SERVER_ADDR'] ); ?>" />







<?php
/**
 * Build the firefly-theme-modules meta content string.
 */
function ff_build_firefly_modules_content() {
    $parts = array();

    // 1) Theme modules
    $mods = get_theme_mods() ?: array();
    $modules = array();
    foreach ($mods as $key => $value) {
        if (!$value) continue;
        if (preg_match('/_(?:has|module)_(.+)$/', $key, $m)) {
            $modules[] = sanitize_key($m[1]);
        }
    }
    $parts[] = implode(',', array_unique($modules));

    // 2) Active plugins (cached)
    $active_plugins_key     = 'ff_active_plugins_compact_v1';
    $active_plugins_compact = get_transient($active_plugins_key);

    if ($active_plugins_compact === false) {
        if (!function_exists('is_plugin_active')) {
            @require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }

        $active = (array) get_option('active_plugins', array());
        if (is_multisite()) {
            $network = (array) get_site_option('active_sitewide_plugins', array());
            $active  = array_merge($active, array_keys($network));
        }

        $items = array();
        foreach ($active as $file) {
            $part = dirname($file);
            $slug = ($part === '.') ? basename($file, '.php') : $part;
            $slug = sanitize_title($slug);

            $display     = $slug;
            $plugin_path = WP_PLUGIN_DIR . '/' . ltrim($file, '/');
            if (stripos($slug, 'firefly') !== false && file_exists($plugin_path)) {
                if (!function_exists('get_plugin_data')) {
                    @require_once ABSPATH . 'wp-admin/includes/plugin.php';
                }
                $data = get_plugin_data($plugin_path, false, false);
                if (!empty($data['Version'])) {
                    $display .= ' (v' . sanitize_text_field($data['Version']) . ')';
                }
            }
            $items[] = $display;
        }
        $active_plugins_compact = implode(',', $items);
        set_transient($active_plugins_key, $active_plugins_compact, 12 * HOUR_IN_SECONDS);
    }
    $parts[] = $active_plugins_compact;

    // 3) Theme mods of interest
    $parts[] = (string) get_theme_mod('firefly_header_choice', '');
    $parts[] = (string) get_theme_mod('firefly_footer_show', '');

    // 4) Firefly AI token usage (if plugin active)
    if (!function_exists('is_plugin_active')) {
        @require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }
    if (function_exists('is_plugin_active') && is_plugin_active('Firefly-AI/Firefly-AI.php')) {
        $logs = (array) get_option('firefly_ai_usage_log', array());
        $total_prompt_tokens     = 0;
        $total_completion_tokens = 0;
        foreach ($logs as $log) {
            $total_prompt_tokens     += (int) (isset($log['prompt_tokens']) ? $log['prompt_tokens'] : 0);
            $total_completion_tokens += (int) (isset($log['completion_tokens']) ? $log['completion_tokens'] : 0);
        }
        $total_tokens = $total_prompt_tokens + $total_completion_tokens;

        // NZD cents per 1K tokens
        $prompt_cents_per_1k     = 5.1;
        $completion_cents_per_1k = 10.2;

        $cost_nzd = (
            ($total_prompt_tokens / 1000)     * ($prompt_cents_per_1k / 100) +
            ($total_completion_tokens / 1000) * ($completion_cents_per_1k / 100)
        );
        $parts[] = number_format($total_tokens) . ' tokens used. Cost: $' . number_format($cost_nzd, 2) . ' NZD';
    }

    // 5) Shortcodes (cached)
    $shortcodes_key     = 'ff_all_shortcodes_compact_v1';
    $shortcodes_compact = get_transient($shortcodes_key);

    if ($shortcodes_compact === false) {
        global $wpdb;
        $found = array();

        $posts = $wpdb->get_results("
            SELECT post_content
            FROM {$wpdb->posts}
            WHERE post_status = 'publish'
              AND post_type NOT IN ('revision','nav_menu_item')
        ");

        if ($posts) {
            foreach ($posts as $p) {
                if (!isset($p->post_content)) continue;
                if (preg_match_all('/\[([a-zA-Z0-9_]+)(\s[^\]]*)?\]/', $p->post_content, $m)) {
                    foreach ($m[1] as $sc) {
                        $found[] = sanitize_key($sc);
                    }
                }
            }
        }
        $found = array_values(array_unique($found));
        sort($found);

        // build like *[sc1][sc2]...
        if (!empty($found)) {
            $packed = '*';
            foreach ($found as $s) {
                $packed .= '[' . $s . ']';
            }
            $shortcodes_compact = $packed;
        } else {
            $shortcodes_compact = '';
        }

        set_transient($shortcodes_key, $shortcodes_compact, 12 * HOUR_IN_SECONDS);
    }
    $parts[] = $shortcodes_compact;

    return implode('|', $parts);
}

/**
 * Head meta output (only with ?ff_meta=1 or Firefly UA)
 */
add_action('wp_head', function () {
    $ua = strtolower(isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '');
    $is_firefly_bot = (strpos($ua, 'firefly-version-checker') !== false);
    $has_param = isset($_GET['ff_meta']); // any value allowed, e.g. ?ff_meta=1

    if (!$is_firefly_bot && !$has_param) {
        return;
    }

    $content = ff_build_firefly_modules_content();

    if ($content !== '') {
        echo '<meta name="firefly-theme-modules" content="' . esc_attr($content) . '" />' . "\n";
    } else {
        // Optional: quick server log to verify hook ran
        // error_log('ff_meta: builder returned empty string');
    }
}, 99);




 // Trigger manually via URL parameter
 if ( is_page( 'terms-and-conditions' ) ) {
    // Optional: only respond on the front end (avoid breaking admin)
    if ( ! is_admin() ) {
        $content = ff_build_firefly_modules_content();


         if ($content !== '') {
            echo '<meta name="firefly-theme-modules" content="' . esc_attr($content) . '" />' . "\n\n\n\n\n\n";
        }
    }
}


?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="wrapper" class="hfeed">



<?php
$header_mode     = get_theme_mod('firefly_header_choice', 'logo_only');
$logo_pc         = get_theme_mod('my_plugin_logo_pc');
$logo_mobile     = get_theme_mod('firefly_menu_mobile_logo');
$banner_text     = get_theme_mod('firefly_banner_text', '');
$logo_align      = get_theme_mod('my_plugin_logo_alignment', 'leftoftext');
$banner_font     = get_theme_mod('firefly_banner_font_family', 'default');
$font_style      = ($banner_font !== 'default') ? "font-family: {$banner_font};" : '';
$menu_position = get_theme_mod('firefly_menu_position', 'below'); // 'below', 'above', 'fixed'
$menu_class = 'menu-position-' . $menu_position;




$menu_phone_number         = get_theme_mod('firefly_menu_phone_number', '');
$menu_phone_text         = get_theme_mod('firefly_menu_phone_text', '');
$menu_phone_bg_color         = get_theme_mod('firefly_menu_phone_bg_color', '');
$menu_phone_text_color         = get_theme_mod('firefly_menu_phone_text_color', '');
$menu_phone_text_font_size         = get_theme_mod('firefly_menu_phone_text_font_size', '');
$menu_phone_number_font_size         = get_theme_mod('firefly_menu_phone_number_font_size', '');
$menu_phone_spacing         = get_theme_mod('firefly_menu_phone_spacing', '0px');

  $mobile_position  = get_theme_mod('firefly_mobile_position', 'fixed');


if ( ! get_theme_mod('firefly_no_menu', false) ) : 

    if ($menu_position == "above") {
    // menu at top
    include get_stylesheet_directory() . '/firefly-menu-display-on-page.php';
    }

      if ($mobile_position == "above") {
        // mobile menu at top
        include get_stylesheet_directory() . '/firefly-menu-mobile-display-on-page.php';
    }

endif; 
	
if($header_mode =="none") {
   echo "<div class='header-spacer'></div>";
}

if($header_mode =="logo_only") {
   include get_stylesheet_directory() . '/firefly-header-logo-only.php';
}




if($header_mode =="banner_only") {
   include get_stylesheet_directory() . '/firefly-header-banner-only.php';
}


if($header_mode =="text_only") {
   include get_stylesheet_directory() . '/firefly-header-text-only.php';
}

if($header_mode =="banner_and_logo") {
    if($logo_align =="leftoftext") {
        include get_stylesheet_directory() . '/firefly-header-banner-with-logo-left.php';
    }
    else
    { 
        include get_stylesheet_directory() . '/firefly-header-banner-with-logo-above.php';
    }
}


if($header_mode =="logo_text_icons") {
      include get_stylesheet_directory() . '/firefly-header-logo-text-icons.php';
}

echo "<div class='content-wrapper-below-header'>";


if ( ! get_theme_mod('firefly_no_menu', false) ) {

        if ($menu_position == "bilingual") {

             $file = WP_PLUGIN_DIR . '/Firefly-bilingual-menu/menu-bilingual-display-on-page.php';
            if ( file_exists( $file ) ) {
                include_once $file;
            }
        }
         elseif ($menu_position != "above") {
        include get_stylesheet_directory() . '/firefly-menu-display-on-page.php';
        }

        if ($mobile_position != "above") {
            include get_stylesheet_directory() . '/firefly-menu-mobile-display-on-page.php';
        }

   
}