<?php


//$slug = sanitize_title($term->name);
//echo "<h1>SLUG $slug</h1>";

echo "<div class='thing-$slug'><div class='thing-container-$slug'>";

$thumb_width   = get_theme_mod("firefly_thing_thumb_width_$style_key", get_theme_mod("firefly_thing_thumb_width_$slug", 300));
$thumb_height  = get_theme_mod("firefly_thing_thumb_height_$style_key", get_theme_mod("firefly_thing_thumb_height_$slug", 300));

$haslinks   = get_theme_mod("firefly_thing_link_to_page_$slug",1);
$post_slug = sanitize_title(get_the_title());
$galleryyesorno      = get_theme_mod("firefly_thing_image_display_mode_$slug", 'single');  


while ($query->have_posts()) {

    $query->the_post();
    $post_id = get_the_ID();
    $link = esc_url(site_url("/$post_id/$slug/$post_slug"));
     
   

/* draft? */
$is_draft    = get_post_status() === 'draft';
$draft_class = $is_draft ? ' firefly-draft' : '';

echo '<div class="thing-panel-' . esc_attr( $slug ) . $draft_class . '">';



      if (current_user_can('manage_options')) {
          $template_file = get_stylesheet_directory() . "/firefly-admin-thing.php";

        if (file_exists($template_file)) {
            include $template_file;
        }
    }


    

    if ($galleryyesorno == "single") {

        // === Single Image ===
$gallery_images = get_post_meta(get_the_ID(), 'thing_gallery', true);
$thumbnail_id   = get_post_thumbnail_id();
$image_id       = null;

// Prefer thumbnail if available
if ($thumbnail_id) {
    $image_id = $thumbnail_id;
} elseif (is_array($gallery_images) && !empty($gallery_images)) {
    $image_id = $gallery_images[0];
}

if ($image_id) {
    if ($haslinks == 1) {
        echo "<a href='$link'>";
    }

    echo '<div class="firefly-gallery-wrapper" style="width:' . esc_attr($thumb_width) . 'px;height:' . esc_attr($thumb_height) . 'px;">';
             $alt = get_post_meta( $image_id, '_wp_attachment_image_alt', true );

echo wp_get_attachment_image( $image_id, 'medium', false, [
    'style'   => 'width:100%;height:100%;object-fit:cover;',
    'loading' => 'lazy',
    'alt'     => $alt !== '' ? $alt : get_the_title(),   // fallback = post title
    'title'   => $title !== '' ? $alt : get_the_title(),
] );

    echo '</div>';

    if ($haslinks == 1) {
        echo "</a>";
    }
}




    }
    else
    {

  if ($haslinks == 1) {
        echo '<a href="' . esc_url($link) . '" class="thing-link" >'; 
     }



$gallery_images = get_post_meta(get_the_ID(), 'thing_gallery', true);
$thumbnail_id = get_post_thumbnail_id();

// Combine all images (featured first if exists)
$all_images = [];
if ($thumbnail_id) {
    $all_images[] = $thumbnail_id;
}
if (is_array($gallery_images)) {
    foreach ($gallery_images as $image_id) {
        if ($image_id != $thumbnail_id) {
            $all_images[] = $image_id;
        }
    }
}

// Display image gallery or fallback
if (!empty($all_images)) {
    echo '<div class="firefly-gallery-wrapper" style="width:' . esc_attr($thumb_width) . 'px;height:' . esc_attr($thumb_height) . 'px;">';

    foreach ($all_images as $index => $image_id) {
        $opacity = $index === 0 ? '1' : '0';
        echo '<div class="firefly-gallery-image" style="opacity:' . $opacity . ';transition:opacity 0.5s ease;">';
        echo wp_get_attachment_image($image_id, 'medium', false, [
            'style' => 'width:100%;height:100%;object-fit:cover;',
            'loading' => 'lazy',
        ]);
        echo '</div>';
    }

    echo '</div>';

    echo '
    <script>
    document.addEventListener("DOMContentLoaded", function() {
        const gallery = document.querySelectorAll(".firefly-gallery-wrapper");
        gallery.forEach(wrapper => {
            const images = wrapper.querySelectorAll(".firefly-gallery-image");
            if (images.length <= 1) return;

            let currentIndex = 0;
            let nextIndex = 1;

            function cycleImages() {
                images[currentIndex].style.opacity = "0";
                images[nextIndex].style.opacity = "1";
                currentIndex = nextIndex;
                nextIndex = (nextIndex + 1) % images.length;
                wrapper.dataset.timeoutId = setTimeout(cycleImages, 3000);
            }

            wrapper.dataset.timeoutId = setTimeout(cycleImages, 3000);

            wrapper.addEventListener("mouseenter", () => {
                clearTimeout(wrapper.dataset.timeoutId);
            });

            wrapper.addEventListener("mouseleave", () => {
                wrapper.dataset.timeoutId = setTimeout(cycleImages, 3000);
            });
        });
    });
    </script>
    ';
} else {
    echo '<div class="thing-image-' . esc_attr($slug) . '" style="width:' . esc_attr($thumb_width) . 'px;height:' . esc_attr($thumb_height) . 'px;">';
    echo get_the_post_thumbnail(get_the_ID(), 'medium', [
        'style' => 'width:100%;height:100%;object-fit:cover;display:block;',
    ]);
    echo '</div>';
}

     if ($haslinks == 1) {
        echo "</a>";
     }
    }
    echo '</div>
    
    '; // .thing-panel
}

wp_reset_postdata();
echo '</div></div>'; // .thing-container .thing

// === Styling ===

$layout = get_theme_mod("firefly_thing_layout_$slug", 'list');
$style_key = "{$layout}_{$slug}";

$thumb_width   = get_theme_mod("firefly_thing_thumb_width_$style_key", get_theme_mod("firefly_thing_thumb_width_$slug", 300));
$thumb_height  = get_theme_mod("firefly_thing_thumb_height_$style_key", get_theme_mod("firefly_thing_thumb_height_$slug", 300));
$image_padding = get_theme_mod("firefly_thing_image_padding_$slug", '0px');
$panel_margin  = get_theme_mod("firefly_thing_panel_margin_$slug", '10px');
$line_colour   = firefly_get_colour_value('firefly_document_line_colour');
$panel_border  = get_theme_mod('firefly_document_border', '0px');

$panel_margin_top    = get_theme_mod("firefly_panel_margin_top_$slug", '10px');
$panel_margin_bottom = get_theme_mod("firefly_panel_margin_bottom_$slug", '10px');
$panel_padding_top   = get_theme_mod("firefly_panel_padding_top_$slug", '10px');
$panel_padding_bottom= get_theme_mod("firefly_panel_padding_bottom_$slug", '10px');

$bg_thing_block            = firefly_get_colour_value('firefly_document_background');

$text_colour_key       = get_theme_mod("firefly_thing_text_colour_$slug", 'black');
$background_colour_key = get_theme_mod("firefly_thing_background_colour_$slug", 'white');
$line_colour_key       = get_theme_mod("firefly_thing_line_colour_$slug", 'black');

$text_colour       = firefly_get_colour_value("firefly_colour_$text_colour_key");
$background_colour = firefly_get_colour_value("firefly_colour_$background_colour_key");
$line_colour       = firefly_get_colour_value("firefly_colour_$line_colour_key");

$line_width       = get_theme_mod("firefly_thing_border_$slug", 'black');


$firefly_container_padding_top = get_theme_mod("firefly_container_padding_top_$slug", '10px');
$firefly_container_padding_bottom = get_theme_mod("firefly_container_padding_bottom_$slug", '10px');
$line_colour_key = get_theme_mod("firefly_thing_line_colour_$slug", 'black');

$line_colour= match ($line_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#000000',
};



$panel_colour_key = get_theme_mod("firefly_thing_panel_colour_$slug", 'black');

$panel_colour = match ($panel_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#000000',
};



$background_colour_key = get_theme_mod("firefly_thing_background_colour_$slug", 'black');

$background_colour = match ($background_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#000000',
};


//cho "<h1>$panel_colour_key $panel_colour ===</h1>";

// ✅ Final CSS
echo "


<style>
.thing-container-$slug {
    margin: 0 auto;
    text-align: center;
    width: 100%;
    display: flex;                /* <-- key */
    flex-wrap: wrap;             /* allow wrapping */
    justify-content: center;
    gap: $panel_margin;
 
    background-color:{$background_colour};

    margin-top:{$panel_margin_top};
    margin-bottom:{$panel_margin_bottom};
    padding-top:{$firefly_container_padding_top};
    padding-bottom:{$firefly_container_padding_bottom};
    
}
    .flip {}

.thing-panel-$slug {
    display: inline-block;       /* each panel floats inlineeeee */
    border: {$line_width} solid {$line_colour};
    margin: 0;
    padding: 0;
    background-color: {$panel_colour};
}

.thing-image-$slug {
    width: {$thumb_width}px;
    height: {$thumb_height}px;
    padding: {$image_padding};
    overflow: hidden;
}
.thing-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.firefly-gallery-wrapper {
    position: relative;
    width: <?php echo esc_attr($thumb_width); ?>px;
    height: <?php echo esc_attr($thumb_height); ?>px;
    overflow: hidden;
    line-height: 0;
    background-color: #f0f0f0; /* optional: helps catch uninitialized blank space */
}

.firefly-gallery-image {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
}

.firefly-gallery-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
    object-position: center center;
}


        .firefly-draft          { filter: grayscale(1);  }
.firefly-draft img      { filter: grayscale(1);  }

.firefly-draft .thing-name,
.firefly-draft .thing-field,
.firefly-draft .thing-description {
    color:#777 !important;
    text-decoration:line-through;
}

</style>";
