<?php

//$slug = sanitize_title($term->name);

// === Styling setup ===
$layout = get_theme_mod("firefly_thing_layout_$slug", 'list');
$style_key = "{$layout}_{$slug}";

$thumb_width   = get_theme_mod("firefly_thing_thumb_width_$style_key", get_theme_mod("firefly_thing_thumb_width_$slug", 300));
$thumb_height  = get_theme_mod("firefly_thing_thumb_height_$style_key", get_theme_mod("firefly_thing_thumb_height_$slug", 300));
$image_padding = get_theme_mod("firefly_thing_image_padding_$slug", '0px');
$panel_margin  = get_theme_mod("firefly_thing_panel_margin_$slug", '10px');
$panel_border  = get_theme_mod('firefly_document_border', '1px');

$panel_margin_top    = get_theme_mod("firefly_panel_margin_top_$slug", '10px');
$panel_margin_bottom = get_theme_mod("firefly_panel_margin_bottom_$slug", '10px');
$panel_padding_top   = get_theme_mod("firefly_panel_padding_top_$slug", '10px');
$panel_padding_bottom= get_theme_mod("firefly_panel_padding_bottom_$slug", '10px');

$text_colour_key       = get_theme_mod("firefly_thing_text_colour_$slug", 'black');
$heading_colour_key       = get_theme_mod("firefly_thing_heading_colour_$slug", 'black');
$background_colour_key = get_theme_mod("firefly_thing_background_colour_$slug", 'white');
$line_colour_key       = get_theme_mod("firefly_thing_line_colour_$slug", 'black');
$panel_colour_key      = get_theme_mod("firefly_thing_panel_colour_$slug", 'white');

$heading_colour = match ($heading_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#000000',
};


$text_colour = match ($text_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#000000',
};

$background_colour = match ($background_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#ffffff',
};

$line_colour = match ($line_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#000000',
};

$panel_colour = match ($panel_colour_key) {
    'colour1' => get_theme_mod('firefly_colour_1', '#0b3d32'),
    'colour2' => get_theme_mod('firefly_colour_2', '#65b32e'),
    'colour3' => get_theme_mod('firefly_colour_3', '#d3f5d1'),
    'colour4' => get_theme_mod('firefly_colour_4', '#e4f1ce'),
    'white'   => '#ffffff',
    default   => '#ffffff',
};

// === Start Container
echo "<div class='thing-container-$slug'>";

$haslinks   = get_theme_mod("firefly_thing_link_to_page_$slug",1);
$post_slug = sanitize_title(get_the_title());


// === Loop
while ($query->have_posts()) {
    $query->the_post();


  
    $post_id = get_the_ID();
    
$link = esc_url(site_url("/$post_id/$slug/$post_slug"));
$onclick = $haslinks ? "onclick=\"window.location.href='$link'\"" : '';

     

/* draft? */
$is_draft    = get_post_status() === 'draft';
$draft_class = $is_draft ? ' firefly-draft' : '';

echo '<div class="thing-panel-' . esc_attr( $slug ) . $draft_class . '">';


    // Admin Tools
    if (current_user_can('manage_options')) {
        $template_file = get_stylesheet_directory() . "/firefly-admin-thing.php";
        if (file_exists($template_file)) include $template_file;
    }





    // Image
    if (has_post_thumbnail()) {
        
        echo '<div class="thing-image-' . esc_attr($slug) . '">';

           if ($haslinks == 1) {
            echo "<a href='$link'>";
        }


        echo get_the_post_thumbnail(get_the_ID(), 'medium', [
            'style' => 'width:100%;height:100%;object-fit:cover;display:block;',
        ]);

           if ($haslinks == 1) {
            echo "</a>";
        }

        echo '</div>';
    }

    // Info Block
    echo '<div class="thing-info">';

       if ($haslinks == 1) {
            echo "<a href='$link'>";
        }


    echo '<div class="thing-name">' . esc_html(get_the_title()) . '</div>';

       if ($haslinks == 1) {
            echo "</a>";
        }



    // Get description (use excerpt if set, fallback to content)
    $raw_description = get_the_excerpt();

    // Output
    echo '<div class="thing-description">';
    echo  $raw_description;
    echo '</div>';

    foreach ($list_fields as $field_raw) {
        $is_checkbox = str_starts_with($field_raw, '*');
        $field = ltrim($field_raw, '*');
          //  $key = sanitize_key($field);
         $key = thing_meta_key( $field );

        $val = get_post_meta(get_the_ID(), $key, true);

        if ($val !== '') {
            $output = $is_checkbox ? ($val ? '✅' : '❌') : esc_html($val);
            if (strtolower($field) === 'price') {

                   if ($haslinks == 1) {
                        echo "<a href='$link'>";
                    }

                echo '<div class="thing-price">$ ' . $output . '</div>';

                   if ($haslinks == 1) {
                    echo "</a>";
                }

            } else {
                echo '<div class="thing-field">' . esc_html( $field ) . ': '  . $output . '</div>';
            }
        }
    }

   

    echo '</div>'; // .thing-info
    echo '</div>'; // .thing-panel
}

wp_reset_postdata();
echo "</div>"; // .thing-container



$text_align = get_theme_mod("firefly_thing_text_align_$slug", 'left');

$thing_heading_font_size = get_theme_mod("firefly_thing_heading_size_$slug", '36px');

$thing_description_font_size = get_theme_mod("firefly_thing_description_font_size_$slug", '18px');

$thing_heading_font_family = get_theme_mod("firefly_thing_heading_font_$slug", '18px');
$thing_description_font_family = get_theme_mod("firefly_thing_description_font_$slug", '18px');



$thing_heading_font_family = get_theme_mod("firefly_thing_heading_font_$slug", '18px');
$thing_description_font_family = get_theme_mod("firefly_thing_description_font_$slug", '18px');

$thing_custom_fields_font_size = get_theme_mod("firefly_thing_custom_fields_font_size_$slug", '18px');
$thing_headng_padding_top = get_theme_mod("firefly_panel_heading_padding_top_$slug", '18px');
$thing_headng_padding_bottom = get_theme_mod("firefly_panel_heading_padding_bottom_$slug", '18px');
$thing_description_padding_bottom = get_theme_mod("firefly_panel_description_padding_bottom_$slug", '18px');
$firefly_panel_padding_leftright = get_theme_mod("firefly_panel_padding_leftright_$slug", '10px');

$panel_padding_bottom = get_theme_mod("firefly_panel_padding_bottom_$slug", '10px');
$thing_heading_weight = get_theme_mod("firefly_thing_heading_weight_$slug", '10px');


// === Output CSS
echo "
<style>


/* these styles come from firefly-thing-style-list.php */


.thing-container-$slug {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    gap: 30px;
    padding: 20px;
    background: {$background_colour};
}

.thing-panel-$slug {
    background: {$panel_colour};
    border: {$panel_border} solid {$line_colour};
    width: 100%;
    text-align: {$text_align};
}

.thing-panel-$slug:hover {
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.12);
}

.thing-image-$slug {
    width: {$thumb_width}px;
    height: {$thumb_height}px;
    overflow: hidden;
    float:right;
    margin-left:10px;
    margin-bottom:10px;
}




.thing-image-$slug img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
}

.thing-name {
    font-family:{$thing_heading_font_family};
    font-size: {$thing_heading_font_size};
    font-weight: 600;
    color: {$heading_colour};
    line-height: 1.4;
    margin-bottom: 6px;
}

.thing-info {
    font-family:{$thing_description_font_family};
    padding: 16px 20px 22px;
    display: flex;
    flex-direction: column;
    gap: 6px;
    font-family: 'Segoe UI', sans-serif;
}


.thing-field {
   font-family:{$thing_description_font_family};
    font-size: {$thing_description_font_size};
     color: {$text_colour};
    line-height: 1.3;
}

.thing-price {
    font-size: 1.1rem;
    font-weight: 600;
    color: #0071c2;
    margin-top: 4px;
    margin-bottom: 8px;
}


.thing-link,
.thing-link:hover,
.thing-link:visited,
.thing-link:active {
    text-decoration: none !important;
}

.thing-link * {
    text-decoration: none !important;
}

.thing-link .thing-name {
    text-decoration: none !important;
}


        .firefly-draft          { filter: grayscale(1);  }
.firefly-draft img      { filter: grayscale(1);  }

.firefly-draft .thing-name,
.firefly-draft .thing-field,
.firefly-draft .thing-description {
    color:#777 !important;
    text-decoration:line-through;
}


</style>
";
?>
