<?php


// ===== Mobile Menu =====
$menu_logo_mobile           = get_theme_mod('firefly_menu_mobile_logo', '');
$menu_phone_number          = get_theme_mod('firefly_menu_phone_number', '');
$menu_phone_icon_url        = get_theme_mod('firefly_menu_phone_icon', '');
$menu_phone_icon_height     = get_theme_mod('firefly_menu_phone_icon_height', '40');
$menu_phone_bg_color        = get_theme_mod('firefly_menu_phone_bg_color', '#ffff00');
$firefly_menu_hamburger_text = get_theme_mod('firefly_menu_hamburger_text', '');



?>

<div class="mobile-menu-bar" style="display:flex;justify-content:space-between;align-items:center;padding:0;height:70px;">
  <!-- Mobile Logo -->
  <?php if ($menu_logo_mobile): ?>
    <a href="<?php echo esc_url(home_url('/')); ?>" class="mobile-menu-logo" style="display:flex;align-items:center;">
      <img src="<?php echo esc_url($menu_logo_mobile); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
    </a>
  <?php endif; ?>

  <!-- Right: Hamburger + Phone -->
  <div class="mobile-menu-right" style="display:flex;align-items:center;flex-direction:row-reverse;gap:0;">
    <?php if ($menu_phone_number && $menu_phone_icon_url): ?>
      <a href="tel:<?php echo esc_attr(preg_replace('/\D+/', '', $menu_phone_number)); ?>"
         class="mobile-menu-phone"
         style="display:flex;align-items:center;background-color:<?php echo esc_attr($menu_phone_bg_color); ?>;padding:0 10px;height:70px;">
        <img src="<?php echo esc_url($menu_phone_icon_url); ?>" alt="Phone Icon"
             style="height:<?php echo intval($menu_phone_icon_height); ?>px;width:auto;">
      </a>
    <?php endif; ?>

    <button class="mobile-menu-toggle" aria-label="Toggle menu"
            style="background:none;border:none;font-size:28px;padding:0 15px;height:70px;display:flex;align-items:center;cursor:pointer;"><?php
            
            if ($firefly_menu_hamburger_text) {
              echo "<span style='font-size:16px;'>MENU</span> ";
            }
            
            ?>&#9776;
    </button>
  </div>
</div>

<nav class="mobile-menu" style="display:none;">
  <?php
  wp_nav_menu([
    'theme_location' => 'main-menu',
    'container'      => false,
    'menu_class'     => '',
    'fallback_cb'    => false,
  ]);
  ?>
</nav>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const toggle = document.querySelector('.mobile-menu-toggle');
  const menu   = document.querySelector('nav.mobile-menu');
  if (!toggle || !menu) return;

  // CSS controls visibility; avoid sticky inline styles
  function showMenu(show) {
    menu.style.display = show ? 'block' : 'none';
    toggle.innerHTML = show ? '✕' : '☰';
  }

  toggle.addEventListener('click', function (e) {
    e.preventDefault();
    const visible = (menu.style.display === 'block');
    showMenu(!visible);
  });

  // Close on resize to desktop
  function handleResize() {
    if (window.innerWidth > 768) {
      showMenu(false);
    }
  }
  window.addEventListener('resize', handleResize);
  handleResize();
});
</script>
