<?php
$banner_subheading = get_theme_mod('firefly_subheading_text', '');

// Heading sizes
$firefly_heading_size_text_only         = get_theme_mod('firefly_heading_size_text_only', '60px');
$firefly_heading_size_tablet_text_only  = get_theme_mod('firefly_heading_size_tablet_text_only', '40px');
$firefly_heading_size_mobile_text_only  = get_theme_mod('firefly_heading_size_mobile_text_only', '30px');

// Subheading sizes (reuse keys from the other page)
$subheading_size_text_only        = get_theme_mod('firefly_subheading_size_text_only', '30px');
$subheading_size_tablet_text_only = get_theme_mod('firefly_subheading_size_tablet_text_only', '20px');
$subheading_size_mobile_text_only = get_theme_mod('firefly_subheading_size_mobile_text_only', '20px');

// New heading/subheading spacing controls from the other page
$heading_space_bottom_desktop = get_theme_mod('firefly_heading_space_bottom_desktop', '0px');
$heading_space_bottom_tablet  = get_theme_mod('firefly_heading_space_bottom_tablet', '0px');
$heading_space_bottom_mobile  = get_theme_mod('firefly_heading_space_bottom_mobile', '0px');

$subheading_padding_top    = get_theme_mod('firefly_subheading_padding_top', '0px');
$subheading_padding_bottom = get_theme_mod('firefly_subheading_padding_bottom', '0px');

// Existing text-only paddings (keep top for heading from this page)
$firefly_text_only_heading_padding_top = get_theme_mod('firefly_text_only_heading_padding_top', '10px');

// Line controls (keep existing bottom line for heading; add top line for subheading from other page)
$show_line_between  = get_theme_mod('firefly_show_line_between', '');
$line_width         = absint(get_theme_mod('firefly_line_width', 1));
$line_color         = sanitize_hex_color(get_theme_mod('firefly_line_color', '#000000'));
$line_space_above   = get_theme_mod('firefly_line_space_above', '10px');

?>
<div class="firefly-text-only">
    <div class="firefly-banner-text-textonly">
        <?php echo esc_html($banner_text); ?>
    </div>

    <div class="firefly-banner-subheading">
        <?php echo esc_html($banner_subheading); ?>
    </div>
</div>

<?php
$firefly_banner_font_family              = get_theme_mod('firefly_banner_font_family', 'Arial, sans-serif');
$firefly_banner_background_color_text_only = get_theme_mod('firefly_banner_background_color_text_only', '#ffffff');
$firefly_banner_font_weight              = get_theme_mod('firefly_banner_font_weight', 'normal');
$line_height                             = get_theme_mod('firefly_banner_line_height', '80%');
$firefly_banner_text_color               = get_theme_mod('firefly_banner_text_color_text_only', '#ffffff');

echo "<style id='firefly-header-css'>

/* BANNER STYLES */
.firefly-text-only {
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    text-align: center;
    width: 100%;
    position: relative;
    color: {$firefly_banner_text_color};
    font-family: {$firefly_banner_font_family};
    font-weight: {$firefly_banner_font_weight};
    line-height: {$line_height};
    height: auto;
    background-color: {$firefly_banner_background_color_text_only};
}

.firefly-banner-text-textonly {
    position: relative;
    z-index: 2;
    max-width: 1200px;
    word-wrap: break-word;
    hyphens: auto;
    line-height: {$line_height};
    margin: 0 auto;
    padding-top: {$firefly_text_only_heading_padding_top};
    padding-bottom: {$heading_space_bottom_desktop};
    font-size: {$firefly_heading_size_text_only};";

if ($show_line_between) {
    echo "
    border-bottom: {$line_width}px {$line_color} solid;
    /* preserve spacing choice from this page */
    padding-bottom: {$line_space_above};";
}

echo "
}

.firefly-banner-subheading {
    line-height: {$line_height};
    margin: 0 auto;
    font-size: {$subheading_size_text_only};
    padding-top: {$subheading_padding_top};
    padding-bottom: {$subheading_padding_bottom};";

if ($show_line_between) {
    // add the subheading line from the other page (keep white as per source)
   // echo "   border-top: 2px solid white;";
}

echo "
}

/* DESKTOP */
@media (min-width: 1025px) {
    .firefly-text-only { min-height: 250px; }
}

/* TABLET */
@media (min-width: 601px) and (max-width: 1024px) {
    .firefly-text-only { min-height: 200px; }

    .firefly-banner-text-textonly {
        font-size: {$firefly_heading_size_tablet_text_only};
        padding-bottom: {$heading_space_bottom_tablet};
    }

    .firefly-banner-subheading {
        font-size: {$subheading_size_tablet_text_only};
    }
}

/* MOBILE */
@media (max-width: 600px) {
    .firefly-text-only {
        min-height: 150px;
        padding: 20px 10px;
    }

    .firefly-banner-text-textonly {
        font-size: {$firefly_heading_size_mobile_text_only};
        padding-bottom: {$heading_space_bottom_mobile}
    }

    .firefly-banner-subheading {
        font-size: {$subheading_size_mobile_text_only};
    }
}

/* Custom min-heights driven by existing controls */
@media (min-width: 1025px) {
    .firefly-text-only { min-height: " . get_theme_mod('firefly_banner_height_desktop', 400) . "px; }
}
@media (min-width: 701px) and (max-width: 1024px) {
    .firefly-text-only { min-height: " . get_theme_mod('firefly_banner_height_tablet', 300) . "px; }
}
@media (max-width: 700px) {
    .firefly-text-only { min-height: " . get_theme_mod('firefly_banner_height_mobile', 250) . "px; }
}

/* (left intact from original file, if you use it elsewhere)
margin-top: \$firefly_header_margin_top_mobile;
*/
</style>";
