<?php


$logo_pc     = get_theme_mod('my_plugin_logo_pc'); // used in the image tag
$logo_mobile = get_theme_mod('my_plugin_logo_mobile'); // used in the image tag

?><div class="banner-with-phone">
  <div class="firefly-logo-wrap">
    <?php if (!empty($logo_pc)) : ?>
      <img class="firefly-logo-pc" src="<?php echo esc_url($logo_pc); ?>" alt="Site Logo">
    <?php endif; ?>

    <?php if (!empty($logo_mobile)) { ?>
      <div class="logo-mobile">
        <img class="firefly-logo-mobile" src="<?php echo esc_url($logo_mobile); ?>" alt="Mobile Logo">
      </div>
    <?php 
}
else
{
echo "empty";
}
?>
  </div>

  <div class="banner-extracontent">
    <?php
    $phone_position = get_theme_mod('firefly_logo_phone_position', 'top');
    $phone_number = get_theme_mod('firefly_logo_phone_number', '');
    $phone_prefix = get_theme_mod('firefly_logo_phone_prefix', '');
    $icon_height = get_theme_mod('firefly_logo_icon_height', '150px');


    $icons = [];
for ($i = 1; $i <= 4; $i++) {
    $icon_url = get_theme_mod("firefly_logo_icon_{$i}", '');
    $icon_link = get_theme_mod("firefly_logo_icon_{$i}_link", '');

    if ($icon_url) {
        $icons[] = [
            'url'  => $icon_url,
            'link' => $icon_link,
        ];
    }
}




if (!empty($icons)) {
    echo '<div class="banner-icons">';
    foreach ($icons as $icon) {
        $img_tag = "<img src='" . esc_url($icon['url']) . "' alt='Icon' style='height:$icon_height;margin-left:10px;'>";
        if (!empty($icon['link'])) {
            echo "<a href='" . esc_url($icon['link']) . "' target='_blank' rel='noopener'>$img_tag</a>";
        } else {
            echo $img_tag;
        }
    }
    echo '</div>';
}

    if ($phone_position == "top" && $phone_number) {
        echo "<div class=\"banner-phonenumber\">$phone_prefix <a href=\"tel:$phone_number\">$phone_number</a></div>";
    }

    $other_text = get_theme_mod('firefly_logo_other_text', '');
    if ($other_text) {
        $other_text = str_replace("\n", "<br>", $other_text);
        echo "<div class=\"banner-othertext\">$other_text</div>";
    }

    if ($phone_position != "top" && $phone_number) {
        echo "<div class=\"banner-phonenumber\">$phone_prefix <a href=\"tel:$phone_number\">$phone_number</a></div>";
    }
    ?>
  </div>
</div>



    <?php


$logo_size_desktop = get_theme_mod('my_plugin_logo_size_desktop', '980px'); // used in CSS
$logo_size_tablet  = get_theme_mod('my_plugin_logo_size_tablet', '780px');  // used in media query
$logo_size_mobile  = get_theme_mod('my_plugin_logo_size_mobile', '560px');  // used in media query

$logo_max_width    = get_theme_mod('my_plugin_logo_max_width', '90%'); // used in `.firefly-logo-wrap`
$padding_top       = get_theme_mod('my_plugin_logo_padding_top', '0px'); // used in `.firefly-logo-wrap`
$padding_bottom    = get_theme_mod('my_plugin_logo_padding_bottom', '0px'); // used in `.firefly-logo-wrap`
$padding_leftright = get_theme_mod('my_plugin_logo_padding_leftright', '0px'); // used in `.firefly-logo-wrap`
$bg_colour         = get_theme_mod('my_plugin_logo_background', '#ffffff'); // used in `.firefly-logo-wrap`

$my_plugin_logo_size_breakpoint = get_theme_mod('my_plugin_logo_size_breakpoint', '800px'); // used in media query
$logo_only_align = get_theme_mod('my_plugin_logo_only_alignment', 'center'); // used in inline `style=`


$phone_font           = get_theme_mod('firefly_logo_phone_font', 'default');
$phone_size           = get_theme_mod('firefly_logo_phone_size', '18px');
$phone_color          = get_theme_mod('firefly_logo_phone_color', '#000000');

$phone_margin_top          = get_theme_mod('firefly_logo_phone_margin_top', '18px');
$phone_margin_bottom           = get_theme_mod('firefly_logo_phone_margin_bottom', '18px');
$logo_phone_vertical_align          = get_theme_mod('firefly_logo_phone_vertical_align', 'top');



$other_font           = get_theme_mod('firefly_logo_other_font', 'default');
$other_size           = get_theme_mod('firefly_logo_other_size', '18px');
$other_color          = get_theme_mod('firefly_logo_other_color', '#000000');
$banner_bkgnd_color   = get_theme_mod('firefly_banner_background_color', '#ffffff');

$logo_padding_top  = get_theme_mod('firefly_logo_padding_top', '0px');
$logo_padding_leftright   = get_theme_mod('firefly_logo_padding_leftright', '0px');
$logo_padding_bottom   = get_theme_mod('firefly_logo_padding_bottom', '0px');



echo "<style>";

$align_css = match ($logo_phone_vertical_align) {
    'middle' => 'center',
    'bottom' => 'flex-end',
    default  => 'flex-start',
};

echo "

/* Container that holds logo + phone/text */
.banner-with-phone {
    display: flex;
    justify-content: space-between;
      align-items: {$align_css};
    flex-wrap: wrap;
    width: 100%;
    box-sizing: border-box;
    background-color:{$banner_bkgnd_color} !important;
    xx:xxx;
}

/* Logo wrapper */
.firefly-logo-wrap {
    flex: 1;
    display: flex;
    align-items: center;
    padding-top: {$logo_padding_top};
    padding-bottom: {$logo_padding_bottom};
    padding-left: {$logo_padding_leftright};
    padding-right: {$logo_padding_leftright};
    background-color: {$banner_bkgnd_color};
    max-width: {$logo_max_width};
    margin-top:0px !important;
}

/* Extra content container */
.banner-extracontent {
    flex: 1;
    display: flex;
    flex-direction: column;
    justify-content: {$align_css};
    align-items: flex-end;
    padding: 10px;
}



/* Phone number */
.banner-phonenumber {
    font-family: {$phone_font};
    font-size: {$phone_size};
    color: {$phone_color};
    text-align: right;
    margin-top: {$phone_margin_top};
    margin-bottom: {$phone_margin_bottom};
}

.banner-phonenumber a {
    color: {$phone_color} !important;
}

/* Additional text */
.banner-othertext {
    font-family: {$other_font};
    font-size: {$other_size};
    color: {$other_color};
    text-align: right;
    line-height: 120%;
}

/* Logo styling */
.firefly-logo-pc,
.firefly-logo-mobile {
    max-width: 100%;
    height: auto;
    float: left;
}

.firefly-logo-pc {
    width: {$logo_size_desktop};
    z-index: 1;
}

.firefly-logo-mobile {
    width: {$logo_size_mobile} !important;
    display: none;
}



/* Tablet breakpoints */
@media (min-width: 601px) and (max-width: 1024px) {
    .firefly-logo-pc,
    .firefly-logo-mobile {
        width: {$logo_size_tablet} !important;
    }
}

/* Mobile fallback */
@media (max-width: 600px) {

  /* turn the whole container back into block layout */
  .banner-with-phone {
    display: block !important;
  }

  /* make every child take 100% and drop any floats */
  .firefly-logo-wrap,
  .banner-extracontent,
  .banner-icons,
  .banner-phonenumber,
  .firefly_othertext {
    width: 100% !important;
    float: none !important;
    display: block !important;
    margin: 0 auto !important;
    text-align: center;
  }

  /* force both logo variants to be 100% wide, no float */
  .firefly-logo-pc,
  .firefly-logo-mobile {
    float: none !important;
    width: 100% !important;
    max-width: 100% !important;
    height: auto !important;
    margin: 0 auto !important;
  }

}

/* Responsive logo switching */
@media (max-width: {$my_plugin_logo_size_breakpoint}) {
    .firefly-logo-pc {
        display: none !important;
    }
    .firefly-logo-mobile {
        display: block;
        margin: 0 auto;
    }
}


";

echo "</style>";

