<?php

    $logo_pc     = get_theme_mod('my_plugin_logo_pc'); // used in the image tag
$logo_mobile = get_theme_mod('my_plugin_logo_mobile'); // used in the image tag

$logo_size_desktop = get_theme_mod('my_plugin_logo_size_desktop', '980px'); // used in CSS
$logo_size_tablet  = get_theme_mod('my_plugin_logo_size_tablet', '780px');  // used in media query
$logo_size_mobile  = get_theme_mod('my_plugin_logo_size_mobile', '560px');  // used in media query

$logo_max_width    = get_theme_mod('my_plugin_logo_max_width', '90%'); // used in `.firefly-logo-wrap`
$padding_top       = get_theme_mod('my_plugin_logo_padding_top', '0px'); // used in `.firefly-logo-wrap`
$padding_bottom    = get_theme_mod('my_plugin_logo_padding_bottom', '0px'); // used in `.firefly-logo-wrap`
$padding_leftright = get_theme_mod('my_plugin_logo_padding_leftright', '0px'); // used in `.firefly-logo-wrap`
$bg_colour         = get_theme_mod('my_plugin_logo_background', '#ffffff'); // used in `.firefly-logo-wrap`

$my_plugin_logo_size_breakpoint = get_theme_mod('my_plugin_logo_size_breakpoint', '800px'); // used in media query
$logo_only_align = get_theme_mod('my_plugin_logo_only_alignment', 'center'); // used in inline `style=`

?><div class="firefly-logo-wrap">
    <?php if (!empty($logo_pc)) : ?>
        <img class="firefly-logo-pc" src="<?php echo esc_url($logo_pc); ?>" alt="Site Logo">
    <?php endif; ?>

    <?php if (!empty($logo_mobile)) : ?>
        <div class="logo-mobile">
            <img class="firefly-logo-mobile" src="<?php echo esc_url($logo_mobile); ?>" alt="Mobile Logo">
        </div>
    <?php endif; ?>
</div>



    <?php


echo "<style id='firefly-header-css'>

/* LOGO WRAPPER */
.firefly-logo-wrap {
    padding-top: {$padding_top};
    padding-bottom: {$padding_bottom};
    padding-left: {$padding_leftright};
    padding-right: {$padding_leftright};
    background-color: {$bg_colour};
    max-width: {$logo_max_width};
    margin-left: auto;
    margin-right: auto;
    position: relative;

      display: flex;
    align-items: center;

    ";
    // Horizontal alignment
    if ($logo_only_align === 'left') {
        echo "justify-content: flex-start;";
    } elseif ($logo_only_align === 'right') {
        echo "justify-content: flex-end;";
    } else {
        echo "justify-content: center;";
    }

echo "

}

/* DESKTOP + MOBILE IMAGES */
.firefly-logo-pc,
.firefly-logo-mobile {
    max-width: 100%;
    height: auto;
}

/* Desktop logo default */
.firefly-logo-pc {
    width: {$logo_size_desktop};
    z-index: 1;
}

/* Mobile logo default hidden */
.firefly-logo-mobile {
    width: {$logo_size_mobile} !important;
    display: none;
}

/* Show/hide and size switch based on breakpoint */
@media (min-width: 601px) and (max-width: 1024px) {
    .firefly-logo-pc {
        width: {$logo_size_tablet} !important;
    }
    .firefly-logo-mobile {
        width: {$logo_size_tablet} !important;
    }
}

@media (max-width: 600px) {
    .firefly-logo-pc {
        width: {$logo_size_mobile} !important;
    }
    .firefly-logo-mobile {
        width: {$logo_size_mobile} !important;
    }
}

@media (max-width: {$my_plugin_logo_size_breakpoint}) {
    .firefly-logo-pc {
        display: none !important;
    }
    .firefly-logo-mobile {
        display: block;
        margin: 0 auto;
    }
}

</style>";
