<?php



$subheading_text= get_theme_mod('firefly_subheading_text', '');


echo '<div class="firefly-banner-only">
<div class="firefly-banner-text-wrapper">
        <div class="firefly-banner-text"> <div class="firefly-banner-heading">';
  echo esc_html($banner_text); 
    echo "</div>\n\r";

  if ($subheading_text) {
    echo "<div class='firefly-banner-subheading' >";
    echo $subheading_text;
    echo "</div>\n\r";
  }

     echo '       </div> </div>
    </div>
';


$firefly_banner_text_color = get_theme_mod('firefly_banner_text_color', '#ffffff');
$firefly_banner_text_size = get_theme_mod('firefly_banner_text_size', '60px');
$firefly_banner_text_size_tablet = get_theme_mod('firefly_banner_text_size_tablet', '48px');
$firefly_banner_text_size_mobile = get_theme_mod('firefly_banner_text_size_mobile', '36px');
$firefly_banner_font_family = get_theme_mod('firefly_banner_font_family', 'Arial, sans-serif');



$subheading_size_text_only = get_theme_mod('firefly_subheading_size_text_only', '30px');
$subheading_size_tablet_text_only = get_theme_mod('firefly_subheading_size_tablet_text_only', '20px');
$subheading_size_mobile_text_only = get_theme_mod('firefly_subheading_size_mobile_text_only', '20px');


$heading_space_bottom_desktop = get_theme_mod('firefly_heading_space_bottom_desktop', '0px');
$heading_space_bottom_tablet = get_theme_mod('firefly_heading_space_bottom_tablet', '0px');
$heading_space_bottom_mobile = get_theme_mod('firefly_heading_space_bottom_mobile', '0px');


$subheading_padding_top = get_theme_mod('firefly_subheading_padding_top', '0px');
$subheading_padding_bottom = get_theme_mod('firefly_subheading_padding_bottom', '0px');


$firefly_banner_font_weight = get_theme_mod('firefly_banner_font_weight', 'normal');
$firefly_banner_desktop = get_theme_mod('firefly_banner_desktop', '');
$firefly_banner_tablet = get_theme_mod('firefly_banner_tablet', '');
$firefly_banner_mobile = get_theme_mod('firefly_banner_mobile', '');
$overlay_opacity = intval(get_theme_mod('firefly_banner_darken', 0)) / 100;
$line_height = get_theme_mod('firefly_banner_line_height', '80%');
$bg_style        = get_theme_mod('firefly_banner_background_style', 'cover');

$show_line_between = get_theme_mod('firefly_show_line_between', '');


$firefly_banner_height_desktop = get_theme_mod('firefly_banner_height_desktop', '400px');


    // Background style (assuming cover is default)

echo "<style id='firefly-header-css'>

.firefly-banner-only::before {
    content: '';
    position: absolute;
    inset: 0;
   /* background-color: rgba(0, 0, 0, $overlay_opacity);*/
    z-index: 1;
}

/* BANNER STYLES */
.firefly-banner-only {
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    text-align: center;
    padding: 40px 20px;
    width: 100%;
    position: relative;
    color: {$firefly_banner_text_color};
    font-size: {$firefly_banner_text_size};
    font-family: {$firefly_banner_font_family};
    grey:grey;
    font-weight: {$firefly_banner_font_weight};
    line-height: {$line_height};
    background-image: url('{$firefly_banner_desktop}');
      background-position: center center;
    background-repeat: " . (in_array($bg_style, ['repeat', 'repeat-x', 'repeat-y']) ? $bg_style : 'no-repeat') . ";
    background-size: " . (in_array($bg_style, ['cover', 'contain']) ? $bg_style : 'auto') . ";
    height: auto;
}



.firefly-banner-text {
    position: relative;
    z-index: 2;
    max-width: 1200px;
    word-wrap: break-word;
    hyphens: auto;
    line-height: {$line_height};
    margin: 0 auto;

";
    
if ($show_line_between) {
    echo "
    border-bottom: {$line_width}px {$line_color} solid;
    /* preserve spacing choice from this page */
    padding-bottom: {$line_space_above};";
}
 
echo "
}


.firefly-banner-heading {
  padding-bottom: {$heading_space_bottom_desktop};
}



.firefly-banner-subheading {
	line-height: {$line_height};
    margin: 0 auto;
	font-size: {$subheading_size_text_only};
    padding-bottom:{$subheading_padding_bottom};
    padding-top:{$subheading_padding_top};
    ";

    if ($show_line_between) {
        // echo "border-top:2px solid white ;\n\r"; 
    }

    echo "
}
/* RESPONSIVE STYLES */
@media (min-width: 1025px) {
    .firefly-text-only {
        min-height: 250px;
    }
}



/* RESPONSIVE STYLES */
@media (min-width: 1025px) {
    .firefly-banner-only {
        font-size: {$firefly_banner_text_size};
        background-image: url('{$firefly_banner_desktop}');
        min-height: 250px;
    }
}

@media (min-width: 601px) and (max-width: 1024px) {
    .firefly-banner-only {
        font-size: {$firefly_banner_text_size_tablet};
        background-image: url('{$firefly_banner_tablet}');
        min-height: 200px;
    }

     .firefly-banner-subheading {
        font-size: {$subheading_size_tablet_text_only};
    }
}

@media (max-width: 600px) {
    .firefly-banner-only {
        font-size: {$firefly_banner_text_size_mobile};
        background-image: url('{$firefly_banner_mobile}');
        min-height: 150px;
        padding: 20px 10px;
    }

    .firefly-banner-subheading {
        font-size: {$subheading_size_mobile_text_only};
    }
}

/* Custom min-heights */
@media (min-width: 1025px) {
    .firefly-banner-only {
        min-height: " . get_theme_mod('firefly_banner_height_desktop', 400) . "px;
    }
}

@media (min-width: 701px) and (max-width: 1024px) {
    .firefly-banner-only {
        min-height: " . get_theme_mod('firefly_banner_height_tablet', 300) . "px;
    }
}

@media (max-width: 700px) {
    .firefly-banner-only {
        min-height: " . get_theme_mod('firefly_banner_height_mobile', 250) . "px;
    }
}

</style>";
