<?php

/* =========================
 * 1) Catalog + helpers
 * ========================= */

if ( ! function_exists('firefly_google_fonts_catalog') ) {
    function firefly_google_fonts_catalog() {
        return [
            // First from your list
          'Abril Fatface, cursive' => [
        'label'   => 'Abril Fatface (dramatic, elegant)',
        'weights' => ['400'],
    ],
    'Aclonica, sans-serif' => [
        'label'   => 'Aclonica (negative space cuts)',
        'weights' => ['400'],
    ],
    'Alegreya, serif' => [
        'label'   => 'Alegreya (dynamic, readable)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Aleo, serif' => [
        'label'   => 'Aleo (contemporary, slab-serif)',
        'weights' => ['300','400','700'],
    ],
    'Almendra Display, cursive' => [
        'label'   => 'Almendra Display (ancient coin)',
        'weights' => ['400'],
    ],
    'Amarante, cursive' => [
        'label'   => 'Amarante (Art Nouveau-inspired shapes)',
        'weights' => ['400'],
    ],
    'Anton, sans-serif' => [
        'label'   => 'Anton (strong, impactful)',
        'weights' => ['400'],
    ],
    'Archivo Narrow, sans-serif' => [
        'label'   => 'Archivo Narrow (condensed, versatile)',
        'weights' => ['400','500','600','700'],
    ],
    'Arial, sans-serif' => [
        'label'   => 'Arial (classic, neutral)',
        'weights' => ['400','700'],
    ],
    'Arvo, serif' => [
        'label'   => 'Arvo (geometric, slab-serif)',
        'weights' => ['400','700'],
    ],
    'Audiowide, cursive' => [
        'label'   => 'Audiowide (perfect circles)',
        'weights' => ['400'],
    ],
    'Bacasime Antique, serif' => [
        'label'   => 'Bacasime Antique (classic, antique style)',
        'weights' => ['400'],
    ],
    'Bangers, cursive' => [
        'label'   => 'Bangers (comic, bold, display)',
        'weights' => ['400'],
    ],
    'Barlow, sans-serif' => [
        'label'   => 'Barlow (contemporary, versatile)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Bayon, sans-serif' => [
        'label'   => 'Bayon (angular Khmer style)',
        'weights' => ['400'],
    ],
    'Bebas Neue, sans-serif' => [
        'label'   => 'Bebas Neue (clean, display)',
        'weights' => ['400'],
    ],
    'Bitter, serif' => [
        'label'   => 'Bitter (contemporary, readable)',
        'weights' => ['400','500','600','700','800'],
    ],
    'Black Ops One, sans-serif' => [
        'label'   => 'Black Ops One (military stencil)',
        'weights' => ['400'],
    ],
    'Blaka Hollow, cursive' => [
        'label'   => 'Blaka Hollow (batik cutouts)',
        'weights' => ['400'],
    ],
    'Bodoni Moda, serif' => [
        'label'   => 'Bodoni Moda (fashion, high-contrast)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Bowlby One, sans-serif' => [
        'label'   => 'Bowlby One (movie poster)',
        'weights' => ['400'],
    ],
    'Brush Script MT, cursive' => [
        'label'   => 'Brush Script MT (casual, artistic)',
        'weights' => ['400'],
    ],
    'Bungee, sans-serif' => [
        'label'   => 'Bungee (urban street-style)',
        'weights' => ['400'],
    ],
    'Bungee Shade, sans-serif' => [
        'label'   => 'Bungee Shade (3D shadow effect)',
        'weights' => ['400'],
    ],
    'Butterfly Kids, cursive' => [
        'label'   => 'Butterfly Kids (flower stems)',
        'weights' => ['400'],
    ],
    'Cabin, sans-serif' => [
        'label'   => 'Cabin (contemporary, friendly)',
        'weights' => ['400','500','600','700'],
    ],
    'Chango, cursive' => [
        'label'   => 'Chango (playful deco shapes)',
        'weights' => ['400'],
    ],
    'Cinzel, serif' => [
        'label'   => 'Cinzel (classic, Roman-style headings)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Coda Caption, sans-serif' => [
        'label'   => 'Coda Caption (compact, bold)',
        'weights' => ['800'],
    ],
    'Codystar, cursive' => [
        'label'   => 'Codystar (constellation lines)',
        'weights' => ['300','400'],
    ],
    'Concert One, cursive' => [
        'label'   => 'Concert One (bold, fun)',
        'weights' => ['400'],
    ],
    'Condiment, cursive' => [
        'label'   => 'Condiment (condensed, playful)',
        'weights' => ['400'],
    ],
    'Cormorant Garamond, serif' => [
        'label'   => 'Cormorant Garamond (classic, refined)',
        'weights' => ['300','400','500','600','700'],
    ],
    'Courier New, monospace' => [
        'label'   => 'Courier New (technical, classic)',
        'weights' => ['400','700'],
    ],
    'Creepster, cursive' => [
        'label'   => 'Creepster (horror punk dripping style)',
        'weights' => ['400'],
    ],
    'Dancing Script, cursive' => [
        'label'   => 'Dancing Script (swirling elegance)',
        'weights' => ['400','500','600','700'],
    ],
    'DotGothic16, sans-serif' => [
        'label'   => 'DotGothic16 (pixel dots)',
        'weights' => ['400'],
    ],
    'Dosis, sans-serif' => [
        'label'   => 'Dosis (light, rounded)',
        'weights' => ['200','300','400','500','600','700','800'],
    ],
    'Eater, cursive' => [
        'label'   => 'Eater (vampire punk)',
        'weights' => ['400'],
    ],
    'Emilys Candy, cursive' => [
        'label'   => 'Emilys Candy (sweet wrappers)',
        'weights' => ['400'],
    ],
    'Exo 2, sans-serif' => [
        'label'   => 'Exo 2 (tech-inspired, readable)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Fascinate, cursive' => [
        'label'   => 'Fascinate (comic book)',
        'weights' => ['400'],
    ],
    'Fasthand, serif' => [
        'label'   => 'Fasthand (Asian brush strokes)',
        'weights' => ['400'],
    ],
    'Faster One, cursive' => [
        'label'   => 'Faster One (speed lines)',
        'weights' => ['400'],
    ],
    'Fira Sans, sans-serif' => [
        'label'   => 'Fira Sans (technical, clean)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Fjalla One, sans-serif' => [
        'label'   => 'Fjalla One (bold, compact headings)',
        'weights' => ['400'],
    ],
    'Francois One, sans-serif' => [
        'label'   => 'Francois One (rounded, headline)',
        'weights' => ['400'],
    ],
    'Freckle Face, cursive' => [
        'label'   => 'Freckle Face (spray-paint texture)',
        'weights' => ['400'],
    ],
    'Frijole, cursive' => [
        'label'   => 'Frijole (Day of the Dead)',
        'weights' => ['400'],
    ],
    'Georgia, serif' => [
        'label'   => 'Georgia (elegant, classic)',
        'weights' => ['400','700'],
    ],
    'Gothic A1, sans-serif' => [
        'label'   => 'Gothic A1 (modern gothic style)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Gravitas One, serif' => [
        'label'   => 'Gravitas One (bold, slab-serif display)',
        'weights' => ['400'],
    ],
    'Great Vibes, cursive' => [
        'label'   => 'Great Vibes (calligraphic flair)',
        'weights' => ['400'],
    ],
    'Helvetica, sans-serif' => [
        'label'   => 'Helvetica (clean, versatile)',
        'weights' => ['400','700'],
    ],
    'Henny Penny, cursive' => [
        'label'   => 'Henny Penny (medieval manuscript)',
        'weights' => ['400'],
    ],
    'Hind, sans-serif' => [
        'label'   => 'Hind (simple, readable)',
        'weights' => ['300','400','500','600','700'],
    ],
    'IBM Plex Sans, sans-serif' => [
        'label'   => 'IBM Plex Sans (technical, professional)',
        'weights' => ['100','200','300','400','500','600','700'],
    ],
    'Inconsolata, monospace' => [
        'label'   => 'Inconsolata (monospace, technical)',
        'weights' => ['200','300','400','500','600','700','800','900'],
    ],
    'Inter, sans-serif' => [
        'label'   => 'Inter (neutral, readable)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Irish Grover, cursive' => [
        'label'   => 'Irish Grover (Celtic knots)',
        'weights' => ['400'],
    ],
    'Josefin Sans, sans-serif' => [
        'label'   => 'Josefin Sans (geometric, elegant)',
        'weights' => ['100','200','300','400','500','600','700'],
    ],
    'Kanit, sans-serif' => [
        'label'   => 'Kanit (condensed, modern Thai-style)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Karla, sans-serif' => [
        'label'   => 'Karla (minimalist, clean)',
        'weights' => ['200','300','400','500','600','700','800'],
    ],
    'Kranky, cursive' => [
        'label'   => 'Kranky (Halloween spooky)',
        'weights' => ['400'],
    ],
    'Lato, sans-serif' => [
        'label'   => 'Lato (warm, sophisticated)',
        'weights' => ['100','300','400','700','900'],
    ],
    'League Gothic, sans-serif' => [
        'label'   => 'League Gothic (tall, narrow, vintage)',
        'weights' => ['400'],
    ],
    'Libre Baskerville, serif' => [
        'label'   => 'Libre Baskerville (traditional, readable)',
        'weights' => ['400','700'],
    ],
    'Limelight, sans-serif' => [
        'label'   => 'Limelight (Broadway marquee)',
        'weights' => ['400'],
    ],
    'Lobster, cursive' => [
        'label'   => 'Lobster (50s diner)',
        'weights' => ['400'],
    ],
    'Luckiest Guy, cursive' => [
        'label'   => 'Luckiest Guy (comic, bold, fun)',
        'weights' => ['400'],
    ],
    'Major Mono Display, monospace' => [
        'label'   => 'Major Mono Display (hacking terminal)',
        'weights' => ['400'],
    ],
    'MedievalSharp, cursive' => [
        'label'   => 'MedievalSharp (castle inscriptions)',
        'weights' => ['400'],
    ],
    'Merriweather, serif' => [
        'label'   => 'Merriweather (traditional, readable)',
        'weights' => ['300','400','700','900'],
    ],
    'Metal Mania, cursive' => [
        'label'   => 'Metal Mania (engraved metal)',
        'weights' => ['400'],
    ],
    'Metrophobic, sans-serif' => [
        'label'   => 'Metrophobic (streamlined moderne)',
        'weights' => ['400'],
    ],
    'Michroma, sans-serif' => [
        'label'   => 'Michroma (retro-futuristic)',
        'weights' => ['400'],
    ],
    'Miltonian, cursive' => [
        'label'   => 'Miltonian (woodcut prints)',
        'weights' => ['400'],
    ],
    'Monoton, cursive' => [
        'label'   => 'Monoton (neon tube lights)',
        'weights' => ['400'],
    ],
    'Montserrat, sans-serif' => [
        'label'   => 'Montserrat (geometric, modern)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Mountains of Christmas, cursive' => [
        'label'   => 'Mountains of Christmas (snowy peaks)',
        'weights' => ['400','700'],
    ],
    'Muli, sans-serif' => [
        'label'   => 'Muli (minimalist, versatile)',
        'weights' => ['200','300','400','600','700','800'],
    ],
    'Nabla, cursive' => [
        'label'   => 'Nabla (colorful layered)',
        'weights' => ['400'],
    ],
    'Nasalization, sans-serif' => [
        'label'   => 'Nasalization (space age)',
        'weights' => ['400'],
    ],
    'Neon Tubes, sans-serif' => [
        'label'   => 'Neon Tubes (retro, glowing lines)',
        'weights' => ['400'],
    ],
    'New Rocker, cursive' => [
        'label'   => 'New Rocker (70s metal band)',
        'weights' => ['400'],
    ],
    'Nosifer, cursive' => [
        'label'   => 'Nosifer (zombie apocalypse)',
        'weights' => ['400'],
    ],
    'Noto Sans Cherokee, sans-serif' => [
        'label'   => 'Noto Sans Cherokee (indigenous)',
        'weights' => ['400'],
    ],
    'Noto Sans Linear B, sans-serif' => [
        'label'   => 'Noto Sans Linear B (ancient Greek)',
        'weights' => ['400'],
    ],
    'Noto Sans Mayan, sans-serif' => [
        'label'   => 'Noto Sans Mayan (hieroglyphic)',
        'weights' => ['400'],
    ],
    'Noto Sans Osmanya, sans-serif' => [
        'label'   => 'Noto Sans Osmanya (ancient script)',
        'weights' => ['400'],
    ],
    'Nunito, sans-serif' => [
        'label'   => 'Nunito (rounded, friendly)',
        'weights' => ['200','300','400','600','700','800','900'],
    ],
    'Ojuju, sans-serif' => [
        'label'   => 'Ojuju (Afro-grotesque style)',
        'weights' => ['400','500','600','700','800'],
    ],
    'Old Standard TT, serif' => [
        'label'   => 'Old Standard TT (late 19th and early 20th-century style)',
        'weights' => ['400','700'],
    ],
    'Open Sans, sans-serif' => [
        'label'   => 'Open Sans (neutral, friendly)',
        'weights' => ['300','400','500','600','700','800'],
    ],
    'Orbitron, sans-serif' => [
        'label'   => 'Orbitron (sci-fi interface)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Oswald, sans-serif' => [
        'label'   => 'Oswald (bold, impactful)',
        'weights' => ['200','300','400','500','600','700'],
    ],
    'Pacifico, cursive' => [
        'label'   => 'Pacifico (playful, casual)',
        'weights' => ['400'],
    ],
    'Palatino, serif' => [
        'label'   => 'Palatino (traditional, refined)',
        'weights' => ['400','700'],
    ],
    'Parisienne, cursive' => [
        'label'   => 'Parisienne (Parisian café)',
        'weights' => ['400'],
    ],
    'Passion One, cursive' => [
        'label'   => 'Passion One (extra-bold, expressive)',
        'weights' => ['400','700','900'],
    ],
    'Patua One, serif' => [
        'label'   => 'Patua One (slab-serif, display)',
        'weights' => ['400'],
    ],
    'Pirata One, cursive' => [
        'label'   => 'Pirata One (Jolly Roger skull)',
        'weights' => ['400'],
    ],
    'Play, sans-serif' => [
        'label'   => 'Play (compact, modern)',
        'weights' => ['400','700'],
    ],
    'Playfair Display, serif' => [
        'label'   => 'Playfair Display (classic, elegant)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Poiret One, cursive' => [
        'label'   => 'Poiret One (geometric deco)',
        'weights' => ['400'],
    ],
    'Poppins, sans-serif' => [
        'label'   => 'Poppins (geometric, friendly)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Press Start 2P, cursive' => [
        'label'   => 'Press Start 2P (8-bit arcade)',
        'weights' => ['400'],
    ],
    'Prompt, sans-serif' => [
        'label'   => 'Prompt (rounded, condensed)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Quicksand, sans-serif' => [
        'label'   => 'Quicksand (light, modern)',
        'weights' => ['300','400','500','600','700'],
    ],
    'Racing Sans One, sans-serif' => [
        'label'   => 'Racing Sans One (fast, sporty)',
        'weights' => ['400'],
    ],
    'Rajdhani, sans-serif' => [
        'label'   => 'Rajdhani (angular tech)',
        'weights' => ['300','400','500','600','700'],
    ],
    'Raleway, sans-serif' => [
        'label'   => 'Raleway (elegant, stylish)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Rampart One, cursive' => [
        'label'   => 'Rampart One (chiseled stone effect)',
        'weights' => ['400'],
    ],
    'Ribeye Marrow, cursive' => [
        'label'   => 'Ribeye Marrow (chalk outline)',
        'weights' => ['400'],
    ],
    'Righteous, cursive' => [
        'label'   => 'Righteous (geometric, unique headings)',
        'weights' => ['400'],
    ],
    'Roboto Condensed, sans-serif' => [
        'label'   => 'Roboto Condensed (modern, approachable)',
        'weights' => ['300','400','700'],
    ],
    'Roboto, sans-serif' => [
        'label'   => 'Roboto (modern, approachable)',
        'weights' => ['100','300','400','500','700','900'],
    ],
    'Rubik Beastly, cursive' => [
        'label'   => 'Rubik Beastly (monster claws)',
        'weights' => ['400'],
    ],
    'Rubik Broken Fax, cursive' => [
        'label'   => 'Rubik Broken Fax (glitch distortion)',
        'weights' => ['400'],
    ],
    'Rubik Glitch, cursive' => [
        'label'   => 'Rubik Glitch (digital distortion)',
        'weights' => ['400'],
    ],
    'Rubik Moonrocks, cursive' => [
        'label'   => 'Rubik Moonrocks (space texture)',
        'weights' => ['400'],
    ],
    'Rubik Vinyl, cursive' => [
        'label'   => 'Rubik Vinyl (70s funk)',
        'weights' => ['400'],
    ],
    'Rubik Wet Paint, cursive' => [
        'label'   => 'Rubik Wet Paint (dripping ink)',
        'weights' => ['400'],
    ],
    'Rubik, sans-serif' => [
        'label'   => 'Rubik (modern, slightly rounded)',
        'weights' => ['300','400','500','600','700','800','900'],
    ],
    'Russo One, sans-serif' => [
        'label'   => 'Russo One (bold geometry)',
        'weights' => ['400'],
    ],
    'Rye, serif' => [
        'label'   => 'Rye (saloon woodtype)',
        'weights' => ['400'],
    ],
    'Sacramento, cursive' => [
        'label'   => 'Sacramento (brush script)',
        'weights' => ['400'],
    ],
    'Saira Condensed, sans-serif' => [
        'label'   => 'Saira Condensed (modern, condensed)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Saira Extra Condensed, sans-serif' => [
        'label'   => 'Saira Extra Condensed (extra tight)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Share Tech, sans-serif' => [
        'label'   => 'Share Tech (clean circuitry)',
        'weights' => ['400'],
    ],
    'Slabo 27px, serif' => [
        'label'   => 'Slabo 27px (modern, slab-serif)',
        'weights' => ['400'],
    ],
    'Smokum, serif' => [
        'label'   => 'Smokum (wanted poster)',
        'weights' => ['400'],
    ],
    'Snowburst One, cursive' => [
        'label'   => 'Snowburst One (crystal shards)',
        'weights' => ['400'],
    ],
    'Smythe, serif' => [
        'label'   => 'Smythe (Arts and Crafts movement-inspired)',
        'weights' => ['400'],
    ],
    'Source Sans Pro, sans-serif' => [
        'label'   => 'Source Sans Pro (clean, reliable)',
        'weights' => ['200','300','400','600','700','900'],
    ],
    'Space Mono, monospace' => [
        'label'   => 'Space Mono (retro-futuristic style)',
        'weights' => ['400','700'],
    ],
    'Spectral, serif' => [
        'label'   => 'Spectral (elegant, modern)',
        'weights' => ['200','300','400','500','600','700','800'],
    ],
    'Staatliches, sans-serif' => [
        'label'   => 'Staatliches (Bauhaus blocks)',
        'weights' => ['400'],
    ],
    'Stardos Stencil, serif' => [
        'label'   => 'Stardos Stencil (circus deco)',
        'weights' => ['400','700'],
    ],
    'Stick, sans-serif' => [
        'label'   => 'Stick (basic lineart)',
        'weights' => ['400'],
    ],
    'Syncopate, sans-serif' => [
        'label'   => 'Syncopate (negative space)',
        'weights' => ['400','700'],
    ],
    'Tahoma, sans-serif' => [
        'label'   => 'Tahoma (modern, legible)',
        'weights' => ['400','700'],
    ],
    'Tajawal, sans-serif' => [
        'label'   => 'Tajawal (clean, modern)',
        'weights' => ['200','300','400','500','700','800','900'],
    ],
    'Tangerine, cursive' => [
        'label'   => 'Tangerine (delicate quill)',
        'weights' => ['400','700'],
    ],
    'Teko, sans-serif' => [
        'label'   => 'Teko (angular, strong headings)',
        'weights' => ['300','400','500','600','700'],
    ],
    'Times New Roman, serif' => [
        'label'   => 'Times New Roman (traditional, formal)',
        'weights' => ['400','700'],
    ],
    'Titillium Web, sans-serif' => [
        'label'   => 'Titillium Web (modern, stylish)',
        'weights' => ['200','300','400','600','700','900'],
    ],
    'Tourney, sans-serif' => [
        'label'   => 'Tourney (multiple weights)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Train One, cursive' => [
        'label'   => 'Train One (railroad tracks)',
        'weights' => ['400'],
    ],
    'Trebuchet MS, sans-serif' => [
        'label'   => 'Trebuchet MS (friendly, modern)',
        'weights' => ['400','700'],
    ],
    'Ubuntu, sans-serif' => [
        'label'   => 'Ubuntu (humanist, approachable)',
        'weights' => ['300','400','500','700'],
    ],
    'Uncial Antiqua, cursive' => [
        'label'   => 'Uncial Antiqua (ancient manuscript)',
        'weights' => ['400'],
    ],
    'UnifrakturMaguntia, cursive' => [
        'label'   => 'UnifrakturMaguntia (medieval blackletter)',
        'weights' => ['400'],
    ],
    'Unica One, sans-serif' => [
        'label'   => 'Unica One (condensed, clean headings)',
        'weights' => ['400'],
    ],
    'Varela Round, sans-serif' => [
        'label'   => 'Varela Round (rounded, friendly)',
        'weights' => ['400'],
    ],
    'Vast Shadow, cursive' => [
        'label'   => 'Vast Shadow (long drop shadows)',
        'weights' => ['400'],
    ],
    'Verdana, sans-serif' => [
        'label'   => 'Verdana (modern, readable)',
        'weights' => ['400','700'],
    ],
    'VT323, monospace' => [
        'label'   => 'VT323 (pixel terminal)',
        'weights' => ['400'],
    ],
    'Wallpoet, sans-serif' => [
        'label'   => 'Wallpoet (digital stencil)',
        'weights' => ['400'],
    ],
    'Work Sans, sans-serif' => [
        'label'   => 'Work Sans (technical, clean)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Yanone Kaffeesatz, sans-serif' => [
        'label'   => 'Yanone Kaffeesatz (clean, light condensed)',
        'weights' => ['200','300','400','500','600','700'],
    ],
    'Yeseva One, serif' => [
        'label'   => 'Yeseva One (1920s deco elegance)',
        'weights' => ['400'],
    ],
    'Zeyada, cursive' => [
        'label'   => 'Zeyada (handwritten, casual)',
        'weights' => ['400'],
    ],
    'Zilla Slab Highlight, cursive' => [
        'label'   => 'Zilla Slab Highlight (comic book emphasis)',
        'weights' => ['400'],
    ],
    'Zen Tokyo Zoo, cursive' => [
        'label'   => 'Zen Tokyo Zoo (animal shapes)',
        'weights' => ['400'],
    ],

    // ───────────────────────────────
    // Optional: a few great additions
    // ───────────────────────────────
    'Manrope, sans-serif' => [
        'label'   => 'Manrope (modern, readable)',
        'weights' => ['200','300','400','500','600','700','800'],
    ],
    'Plus Jakarta Sans, sans-serif' => [
        'label'   => 'Plus Jakarta Sans (clean, contemporary)',
        'weights' => ['200','300','400','500','600','700','800'],
    ],
    'DM Sans, sans-serif' => [
        'label'   => 'DM Sans (neutral, friendly)',
        'weights' => ['300','400','500','700','800','900'],
    ],
    'DM Serif Display, serif' => [
        'label'   => 'DM Serif Display (elegant display serif)',
        'weights' => ['400','700'],
    ],
    'Crimson Pro, serif' => [
        'label'   => 'Crimson Pro (classic book serif)',
        'weights' => ['200','300','400','500','600','700','800','900'],
    ],
    'Source Serif 4, serif' => [
        'label'   => 'Source Serif 4 (versatile serif)',
        'weights' => ['200','300','400','500','600','700','800','900'],
    ],
    'Space Grotesk, sans-serif' => [
        'label'   => 'Space Grotesk (techy grotesque)',
        'weights' => ['300','400','500','600','700'],
    ],
    'Urbanist, sans-serif' => [
        'label'   => 'Urbanist (spacious, modern)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Outfit, sans-serif' => [
        'label'   => 'Outfit (sleek geometric)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Mulish, sans-serif' => [
        'label'   => 'Mulish (rounded, versatile)',
        'weights' => ['200','300','400','500','600','700','800','900'],
    ],
    'Public Sans, sans-serif' => [
        'label'   => 'Public Sans (USWDS, utilitarian)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Fraunces, serif' => [
        'label'   => 'Fraunces (soft-serif branding)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Lexend, sans-serif' => [
        'label'   => 'Lexend (reading-optimized)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
        ];
    }
}

if ( ! function_exists('my_plugin_weight_labels') ) {
    function my_plugin_weight_labels() {
        return [
            '100' => __('Thin (100)', 'my-plugin'),
            '200' => __('Extra Light (200)', 'my-plugin'),
            '300' => __('Light (300)', 'my-plugin'),
            '400' => __('Normal (400)', 'my-plugin'),
            '500' => __('Medium (500)', 'my-plugin'),
            '600' => __('Semi-Bold (600)', 'my-plugin'),
            '700' => __('Bold (700)', 'my-plugin'),
            '800' => __('Extra-Bold (800)', 'my-plugin'),
            '900' => __('Black (900)', 'my-plugin'),
        ];
    }
}

// "Roboto, sans-serif" -> "Roboto"
if ( ! function_exists('my_plugin_base_family') ) {
    function my_plugin_base_family($family_with_stack) {
        return trim(preg_replace('/\s*,.*$/', '', (string)$family_with_stack));
    }
}

if ( ! function_exists('my_plugin_get_weights_for_family') ) {
    function my_plugin_get_weights_for_family($family_with_stack) {
        $catalog = firefly_google_fonts_catalog(); // Use your main catalog function

        // exact key
        if (isset($catalog[$family_with_stack]['weights'])) {
            return $catalog[$family_with_stack]['weights'];
        }

        // fallback by base family name
        $base = my_plugin_base_family($family_with_stack);
        foreach ($catalog as $full => $meta) {
            if (my_plugin_base_family($full) === $base && isset($meta['weights'])) {
                return $meta['weights'];
            }
        }

        // safe fallback
        return ['400','700'];
    }
}
// Map legacy and validate
if ( ! function_exists('my_plugin_normalize_weight') ) {
    function my_plugin_normalize_weight($value) {
        if ($value === 'bold'   || $value === 700 || $value === '700') return '700';
        if ($value === 'normal' || $value === 400 || $value === '400' || $value === '' || $value === null) return '400';
        $valid = ['100','200','300','400','500','600','700','800','900'];
        $value = (string) $value;
        return in_array($value, $valid, true) ? $value : '400';
    }
}


if (!function_exists('firefly_customizer_fonts')) {
    function firefly_customizer_fonts($wp_customize) {
        // Create a panel for font controls
        $wp_customize->add_panel('firefly_fonts_panel', array(
            'title'       => __('Firefly Fonts', 'my-plugin'),
            'priority'    => 31,
            'description' => __('Customize fonts for body text and headings.', 'my-plugin'),
        ));

        // Google Fonts list
       $google_fonts = [
    'Abril Fatface, cursive' => [
        'label'   => 'Abril Fatface (dramatic, elegant)',
        'weights' => ['400'],
    ],
    'Aclonica, sans-serif' => [
        'label'   => 'Aclonica (negative space cuts)',
        'weights' => ['400'],
    ],
    'Alegreya, serif' => [
        'label'   => 'Alegreya (dynamic, readable)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Aleo, serif' => [
        'label'   => 'Aleo (contemporary, slab-serif)',
        'weights' => ['300','400','700'],
    ],
    'Almendra Display, cursive' => [
        'label'   => 'Almendra Display (ancient coin)',
        'weights' => ['400'],
    ],
    'Amarante, cursive' => [
        'label'   => 'Amarante (Art Nouveau-inspired shapes)',
        'weights' => ['400'],
    ],
    'Anton, sans-serif' => [
        'label'   => 'Anton (strong, impactful)',
        'weights' => ['400'],
    ],
    'Archivo Narrow, sans-serif' => [
        'label'   => 'Archivo Narrow (condensed, versatile)',
        'weights' => ['400','500','600','700'],
    ],
    'Arial, sans-serif' => [
        'label'   => 'Arial (classic, neutral)',
        'weights' => ['400','700'],
    ],
    'Arvo, serif' => [
        'label'   => 'Arvo (geometric, slab-serif)',
        'weights' => ['400','700'],
    ],
    'Audiowide, cursive' => [
        'label'   => 'Audiowide (perfect circles)',
        'weights' => ['400'],
    ],
    'Bacasime Antique, serif' => [
        'label'   => 'Bacasime Antique (classic, antique style)',
        'weights' => ['400'],
    ],
    'Bangers, cursive' => [
        'label'   => 'Bangers (comic, bold, display)',
        'weights' => ['400'],
    ],
    'Barlow, sans-serif' => [
        'label'   => 'Barlow (contemporary, versatile)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Bayon, sans-serif' => [
        'label'   => 'Bayon (angular Khmer style)',
        'weights' => ['400'],
    ],
    'Bebas Neue, sans-serif' => [
        'label'   => 'Bebas Neue (clean, display)',
        'weights' => ['400'],
    ],
    'Bitter, serif' => [
        'label'   => 'Bitter (contemporary, readable)',
        'weights' => ['400','500','600','700','800'],
    ],
    'Black Ops One, sans-serif' => [
        'label'   => 'Black Ops One (military stencil)',
        'weights' => ['400'],
    ],
    'Blaka Hollow, cursive' => [
        'label'   => 'Blaka Hollow (batik cutouts)',
        'weights' => ['400'],
    ],
    'Bodoni Moda, serif' => [
        'label'   => 'Bodoni Moda (fashion, high-contrast)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Bowlby One, sans-serif' => [
        'label'   => 'Bowlby One (movie poster)',
        'weights' => ['400'],
    ],
    'Brush Script MT, cursive' => [
        'label'   => 'Brush Script MT (casual, artistic)',
        'weights' => ['400'],
    ],
    'Bungee, sans-serif' => [
        'label'   => 'Bungee (urban street-style)',
        'weights' => ['400'],
    ],
    'Bungee Shade, sans-serif' => [
        'label'   => 'Bungee Shade (3D shadow effect)',
        'weights' => ['400'],
    ],
    'Butterfly Kids, cursive' => [
        'label'   => 'Butterfly Kids (flower stems)',
        'weights' => ['400'],
    ],
    'Cabin, sans-serif' => [
        'label'   => 'Cabin (contemporary, friendly)',
        'weights' => ['400','500','600','700'],
    ],
    'Chango, cursive' => [
        'label'   => 'Chango (playful deco shapes)',
        'weights' => ['400'],
    ],
    'Cinzel, serif' => [
        'label'   => 'Cinzel (classic, Roman-style headings)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Coda Caption, sans-serif' => [
        'label'   => 'Coda Caption (compact, bold)',
        'weights' => ['800'],
    ],
    'Codystar, cursive' => [
        'label'   => 'Codystar (constellation lines)',
        'weights' => ['300','400'],
    ],
    'Concert One, cursive' => [
        'label'   => 'Concert One (bold, fun)',
        'weights' => ['400'],
    ],
    'Condiment, cursive' => [
        'label'   => 'Condiment (condensed, playful)',
        'weights' => ['400'],
    ],
    'Cormorant Garamond, serif' => [
        'label'   => 'Cormorant Garamond (classic, refined)',
        'weights' => ['300','400','500','600','700'],
    ],
    'Courier New, monospace' => [
        'label'   => 'Courier New (technical, classic)',
        'weights' => ['400','700'],
    ],
    'Creepster, cursive' => [
        'label'   => 'Creepster (horror punk dripping style)',
        'weights' => ['400'],
    ],
    'Dancing Script, cursive' => [
        'label'   => 'Dancing Script (swirling elegance)',
        'weights' => ['400','500','600','700'],
    ],
    'DotGothic16, sans-serif' => [
        'label'   => 'DotGothic16 (pixel dots)',
        'weights' => ['400'],
    ],
    'Dosis, sans-serif' => [
        'label'   => 'Dosis (light, rounded)',
        'weights' => ['200','300','400','500','600','700','800'],
    ],
    'Eater, cursive' => [
        'label'   => 'Eater (vampire punk)',
        'weights' => ['400'],
    ],
    'Emilys Candy, cursive' => [
        'label'   => 'Emilys Candy (sweet wrappers)',
        'weights' => ['400'],
    ],
    'Exo 2, sans-serif' => [
        'label'   => 'Exo 2 (tech-inspired, readable)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Fascinate, cursive' => [
        'label'   => 'Fascinate (comic book)',
        'weights' => ['400'],
    ],
    'Fasthand, serif' => [
        'label'   => 'Fasthand (Asian brush strokes)',
        'weights' => ['400'],
    ],
    'Faster One, cursive' => [
        'label'   => 'Faster One (speed lines)',
        'weights' => ['400'],
    ],
    'Fira Sans, sans-serif' => [
        'label'   => 'Fira Sans (technical, clean)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Fjalla One, sans-serif' => [
        'label'   => 'Fjalla One (bold, compact headings)',
        'weights' => ['400'],
    ],
    'Francois One, sans-serif' => [
        'label'   => 'Francois One (rounded, headline)',
        'weights' => ['400'],
    ],
    'Freckle Face, cursive' => [
        'label'   => 'Freckle Face (spray-paint texture)',
        'weights' => ['400'],
    ],
    'Frijole, cursive' => [
        'label'   => 'Frijole (Day of the Dead)',
        'weights' => ['400'],
    ],
    'Georgia, serif' => [
        'label'   => 'Georgia (elegant, classic)',
        'weights' => ['400','700'],
    ],
    'Gothic A1, sans-serif' => [
        'label'   => 'Gothic A1 (modern gothic style)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Gravitas One, serif' => [
        'label'   => 'Gravitas One (bold, slab-serif display)',
        'weights' => ['400'],
    ],
    'Great Vibes, cursive' => [
        'label'   => 'Great Vibes (calligraphic flair)',
        'weights' => ['400'],
    ],
    'Helvetica, sans-serif' => [
        'label'   => 'Helvetica (clean, versatile)',
        'weights' => ['400','700'],
    ],
    'Henny Penny, cursive' => [
        'label'   => 'Henny Penny (medieval manuscript)',
        'weights' => ['400'],
    ],
    'Hind, sans-serif' => [
        'label'   => 'Hind (simple, readable)',
        'weights' => ['300','400','500','600','700'],
    ],
    'IBM Plex Sans, sans-serif' => [
        'label'   => 'IBM Plex Sans (technical, professional)',
        'weights' => ['100','200','300','400','500','600','700'],
    ],
    'Inconsolata, monospace' => [
        'label'   => 'Inconsolata (monospace, technical)',
        'weights' => ['200','300','400','500','600','700','800','900'],
    ],
    'Inter, sans-serif' => [
        'label'   => 'Inter (neutral, readable)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Irish Grover, cursive' => [
        'label'   => 'Irish Grover (Celtic knots)',
        'weights' => ['400'],
    ],
    'Josefin Sans, sans-serif' => [
        'label'   => 'Josefin Sans (geometric, elegant)',
        'weights' => ['100','200','300','400','500','600','700'],
    ],
    'Kanit, sans-serif' => [
        'label'   => 'Kanit (condensed, modern Thai-style)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Karla, sans-serif' => [
        'label'   => 'Karla (minimalist, clean)',
        'weights' => ['200','300','400','500','600','700','800'],
    ],
    'Kranky, cursive' => [
        'label'   => 'Kranky (Halloween spooky)',
        'weights' => ['400'],
    ],
    'Lato, sans-serif' => [
        'label'   => 'Lato (warm, sophisticated)',
        'weights' => ['100','300','400','700','900'],
    ],
    'League Gothic, sans-serif' => [
        'label'   => 'League Gothic (tall, narrow, vintage)',
        'weights' => ['400'],
    ],
    'Libre Baskerville, serif' => [
        'label'   => 'Libre Baskerville (traditional, readable)',
        'weights' => ['400','700'],
    ],
    'Limelight, sans-serif' => [
        'label'   => 'Limelight (Broadway marquee)',
        'weights' => ['400'],
    ],
    'Lobster, cursive' => [
        'label'   => 'Lobster (50s diner)',
        'weights' => ['400'],
    ],
    'Luckiest Guy, cursive' => [
        'label'   => 'Luckiest Guy (comic, bold, fun)',
        'weights' => ['400'],
    ],
    'Major Mono Display, monospace' => [
        'label'   => 'Major Mono Display (hacking terminal)',
        'weights' => ['400'],
    ],
    'MedievalSharp, cursive' => [
        'label'   => 'MedievalSharp (castle inscriptions)',
        'weights' => ['400'],
    ],
    'Merriweather, serif' => [
        'label'   => 'Merriweather (traditional, readable)',
        'weights' => ['300','400','700','900'],
    ],
    'Metal Mania, cursive' => [
        'label'   => 'Metal Mania (engraved metal)',
        'weights' => ['400'],
    ],
    'Metrophobic, sans-serif' => [
        'label'   => 'Metrophobic (streamlined moderne)',
        'weights' => ['400'],
    ],
    'Michroma, sans-serif' => [
        'label'   => 'Michroma (retro-futuristic)',
        'weights' => ['400'],
    ],
    'Miltonian, cursive' => [
        'label'   => 'Miltonian (woodcut prints)',
        'weights' => ['400'],
    ],
    'Monoton, cursive' => [
        'label'   => 'Monoton (neon tube lights)',
        'weights' => ['400'],
    ],
    'Montserrat, sans-serif' => [
        'label'   => 'Montserrat (geometric, modern)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Mountains of Christmas, cursive' => [
        'label'   => 'Mountains of Christmas (snowy peaks)',
        'weights' => ['400','700'],
    ],
    'Muli, sans-serif' => [
        'label'   => 'Muli (minimalist, versatile)',
        'weights' => ['200','300','400','600','700','800'],
    ],
    'Nabla, cursive' => [
        'label'   => 'Nabla (colorful layered)',
        'weights' => ['400'],
    ],
    'Nasalization, sans-serif' => [
        'label'   => 'Nasalization (space age)',
        'weights' => ['400'],
    ],
    'Neon Tubes, sans-serif' => [
        'label'   => 'Neon Tubes (retro, glowing lines)',
        'weights' => ['400'],
    ],
    'New Rocker, cursive' => [
        'label'   => 'New Rocker (70s metal band)',
        'weights' => ['400'],
    ],
    'Nosifer, cursive' => [
        'label'   => 'Nosifer (zombie apocalypse)',
        'weights' => ['400'],
    ],
    'Noto Sans Cherokee, sans-serif' => [
        'label'   => 'Noto Sans Cherokee (indigenous)',
        'weights' => ['400'],
    ],
    'Noto Sans Linear B, sans-serif' => [
        'label'   => 'Noto Sans Linear B (ancient Greek)',
        'weights' => ['400'],
    ],
    'Noto Sans Mayan, sans-serif' => [
        'label'   => 'Noto Sans Mayan (hieroglyphic)',
        'weights' => ['400'],
    ],
    'Noto Sans Osmanya, sans-serif' => [
        'label'   => 'Noto Sans Osmanya (ancient script)',
        'weights' => ['400'],
    ],
    'Nunito, sans-serif' => [
        'label'   => 'Nunito (rounded, friendly)',
        'weights' => ['200','300','400','600','700','800','900'],
    ],
    'Ojuju, sans-serif' => [
        'label'   => 'Ojuju (Afro-grotesque style)',
        'weights' => ['400','500','600','700','800'],
    ],
    'Old Standard TT, serif' => [
        'label'   => 'Old Standard TT (late 19th and early 20th-century style)',
        'weights' => ['400','700'],
    ],
    'Open Sans, sans-serif' => [
        'label'   => 'Open Sans (neutral, friendly)',
        'weights' => ['300','400','500','600','700','800'],
    ],
    'Orbitron, sans-serif' => [
        'label'   => 'Orbitron (sci-fi interface)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Oswald, sans-serif' => [
        'label'   => 'Oswald (bold, impactful)',
        'weights' => ['200','300','400','500','600','700'],
    ],
    'Pacifico, cursive' => [
        'label'   => 'Pacifico (playful, casual)',
        'weights' => ['400'],
    ],
    'Palatino, serif' => [
        'label'   => 'Palatino (traditional, refined)',
        'weights' => ['400','700'],
    ],
    'Parisienne, cursive' => [
        'label'   => 'Parisienne (Parisian café)',
        'weights' => ['400'],
    ],
    'Passion One, cursive' => [
        'label'   => 'Passion One (extra-bold, expressive)',
        'weights' => ['400','700','900'],
    ],
    'Patua One, serif' => [
        'label'   => 'Patua One (slab-serif, display)',
        'weights' => ['400'],
    ],
    'Pirata One, cursive' => [
        'label'   => 'Pirata One (Jolly Roger skull)',
        'weights' => ['400'],
    ],
    'Play, sans-serif' => [
        'label'   => 'Play (compact, modern)',
        'weights' => ['400','700'],
    ],
    'Playfair Display, serif' => [
        'label'   => 'Playfair Display (classic, elegant)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Poiret One, cursive' => [
        'label'   => 'Poiret One (geometric deco)',
        'weights' => ['400'],
    ],
    'Poppins, sans-serif' => [
        'label'   => 'Poppins (geometric, friendly)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Press Start 2P, cursive' => [
        'label'   => 'Press Start 2P (8-bit arcade)',
        'weights' => ['400'],
    ],
    'Prompt, sans-serif' => [
        'label'   => 'Prompt (rounded, condensed)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Quicksand, sans-serif' => [
        'label'   => 'Quicksand (light, modern)',
        'weights' => ['300','400','500','600','700'],
    ],
    'Racing Sans One, sans-serif' => [
        'label'   => 'Racing Sans One (fast, sporty)',
        'weights' => ['400'],
    ],
    'Rajdhani, sans-serif' => [
        'label'   => 'Rajdhani (angular tech)',
        'weights' => ['300','400','500','600','700'],
    ],
    'Raleway, sans-serif' => [
        'label'   => 'Raleway (elegant, stylish)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Rampart One, cursive' => [
        'label'   => 'Rampart One (chiseled stone effect)',
        'weights' => ['400'],
    ],
    'Ribeye Marrow, cursive' => [
        'label'   => 'Ribeye Marrow (chalk outline)',
        'weights' => ['400'],
    ],
    'Righteous, cursive' => [
        'label'   => 'Righteous (geometric, unique headings)',
        'weights' => ['400'],
    ],
    'Roboto Condensed, sans-serif' => [
        'label'   => 'Roboto Condensed (modern, approachable)',
        'weights' => ['300','400','700'],
    ],
    'Roboto, sans-serif' => [
        'label'   => 'Roboto (modern, approachable)',
        'weights' => ['100','300','400','500','700','900'],
    ],
    'Rubik Beastly, cursive' => [
        'label'   => 'Rubik Beastly (monster claws)',
        'weights' => ['400'],
    ],
    'Rubik Broken Fax, cursive' => [
        'label'   => 'Rubik Broken Fax (glitch distortion)',
        'weights' => ['400'],
    ],
    'Rubik Glitch, cursive' => [
        'label'   => 'Rubik Glitch (digital distortion)',
        'weights' => ['400'],
    ],
    'Rubik Moonrocks, cursive' => [
        'label'   => 'Rubik Moonrocks (space texture)',
        'weights' => ['400'],
    ],
    'Rubik Vinyl, cursive' => [
        'label'   => 'Rubik Vinyl (70s funk)',
        'weights' => ['400'],
    ],
    'Rubik Wet Paint, cursive' => [
        'label'   => 'Rubik Wet Paint (dripping ink)',
        'weights' => ['400'],
    ],
    'Rubik, sans-serif' => [
        'label'   => 'Rubik (modern, slightly rounded)',
        'weights' => ['300','400','500','600','700','800','900'],
    ],
    'Russo One, sans-serif' => [
        'label'   => 'Russo One (bold geometry)',
        'weights' => ['400'],
    ],
    'Rye, serif' => [
        'label'   => 'Rye (saloon woodtype)',
        'weights' => ['400'],
    ],
    'Sacramento, cursive' => [
        'label'   => 'Sacramento (brush script)',
        'weights' => ['400'],
    ],
    'Saira Condensed, sans-serif' => [
        'label'   => 'Saira Condensed (modern, condensed)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Saira Extra Condensed, sans-serif' => [
        'label'   => 'Saira Extra Condensed (extra tight)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Share Tech, sans-serif' => [
        'label'   => 'Share Tech (clean circuitry)',
        'weights' => ['400'],
    ],
    'Slabo 27px, serif' => [
        'label'   => 'Slabo 27px (modern, slab-serif)',
        'weights' => ['400'],
    ],
    'Smokum, serif' => [
        'label'   => 'Smokum (wanted poster)',
        'weights' => ['400'],
    ],
    'Snowburst One, cursive' => [
        'label'   => 'Snowburst One (crystal shards)',
        'weights' => ['400'],
    ],
    'Smythe, serif' => [
        'label'   => 'Smythe (Arts and Crafts movement-inspired)',
        'weights' => ['400'],
    ],
    'Source Sans Pro, sans-serif' => [
        'label'   => 'Source Sans Pro (clean, reliable)',
        'weights' => ['200','300','400','600','700','900'],
    ],
    'Space Mono, monospace' => [
        'label'   => 'Space Mono (retro-futuristic style)',
        'weights' => ['400','700'],
    ],
    'Spectral, serif' => [
        'label'   => 'Spectral (elegant, modern)',
        'weights' => ['200','300','400','500','600','700','800'],
    ],
    'Staatliches, sans-serif' => [
        'label'   => 'Staatliches (Bauhaus blocks)',
        'weights' => ['400'],
    ],
    'Stardos Stencil, serif' => [
        'label'   => 'Stardos Stencil (circus deco)',
        'weights' => ['400','700'],
    ],
    'Stick, sans-serif' => [
        'label'   => 'Stick (basic lineart)',
        'weights' => ['400'],
    ],
    'Syncopate, sans-serif' => [
        'label'   => 'Syncopate (negative space)',
        'weights' => ['400','700'],
    ],
    'Tahoma, sans-serif' => [
        'label'   => 'Tahoma (modern, legible)',
        'weights' => ['400','700'],
    ],
    'Tajawal, sans-serif' => [
        'label'   => 'Tajawal (clean, modern)',
        'weights' => ['200','300','400','500','700','800','900'],
    ],
    'Tangerine, cursive' => [
        'label'   => 'Tangerine (delicate quill)',
        'weights' => ['400','700'],
    ],
    'Teko, sans-serif' => [
        'label'   => 'Teko (angular, strong headings)',
        'weights' => ['300','400','500','600','700'],
    ],
    'Times New Roman, serif' => [
        'label'   => 'Times New Roman (traditional, formal)',
        'weights' => ['400','700'],
    ],
    'Titillium Web, sans-serif' => [
        'label'   => 'Titillium Web (modern, stylish)',
        'weights' => ['200','300','400','600','700','900'],
    ],
    'Tourney, sans-serif' => [
        'label'   => 'Tourney (multiple weights)',
        'weights' => ['400','500','600','700','800','900'],
    ],
    'Train One, cursive' => [
        'label'   => 'Train One (railroad tracks)',
        'weights' => ['400'],
    ],
    'Trebuchet MS, sans-serif' => [
        'label'   => 'Trebuchet MS (friendly, modern)',
        'weights' => ['400','700'],
    ],
    'Ubuntu, sans-serif' => [
        'label'   => 'Ubuntu (humanist, approachable)',
        'weights' => ['300','400','500','700'],
    ],
    'Uncial Antiqua, cursive' => [
        'label'   => 'Uncial Antiqua (ancient manuscript)',
        'weights' => ['400'],
    ],
    'UnifrakturMaguntia, cursive' => [
        'label'   => 'UnifrakturMaguntia (medieval blackletter)',
        'weights' => ['400'],
    ],
    'Unica One, sans-serif' => [
        'label'   => 'Unica One (condensed, clean headings)',
        'weights' => ['400'],
    ],
    'Varela Round, sans-serif' => [
        'label'   => 'Varela Round (rounded, friendly)',
        'weights' => ['400'],
    ],
    'Vast Shadow, cursive' => [
        'label'   => 'Vast Shadow (long drop shadows)',
        'weights' => ['400'],
    ],
    'Verdana, sans-serif' => [
        'label'   => 'Verdana (modern, readable)',
        'weights' => ['400','700'],
    ],
    'VT323, monospace' => [
        'label'   => 'VT323 (pixel terminal)',
        'weights' => ['400'],
    ],
    'Wallpoet, sans-serif' => [
        'label'   => 'Wallpoet (digital stencil)',
        'weights' => ['400'],
    ],
    'Work Sans, sans-serif' => [
        'label'   => 'Work Sans (technical, clean)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Yanone Kaffeesatz, sans-serif' => [
        'label'   => 'Yanone Kaffeesatz (clean, light condensed)',
        'weights' => ['200','300','400','500','600','700'],
    ],
    'Yeseva One, serif' => [
        'label'   => 'Yeseva One (1920s deco elegance)',
        'weights' => ['400'],
    ],
    'Zeyada, cursive' => [
        'label'   => 'Zeyada (handwritten, casual)',
        'weights' => ['400'],
    ],
    'Zilla Slab Highlight, cursive' => [
        'label'   => 'Zilla Slab Highlight (comic book emphasis)',
        'weights' => ['400'],
    ],
    'Zen Tokyo Zoo, cursive' => [
        'label'   => 'Zen Tokyo Zoo (animal shapes)',
        'weights' => ['400'],
    ],

    // ───────────────────────────────
    // Optional: a few great additions
    // ───────────────────────────────
    'Manrope, sans-serif' => [
        'label'   => 'Manrope (modern, readable)',
        'weights' => ['200','300','400','500','600','700','800'],
    ],
    'Plus Jakarta Sans, sans-serif' => [
        'label'   => 'Plus Jakarta Sans (clean, contemporary)',
        'weights' => ['200','300','400','500','600','700','800'],
    ],
    'DM Sans, sans-serif' => [
        'label'   => 'DM Sans (neutral, friendly)',
        'weights' => ['300','400','500','700','800','900'],
    ],
    'DM Serif Display, serif' => [
        'label'   => 'DM Serif Display (elegant display serif)',
        'weights' => ['400','700'],
    ],
    'Crimson Pro, serif' => [
        'label'   => 'Crimson Pro (classic book serif)',
        'weights' => ['200','300','400','500','600','700','800','900'],
    ],
    'Source Serif 4, serif' => [
        'label'   => 'Source Serif 4 (versatile serif)',
        'weights' => ['200','300','400','500','600','700','800','900'],
    ],
    'Space Grotesk, sans-serif' => [
        'label'   => 'Space Grotesk (techy grotesque)',
        'weights' => ['300','400','500','600','700'],
    ],
    'Urbanist, sans-serif' => [
        'label'   => 'Urbanist (spacious, modern)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Outfit, sans-serif' => [
        'label'   => 'Outfit (sleek geometric)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Mulish, sans-serif' => [
        'label'   => 'Mulish (rounded, versatile)',
        'weights' => ['200','300','400','500','600','700','800','900'],
    ],
    'Public Sans, sans-serif' => [
        'label'   => 'Public Sans (USWDS, utilitarian)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Fraunces, serif' => [
        'label'   => 'Fraunces (soft-serif branding)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
    'Lexend, sans-serif' => [
        'label'   => 'Lexend (reading-optimized)',
        'weights' => ['100','200','300','400','500','600','700','800','900'],
    ],
];

        // Define font targets
        $font_targets = [
            
            'h1'   => 'Heading 1 Font',
            'h2'   => 'Heading 2 Font',
            'h3'   => 'Heading 3 Font',
            'body' => 'Body Font',
        ];





        foreach ($font_targets as $key => $label) {
            $section_id = "firefly_fonts_section_{$key}";
        
            $wp_customize->add_section($section_id, array(
                'title'    => __($label, 'my-plugin'),
                'panel'    => 'firefly_fonts_panel',
                'priority' => 10,
            ));
        


            
            // Font family
         // Font family
$wp_customize->add_setting("my_plugin_{$key}_font", array(
    'default'           => 'Arial, sans-serif',
    'transport'         => 'refresh',
    'sanitize_callback' => 'sanitize_text_field',
));

// Create simple key-value pairs for the select control
$font_choices = [];
foreach ($google_fonts as $font_key => $font_data) {
    $font_choices[$font_key] = $font_data['label'];
}

$wp_customize->add_control("my_plugin_{$key}_font_control", array(
    'label'    => __("Font Family", 'my-plugin'),
    'section'  => $section_id,
    'settings' => "my_plugin_{$key}_font",
    'type'     => 'select',
    'choices'  => $font_choices,  // ← Now using the simple array
));
            // Font weight (headings only)




// 1) Normalizer used both for reading and saving
if ( ! function_exists('my_plugin_normalize_weight') ) {
    function my_plugin_normalize_weight( $value ) {
        // Map legacy strings
        if ($value === 'bold'   || $value === 700 || $value === '700') return '700';
        if ($value === 'normal' || $value === 400 || $value === '400' || $value === '' || $value === null) return '400';

        // Allow only valid numeric weights
        $valid = ['100','200','300','400','500','600','700','800','900'];
        $value = (string) $value;
        return in_array($value, $valid, true) ? $value : '400';
    }
}

// 2) Register setting/control and attach a filter per key
// Font weight (headings only)

//=====================================================================

if (in_array($key, ['h1','h2','h3'], true)) {
    
    $wp_customize->add_setting("my_plugin_{$key}_weight", array(
        'default'           => '400',
        'transport'         => 'refresh',
        'sanitize_callback' => 'my_plugin_normalize_weight',
    ));

    // Get current family to determine available weights
    $current_family = get_theme_mod("my_plugin_{$key}_font", 'Arial, sans-serif');
    $available_weights = (array) my_plugin_get_weights_for_family($current_family);

    // All possible weights
    $font_weights_all = array('100','200','300','400','500','600','700','800','900');

    // Display labels
    $weight_labels = array(
        '100' => __('Thin (100)', 'my-plugin'),
        '200' => __('Extra Light (200)', 'my-plugin'),
        '300' => __('Light (300)', 'my-plugin'),
        '400' => __('Regular / Normal (400)', 'my-plugin'),
        '500' => __('Medium (500)', 'my-plugin'),
        '600' => __('Semi Bold (600)', 'my-plugin'),
        '700' => __('Bold (700)', 'my-plugin'),
        '800' => __('Extra Bold (800)', 'my-plugin'),
        '900' => __('Black / Heavy (900)', 'my-plugin'),
    );

    // Build choices with hints for unavailable weights
    $weight_choices = array();
    foreach ($font_weights_all as $w) {
        $label = isset($weight_labels[$w]) ? $weight_labels[$w] : $w;
        if (!in_array($w, $available_weights, true)) {
          //  $label .= ' ' . __('— not available', 'my-plugin');
        }
        $weight_choices[$w] = $label;
    }

    $wp_customize->add_control("my_plugin_{$key}_weight_control", array(
        'label'       => __("Font Weight", 'my-plugin'),
        'section'     => $section_id,
        'settings'    => "my_plugin_{$key}_weight",
        'type'        => 'radio',
        'choices'     => $weight_choices,
        'input_attrs' => array(
            'class' => 'firefly-weight-radio',
            'data-target' => $key,
        ),
    ));
}

//=====================================================================



$wp_customize->add_setting("my_plugin_{$key}_font_link_dummy", [
    'sanitize_callback' => 'sanitize_text_field',
]);

$wp_customize->add_control("my_plugin_{$key}_font_link", array(
    'label' => '',
    'section' => $section_id,
    'settings' => "my_plugin_{$key}_font_link_dummy", // Needs to point to a real setting
    'type' => 'hidden', // or 'text' if you want the input box (but it sounds like you don't)
    'description' => '<a href="' . esc_url(site_url('/firefly-view-fonts')) . '" target="_blank">🎨 View Fonts</a>',
    'active_callback' => $banner_active,
));


            $colour_choices_text = array(
                'colour1' => array('color' => get_theme_mod('firefly_colour_1', '#dd3333'), 'label' => 'Colour 1'),
                'colour2' => array('color' => get_theme_mod('firefly_colour_2', '#1e73be'), 'label' => 'Colour 2'),
                'colour3' => array('color' => get_theme_mod('firefly_colour_3', '#8224e3'), 'label' => 'Colour 3'),
                'colour4' => array('color' => get_theme_mod('firefly_colour_4', '#ededc4'), 'label' => 'Colour 4'),
                'black'   => array('color' => '#000000', 'label' => 'Black'),
                'white'   => array('color' => '#ffffff', 'label' => 'White'),
            );
        
        
            // Line spacing (line-height)
            $line_spacing_choices = [];
            for ($i = 80; $i <= 300; $i += 10) {
                $line_spacing_choices["{$i}%"] = "{$i}%";
            }
            $wp_customize->add_setting("my_plugin_{$key}_line_height", array(
                'default'           => '100%',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control("my_plugin_{$key}_line_height_control", array(
                'label'    => __("Line Spacing", 'my-plugin'),
                'section'  => $section_id,
                'settings' => "my_plugin_{$key}_line_height",
                'type'     => 'select',
                'choices'  => $line_spacing_choices,
            ));
        
            // Margin top
            $margin_choices = [];
            for ($i = 0; $i <= 50; $i += 5) {
                $margin_choices["{$i}px"] = "{$i}px";
            }
            $wp_customize->add_setting("my_plugin_{$key}_margin_top", array(
                'default'           => '0px',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control("my_plugin_{$key}_margin_top_control", array(
                'label'    => __("Space Above", 'my-plugin'),
                'section'  => $section_id,
                'settings' => "my_plugin_{$key}_margin_top",
                'type'     => 'select',
                'choices'  => $margin_choices,
            ));
        
            // Margin bottom
            $wp_customize->add_setting("my_plugin_{$key}_margin_bottom", array(
                'default'           => '0px',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control("my_plugin_{$key}_margin_bottom_control", array(
                'label'    => __("Space Below", 'my-plugin'),
                'section'  => $section_id,
                'settings' => "my_plugin_{$key}_margin_bottom",
                'type'     => 'select',
                'choices'  => $margin_choices,
            ));


            


            // Font size
                $font_size_choices = [
                    '12px'  => '12 px',
                    '14px'  => '14 px',
                    '16px'  => '16 px (Default)',
                    '18px'  => '18 px',
                    '20px'  => '20 px',
                    '24px'  => '24 px',
                    '28px'  => '28 px',
                    '32px'  => '32 px',
                    '36px'  => '36 px',
                    '40px'  => '40 px',
                    '48px'  => '48 px',
                    '56px'  => '56 px',
                    '62px'  => '62 px',
                    '78px'  => '78 px',
                ];


                $sizes = [
                    'text_size_desktop' => 'Desktop',
                    'text_size_tablet' => 'Tablet',
                    'text_size_mobile' => 'Mobile',
                ];


                $sizes = [
    'desktop' => 'Desktop Font Size',
    'tablet'  => 'Tablet Font Size',
    'mobile'  => 'Mobile Font Size',
];

foreach ($sizes as $suffix => $label_text) {
    $wp_customize->add_setting("my_plugin_{$key}_font_size_{$suffix}", array(
        'default'           => '16px',
        'transport'         => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control("my_plugin_{$key}_font_size_{$suffix}_control", array(
        'label'    => __($label_text, 'my-plugin'),
        'section'  => $section_id,
        'settings' => "my_plugin_{$key}_font_size_{$suffix}",
        'type'     => 'select',
        'choices'  => $font_size_choices,
    ));
}

                
          



$sizes = [
    'desktop' => 'Desktop Font Size',
    'tablet'  => 'Tablet Font Size',
    'mobile'  => 'Mobile Font Size',
];

foreach ($sizes as $suffix => $label_text) {
    $wp_customize->add_setting("my_plugin_{$key}_font_size_{$suffix}", array(
        'default'           => '16px',
        'transport'         => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control("my_plugin_{$key}_font_size_{$suffix}_control", array(
        'label'    => __($label_text, 'my-plugin'),
        'section'  => $section_id,
        'settings' => "my_plugin_{$key}_font_size_{$suffix}",
        'type'     => 'select',
        'choices'  => $font_size_choices,
    ));
}





                $wp_customize->add_setting("my_plugin_{$key}_font_colour", array(
                    'default'           => 'black',
                    'transport'         => 'refresh',
                    'sanitize_callback' => 'sanitize_text_field',
                ));

                
                $wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
                    $wp_customize,
                    "my_plugin_{$key}_font_colour_control",
                    array(
                        'label'       => __('Font Colour', 'my-plugin'),
                        'section'     => $section_id,
                        'settings'    => "my_plugin_{$key}_font_colour",
                        'choices'     => $colour_choices_text,
                        'description' => __('Choose a text colour.', 'my-plugin'),
                    )
                ));


                if ($key === 'body') {
                    // Link colour
                    $wp_customize->add_setting("my_plugin_body_link_colour", array(
                        'default'           => 'black',
                        'transport'         => 'refresh',
                        'sanitize_callback' => 'sanitize_text_field',
                    ));
                
                    $wp_customize->add_control(new Firefly_Radio_Colour_Control_Text(
                        $wp_customize,
                        "my_plugin_body_link_colour_control",
                        array(
                            'label'       => __('Link Colour', 'my-plugin'),
                            'section'     => $section_id,
                            'settings'    => "my_plugin_body_link_colour",
                            'choices'     => $colour_choices_text,
                            'description' => __('Choose a colour for links in paragraphs and lists.', 'my-plugin'),
                        )
                    ));
                
                    // Link underline toggle
                    $wp_customize->add_setting("my_plugin_body_link_underline", array(
                        'default'           => 'yes',
                        'transport'         => 'refresh',
                        'sanitize_callback' => function($value) {
                            return in_array($value, ['yes', 'no']) ? $value : 'yes';
                        },
                    ));
                
                    $wp_customize->add_control("my_plugin_body_link_underline_control", array(
                        'label'    => __('Underline Links?', 'my-plugin'),
                        'section'  => $section_id,
                        'settings' => "my_plugin_body_link_underline",
                        'type'     => 'radio',
                        'choices'  => [
                            'yes' => __('Yes', 'my-plugin'),
                            'no'  => __('No', 'my-plugin'),
                        ],
                    ));
                }
                

                //===================================================
                // Step 1: add choices, add_setting and add_control
                //===================================================

        }
    }  
    
    
}




add_action('customize_register', 'firefly_customizer_fonts', 20);

// Inject the CSS into the site


add_action('customize_register', function () {
    if (!class_exists('Firefly_Radio_Colour_Control_Text')) {        class Firefly_Radio_Colour_Control_Text extends WP_Customize_Control {
            public $type = 'radio';

            public function render_content() {
                if (empty($this->choices)) return;

                if (!empty($this->label)) {
                    echo '<span class="customize-control-title">' . esc_html($this->label) . '</span>';
                }

                if (!empty($this->description)) {
                    echo '<span class="description customize-control-description">' . $this->description . '</span>';
                }

                foreach ($this->choices as $value => $info) {
                    $color = $info['color'];
                    $text  = $info['label'];
                    ?>
                    <label style="display:flex;align-items:center;margin:4px 0; padding-left: 40px;">
                        <input type="radio" name="<?php echo esc_attr($this->id); ?>"
                            value="<?php echo esc_attr($value); ?>"
                            <?php $this->link(); checked($this->value(), $value); ?> />
                        <span style="background:<?php echo esc_attr($color); ?>;
                                    width:12px;height:12px;display:inline-block;
                                    margin:0 6px;border:1px solid #ccc;"></span>
                        <?php echo esc_html($text); ?>
                    </label>
                    <?php
                }
            }
        }
    }
});


//=========================================================


// Replace the existing JavaScript code with this updated version
// Replace the JavaScript code with this updated version
// Replace the JavaScript part with this version
add_action('customize_controls_enqueue_scripts', function() {
    static $done = false;
    if ($done) return;
    $done = true;

    $font_catalog = firefly_google_fonts_catalog();
    $font_weights_data = [];
    
    foreach ($font_catalog as $font_family => $font_data) {
        $font_weights_data[$font_family] = array_map('strval', 
            isset($font_data['weights']) ? $font_data['weights'] : ['400']
        );
    }

    $font_weights_json = json_encode($font_weights_data);

    wp_add_inline_script('customize-controls', <<<JS
(function($) {
    'use strict';
    
    console.log('🔧 Firefly Fonts Script Loaded');
    
    var fontWeightsData = {$font_weights_json};
    
    function updateWeightAvailability(targetKey) {
        var fontSetting = 'my_plugin_' + targetKey + '_font';
        var weightControlId = 'my_plugin_' + targetKey + '_weight_control';
        
        if (typeof wp.customize === 'undefined') return;
        
        var fontFamily = wp.customize(fontSetting)();
        
        if (!fontFamily || !fontWeightsData[fontFamily]) {
            return;
        }
        
        var availableWeights = fontWeightsData[fontFamily];
        var weightControl = wp.customize.control(weightControlId);
        if (!weightControl) return;
        
        var radios = weightControl.container.find('input[type="radio"]');
        
        radios.each(function(index) {
            var \$radio = $(this);
            var \$label = \$radio.closest('label');
            var weightValue = \$radio.val();
            var isAvailable = availableWeights.indexOf(weightValue) !== -1;
            
            if (isAvailable) {
                \$radio.prop('disabled', false);
                \$label.removeClass('firefly-disabled-weight');
                // Force remove any inline styles that might be causing issues
                \$label.css({
                    'color': '',
                    'opacity': '',
                    'cursor': ''
                });
            } else {
                \$radio.prop('disabled', true);
                \$label.addClass('firefly-disabled-weight');
                // Apply aggressive inline styling as backup
                \$label.css({
                    'color': '#888888 !important',
                    'opacity': '0.6 !important',
                    'cursor': 'not-allowed !important'
                });
                
                // Also style any spans within the label
                \$label.find('span').css({
                    'color': '#888888 !important'
                });
                
                if (\$radio.is(':checked')) {
                    var \$radio400 = weightControl.container.find('input[value="400"]');
                    if (\$radio400.length && !\$radio400.is(':disabled')) {
                        \$radio400.prop('checked', true).trigger('change');
                    }
                }
            }
        });
    }
    
    function setupFontWeightUpdates() {
        var targets = ['h1', 'h2', 'h3'];
        
        targets.forEach(function(key) {
            var fontSetting = 'my_plugin_' + key + '_font';
            
            wp.customize(fontSetting, function(setting) {
                setting.bind(function(newValue) {
                    setTimeout(function() {
                        updateWeightAvailability(key);
                    }, 50);
                });
            });
        });
    }
    
    wp.customize.bind('ready', function() {
        setupFontWeightUpdates();
        
        setTimeout(function() {
            ['h1', 'h2', 'h3'].forEach(function(key) {
                updateWeightAvailability(key);
            });
        }, 500);
    });
    
})(jQuery);
JS
    , 'after');
});

// Update the CSS to be more specific and reliable
// Replace the CSS part with this more aggressive approach
add_action('customize_controls_print_styles', function() {
    echo '<style>
    /* Force grey text for disabled font weights - aggressive approach */
    .customize-control-radio label.firefly-disabled-weight,
    .customize-control-radio label.firefly-disabled-weight *,
    .customize-control-radio input[type="radio"]:disabled + span,
    .customize-control-radio input[type="radio"]:disabled ~ span,
    .customize-control-radio label:has(input[type="radio"]:disabled),
    .customize-control-radio label:has(input[type="radio"]:disabled) * {
        color: #888888 !important;
        opacity: 0.6 !important;
        cursor: not-allowed !important;
    }
    
    /* Target the radio control specifically */
    .customize-control .firefly-disabled-weight,
    .customize-control .firefly-disabled-weight .customize-control-title,
    .customize-control .firefly-disabled-weight span {
        color: #888888 !important;
    }
    
    /* Override any WordPress default colors */
    .wp-full-overlay .customize-control .firefly-disabled-weight,
    .wp-full-overlay .customize-control .firefly-disabled-weight * {
        color: #888888 !important;
    }
    </style>';
}, 99);



// Add this as a last resort - it will inject CSS directly into the head
add_action('customize_controls_head', function() {
    echo '<style id="firefly-font-weight-fix">
    /* NUCLEAR OPTION - Maximum specificity for grey text */
    body.wp-customizer .customize-control-radio .firefly-disabled-weight,
    body.wp-customizer .customize-control-radio .firefly-disabled-weight *,
    body.wp-customizer .customize-control-radio label.firefly-disabled-weight,
    body.wp-customizer .customize-control-radio label.firefly-disabled-weight *,
    body.wp-customizer .customize-control-radio input[type="radio"]:disabled + *,
    body.wp-customizer .customize-control-radio input[type="radio"]:disabled ~ * {
        color: #888888 !important;
        opacity: 0.6 !important;
        cursor: not-allowed !important;
    }
    
    /* Override ALL possible WordPress styles */
    .wp-core-ui .customize-control-radio .firefly-disabled-weight,
    .wp-core-ui .customize-control-radio .firefly-disabled-weight *,
    .wp-core-ui .customize-control-radio label.firefly-disabled-weight,
    .wp-core-ui .customize-control-radio label.firefly-disabled-weight * {
        color: #888888 !important;
    }
    </style>';
});


//=========================================================


function firefly_custom_text_fonts() {
    $elements = ['body', 'h1', 'h2', 'h3'];
    echo "<style id='firefly-custom-text-fonts'> 
    

/* Put in Customizer admin CSS enqueue or an inline <style> */
.customize-control .font-weight-options label.disabled-font-weight {
  opacity: .45;
  cursor: not-allowed;
  color: #999;
}
.customize-control .font-weight-options label {
  display: inline-flex;
  align-items: center;
  gap: 6px;
  margin: 4px 8px 4px 0;
}
.customize-control .font-weight-options input[type='radio'][disabled] {
  pointer-events: none;
}


    /* these styles are from firefly-fonts.php */
    
    \n";

    foreach ($elements as $tag) {
        $font = get_theme_mod("my_plugin_{$tag}_font", 'Arial, sans-serif');
       
        $weight = my_plugin_normalize_weight(
            get_theme_mod("my_plugin_{$tag}_weight", '400')
        );


        $line_height = get_theme_mod("my_plugin_{$tag}_line_height", '100%');
        $margin_top = get_theme_mod("my_plugin_{$tag}_margin_top", '0px');
        $margin_bottom = get_theme_mod("my_plugin_{$tag}_margin_bottom", '0px');
        $font_size_desktop = get_theme_mod("my_plugin_{$tag}_font_size_desktop", '16px');
        $font_size_tablet  = get_theme_mod("my_plugin_{$tag}_font_size_tablet", '16px');
        $font_size_mobile  = get_theme_mod("my_plugin_{$tag}_font_size_mobile", '16px');

        $font_colour_key = get_theme_mod("my_plugin_{$tag}_font_colour", 'black');
        $font_colour = match ($font_colour_key) {
            'colour1' => get_theme_mod('firefly_colour_1', '#dd3333'),
            'colour2' => get_theme_mod('firefly_colour_2', '#1e73be'),
            'colour3' => get_theme_mod('firefly_colour_3', '#8224e3'),
            'colour4' => get_theme_mod('firefly_colour_4', '#ededc4'),
            'white'   => '#ffffff',
            default   => '#000000',
        };

        // Shared body elements
        if ($tag === 'body') {
            echo "body, p, ul, ol, .entry-content, .has-medium-font-size {\n";
            echo "  font-family: {$font} !important;\n";
            echo "  line-height: {$line_height} ;\n";//!important
            echo "  font-size: {$font_size_desktop};\n"; //!important
            echo "  color: {$font_colour} \n"; //!important;
            echo "}\n";

            echo "p {\n";
            echo "  margin-top: {$margin_top} !important;\n";
            echo "  margin-bottom: {$margin_bottom} !important;\n";

            echo "}\n";



            
            // Tablet font size
            echo "@media (min-width: 701px) and (max-width: 1024px) {\n";
            echo "  body, p, ul, ol, .entry-content {\n";
            echo "    font-size: {$font_size_tablet} ;\n";
            echo "  }\n";
            echo "}\n";

            // Mobile font size
            echo "@media (max-width: 700px) {\n";
            echo "  body, p, ul, ol, .entry-content {\n";
            echo "    font-size: {$font_size_mobile} ;\n";
            echo "  }\n";
            echo "}\n";


         
        }

        // H1, H2, H3 (or general tags)
        echo "{$tag} {\n";
        echo "  font-family: {$font} !important;\n";
        echo "  font-weight: {$weight} ;";
        echo "  line-height: {$line_height} !important;\n";
        echo "  margin-top: {$margin_top} !important;\n";
		echo "jeff:no;";

        if ($tag != "body") {
         echo "  margin-bottom: {$margin_bottom} !important;\n";
        }
        echo "  font-size: {$font_size_desktop};\n";  //!important
       echo "  color: {$font_colour} ;\n"; //!important
        echo "}\n";

        // Responsive sizes
        echo "@media (min-width: 701px) and (max-width: 1024px) {\n";
        echo "  {$tag} {\n";
        echo "    font-size: {$font_size_tablet}; \n"; //!important;
        echo "  }\n";
        echo "}\n";

        echo "@media (max-width: 700px) {\n";
        echo "  {$tag} {\n";
        echo "    font-size: {$font_size_mobile} ;\n"; //!important
        echo "  }\n";
        echo "}\n";

           echo "
            
            .trump { } 
            
            
            
            ";

    }


 
 
          

    // Final: Link colours (only once!)
    $font_link_colour_key = get_theme_mod('my_plugin_body_link_colour', 'black');
    $link_colour = match ($font_link_colour_key) {
        'colour1' => get_theme_mod('firefly_colour_1', '#dd3333'),
        'colour2' => get_theme_mod('firefly_colour_2', '#1e73be'),
        'colour3' => get_theme_mod('firefly_colour_3', '#8224e3'),
        'colour4' => get_theme_mod('firefly_colour_4', '#ededc4'),
        'white'   => '#ffffff',
        default   => '#000000',
    };
    $link_underline = get_theme_mod('my_plugin_body_link_underline', 'yes') === 'yes' ? 'underline' : 'none';

 echo "body a:not(.menu a), p a:not(.menu a), ul a:not(.menu a), ol a:not(.menu a), li a:not(.menu a), .entry-content a:not(.menu a) {\n";
echo "  color: {$link_colour} ;\n";
echo "  text-decoration: {$link_underline} !important;\n";
echo "}\n";

echo " body { margin-top:0px !important; } ";


    echo "</style>\n";
}


add_action('wp_head', 'firefly_custom_text_fonts');

// Enqueue selected Google Fonts
function firefly_enqueue_selected_google_fonts() {
    $keys = ['body', 'h1', 'h2', 'h3'];
    $font_families = [];

    foreach ($keys as $key) {
        $font_value = get_theme_mod("my_plugin_{$key}_font", 'Arial, sans-serif');
        $font_name = explode(',', $font_value)[0];
        $font_name = trim($font_name, ' "\'');

        // Skip system fonts
        $standard_fonts = [
            'Arial', 'Verdana', 'Times New Roman', 'Georgia', 'Palatino',
            'Helvetica', 'Tahoma', 'Trebuchet MS', 'Courier New', 'Brush Script MT'
        ];
        if (!in_array($font_name, $standard_fonts)) {
            $font_families[] = str_replace(' ', '+', $font_name);
        }

        $colour_key = get_theme_mod("my_plugin_{$key}_font_colour", 'black'); 
        $colour = match ($colour_key) {
            'colour1' => get_theme_mod('firefly_colour_1', '#dd3333'),
            'colour2' => get_theme_mod('firefly_colour_2', '#1e73be'),
            'colour3' => get_theme_mod('firefly_colour_3', '#8224e3'),
            'colour4' => get_theme_mod('firefly_colour_4', '#ededc4'),
            'white'   => '#ffffff',
            default   => '#000000',
        };

    }

    $font_families = array_unique($font_families);
    if (!empty($font_families)) {
      

        $families_in = array_unique($font_families);

// Build family params with weights
$families_out = array_map(function($raw) {
    // Strip fallbacks after a comma (e.g. "Roboto, sans-serif")
    $family = trim(explode(',', $raw)[0]);

    // Replace spaces with +
    $family = preg_replace('/\s+/', '+', $family);

    // Append the weight range
    return "family={$family}:wght@100;200;300;400;500;600;700;800;900";
}, $families_in);

if ($families_out) {
    // Join with & and use css2 endpoint
    $query = implode('&', $families_out);
    $url = "https://fonts.googleapis.com/css2?{$query}&display=swap";
    echo "<link rel='stylesheet' href='" . esc_url($url) . "' media='all' />\n";
}





    }





}



add_action('wp_head', 'firefly_enqueue_selected_google_fonts', 1);


