<?php
// 1. Your custom swatch‐picker control, with the full presets array
if ( class_exists('WP_Customize_Control') ) {
    class Firefly_Colour_Preset_Control extends WP_Customize_Control {
        public $type = 'firefly_colour_preset';

        public function render_content() {
            ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
            </label>
            <div class="firefly-presets">
                <?php
                $presets = [
                    'Fresh Mint'        => ['#2E7D32','#66BB6A','#E8F5E9','#F1F8E9'],
                    'Sunset Sand'       => ['#D84315','#FF8A65','#FFF3E0','#FBE9E7'],
                    'Ocean Breeze'      => ['#01579B','#0288D1','#E1F5FE','#E0F7FA'],
                    'Lavender Fields'   => ['#6A1B9A','#BA68C8','#F3E5F5','#EDE7F6'],
                    'Autumn Spice'      => ['#4E342E','#8D6E63','#EFEBE9','#FBE9E7'],
                    'Midnight Ice'      => ['#263238','#607D8B','#ECEFF1','#CFD8DC'],
                    'Forest Dew'        => ['#33691E','#689F38','#F1F8E9','#DCEDC8'],
                    'Citrus Splash'     => ['#F9A825','#FFEB3B','#FFFDE7','#FFF8E1'],
                    'Blush Bloom'       => ['#AD1457','#F06292','#FCE4EC','#F8BBD0'],
                    'Sky Drift'         => ['#1565C0','#64B5F6','#E3F2FD','#E1F5FE'],
                    'Slate Classic'     => ['#2C3E50','#5D6D7E','#F4F6F7','#EBEDEF'],
                    'Navy Trust'        => ['#1B2631','#34495E','#E5E8E8','#F2F3F4'],
                    'Charcoal Blue'     => ['#2E4053','#566573','#F8F9F9','#EAEDED'],
                    'Legal Ivory'       => ['#4D5656','#85929E','#FDFEFE','#F7F9F9'],
                    'Corporate Gold'    => ['#3E2723','#A1887F','#FFF8E1','#F5F5DC'],
                    'Oxford Gray'       => ['#212121','#616161','#FAFAFA','#EEEEEE'],
                    'Executive Blue'    => ['#003366','#336699','#F5F8FA','#EDF3F8'],
                    'Steadfast Forest'  => ['#1B5E20','#4CAF50','#F1F8E9','#E8F5E9'],
                    'Muted Royal'       => ['#283593','#5C6BC0','#E8EAF6','#F3F4F6'],
                    'Tradition Grey'    => ['#424242','#757575','#F9F9F9','#F0F0F0'],
                    'Ink & Petal'       => ['#4A148C','#F06292','#FCE4EC','#F3E5F5'],
                    'Terra Clay'        => ['#6D4C41','#FF7043','#FFF3E0','#EFEBE9'],
                    'Sunset Haze'       => ['#D84315','#FFB74D','#FFF8E1','#FBE9E7'],
                    'Soft Cyanotype'    => ['#01579B','#4FC3F7','#E1F5FE','#F3F9FB'],
                    'Pastel Bloom'      => ['#BA68C8','#FFD54F','#FFF8E1','#F3E5F5'],
                    'Painter’s Smoke'   => ['#263238','#90A4AE','#ECEFF1','#CFD8DC'],
                    'Bright Modernist'  => ['#F50057','#00BCD4','#F1F8E9','#FFFDE7'],
                    'Gallery White'     => ['#212121','#757575','#FAFAFA','#EEEEEE'],
                    'Bold Botanica'     => ['#1B5E20','#66BB6A','#E8F5E9','#F1F8E9'],
                    'Cerulean Twist'    => ['#1976D2','#64B5F6','#E3F2FD','#E1F5FE'],
                    'Candy Gold'        => ['#FFB6C1','#FFD700','#FFA500','#FAF0E6'],
                    'Olive Orchard'     => ['#98FB98','#8B4513','#FFEBCD','#BDB76B'],
                    'Seaside Driftwood' => ['#FFF5EE','#F4A460','#7FFFD4','#2F4F4F'],
                    'Antique Lace'      => ['#D2B48C','#FAEBD7','#FF00FF','#FFA07A'],
                    'Marshlight'        => ['#F0E68C','#800000','#FF0000','#00FFFF'],
                    'Ruby Root'         => ['#B22222','#A52A2A','#FFFFE0','#FFE4C4'],
                    'Enchanted Violets' => ['#9932CC','#9400D3','#F0FFF0','#E0FFFF'],
                    'Cherry Rose'       => ['#FF1493','#C71585','#F5FFFA','#FFFACD'],
                    'Mystic Muse'       => ['#8A2BE2','#6A5ACD','#FFF8DC','#F8F8FF'],
                    'Lakehouse Calm'    => ['#5F9EA0','#4682B4','#FFFFF0','#FAFAD2'],
                    'Fern Bloom'        => ['#7CFC00','#228B22','#FFF0F5','#FDF5E6'],
                    'Crimson Dust'      => ['#DC143C','#B22222','#F5F5DC','#FAEBD7'],
                    'Twilight Tide'     => ['#00008B','#191970','#F0F8FF','#FFF5EE'],
                    'Forest Echo'       => ['#006400','#556B2F','#F5F5F5','#F8F8FF'],
                    'Royal Archive'     => ['#000080','#483D8B','#FFF8DC','#E6E6FA'],
                    'Brick & Bone'      => ['#8B0000','#A52A2A','#F5F5F5','#FFFFF0'],
                    'Teal Reserve'      => ['#008080','#20B2AA','#FFFAFA','#FFFFE0'],
                    'Minted Meadow'     => ['#2E8B57','#3CB371','#F5FFFA','#FFF0F5'],
                    'Coral Burst'       => ['#B03060','#FF4500','#FAFAD2','#F0FFF0'],
                    'Rosewood Mist'     => ['#CD5C5C','#F08080','#E0FFFF','#FFFAFA'],
                    'Amethyst Veil'     => ['#9370DB','#8A2BE2','#F5F5DC','#FFF5EE'],
                    'Velvet Ink'        => ['#4B0082','#8B008B','#FFFACD','#F0FFF0'],
                    'Smoky Steel'       => ['#2F4F4F','#696969','#FAF0E6','#F8F8FF'],
                    'Tidepool Teal'     => ['#008B8B','#5F9EA0','#FFFFF0','#FFFAF0'],
                    'Orchid Storm'      => ['#0000CD','#0000FF','#FFF5EE','#F0FFF0'],
                    'Golden Bark'       => ['#DAA520','#B8860B','#F5F5DC','#FFFFE0'],
                    'Clay Hearth'       => ['#D2691E','#A0522D','#FFF8DC','#FDF5E6'],
                    'Spiced Citrus'     => ['#DC143C','#FF6347','#FAF0E6','#FFFACD'],
                    'Berry Cream'       => ['#C71585','#DB7093','#F5FFFA','#FFFFF0'],
                    'Sunburst Blush'    => ['#FF4500','#FF6347','#F0FFF0','#FFF0F5'],
                    'Mosslight'         => ['#6B8E23','#9ACD32','#FDF5E6','#FFF8DC'],
                    'Petal Pop'         => ['#FF69B4','#FF1493','#F0F8FF','#FFF0F5'],
                    'Regal Plum'        => ['#800080','#9932CC','#FFFAF0','#FFFFE0'],
                    'Cool Herb'         => ['#3CB371','#66CDAA','#FFF5EE','#FAFAD2'],
                    'Azure Pulse'       => ['#1E90FF','#4169E1','#F5FFFA','#FFFFF0'],
                    'Neon Grove'        => ['#32CD32','#7FFF00','#FFF0F5','#F8F8FF'],
                    'Peach Fire'        => ['#FFA07A','#FF7F50','#FFFFF0','#FFF5EE'],
                    'Turquoise Charm'   => ['#40E0D0','#00CED1','#F0F8FF','#F5F5F5'],
                    'Lavender Flame'    => ['#EE82EE','#DA70D6','#FFFFF0','#F5F5DC'],
                    'Pacific Rose'      => ['#DC143C','#FF69B4','#FFF0F5','#FFF5EE'],
                    'Burnt Topaz'       => ['#8B4513','#A0522D','#F5DEB3','#FAFAD2'],
                    'Berry Ice'         => ['#FF1493','#BA55D3','#F5F5F5','#FFF0F5'],
                    'Soft Mango'        => ['#FFDAB9','#FFE4B5','#FFFFF0','#FAEBD7'],
                    'Ink Blossom'       => ['#483D8B','#9370DB','#FFF5EE','#F0FFF0'],
                    'Lime Zing'         => ['#ADFF2F','#7CFC00','#F5FFFA','#F0FFF0'],
                    'Blue Horizon'      => ['#0000CD','#4682B4','#E6F0FA','#F5F5FF'],
                    'Cocoa Dust'        => ['#8B4513','#D2691E','#FAEBD7','#FFFAF0'],
                    'Dusty Petals'      => ['#DA70D6','#D8BFD8','#FFF0F5','#FAEBD7'],
                    'Harvest Ink'       => ['#A0522D','#556B2F','#F5F5DC','#FFF8DC'],
                    'Sapphire Wine'     => ['#6A5ACD','#800080','#F0F8FF','#FFF5F5'],
                    'Golden Poppy'      => ['#FFD700','#FF8C00','#FFF8DC','#FFFFF0'],
                ];
                foreach ( $presets as $name => $colors ) {
                    $data = esc_attr( wp_json_encode($colors) );
                    echo "<div class='firefly-preset' data-colors='$data' style='cursor:pointer;margin:10px 0;padding:5px;border:1px solid #ccc;border-radius:6px;'>";
                      echo "<strong style='display:block;margin-bottom:5px;'>$name</strong>";
                      foreach ( $colors as $c ) {
                          echo "<span style='display:inline-block;width:20px;height:20px;background:{$c};margin-right:5px;border-radius:4px;border:1px solid #aaa;'></span>";
                      }
                    echo "</div>";
                }
                ?>
            </div>
            <?php
        }
    }
}


// 2. Panel + sections + all controls
function firefly_customizer_colours( $wp_customize ) {
    // Panel
    $wp_customize->add_panel( 'firefly_colours_panel', [
        'title'    => __( 'Firefly Colours', 'my-plugin' ),
        'priority' => 31,
    ] );

    // Colour Template subsection
    $wp_customize->add_section( 'firefly_colour_templates_section', [
        'title'       => __( 'Colour Template', 'my-plugin' ),
        'panel'       => 'firefly_colours_panel',
        'priority'    => 10,
        'description' => __( 'Pick from preset palettes of colour combinations.', 'my-plugin' ),
    ] );
    $wp_customize->add_control( new Firefly_Colour_Preset_Control( $wp_customize, 'firefly_colour_presets', [
        'label'    => __( 'Preset Palettes', 'my-plugin' ),
        'section'  => 'firefly_colour_templates_section',
        'settings' => [],
    ] ) );

    // Tweak Colours subsection
    $wp_customize->add_section( 'firefly_tweak_colours_section', [
        'title'       => __( 'Tweak Colours', 'my-plugin' ),
        'panel'       => 'firefly_colours_panel',
        'priority'    => 11,
        'description' => __( 'Adjust each of the four core colours manually.', 'my-plugin' ),
    ] );
    for ( $i = 1; $i <= 4; $i++ ) {
        $id = "firefly_colour_{$i}";
        $wp_customize->add_setting( $id, [
            'default'           => '#000000',
            'transport'         => 'refresh',
            'sanitize_callback' => 'sanitize_hex_color',
        ] );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, "{$id}_control", [
            'label'   => sprintf( __( 'Colour %d', 'my-plugin' ), $i ),
            'section' => 'firefly_tweak_colours_section',
            'settings'=> $id,
        ] ) );
    }



    
// ——————————————————————————————————————————————————————————
// 3) Apply Colours subsection: radio‐swatch controls just like your layout page
// ——————————————————————————————————————————————————————————
// 3) Apply Colours subsection
$wp_customize->add_section( 'firefly_apply_colours_section', [
    'title'       => __( 'Apply Colours', 'my-plugin' ),
    'panel'       => 'firefly_colours_panel',
    'priority'    => 12,
    'description' => __( 'Map each theme element to one of your core colours, or pick a custom hex value.', 'my-plugin' ),
] );

// your radio‐swatch choices (four core + black/white)
$colour_choices = [
    'colour1' => [ 'color' => get_theme_mod('firefly_colour_1','#dd3333'), 'label'=>__( 'Colour 1','my-plugin') ],
    'colour2' => [ 'color' => get_theme_mod('firefly_colour_2','#1e73be'), 'label'=>__( 'Colour 2','my-plugin') ],
    'colour3' => [ 'color' => get_theme_mod('firefly_colour_3','#8224e3'), 'label'=>__( 'Colour 3','my-plugin') ],
    'colour4' => [ 'color' => get_theme_mod('firefly_colour_4','#ededc4'), 'label'=>__( 'Colour 4','my-plugin') ],
    'black'   => [ 'color' => '#000000',                              'label'=>__( 'Black','my-plugin')   ],
    'white'   => [ 'color' => '#ffffff',                              'label'=>__( 'White','my-plugin')   ],
];

// list every variable you gave me, with a friendly label and default value
$apply_vars = [
    // — radio‐choice mappings —
    'my_plugin_h1_font_colour'            => ['label'=>__('H1 Font Colour','my-plugin'),           'default'=>'colour2','type'=>'radio'],
    'my_plugin_h2_font_colour'            => ['label'=>__('H2 Font Colour','my-plugin'),           'default'=>'colour2','type'=>'radio'],
    'my_plugin_h3_font_colour'            => ['label'=>__('H3 Font Colour','my-plugin'),           'default'=>'colour2','type'=>'radio'],
    'my_plugin_body_link_colour'          => ['label'=>__('Body Link Colour','my-plugin'),         'default'=>'colour2','type'=>'radio'],

    'layout_bg_color_choice'              => ['label'=>__('Layout Background Choice','my-plugin'),'default'=>'white','type'=>'radio'],
    'layout_content_color_choice'         => ['label'=>__('Layout Content Choice','my-plugin'),   'default'=>'colour3','type'=>'radio'],

    'my_plugin_group1_background_color'   => ['label'=>__('Group 1 Background','my-plugin'),      'default'=>'colour1','type'=>'radio'],
    'my_plugin_group2_background_color'   => ['label'=>__('Group 2 Background','my-plugin'),      'default'=>'colour2','type'=>'radio'],
    'my_plugin_group2_heading_color'      => ['label'=>__('Group 2 Heading','my-plugin'),         'default'=>'white','type'=>'radio'],
    'my_plugin_group2_text_color'         => ['label'=>__('Group 2 Text','my-plugin'),            'default'=>'white','type'=>'radio'],

    'my_plugin_group3_background_color'   => ['label'=>__('Group 3 Background','my-plugin'),      'default'=>'colour4','type'=>'radio'],
    'my_plugin_group3_heading_color'      => ['label'=>__('Group 3 Heading','my-plugin'),         'default'=>'colour1','type'=>'radio'],
    'my_plugin_group3_text_color'         => ['label'=>__('Group 3 Text','my-plugin'),            'default'=>'colour1','type'=>'radio'],
    'my_plugin_group3_border_color'       => ['label'=>__('Group 3 Border','my-plugin'),          'default'=>'black','type'=>'radio'],

    'firefly_menu_top_background_colour'  => ['label'=>__('Menu Top Background','my-plugin'),     'default'=>'colour1','type'=>'radio'],
    'firefly_menu_top_text_colour'        => ['label'=>__('Menu Top Text','my-plugin'),           'default'=>'white','type'=>'radio'],
    'firefly_menu_top_highlight_background'=>['label'=>__('Menu Top Highlight BG','my-plugin'),  'default'=>'colour2','type'=>'radio'],
    'firefly_menu_top_highlight_text_colour'=>['label'=>__('Menu Top Highlight Text','my-plugin'),'default'=>'white','type'=>'radio'],

    'firefly_menu_mobile_text_colour'     => ['label'=>__('Menu Mobile Text','my-plugin'),        'default'=>'white','type'=>'radio'],
    'firefly_menu_mobile_highlight_background'=>['label'=>__('Menu Mobile Highlight BG','my-plugin'),'default'=>'colour2','type'=>'radio'],
    'firefly_menu_mobile_highlight_text_colour'=>['label'=>__('Menu Mobile Highlight Text','my-plugin'),'default'=>'white','type'=>'radio'],

    'firefly_gallery_background'         => ['label'=>__('Gallery Background','my-plugin'),       'default'=>'colour3','type'=>'radio'],

    // — hex‐picker values —
    'firefly_banner_text_color'          => ['label'=>__('Banner Text Colour','my-plugin'),      'default'=>'#ffffff','type'=>'hex'],
    'firefly_banner_background_color'    => ['label'=>__('Banner Background','my-plugin'),       'default'=>'#dddac9','type'=>'hex'],
    'firefly_logo_phone_color'           => ['label'=>__('Logo Phone Colour','my-plugin'),       'default'=>'#000000','type'=>'hex'],
    'firefly_logo_other_color'           => ['label'=>__('Logo Other Colour','my-plugin'),       'default'=>'#000000','type'=>'hex'],
];

// now loop and register each one…
foreach ( $apply_vars as $setting_id => $args ) {
    $default = get_theme_mod( $setting_id, $args['default'] );

    // 1) register setting
    $wp_customize->add_setting( $setting_id, [
        'default'           => $default,
        'transport'         => 'refresh',
        'sanitize_callback' => $args['type'] === 'hex'
            ? 'sanitize_hex_color'
            : 'sanitize_text_field',
    ] );

    // 2) add the appropriate control
    if ( $args['type'] === 'hex' ) {
        // a normal hex‐picker
        $wp_customize->add_control( new WP_Customize_Color_Control(
            $wp_customize,
            "{$setting_id}_control",
            [
                'label'    => $args['label'],
                'section'  => 'firefly_apply_colours_section',
                'settings' => $setting_id,
            ]
        ) );
    } else {
        // a radio‐swatch choice
        $wp_customize->add_control( new Firefly_Radio_Colour_Control(
            $wp_customize,
            $setting_id,
            [
                'label'    => $args['label'],
                'section'  => 'firefly_apply_colours_section',
                'settings' => $setting_id,
                'choices'  => $colour_choices,
            ]
        ) );
    }
}


}
add_action( 'customize_register', 'firefly_customizer_colours' );
/**
 * When you click a palette swatch, update the four tweak-colours pickers.
 */
add_action( 'customize_controls_print_footer_scripts', function() { ?>
    <script type="text/javascript">
    (function($){
      wp.customize.bind('ready', function(){
        $('.firefly-preset').on('click', function(){
          var colors = JSON.parse( $(this).attr('data-colors') );
          if ( colors.length === 4 ) {
            for ( var i = 1; i <= 4; i++ ) {
              var c = colors[i-1];
              // 1) update the actual setting
              wp.customize( 'firefly_colour_' + i ).set( c );

              // 2) sync the color-picker UI
              var picker = $( '#customize-control-firefly_colour_' + i + '_control .wp-color-picker' );
              if ( picker.length && picker.wpColorPicker ) {
                picker.wpColorPicker( 'color', c );
              }
            }
          }
        });
      });
    })(jQuery);
    </script>
<?php } );

add_action( 'customize_controls_print_footer_scripts', function() { ?>
<script>
(function($){
  wp.customize.bind('ready', function(){

    function repaintCoreSwatches() {
      $('input[type=radio][value^="colour"]').each(function() {
        var key = $(this).val(); // e.g. "colour1"
        var num = key.substring(6); // Extract number part ("1")
        var settingId = 'firefly_colour_' + num;
        var setting = wp.customize(settingId);
        if (setting) {
          var hex = setting();
          $(this).siblings('span').first().css('background-color', hex);
        }
      });
    }

    // Initial paint after controls render
    setTimeout(repaintCoreSwatches, 50);

    // Listen for core colour changes
    for (var i = 1; i <= 4; i++) {
      wp.customize('firefly_colour_' + i, function(setting) {
        setting.bind(repaintCoreSwatches);
      });
    }

    // Update after preset selection
    $('.firefly-presets').on('click', '.firefly-preset', function() {
      setTimeout(repaintCoreSwatches, 10);
    });

  });
})(jQuery);
</script>
<?php } );