<?php
/**
 * Firefly Admin Customizer Panel
 * Appears in the Appearance → Customize menu
 */

function firefly_register_admin_customizer($wp_customize) {
    // Add a new panel at the bottom
    $wp_customize->add_panel('firefly_admin_panel', [
        'title'       => __('Firefly Admin', 'firefly'),
        'priority'    => 999, // Appear at the bottom
    ]);

    // Add a section inside that panel
    $wp_customize->add_section('firefly_admin_settings_section', [
        'title'    => __('Show/Hide admin features', 'firefly'),
        'panel'    => 'firefly_admin_panel',
        'priority' => 1,
    ]);

if (1==2) {
    // Add a new section: Change log and bug report
$wp_customize->add_section('firefly_changelog_section', [
    'title'    => __('Change log and bug report', 'firefly'),
    'panel'    => 'firefly_admin_panel',
    'priority' => 99,
]);

$wp_customize->add_setting('firefly_changelog_iframe', [
    'sanitize_callback' => '__return_null',
]);




$rand = rand(9999,9999999);
$wp_customize->add_control(new WP_Customize_Control(
    $wp_customize,
    'firefly_changelog_iframe',
    [
        'section'     => 'firefly_changelog_section',
        'settings'    => 'firefly_changelog_iframe',
        'label'       => '',
        'description' => '<div style="margin-top:10px;">
            <iframe src="https://rainbowdigital.co.nz/firefly/firefly-WP-theme-changelog.php?x=' . $rand . '" width="100%" height="600" style="border:1px solid #ccc;"></iframe>
        </div>',
        'type'        => 'hidden',
    ]
));

}
    // List of admin options
    $admin_options = [
        'show_page_admin_links'     => 'Show page admin links',
        'show_story_admin_links'    => 'Show story admin links',
        'show_picture_admin_links'  => 'Show picture admin links',
        'show_document_admin_links' => 'Show document admin links',
        'show_event_admin_links'    => 'Show event admin links',
        'show_form_admin_links'     => 'Show form admin links',
        'show_product_admin_links'  => 'Show product admin links',
        'show_gallery_admin_links'  => 'Show gallery admin links',
    ];

    foreach ($admin_options as $key => $label) {
        $setting_id = "my_plugin_{$key}";

        $wp_customize->add_setting($setting_id, [
            'default'           => false,
            'sanitize_callback' => 'wp_validate_boolean',
        ]);

        $wp_customize->add_control($setting_id, [
            'type'     => 'checkbox',
            'section'  => 'firefly_admin_settings_section',
            'label'    => __($label, 'firefly'),
        ]);
    }

    // Add "Site is set up" toggle
    $wp_customize->add_setting('my_plugin_setup_complete', [
        'default'           => false,
        'sanitize_callback' => 'wp_validate_boolean',
    ]);

    $wp_customize->add_control('my_plugin_setup_complete', [
        'type'     => 'checkbox',
        'section'  => 'firefly_admin_settings_section',
        'label'    => __('Site is set up', 'firefly'),
    ]);

	
	
	    // Add "Site is set up" toggle
    $wp_customize->add_setting('my_plugin_do_not_connect_to_manageWP', [
        'default'           => false,
        'sanitize_callback' => 'wp_validate_boolean',
    ]);

    $wp_customize->add_control('my_plugin_do_not_connect_to_manageWP', [
        'type'     => 'checkbox',
        'section'  => 'firefly_admin_settings_section',
        'label'    => __('Do not connect to ManageWP', 'firefly'),
    ]);

	


    // Add extra admin toggles
$wp_customize->add_setting('my_plugin_delete_mode', [
    'default'           => false,
    'sanitize_callback' => 'wp_validate_boolean',
]);

$wp_customize->add_control('my_plugin_delete_mode', [
    'type'     => 'checkbox',
    'section'  => 'firefly_admin_settings_section',
    'label'    => __('Enable delete mode', 'firefly'),
]);

$wp_customize->add_setting('my_plugin_add_textblock', [
    'default'           => false,
    'sanitize_callback' => 'wp_validate_boolean',
]);

$wp_customize->add_control('my_plugin_add_textblock', [
    'type'     => 'checkbox',
    'section'  => 'firefly_admin_settings_section',
    'label'    => __('Enable add textblock mode', 'firefly'),
]);


    // Add "Show red border around textblocks" toggle
$wp_customize->add_setting('my_plugin_show_textblock_borders', [
    'default'           => false,
    'sanitize_callback' => 'wp_validate_boolean',
]);

$wp_customize->add_control('my_plugin_show_textblock_borders', [
    'type'     => 'checkbox',
    'section'  => 'firefly_admin_settings_section',
    'label'    => __('Show red border around textblocks', 'firefly'),
]);



$wp_customize->add_setting('my_plugin_theme_update_access', [
    'default'           => 'jeff', // 'jeff' | 'jeff_rainbowdev' | 'anyone'
    'sanitize_callback' => 'ff_sanitize_theme_update_access',
]);

$wp_customize->add_control('my_plugin_theme_update_access', [
    'type'     => 'radio',
    'section'  => 'firefly_admin_settings_section',
    'label'    => __('Who can update the FireflyWP theme', 'firefly'),
    'choices'  => [
        'jeff'            => __('Only Jeff', 'firefly'),
        'jeff_rainbowdev' => __('Jeff and rainbowdev', 'firefly'),
        'anyone'          => __('Anyone', 'firefly'),
    ],
]);

$wp_customize->add_setting('my_plugin_show_all_settings_note', [
    'sanitize_callback' => '__return_null',
]);

$wp_customize->add_control(new WP_Customize_Control(
    $wp_customize,
    'my_plugin_show_all_settings_note',
    [
        'section'     => 'firefly_admin_settings_section',
        'settings'    => 'my_plugin_show_all_settings_note',
        'label'       => '',
        'description' => '<a href="/?show_all_settings=1" target="_blank" style="display:inline-block;margin-top:10px;">Show all settings</a>',
        'type'        => 'hidden',
    ]
));


    // Add "Show red border around textblocks" toggle
$wp_customize->add_setting('this_site_is_live', [
    'default'           => false,
    'sanitize_callback' => 'wp_validate_boolean',
]);

$wp_customize->add_control('this_site_is_live', [
    'type'     => 'checkbox',
    'section'  => 'firefly_admin_settings_section',
    'label'    => __('This site is live', 'firefly'),
]);

// Add a new section: Modules on this site
$wp_customize->add_section('firefly_modules_section', [
    'title'    => __('Modules on this site', 'firefly'),
    'panel'    => 'firefly_admin_panel',
    'priority' => 2,
]);

$modules = [
        'has_menu'           => ['label' => 'Menu',             'default' => true],
     'module_gallery'           => ['label' => 'Gallery',             'default' => true],
    'module_events'            => ['label' => 'Events',              'default' => true],
    'module_event_booking'     => ['label' => 'Events booking',      'default' => false],
    'module_documents'         => ['label' => 'Documents',           'default' => true],
    'module_fluentform_pro'    => ['label' => 'FluentForm Pro',      'default' => false],
    'module_products'          => ['label' => 'Products',            'default' => false],
    'module_woocommerce'       => ['label' => 'WooCommerce',         'default' => false],
    'module_newsletter'        => ['label' => 'Newsletter',          'default' => false],
    'module_members_only'      => ['label' => 'Members only pages',  'default' => false],
    'module_site_within_site'  => ['label' => 'Site within a site',  'default' => false],
    'has_background_images'  => ['label' => 'Background images',  'default' => false],
    'has_things'  => ['label' => 'Things module',  'default' => false],
];

foreach ($modules as $id => $info) {
    $setting_id = "my_plugin_{$id}";

    $wp_customize->add_setting($setting_id, [
        'default'           => $info['default'],
        'sanitize_callback' => 'wp_validate_boolean',
    ]);

    $wp_customize->add_control($setting_id, [
        'type'    => 'checkbox',
        'section' => 'firefly_modules_section',
        'label'   => __($info['label'], 'firefly'),
    ]);
}

}
add_action('customize_register', 'firefly_register_admin_customizer');




// Sanitize radio choice
function ff_sanitize_theme_update_access( $val ) {
    $allowed = ['jeff', 'jeff_rainbowdev', 'anyone'];
    return in_array($val, $allowed, true) ? $val : 'jeff';
}

// Who is allowed to access the Updates page (Dashboard → Updates)
function ff_user_can_update_firefly_theme(): bool {
    if ( ! is_user_logged_in() ) return false;

    $mode  = get_theme_mod('my_plugin_theme_update_access', 'jeff');
    $user  = wp_get_current_user();
    $email = strtolower(trim($user->user_email));
    $login = strtolower($user->user_login);

    // Jeff’s login email
    $is_jeff       = ($email === 'drjeffsimmonds@gmail.com');
    $is_rainbowdev = ($login === 'rainbowdev');

    switch ($mode) {
        case 'anyone':
            return true;
        case 'jeff_rainbowdev':
            return ($is_jeff || $is_rainbowdev);
        case 'jeff':
        default:
            return $is_jeff;
    }
}

// Hide the Updates page from disallowed users
add_action('admin_menu', function () {
    if ( ! ff_user_can_update_firefly_theme() ) {
        // Remove "Updates" under Dashboard
        remove_submenu_page('index.php', 'update-core.php');
    }
}, 1000);

// Block direct access to update-core.php if disallowed
add_action('admin_init', function () {
    if ( ! ff_user_can_update_firefly_theme() ) {
        global $pagenow;
        if ( $pagenow === 'update-core.php' ) {
            wp_safe_redirect( admin_url('index.php') );
            exit;
        }
    }
});
