(function ($) {
	wp.customize('firefly_colour_1', function (value) {
		value.bind(function (newval) {
			document.documentElement.style.setProperty('--firefly-colour-1', newval);
		});
	});
	wp.customize('firefly_colour_2', function (value) {
		value.bind(function (newval) {
			document.documentElement.style.setProperty('--firefly-colour-2', newval);
		});
	});
	wp.customize('firefly_colour_3', function (value) {
		value.bind(function (newval) {
			document.documentElement.style.setProperty('--firefly-colour-3', newval);
		});
	});
	wp.customize('firefly_colour_4', function (value) {
		value.bind(function (newval) {
			document.documentElement.style.setProperty('--firefly-colour-4', newval);
		});
	});
})(jQuery);



add_action('customize_preview_init', function () {
    ?>
    <script>
    (function($) {
        const updateColors = () => {
            const colours = {
                colour1: wp.customize('firefly_colour_1')(),
                colour2: wp.customize('firefly_colour_2')(),
                colour3: wp.customize('firefly_colour_3')(),
                colour4: wp.customize('firefly_colour_4')()
            };

            // Update custom properties
            document.documentElement.style.setProperty('--firefly-colour-1', colours.colour1);
            document.documentElement.style.setProperty('--firefly-colour-2', colours.colour2);
            document.documentElement.style.setProperty('--firefly-colour-3', colours.colour3);
            document.documentElement.style.setProperty('--firefly-colour-4', colours.colour4);

            // Optional: update elements using classes or inline styles if needed
            // e.g., $('.site').css('background-color', colours.colour2);
        };

        wp.customize('firefly_colour_1', value => value.bind(updateColors));
        wp.customize('firefly_colour_2', value => value.bind(updateColors));
        wp.customize('firefly_colour_3', value => value.bind(updateColors));
        wp.customize('firefly_colour_4', value => value.bind(updateColors));

        // Run once on load
        $(document).ready(updateColors);


(function ($) {
	wp.customize.bind('ready', function () {
		$('body').on('change', 'input[type="radio"][name^="customize-radio-"]', function () {
			const name = $(this).attr('name'); // e.g. customize-radio-firefly_thing_container_background
			const id = name.replace('customize-radio-', '');
			const val = $(this).val();

			if (wp.customize.has(id)) {
				wp.customize(id).set(val);
			}
		});
	});
})(jQuery);



    wp.customize('firefly_event_indent', function (value) {
        value.bind(function (newval) {
            $('.upcoming-events-box .event').css({ paddingLeft: newval, paddingRight: newval });
        });
    });

    wp.customize('firefly_event_background_colour_key', function (value) {
        value.bind(function (key) {
            wp.customize('firefly_colour_' + key, function (colourSetting) {
                $('.upcoming-events-box .event').css('backgroundColor', colourSetting.get());
            });
        });
    });

    wp.customize('firefly_event_heading_colour', function (value) {
        value.bind(function (key) {
            wp.customize('firefly_colour_' + key, function (colourSetting) {
                $('.upcoming-events-box .event h3').css('color', colourSetting.get());
            });
        });
    });

    wp.customize('firefly_event_date_colour', function (value) {
        value.bind(function (key) {
            wp.customize('firefly_colour_' + key, function (colourSetting) {
                $('.upcoming-events-box .event h3 span').css('color', colourSetting.get());
            });
        });
    });

    wp.customize('firefly_event_text_colour', function (value) {
        value.bind(function (key) {
            wp.customize('firefly_colour_' + key, function (colourSetting) {
                $('.upcoming-events-box .event').css('color', colourSetting.get());
            });
        });
    });

// Dynamically watch all firefly_thing_*_colour_* settings
wp.customize.bind('ready', function () {
    wp.customize.settings.controls.forEach(function (control, id) {
        if (id.startsWith('firefly_thing_') && id.endsWith('_colour')) {
            wp.customize(id, value => {
                value.bind(updateThingStyles);
            });
        }
    });
});

wp.customize('firefly_thing_name_colour_bands', function (value) {
    value.bind(function (key) {
        wp.customize('firefly_colour_' + key, function (colourSetting) {
            $('.thing-name').css('color', colourSetting.get());
        });
    });
});


    


   (function ($) {
    function updateDynamicColour(targetSelector, settingPrefix) {
        _.each(wp.customize.settings.settings, function (setting, id) {
            if (id.startsWith(settingPrefix)) {
                wp.customize(id, function (value) {
                    value.bind(function (key) {
                        const colourSettingId = 'firefly_colour_' + key;
                        wp.customize(colourSettingId, function (colourSetting) {
                            $(targetSelector).css('color', colourSetting.get());
                        });
                    });
                });
            }
        });
    }

    $(document).ready(function () {
        updateDynamicColour('.thing-name', 'firefly_thing_name_colour_');
        updateDynamicColour('.thing-panel', 'firefly_thing_panel_background_');
        updateDynamicColour('.thing-container', 'firefly_thing_container_background_');
    });
})(jQuery);




(function ($) {
	wp.customize.bind('ready', function () {
		$('body').on('change', 'input[type="radio"][name^="customize-radio-"]', function () {
			const name = $(this).attr('name'); // e.g., customize-radio-firefly_thing_name_colour_bands
			const id = name.replace('customize-radio-', '');
			const val = $(this).val();

			if (wp.customize.has(id)) {
				wp.customize(id).set(val); // ✅ triggers live update
			}
		});
	});
})(jQuery);
